-- phpMyAdmin SQL Dump
-- version 5.1.1
-- https://www.phpmyadmin.net/
--
-- Host: 127.0.0.1
-- Generation Time: Sep 29, 2023 at 07:05 AM
-- Server version: 10.4.22-MariaDB
-- PHP Version: 8.0.13

CREATE DATABASE `unis`;
USE `unis`;

SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
START TRANSACTION;
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;

--
-- Database: `unis`
--

-- --------------------------------------------------------

--
-- Table structure for table `AcademicTerm`
--

CREATE TABLE `AcademicTerm` (
  `AcademicTermID` bigint(10) UNSIGNED ZEROFILL NOT NULL,
  `Term` varchar(50) NOT NULL,
  `AdmissionYear` year(4) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `AcademicTerm`
--

INSERT INTO `AcademicTerm` (`AcademicTermID`, `Term`, `AdmissionYear`) VALUES
(0000000001, '1st Semester', 2024),
(0000000002, '2nd Semester', 2024),
(0000000003, 'Midyear', 2024),
(0000000004, '1st Semester 2023', 2023),
(0000000005, '2nd Semester 2023', 2023),
(0000000006, 'Midyear 2023', 2023),
(0000000007, '1st Semester 2024', 2024),
(0000000008, '2nd Semester 2024', 2024),
(0000000009, 'Midyear 2024', 2024),
(0000000010, '1st Semester 2025', 2025),
(0000000011, '2nd Semester 2025', 2025),
(0000000012, 'Midyear 2025', 2025),
(0000000013, '1st Semester 2026', 2026);

-- --------------------------------------------------------

--
-- Table structure for table `accountlogs`
--

CREATE TABLE `accountlogs` (
  `AccountLogsID` bigint(10) NOT NULL,
  `EmailAddress` varchar(200) DEFAULT NULL,
  `DateTime` datetime DEFAULT NULL,
  `Remarks` varchar(300) DEFAULT NULL,
  `Action` varchar(45) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `activityvenue`
--

CREATE TABLE `activityvenue` (
  `OrgActivityID` int(10) UNSIGNED ZEROFILL NOT NULL,
  `VenueID` int(10) UNSIGNED ZEROFILL NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `activityvenue` (`OrgActivityID`, `VenueID`) VALUES
(0000000001, 0000000001),
(0000000002, 0000000002),
(0000000003, 0000000003),
(0000000004, 0000000004),
(0000000005, 0000000005),
(0000000006, 0000000006),
(0000000007, 0000000007),
(0000000008, 0000000008),
(0000000009, 0000000009),
(0000000010, 0000000010),
(0000000011, 0000000011),
(0000000012, 0000000012),
(0000000013, 0000000013),
(0000000014, 0000000014),
(0000000015, 0000000015),
(0000000016, 0000000016),
(0000000017, 0000000017),
(0000000018, 0000000018),
(0000000019, 0000000019),
(0000000020, 0000000020);


-- --------------------------------------------------------

--
-- Table structure for table `admissionaccount`
--

CREATE TABLE `admissionaccount` (
  `EmailAddress` varchar(200) NOT NULL,
  `StudentAdmissionID` varchar(100) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `admissionaccount` (`EmailAddress`, `StudentAdmissionID`) VALUES
('student1@example.com', 'ADMISSION12345'),
('student2@example.com', 'ADMISSION67890'),
('student3@example.com', 'ADMISSION54321'),
('student4@example.com', 'ADMISSION24680'),
('student5@example.com', 'ADMISSION97531');


-- --------------------------------------------------------

--
-- Table structure for table `assessmentfeessettings`
--

CREATE TABLE `assessmentfeessettings` (
  `AssessmentID` int(11) UNSIGNED ZEROFILL NOT NULL,
  `AssessmentFessCode` int(11) NOT NULL,
  `AssessmentSemester` varchar(45) NOT NULL,
  `AssessmentYearLevel` varchar(45) NOT NULL,
  `AssessmentSchoolYear` varchar(45) NOT NULL,
  `AssessmentType` varchar(200) NOT NULL,
  `AssessmentDescription` varchar(200) NOT NULL,
  `AssessmentAmount` float(15,2) NOT NULL,
  `AssessmentStatus` int(11) NOT NULL DEFAULT 1,
  `AssessmentEffectivity` varchar(100) NOT NULL,
  `CollegeID` int(10) UNSIGNED ZEROFILL NOT NULL,
  `ProgramID` int(10) UNSIGNED ZEROFILL NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `assessmentfeessettings`
--

INSERT INTO `assessmentfeessettings` (`AssessmentID`, `AssessmentFessCode`, `AssessmentSemester`, `AssessmentYearLevel`, `AssessmentSchoolYear`, `AssessmentType`, `AssessmentDescription`, `AssessmentAmount`, `AssessmentStatus`, `AssessmentEffectivity`, `CollegeID`, `ProgramID`) VALUES
(00000000001, 583778731, 'First Semester', '1st Year', '2023-2024', 'Tuition Fees', 'Per Unit', 250.00, 1, 'Sample', 0000000001, 0000000002),
(00000000002, 583778731, 'First Semester', '1st Year', '2023-2024', 'Tuition Fees', '', 300.00, 1, 'dfb', 0000000001, 0000000001);
-- Sample assessment fees settings data (continued)
INSERT INTO `assessmentfeessettings` (`AssessmentID`, `AssessmentFessCode`, `AssessmentSemester`, `AssessmentYearLevel`, `AssessmentSchoolYear`, `AssessmentType`, `AssessmentDescription`, `AssessmentAmount`, `AssessmentStatus`, `AssessmentEffectivity`, `CollegeID`, `ProgramID`) VALUES
(00000000003, 583778732, 'Second Semester', '2nd Year', '2023-2024', 'Tuition Fees', 'Per Unit', 280.00, 1, 'Sample', 0000000001, 0000000002),
(00000000004, 583778732, 'Second Semester', '2nd Year', '2023-2024', 'Tuition Fees', '', 320.00, 1, 'dfb', 0000000001, 0000000001),
(00000000005, 583778733, 'First Semester', '3rd Year', '2023-2024', 'Registration Fees', 'Sample Description', 500.00, 1, 'Sample', 0000000002, 0000000003),
(00000000006, 583778733, 'First Semester', '3rd Year', '2023-2024', 'Registration Fees', '', 550.00, 1, 'dfb', 0000000002, 0000000004),
(00000000007, 583778734, 'Second Semester', '4th Year', '2023-2024', 'Miscellaneous Fees', 'Misc Fee 1', 100.00, 1, 'Sample', 0000000003, 0000000005),
(00000000008, 583778734, 'Second Semester', '4th Year', '2023-2024', 'Miscellaneous Fees', 'Misc Fee 2', 150.00, 1, 'dfb', 0000000003, 0000000006),
(00000000009, 583778735, 'First Semester', '5th Year', '2023-2024', 'Library Fees', 'Library Fee 1', 50.00, 1, 'Sample', 0000000004, 0000000007),
(00000000010, 583778735, 'First Semester', '5th Year', '2023-2024', 'Library Fees', 'Library Fee 2', 60.00, 1, 'dfb', 0000000004, 0000000008),
(00000000011, 583778736, 'Second Semester', '6th Year', '2023-2024', 'Lab Fees', 'Lab Fee 1', 80.00, 1, 'Sample', 0000000005, 0000000009),
(00000000012, 583778736, 'Second Semester', '6th Year', '2023-2024', 'Lab Fees', 'Lab Fee 2', 90.00, 1, 'dfb', 0000000005, 0000000010);


-- --------------------------------------------------------

--
-- Table structure for table `campus`
--

CREATE TABLE `campus` (
  `CampusID` int(10) UNSIGNED ZEROFILL NOT NULL,
  `CampusName` varchar(300) NOT NULL,
  `CampusAddress` varchar(500) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `campus`
--

INSERT INTO `campus` (`CampusID`, `CampusName`, `CampusAddress`) VALUES
(0000000001, 'CSPC Main', 'Nabua, Cam Sur'),
(0000000002, 'CSPC Bula', 'Bula, Cam Sur');
-- Sample campus data
INSERT INTO `campus` (`CampusID`, `CampusName`, `CampusAddress`) VALUES
(0000000003, 'CSPC Pili', 'Pili, Cam Sur'),
(0000000004, 'CSPC Calabanga', 'Calabanga, Cam Sur'),
(0000000005, 'CSPC Naga', 'Naga City, Cam Sur'),
(0000000006, 'CSPC Iriga', 'Iriga City, Cam Sur'),
(0000000007, 'CSPC Buhi', 'Buhi, Cam Sur'),
(0000000008, 'CSPC Libmanan', 'Libmanan, Cam Sur'),
(0000000009, 'CSPC Sipocot', 'Sipocot, Cam Sur'),
(0000000010, 'CSPC Ragay', 'Ragay, Cam Sur');


-- --------------------------------------------------------

--
-- Table structure for table `citizenship`
--

CREATE TABLE `citizenship` (
  `CitizenshipID` int(10) UNSIGNED ZEROFILL NOT NULL,
  `Citizenship` varchar(250) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Sample citizenship data
INSERT INTO `citizenship` (`CitizenshipID`, `Citizenship`) VALUES
(0000000001, 'United States'),
(0000000002, 'Canada'),
(0000000003, 'United Kingdom'),
(0000000004, 'Australia'),
(0000000005, 'India'),
(0000000006, 'Germany'),
(0000000007, 'France'),
(0000000008, 'Japan'),
(0000000009, 'Brazil'),
(0000000010, 'Mexico'),
(0000000011, 'Philippines');


-- --------------------------------------------------------

--
-- Table structure for table `classtype`
--

CREATE TABLE `classtype` (
  `ClassTypeID` int(10) UNSIGNED ZEROFILL NOT NULL,
  `ClassType` varchar(45) NOT NULL COMMENT 'Lab, Lec, Workshop'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Sample class types
INSERT INTO `classtype` (`ClassTypeID`, `ClassType`) VALUES
(0000000001, 'Laboratory'),
(0000000002, 'Lecture'),
(0000000003, 'Workshop'),
(0000000004, 'Seminar'),
(0000000005, 'Discussion'),
(0000000006, 'Tutorial'),
(0000000007, 'Studio');


-- --------------------------------------------------------

--
-- Table structure for table `clearance`
--

CREATE TABLE `clearance` (
  `ClearanceID` int(11) UNSIGNED ZEROFILL NOT NULL,
  `AssessmentID` int(11) UNSIGNED ZEROFILL NOT NULL,
  `DeansIsVerify` varchar(100) NOT NULL COMMENT 'Yes/No',
  `OSASIsVerify` varchar(100) NOT NULL COMMENT 'Yes/No',
  `StudentCouncilIsVerify` varchar(100) NOT NULL COMMENT 'Yes/No',
  `CashierIsVerify` varchar(100) NOT NULL COMMENT 'Yes/No',
  `RegistrarIsVerify` varchar(100) NOT NULL COMMENT 'Yes/No',
  `AccountingIsVerify` varchar(100) NOT NULL COMMENT 'Yes/No',
  `PTAIsVerify` varchar(100) NOT NULL COMMENT 'Yes/No',
  `AlumniIsVerify` varchar(100) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `college`
--

CREATE TABLE `college` (
  `CollegeID` int(10) UNSIGNED ZEROFILL NOT NULL,
  `CampusID` int(10) UNSIGNED ZEROFILL NOT NULL,
  `CollegeDesc` varchar(450) NOT NULL,
  `CollegeAbbr` varchar(200) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `college`
--

INSERT INTO `college` (`CollegeID`, `CampusID`, `CollegeDesc`, `CollegeAbbr`) VALUES
(0000000001, 0000000001, 'College of Computer Studies', 'CCS'),
(0000000002, 0000000001, 'College of Engineering and Architecture', 'CEA'),
(0000000003, 0000000002, 'College of Business Administration', 'CBA'),
(0000000004, 0000000002, 'College of Arts and Sciences', 'CAS'),
(0000000005, 0000000003, 'College of Education', 'COE'),
(0000000006, 0000000003, 'College of Nursing', 'CON'),
(0000000007, 0000000004, 'College of Medicine', 'COM'),
(0000000008, 0000000004, 'College of Law', 'COL'),
(0000000009, 0000000005, 'College of Fine Arts', 'CFA'),
(0000000010, 0000000005, 'College of Social Sciences', 'CSS');

-- --------------------------------------------------------

--
-- Table structure for table `course`
--

CREATE TABLE `course` (
  `CourseCode` varchar(30) NOT NULL,
  `ProgramID` int(10) UNSIGNED ZEROFILL NOT NULL,
  `CourseName` varchar(300) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `course`
--

INSERT INTO `course` (`CourseCode`, `ProgramID`, `CourseName`) VALUES
('CCCS101', 0000000002, 'Artificial Intelligence'),
('CCCS102', 0000000002, 'Computer Programming'),
('CCCS103', 0000000002, 'Database Design'),
('CCIT101', 0000000001, 'Introduction to Computing'),
('CCIT102', 0000000001, 'Web Development'),
('CCIT103', 0000000001, 'Database Design');

-- Sample courses
INSERT INTO `course` (`CourseCode`, `ProgramID`, `CourseName`) VALUES
('CS101', 0000000001, 'Introduction to Computer Science'),
('CS102', 0000000001, 'Data Structures and Algorithms'),
('CS201', 0000000001, 'Programming in Java'),
('IT101', 0000000001, 'Introduction to Information Technology'),
('SE101', 0000000001, 'Software Engineering Fundamentals'),
('CE101', 0000000002, 'Computer Engineering Basics'),
('CE201', 0000000002, 'Digital Logic Design'),
('ME101', 0000000002, 'Mechanical Engineering Principles'),
('ME201', 0000000002, 'Thermodynamics'),
('BA101', 0000000003, 'Business Administration Fundamentals'),
('BA201', 0000000003, 'Marketing Management'),
('ECON101', 0000000003, 'Principles of Economics'),
('EDU101', 0000000004, 'Foundations of Education'),
('EDU201', 0000000004, 'Secondary Education Methods'),
('NURS101', 0000000005, 'Fundamentals of Nursing'),
('NURS201', 0000000005, 'Medical-Surgical Nursing'),
('PHAR101', 0000000005, 'Pharmacology'),
('MED101', 0000000006, 'Medical Ethics'),
('LAW101', 0000000007, 'Introduction to Law'),
('LAW201', 0000000007, 'Legal Research and Writing'),
('ART101', 0000000008, 'Introduction to Fine Arts'),
('ART201', 0000000008, 'Advanced Fine Arts'),
('HS101', 0000000009, 'Health Sciences Foundations'),
('HS201', 0000000009, 'Clinical Medicine'),
('DHY101', 0000000010, 'Dental Hygiene Fundamentals'),
('DHY201', 0000000010, 'Oral Health Assessment');


-- --------------------------------------------------------

--
-- Table structure for table `coursecoreq`
--

CREATE TABLE `coursecoreq` (
  `CourseCoReqID` bigint(10) UNSIGNED ZEROFILL NOT NULL,
  `CurriculumCourseID` int(10) UNSIGNED ZEROFILL NOT NULL,
  `CourseCoReq` varchar(30) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Sample course co-requisites
INSERT INTO `coursecoreq` (`CourseCoReqID`, `CurriculumCourseID`, `CourseCoReq`) VALUES
(0000000001, 0000000001, 'CS102'),
(0000000002, 0000000001, 'IT101'),
(0000000003, 0000000002, 'CE201'),
(0000000004, 0000000003, 'ME201'),
(0000000005, 0000000004, 'BA201'),
(0000000006, 0000000004, 'ECON101'),
(0000000007, 0000000005, 'NURS201'),
(0000000008, 0000000006, 'LAW201'),
(0000000009, 0000000007, 'ART201'),
(0000000010, 0000000007, 'HS201');


-- --------------------------------------------------------

--
-- Table structure for table `courseplotting`
--

CREATE TABLE `courseplotting` (
  `CoursePlottingID` bigint(10) UNSIGNED ZEROFILL NOT NULL,
  `CourseScheduleID` bigint(10) UNSIGNED ZEROFILL NOT NULL,
  `VenueID` int(10) UNSIGNED ZEROFILL NOT NULL,
  `DayOfWeek` tinyint(1) NOT NULL,
  `StartTime` time NOT NULL,
  `EndTime` time NOT NULL,
  `EmployeeNo` varchar(30) NOT NULL,
  `ClassTypeID` int(10) UNSIGNED ZEROFILL NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Sample course plotting data
INSERT INTO `courseplotting` (`CoursePlottingID`, `CourseScheduleID`, `VenueID`, `DayOfWeek`, `StartTime`, `EndTime`, `EmployeeNo`, `ClassTypeID`) VALUES
(0000000001, 0000000001, 0000000001, 1, '08:00:00', '10:00:00', 'EMP001', 0000000001),
(0000000002, 0000000002, 0000000002, 2, '09:30:00', '11:30:00', 'EMP002', 0000000001),
(0000000003, 0000000003, 0000000003, 3, '14:00:00', '16:00:00', 'EMP003', 0000000002),
(0000000004, 0000000004, 0000000004, 4, '10:00:00', '12:00:00', 'EMP004', 0000000002),
(0000000005, 0000000005, 0000000005, 5, '13:30:00', '15:30:00', 'EMP005', 0000000003),
(0000000006, 0000000006, 0000000006, 1, '08:00:00', '10:00:00', 'EMP006', 0000000003),
(0000000007, 0000000007, 0000000007, 2, '09:30:00', '11:30:00', 'EMP007', 0000000004),
(0000000008, 0000000008, 0000000008, 3, '14:00:00', '16:00:00', 'EMP008', 0000000004),
(0000000009, 0000000009, 0000000009, 4, '10:00:00', '12:00:00', 'EMP009', 0000000005),
(0000000010, 0000000010, 0000000010, 5, '13:30:00', '15:30:00', 'EMP010', 0000000005);


-- --------------------------------------------------------

--
-- Table structure for table `courseprereq`
--

CREATE TABLE `courseprereq` (
  `CoursePreReqID` bigint(10) UNSIGNED ZEROFILL NOT NULL,
  `CurriculumCourseID` int(10) UNSIGNED ZEROFILL NOT NULL,
  `CoursePreReq` varchar(30) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Sample course prerequisites
INSERT INTO `courseprereq` (`CoursePreReqID`, `CurriculumCourseID`, `CoursePreReq`) VALUES
(0000000001, 0000000001, 'CS101'),
(0000000002, 0000000002, 'CS101'),
(0000000003, 0000000002, 'CS102'),
(0000000004, 0000000003, 'CS102'),
(0000000005, 0000000004, 'IT101'),
(0000000006, 0000000005, 'CE101'),
(0000000007, 0000000006, 'CE101'),
(0000000008, 0000000006, 'CE201'),
(0000000009, 0000000007, 'ME101'),
(0000000010, 0000000007, 'ME201'),
(0000000011, 0000000008, 'BA101'),
(0000000012, 0000000009, 'ECON101'),
(0000000013, 0000000010, 'EDU101'),
(0000000014, 0000000011, 'EDU101'),
(0000000015, 0000000012, 'NURS101'),
(0000000016, 0000000013, 'NURS101'),
(0000000017, 0000000014, 'PHAR101'),
(0000000018, 0000000015, 'MED101'),
(0000000019, 0000000016, 'LAW101'),
(0000000020, 0000000017, 'ART101');


-- --------------------------------------------------------

--
-- Table structure for table `courseschedule`
--

CREATE TABLE `courseschedule` (
  `CourseScheduleID` bigint(10) UNSIGNED ZEROFILL NOT NULL,
  `CourseCode` varchar(30) NOT NULL,
  `FacultyNo` varchar(30) NOT NULL,
  `AcademicTermID` bigint(10) UNSIGNED ZEROFILL NOT NULL,
  `Year` varchar(45) DEFAULT NULL,
  `Section` varchar(45) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Sample course schedule data
INSERT INTO `courseschedule` (`CourseScheduleID`, `CourseCode`, `FacultyNo`, `AcademicTermID`, `Year`, `Section`) VALUES
(0000000001, 'CS101', 'EMP001', 0000000001, '2023', 'A'),
(0000000002, 'CS102', 'EMP002', 0000000001, '2023', 'B'),
(0000000003, 'IT101', 'EMP003', 0000000001, '2023', 'A'),
(0000000004, 'CE101', 'EMP004', 0000000001, '2023', 'B'),
(0000000005, 'BA101', 'EMP005', 0000000001, '2023', 'A'),
(0000000006, 'NURS101', 'EMP006', 0000000001, '2023', 'A'),
(0000000007, 'LAW101', 'EMP007', 0000000001, '2023', 'A'),
(0000000008, 'ART101', 'EMP008', 0000000001, '2023', 'A'),
(0000000009, 'CS201', 'EMP009', 0000000001, '2023', 'B'),
(0000000010, 'ME201', 'EMP010', 0000000001, '2023', 'B'),
(0000000011, 'BA201', 'EMP001', 0000000002, '2023', 'A'),
(0000000012, 'EDU101', 'EMP002', 0000000002, '2023', 'A'),
(0000000013, 'NURS201', 'EMP003', 0000000002, '2023', 'A'),
(0000000014, 'MED101', 'EMP004', 0000000002, '2023', 'A'),
(0000000015, 'LAW201', 'EMP005', 0000000002, '2023', 'A'),
(0000000016, 'HS201', 'EMP006', 0000000002, '2023', 'A'),
(0000000017, 'CE201', 'EMP007', 0000000002, '2023', 'A'),
(0000000018, 'ART201', 'EMP008', 0000000002, '2023', 'A'),
(0000000019, 'CS101', 'EMP009', 0000000002, '2023', 'B'),
(0000000020, 'IT101', 'EMP010', 0000000002, '2023', 'B');


-- --------------------------------------------------------

--
-- Table structure for table `curriculum`
--

CREATE TABLE `curriculum` (
  `CurriculumID` int(10) UNSIGNED ZEROFILL NOT NULL,
  `ProgramID` int(10) UNSIGNED ZEROFILL NOT NULL,
  `CurriculumName` varchar(400) DEFAULT NULL,
  `CurriculumBOT` varchar(100) DEFAULT NULL,
  `Effectivity` varchar(45) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Sample curriculum data
INSERT INTO `curriculum` (`CurriculumID`, `ProgramID`, `CurriculumName`, `CurriculumBOT`, `Effectivity`) VALUES
(0000000011, 0000000001, 'BSIT 2024 Curriculum', '2024-04', 'August 2024'),
(0000000012, 0000000002, 'BSCS 2024 Curriculum', '2024-05', 'August 2024'),
(0000000013, 0000000003, 'BBA 2024 Curriculum', '2024-03', 'August 2024'),
(0000000014, 0000000004, 'BSME 2024 Curriculum', '2024-05', 'August 2024'),
(0000000015, 0000000005, 'BSCE 2024 Curriculum', '2024-04', 'August 2024'),
(0000000016, 0000000006, 'BEEd 2024 Curriculum', '2024-03', 'August 2024'),
(0000000017, 0000000007, 'BSEd 2024 Curriculum', '2024-03', 'August 2024'),
(0000000018, 0000000008, 'BSN 2024 Curriculum', '2024-04', 'August 2024'),
(0000000019, 0000000009, 'PharmD 2024 Curriculum', '2024-05', 'August 2024'),
(0000000020, 0000000010, 'MD 2024 Curriculum', '2024-06', 'August 2024');


--
-- Dumping data for table `curriculum`
--

INSERT INTO `curriculum` (`CurriculumID`, `ProgramID`, `CurriculumName`, `CurriculumBOT`, `Effectivity`) VALUES
(0000000001, 0000000001, 'BSIT 2023 Curriculum', '2023-04', 'August 2023'),
(0000000002, 0000000002, 'BSCS 2023 Curriculum', '2023-05', 'August 2023');

-- Sample curriculum data
INSERT INTO `curriculum` (`CurriculumID`, `ProgramID`, `CurriculumName`, `CurriculumBOT`, `Effectivity`) VALUES
(0000000003, 0000000003, 'BBA 2023 Curriculum', '2023-03', 'August 2023'),
(0000000004, 0000000004, 'BSME 2023 Curriculum', '2023-05', 'August 2023'),
(0000000005, 0000000005, 'BSCE 2023 Curriculum', '2023-04', 'August 2023'),
(0000000006, 0000000006, 'BEEd 2023 Curriculum', '2023-03', 'August 2023'),
(0000000007, 0000000007, 'BSEd 2023 Curriculum', '2023-03', 'August 2023'),
(0000000008, 0000000008, 'BSN 2023 Curriculum', '2023-04', 'August 2023'),
(0000000009, 0000000009, 'PharmD 2023 Curriculum', '2023-05', 'August 2023'),
(0000000010, 0000000010, 'MD 2023 Curriculum', '2023-06', 'August 2023');


-- --------------------------------------------------------

--
-- Table structure for table `curriculumcourse`
--

CREATE TABLE `curriculumcourse` (
  `CurriculumCourseID` int(10) UNSIGNED ZEROFILL NOT NULL,
  `CurriculumID` int(10) UNSIGNED ZEROFILL NOT NULL,
  `CourseCode` varchar(30) NOT NULL,
  `Year` int(2) NOT NULL,
  `Term` varchar(50) NOT NULL,
  `LecUnits` int(1) NOT NULL,
  `LabUnits` int(1) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `curriculumcourse`
--

INSERT INTO `curriculumcourse` (`CurriculumCourseID`, `CurriculumID`, `CourseCode`, `Year`, `Term`, `LecUnits`, `LabUnits`) VALUES
(0000000001, 0000000001, 'CCIT101', 1, '1st', 2, 3),
(0000000002, 0000000001, 'CCIT102', 1, '2nd', 2, 3),
(0000000003, 0000000001, 'CCIT103', 2, '1st', 3, 0);
-- Additional data for curriculumcourse table
INSERT INTO `curriculumcourse` (`CurriculumCourseID`, `CurriculumID`, `CourseCode`, `Year`, `Term`, `LecUnits`, `LabUnits`) VALUES
(0000000004, 0000000001, 'CS101', 1, '1st', 3, 2),
(0000000005, 0000000001, 'CS102', 1, '2nd', 3, 2),
(0000000006, 0000000001, 'CS201', 2, '1st', 3, 2),
(0000000007, 0000000001, 'IT101', 2, '2nd', 2, 3),
(0000000008, 0000000001, 'SE101', 3, '1st', 2, 3),
(0000000009, 0000000002, 'CE101', 1, '1st', 3, 2),
(0000000010, 0000000002, 'CE201', 1, '2nd', 3, 2),
(0000000011, 0000000002, 'ME101', 2, '1st', 2, 3),
(0000000012, 0000000002, 'ME201', 2, '2nd', 2, 3),
(0000000013, 0000000003, 'BA101', 1, '1st', 3, 2),
(0000000014, 0000000003, 'BA201', 1, '2nd', 3, 2),
(0000000015, 0000000003, 'ECON101', 2, '1st', 2, 3),
(0000000016, 0000000004, 'EDU101', 1, '1st', 3, 2),
(0000000017, 0000000004, 'EDU201', 1, '2nd', 2, 3),
(0000000018, 0000000005, 'NURS101', 1, '1st', 3, 2),
(0000000019, 0000000005, 'NURS201', 1, '2nd', 3, 2),
(0000000020, 0000000005, 'PHAR101', 2, '1st', 2, 3),
(0000000021, 0000000006, 'MED101', 1, '1st', 3, 2),
(0000000022, 0000000007, 'LAW101', 1, '1st', 3, 2),
(0000000023, 0000000007, 'LAW201', 1, '2nd', 2, 3);



-- --------------------------------------------------------

--
-- Table structure for table `regdocumentlist`
--

CREATE TABLE `regdocumentlist` (
  `RegDocumentListID` int(10) NOT NULL,
  `DocumentName` varchar(250) NOT NULL,
  `DocumentDescription` TEXT NOT NULL,
  `EffectivityDate` DATE NOT NULL,
  `CreatedAt` DATETIME NOT NULL,
  `DeletedAt` DATETIME DEFAULT NULL,
  `LastUpdateAt` DATETIME DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `regdocumentlist` (`RegDocumentListID`, `DocumentName`, `DocumentDescription`, `EffectivityDate`, `CreatedAt`, `DeletedAt`, `LastUpdateAt`) VALUES
(1, 'Enrollment Requirements', 'List of documents required for newly enrolled students', '2023-10-01', '2023-10-01 00:00:00', null, null);
-- --------------------------------------------------------

--
-- Table structure for table `regdocumentrequirement`
--

CREATE TABLE `regdocumentrequirement` (
  `RegDocumentRequirementID` int(10) NOT NULL,
  `RegDocumentListID` int(10) DEFAULT NULL,
  `DocumentName` varchar(300) DEFAULT NULL,
  `DocumentDescription` TEXT NOT NULL,
  `CreatedAt` DATETIME NOT NULL,
  `DeletedAt` DATETIME DEFAULT NULL,
  `LastUpdateAt` DATETIME DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `regdocumentrequirement` (`RegDocumentRequirementID`, `RegDocumentListID`, `DocumentName`, `DocumentDescription`, `CreatedAt`, `DeletedAt`, `LastUpdateAt`) VALUES
(1, 1, 'Transcript of Records', 'Your official record of grades from your SHS.', '2023-10-01 00:00:00', null, null),
(2, 1, 'Certificate of Good Moral Character', 'Document that proves your good moral character from your previous school',  '2023-10-01 00:00:00', null, null);
-- --------------------------------------------------------

--
-- Table structure for table `employee`
--

CREATE TABLE `employee` (
  `EmployeeNo` varchar(30) NOT NULL,
  `FirstName` varchar(350) DEFAULT NULL,
  `MiddleName` varchar(350) DEFAULT NULL,
  `LastName` varchar(350) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Sample employee data
INSERT INTO `employee` (`EmployeeNo`, `FirstName`, `MiddleName`, `LastName`) VALUES
('EMP001', 'John', 'David', 'Smith'),
('EMP002', 'Alice', 'Marie', 'Johnson'),
('EMP003', 'Robert', 'James', 'Brown'),
('EMP004', 'Emily', 'Grace', 'Davis'),
('EMP005', 'Michael', 'Joseph', 'Wilson'),
('EMP006', 'Sophia', 'Elizabeth', 'Martinez'),
('EMP007', 'William', 'Charles', 'Jones'),
('EMP008', 'Olivia', 'Ann', 'Miller'),
('EMP009', 'David', 'Edward', 'Garcia'),
('EMP010', 'Emma', 'Rose', 'Anderson');

-- --------------------------------------------------------

--
-- Table structure for table `fees`
--

CREATE TABLE `fees` (
  `FeeID` int(10) UNSIGNED ZEROFILL NOT NULL,
  `ProgramID` int(10) UNSIGNED ZEROFILL NOT NULL,
  `FeeTypeID` int(10) UNSIGNED ZEROFILL NOT NULL,
  `Amount` decimal(20,2) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `feetype`
--

CREATE TABLE `feetype` (
  `FeeTypeID` int(10) UNSIGNED ZEROFILL NOT NULL,
  `FeeType` varchar(200) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `googleaccount`
--

CREATE TABLE `googleaccount` (
  `EmailAddress` varchar(200) NOT NULL,
  `StudentNo` varchar(100) NOT NULL,
  `EmployeeNo` varchar(30) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*
-- Sample Google account data
INSERT INTO `googleaccount` (`EmailAddress`, `StudentNo`, `EmployeeNo`) VALUES
('john.smith@my.cspc.edu.ph', 'STU0001', NULL),
('alice.johnson@my.cspc.edu.ph', 'STU0002', NULL),
('robert.brown@my.cspc.edu.ph', 'STU0003', NULL),
('emily.davis@my.cspc.edu.ph', 'STU0004', NULL),
('michael.wilson@my.cspc.edu.ph', 'STU0005', NULL),
('sophia.martinez@my.cspc.edu.ph', 'STU0006', NULL),
('william.jones@my.cspc.edu.ph', 'STU0007', NULL),
('olivia.miller@my.cspc.edu.ph', 'STU0008', NULL),
('david.garcia@my.cspc.edu.ph', 'STU0009', NULL),
('emma.anderson@my.cspc.edu.ph', 'STU0010', NULL),
('prof.johnson@cspc.edu.ph', NULL, 'EMP001'),
('prof.smith@cspc.edu.ph', NULL, 'EMP002'),
('prof.martin@cspc.edu.ph', NULL, 'EMP003'),
('prof.davis@cspc.edu.ph', NULL, 'EMP004'),
('prof.wilson@cspc.edu.ph', NULL, 'EMP005'),
('prof.jones@cspc.edu.ph', NULL, 'EMP006'),
('prof.miller@cspc.edu.ph', NULL, 'EMP007'),
('prof.garcia@cspc.edu.ph', NULL, 'EMP008'),
('prof.anderson@cspc.edu.ph', NULL, 'EMP009'),
('prof.tuligs@cspc.edu.ph', NULL, 'EMP010');
*/

-- --------------------------------------------------------

--
-- Table structure for table `reggrade`
--

CREATE TABLE `reggrade` (
  `RegGradeID` bigint(10) NOT NULL,
  `StudentNo` varchar(100) DEFAULT NULL,
  `CourseCode` varchar(30) DEFAULT NULL,
  `Grade` varchar(45) DEFAULT NULL,
  `AcademicTermID` bigint(10) UNSIGNED ZEROFILL NOT NULL,
  `UserIDwhoinput` varchar(45) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `orgactivity`
--

CREATE TABLE `orgactivity` (
  `OrgActivityID` int(10) UNSIGNED ZEROFILL NOT NULL,
  `OrganizationID` int(10) UNSIGNED ZEROFILL NOT NULL,
  `ActivityName` varchar(300) DEFAULT NULL,
  `ActivityDateStart` datetime DEFAULT NULL,
  `ActivityDateEnd` datetime DEFAULT NULL,
  `ActivityType` varchar(100) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Sample orgactivity data
INSERT INTO `orgactivity` (`OrgActivityID`, `OrganizationID`, `ActivityName`, `ActivityDateStart`, `ActivityDateEnd`, `ActivityType`) VALUES
(00000000001, 0000000001, 'Club Meeting', '2023-09-15 10:00:00', '2023-09-15 12:00:00', 'Meeting'),
(00000000002, 0000000002, 'Seminar on Leadership', '2023-09-20 09:30:00', '2023-09-20 16:30:00', 'Seminar'),
(00000000003, 0000000003, 'Community Service', '2023-10-05 08:00:00', '2023-10-05 15:00:00', 'Service'),
(00000000004, 0000000004, 'Workshop on Coding', '2023-10-10 14:00:00', '2023-10-10 17:00:00', 'Workshop'),
(00000000005, 0000000005, 'Fundraising Event', '2023-10-15 11:00:00', '2023-10-15 19:00:00', 'Fundraising'),
(00000000006, 0000000006, 'Art Exhibition', '2023-11-05 10:00:00', '2023-11-10 18:00:00', 'Exhibition'),
(00000000007, 0000000007, 'Sports Tournament', '2023-11-15 08:30:00', '2023-11-20 16:00:00', 'Sports'),
(00000000008, 0000000008, 'Career Fair', '2023-12-01 09:00:00', '2023-12-01 17:00:00', 'Career Fair'),
(00000000009, 0000000009, 'Cultural Night', '2024-01-10 18:00:00', '2024-01-10 22:00:00', 'Cultural'),
(00000000010, 0000000010, 'Debate Competition', '2024-01-20 13:30:00', '2024-01-20 17:30:00', 'Competition'),
(00000000011, 0000000011, 'Environmental Cleanup', '2024-02-05 09:00:00', '2024-02-05 12:00:00', 'Cleanup'),
(00000000012, 0000000012, 'Music Concert', '2024-02-15 19:30:00', '2024-02-15 23:00:00', 'Concert'),
(00000000013, 0000000013, 'Health Awareness Campaign', '2024-03-10 08:30:00', '2024-03-10 16:30:00', 'Campaign'),
(00000000014, 0000000014, 'Science Fair', '2024-03-20 10:00:00', '2024-03-20 17:00:00', 'Fair'),
(00000000015, 0000000015, 'Charity Drive', '2024-04-05 14:00:00', '2024-04-05 18:00:00', 'Charity'),
(00000000016, 0000000016, 'Dance Workshop', '2024-04-15 15:30:00', '2024-04-15 18:30:00', 'Workshop'),
(00000000017, 0000000017, 'Film Screening', '2024-05-01 19:00:00', '2024-05-01 21:00:00', 'Screening'),
(00000000018, 0000000018, 'Tech Expo', '2024-05-10 10:00:00', '2024-05-10 16:00:00', 'Expo'),
(00000000019, 0000000019, 'Volunteer Day', '2024-06-05 08:00:00', '2024-06-05 14:00:00', 'Volunteer'),
(00000000020, 0000000020, 'Fashion Show', '2024-06-15 17:00:00', '2024-06-15 20:00:00', 'Fashion');


-- --------------------------------------------------------

--
-- Table structure for table `organization`
--

CREATE TABLE `organization` (
  `OrganizationID` int(10) UNSIGNED ZEROFILL NOT NULL,
  `CampusID` int(10) UNSIGNED ZEROFILL NOT NULL,
  `OrganizationName` varchar(300) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Sample organization data
INSERT INTO `organization` (`OrganizationID`, `CampusID`, `OrganizationName`) VALUES
(0000000001, 0000000001, 'Computer Science Club'),
(0000000002, 0000000001, 'Engineering Society'),
(0000000003, 0000000002, 'Business Association'),
(0000000004, 0000000002, 'Marketing Club'),
(0000000005, 0000000003, 'Health Sciences Society'),
(0000000006, 0000000003, 'Nursing Students Association'),
(0000000007, 0000000004, 'Art and Design Club'),
(0000000008, 0000000004, 'Theater Ensemble'),
(0000000009, 0000000005, 'Student Government Association'),
(0000000010, 0000000005, 'Debate Club');
-- Additional organization data
INSERT INTO `organization` (`OrganizationID`, `CampusID`, `OrganizationName`) VALUES
(0000000011, 0000000001, 'Mathematics Club'),
(0000000012, 0000000001, 'Science Society'),
(0000000013, 0000000002, 'Entrepreneurship Club'),
(0000000014, 0000000002, 'Finance Society'),
(0000000015, 0000000003, 'Medical Students Association'),
(0000000016, 0000000003, 'Psychology Club'),
(0000000017, 0000000004, 'Music Ensemble'),
(0000000018, 0000000004, 'Dance Club'),
(0000000019, 0000000005, 'Environmental Advocates'),
(0000000020, 0000000005, 'Social Justice Committee');


-- --------------------------------------------------------

--
-- Table structure for table `orgofficer`
--

CREATE TABLE `orgofficer` (
  `OrgOfficerID` int(10) UNSIGNED ZEROFILL NOT NULL,
  `OrganizationID` int(10) UNSIGNED ZEROFILL NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `otherfees`
--

CREATE TABLE `otherfees` (
  `OID` int(11) NOT NULL,
  `AssessmentID` int(10) UNSIGNED ZEROFILL NOT NULL,
  `OSemester` varchar(200) NOT NULL,
  `SchoolYear` varchar(100) NOT NULL,
  `Description` varchar(100) NOT NULL,
  `Amount` float(15,2) NOT NULL,
  `AmountPaid` float(15,2) NOT NULL,
  `Status` varchar(100) NOT NULL COMMENT 'Paid/Unpiand/Partialpaid'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `payment`
--

CREATE TABLE `payment` (
  `PaymentID` int(10) UNSIGNED ZEROFILL NOT NULL,
  `StudentNo` varchar(100) NOT NULL,
  `PaymentDate` datetime NOT NULL,
  `Amount` decimal(20,2) NOT NULL,
  `PaymentTypeID` int(10) UNSIGNED ZEROFILL NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `paymentitem`
--

CREATE TABLE `paymentitem` (
  `PaymentItemID` bigint(10) UNSIGNED ZEROFILL NOT NULL,
  `PaymentID` int(10) UNSIGNED ZEROFILL NOT NULL,
  `FeeID` int(10) UNSIGNED ZEROFILL NOT NULL,
  `Quantity` int(5) NOT NULL,
  `SubTotal` decimal(30,2) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `paymenttype`
--

CREATE TABLE `paymenttype` (
  `PaymentTypeID` int(10) UNSIGNED ZEROFILL NOT NULL,
  `PaymentType` varchar(100) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `program`
--

CREATE TABLE `program` (
  `ProgramID` int(10) UNSIGNED ZEROFILL NOT NULL,
  `CollegeID` int(10) UNSIGNED ZEROFILL NOT NULL,
  `ProgramDesc` varchar(450) NOT NULL,
  `ProgramAbbr` varchar(200) NOT NULL,
  `ProgramLevelID` int(10) UNSIGNED ZEROFILL NOT NULL,
  `DefaultCurriculumID` int(10) DEFAULT NULL COMMENT 'Default Curriculum for Program'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `program`
--

INSERT INTO `program` (`ProgramID`, `CollegeID`, `ProgramDesc`, `ProgramAbbr`, `ProgramLevelID`, `DefaultCurriculumID`) VALUES
(0000000001, 0000000001, 'Bachelor of Science in Information Technology', 'BSIT', 0000000001, NULL),
(0000000002, 0000000001, 'Bachelor of Science in Computer Science', 'BSCS', 0000000001, NULL),
(0000000003, 0000000001, 'Bachelor of Science in Information Science', 'BSIS', 0000000001, NULL);

-- Programs for CollegeID 1
INSERT INTO `program` (`ProgramID`, `CollegeID`, `ProgramDesc`, `ProgramAbbr`, `ProgramLevelID`, `DefaultCurriculumID`) VALUES
(0000000004, 0000000001, 'Bachelor of Science in Software Engineering', 'BSSE', 0000000001, NULL),
(0000000005, 0000000001, 'Bachelor of Science in Computer Engineering', 'BSCE', 0000000001, NULL);

-- Programs for CollegeID 2
INSERT INTO `program` (`ProgramID`, `CollegeID`, `ProgramDesc`, `ProgramAbbr`, `ProgramLevelID`, `DefaultCurriculumID`) VALUES
(0000000006, 0000000002, 'Bachelor of Science in Mechanical Engineering', 'BSME', 0000000001, NULL),
(0000000007, 0000000002, 'Bachelor of Science in Civil Engineering', 'BSCE', 0000000001, NULL);

-- Programs for CollegeID 3
INSERT INTO `program` (`ProgramID`, `CollegeID`, `ProgramDesc`, `ProgramAbbr`, `ProgramLevelID`, `DefaultCurriculumID`) VALUES
(0000000008, 0000000003, 'Master of Business Administration', 'MBA', 0000000002, NULL),
(0000000009, 0000000003, 'Bachelor of Arts in Economics', 'BAE', 0000000001, NULL);

-- Programs for CollegeID 4
INSERT INTO `program` (`ProgramID`, `CollegeID`, `ProgramDesc`, `ProgramAbbr`, `ProgramLevelID`, `DefaultCurriculumID`) VALUES
(0000000010, 0000000004, 'Bachelor of Education in Elementary Education', 'BEEd', 0000000001, NULL),
(0000000011, 0000000004, 'Bachelor of Science in Secondary Education', 'BSEd', 0000000001, NULL);

-- Programs for CollegeID 5
INSERT INTO `program` (`ProgramID`, `CollegeID`, `ProgramDesc`, `ProgramAbbr`, `ProgramLevelID`, `DefaultCurriculumID`) VALUES
(0000000012, 0000000005, 'Bachelor of Science in Nursing', 'BSN', 0000000001, NULL),
(0000000013, 0000000005, 'Doctor of Pharmacy', 'PharmD', 0000000002, NULL);

-- Programs for CollegeID 6
INSERT INTO `program` (`ProgramID`, `CollegeID`, `ProgramDesc`, `ProgramAbbr`, `ProgramLevelID`, `DefaultCurriculumID`) VALUES
(0000000014, 0000000006, 'Doctor of Medicine', 'MD', 0000000002, NULL),
(0000000015, 0000000006, 'Master of Public Health', 'MPH', 0000000002, NULL);

-- Programs for CollegeID 7
INSERT INTO `program` (`ProgramID`, `CollegeID`, `ProgramDesc`, `ProgramAbbr`, `ProgramLevelID`, `DefaultCurriculumID`) VALUES
(0000000016, 0000000007, 'Juris Doctor', 'JD', 0000000002, NULL),
(0000000017, 0000000007, 'Master of Laws', 'LLM', 0000000002, NULL);

-- Programs for CollegeID 8
INSERT INTO `program` (`ProgramID`, `CollegeID`, `ProgramDesc`, `ProgramAbbr`, `ProgramLevelID`, `DefaultCurriculumID`) VALUES
(0000000018, 0000000008, 'Bachelor of Fine Arts', 'BFA', 0000000001, NULL),
(0000000019, 0000000008, 'Master of Fine Arts', 'MFA', 0000000002, NULL);

-- Programs for CollegeID 9
INSERT INTO `program` (`ProgramID`, `CollegeID`, `ProgramDesc`, `ProgramAbbr`, `ProgramLevelID`, `DefaultCurriculumID`) VALUES
(0000000020, 0000000009, 'Bachelor of Science in Health Sciences', 'BSHS', 0000000001, NULL),
(0000000021, 0000000009, 'Master of Public Health', 'MPH', 0000000002, NULL);

-- Programs for CollegeID 10
INSERT INTO `program` (`ProgramID`, `CollegeID`, `ProgramDesc`, `ProgramAbbr`, `ProgramLevelID`, `DefaultCurriculumID`) VALUES
(0000000022, 0000000010, 'Bachelor of Science in Dental Hygiene', 'BSDH', 0000000001, NULL),
(0000000023, 0000000010, 'Doctor of Dental Medicine', 'DMD', 0000000002, NULL);


-- --------------------------------------------------------

--
-- Table structure for table `programlevel`
--

CREATE TABLE `programlevel` (
  `ProgramLevelID` int(10) UNSIGNED ZEROFILL NOT NULL,
  `ProgramLevelName` varchar(250) NOT NULL,
  `ProgramLevelDesc` varchar(500) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `programlevel`
--

INSERT INTO `programlevel` (`ProgramLevelID`, `ProgramLevelName`, `ProgramLevelDesc`) VALUES
(0000000001, 'Undergraduate', '(Certificate and Bachelor Programs)'),
(0000000002, 'Graduate', '(Graduate Micro-Program, Graduate Certificate, Graduate Diploma, Master and Doctoral Programs)'),
(0000000003, 'Undergraduate Degree Transfer', "(current undergraduate students who want to transfer from one Bachelor\'s degree program to another)"),
(0000000004, 'Undergraduate Independent Student', '(Part-time studies only; Courses taken are not part of a degree or certificate.)'),
(0000000005, 'Undergraduate Visiting Student from another University', ''),
(0000000006, 'Undergraduate Microprogram', '');

-- --------------------------------------------------------

--
-- Table structure for table `scholarship`
--

CREATE TABLE `scholarship` (
  `ScholarshipID` int(10) NOT NULL,
  `ScholarshipName` varchar(300) DEFAULT NULL,
  `Sponsor` varchar(100) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `scholarshipsubsidy`
--

CREATE TABLE `scholarshipsubsidy` (
  `ScholarshipID` int(11) UNSIGNED ZEROFILL NOT NULL,
  `AssessmentID` int(11) UNSIGNED ZEROFILL NOT NULL,
  `ScholarshipDescription` varchar(250) NOT NULL,
  `ScholarshipSubsidy` float(15,2) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `statement_of_account_fees`
--

CREATE TABLE `statement_of_account_fees` (
  `ID` int(10) NOT NULL,
  `SchoolYear` varchar(100) NOT NULL,
  `Date_create` datetime NOT NULL,
  `Colleg_ID` int(10) NOT NULL,
  `ProgramID` int(10) NOT NULL,
  `Student_year` varchar(100) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `StudentAcademicHistory`
--

CREATE TABLE `StudentAcademicHistory` (
  `StudentAcademicHistoryID` bigint(10) UNSIGNED ZEROFILL NOT NULL,
  `StudentAdmissionID` varchar(100) NOT NULL,
  `SchoolName` varchar(500) NOT NULL,
  `FromDate` date NOT NULL,
  `ToDate` date NOT NULL,
  `Degree` varchar(45) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Sample student academic history data
INSERT INTO `StudentAcademicHistory` (`StudentAcademicHistoryID`, `StudentAdmissionID`, `SchoolName`, `FromDate`, `ToDate`, `Degree`) VALUES
(0000000001, 'ADMISSION12345', 'High School 1', '2020-09-01', '2024-05-31', 'High School Diploma'),
(0000000002, 'ADMISSION67890', 'High School 2', '2019-08-01', '2023-06-30', 'High School Diploma'),
(0000000003, 'ADMISSION54321', 'High School 3', '2021-07-01', '2025-06-30', 'High School Diploma'),
(0000000004, 'ADMISSION24680', 'High School 4', '2022-09-01', '2026-05-31', 'High School Diploma'),
(0000000005, 'ADMISSION97531', 'High School 5', '2023-08-15', '2027-06-30', 'High School Diploma');

-- --------------------------------------------------------

--
-- Table structure for table `studentadditionalinfo`
--

CREATE TABLE `studentadditionalinfo` (
  `StudentAdditionalInfo` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `studentaddress`
--

CREATE TABLE `studentaddress` (
  `Student_AddressID` bigint(10) UNSIGNED ZEROFILL NOT NULL,
  `StudentNo` varchar(100) DEFAULT NULL,
  `Country` varchar(45) DEFAULT NULL,
  `HouseNo` varchar(45) DEFAULT NULL,
  `Street` varchar(45) DEFAULT NULL,
  `Brgy` varchar(45) DEFAULT NULL,
  `Town` varchar(45) DEFAULT NULL,
  `Province` varchar(45) DEFAULT NULL,
  `Region` varchar(45) DEFAULT NULL,
  `AddressLine1` varchar(45) DEFAULT NULL,
  `AddressLine2` varchar(45) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `StudentAdmissionSubmission`
--

CREATE TABLE `StudentAdmissionSubmission` (
  `StudentAdmissionSubmissionID` int(10) NOT NULL,
  `StudentAdmissionID` varchar(100) DEFAULT NULL,
  `DateSubmitted` datetime DEFAULT NULL,
  `RegDocumentRequirementID` int(10) DEFAULT NULL,
  `StudentRequirementFilename` varchar(45) DEFAULT NULL,
  `isValid` tinyint(1) DEFAULT NULL,
  `EmployeeNo` varchar(30) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Sample student admission submission data
INSERT INTO `StudentAdmissionSubmission` (`StudentAdmissionSubmissionID`, `StudentAdmissionID`, `DateSubmitted`, `RegDocumentRequirementID`, `StudentRequirementFilename`, `isValid`, `EmployeeNo`) VALUES
(1, 'ADMISSION12345', '2023-09-20 10:00:00', 1, 'Document1.pdf', 1, 'EMP001'),
(2, 'ADMISSION67890', '2023-09-21 09:30:00', 1, 'Document2.pdf', 1, 'EMP002'),
(3, 'ADMISSION54321', '2023-09-22 08:00:00', 1, 'Document3.pdf', 1, 'EMP003'),
(4, 'ADMISSION24680', '2023-09-23 14:00:00', 1, 'Document4.pdf', 1, 'EMP004'),
(5, 'ADMISSION97531', '2023-09-24 11:00:00', 1, 'Document5.pdf', 1, 'EMP005');


-- --------------------------------------------------------

--
-- Table structure for table `studentadmission_account`
--

CREATE TABLE `studentadmission_account` (
  `EmailAddress` varchar(100) NOT NULL,
  `Password` varchar(500) NOT NULL,
  `StudentAdmissionID` varchar(100) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Sample student admission account data
INSERT INTO `studentadmission_account` (`EmailAddress`, `Password`, `StudentAdmissionID`) VALUES
('student1@example.com', 'password1', 'ADMISSION12345'),
('student2@example.com', 'password2', 'ADMISSION67890'),
('student3@example.com', 'password3', 'ADMISSION54321'),
('student4@example.com', 'password4', 'ADMISSION24680'),
('student5@example.com', 'password5', 'ADMISSION97531');


-- --------------------------------------------------------

--
-- Table structure for table `StudentAdmission_Address`
--

CREATE TABLE `StudentAdmission_Address` (
  `StudentAdmission_AddressID` bigint(10) UNSIGNED ZEROFILL NOT NULL,
  `StudentAdmissionID` varchar(100) DEFAULT NULL,
  `Country` varchar(45) DEFAULT NULL,
  `HouseNo` varchar(45) DEFAULT NULL,
  `Street` varchar(45) DEFAULT NULL,
  `Brgy` varchar(45) DEFAULT NULL,
  `Town` varchar(45) DEFAULT NULL,
  `Province` varchar(45) DEFAULT NULL,
  `Region` varchar(45) DEFAULT NULL,
  `AddressLine1` varchar(45) DEFAULT NULL,
  `AddressLine2` varchar(45) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Sample student admission address data
INSERT INTO `StudentAdmission_Address` (`StudentAdmission_AddressID`, `StudentAdmissionID`, `Country`, `HouseNo`, `Street`, `Brgy`, `Town`, `Province`, `Region`, `AddressLine1`, `AddressLine2`) VALUES
(0000000001, 'ADMISSION12345', 'Country1', '123', 'Main Street', 'Brgy1', 'Town1', 'Province1', 'Region1', 'Address Line 1', 'Address Line 2'),
(0000000002, 'ADMISSION67890', 'Country2', '456', 'Second Street', 'Brgy2', 'Town2', 'Province2', 'Region2', 'Address Line 1', NULL),
(0000000003, 'ADMISSION54321', 'Country3', '789', 'Third Street', 'Brgy3', 'Town3', 'Province3', 'Region3', 'Address Line 1', 'Address Line 2'),
(0000000004, 'ADMISSION24680', 'Country4', '101', 'Fourth Street', 'Brgy4', 'Town4', 'Province4', 'Region4', 'Address Line 1', 'Address Line 2'),
(0000000005, 'ADMISSION97531', 'Country5', '202', 'Fifth Street', 'Brgy5', 'Town5', 'Province5', 'Region5', 'Address Line 1', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `StudentAdmission_Application`
--

CREATE TABLE `StudentAdmission_Application` (
  `StudentAdmission_ApplicationID` int(10) UNSIGNED ZEROFILL NOT NULL,
  `StudentAdmissionID` varchar(100) NOT NULL,
  `AcademicTermID` bigint(10) UNSIGNED ZEROFILL NOT NULL,
  `Remarks` varchar(250) NOT NULL,
  `DateCreated` datetime NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Sample student admission application data
INSERT INTO `StudentAdmission_Application` (`StudentAdmission_ApplicationID`, `StudentAdmissionID`, `AcademicTermID`, `Remarks`, `DateCreated`) VALUES
(0000000001, 'ADMISSION12345', 0000000001, 'Application for 1st Semester 2023', '2023-09-20 10:30:00'),
(0000000002, 'ADMISSION67890', 0000000001, 'Application for 1st Semester 2023', '2023-09-21 09:45:00'),
(0000000003, 'ADMISSION54321', 0000000001, 'Application for 1st Semester 2023', '2023-09-22 08:15:00'),
(0000000004, 'ADMISSION24680', 0000000001, 'Application for 1st Semester 2023', '2023-09-23 14:20:00'),
(0000000005, 'ADMISSION97531', 0000000001, 'Application for 1st Semester 2023', '2023-09-24 11:40:00');

-- --------------------------------------------------------

--
-- Table structure for table `studentassessmentfees`
--

CREATE TABLE `studentassessmentfees` (
  `FeesID` int(11) UNSIGNED ZEROFILL NOT NULL,
  `AssessmentID` int(11) UNSIGNED ZEROFILL NOT NULL,
  `AssessmentFessID` int(11) UNSIGNED ZEROFILL NOT NULL,
  `Amount` float(15,2) NOT NULL,
  `AmountPaid` float(15,2) NOT NULL COMMENT 'Paid/Unpaids',
  `Status` varchar(100) NOT NULL COMMENT 'Paid/Unpaid/Partialpaid'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `studentcourseschedule`
--

CREATE TABLE `studentcourseschedule` (
  `CourseScheduleID` bigint(10) UNSIGNED ZEROFILL NOT NULL,
  `StudentNo` varchar(100) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `studentcurriculum`
--

CREATE TABLE `studentcurriculum` (
  `StudentNo` varchar(100) NOT NULL,
  `CurriculumID` int(10) UNSIGNED ZEROFILL NOT NULL,
  `isCurrent` tinyint(1) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `regstudentdocumentsubmission`
--

CREATE TABLE `regstudentdocumentsubmission` (
  `RegStudentDocumentSubmissionID` int(10) NOT NULL,
  `StudentNo` varchar(100) DEFAULT NULL,
  `DateSubmitted` datetime DEFAULT NULL,
  `RegDocumentRequirementID` int(10) DEFAULT NULL,
  `StudentRequirementFilename` varchar(45) DEFAULT NULL,
  `isValid` tinyint(1) DEFAULT NULL,
  `EmployeeNo` varchar(30) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `studentinfo`
--

CREATE TABLE `studentinfo` (
  `StudentNo` varchar(100) NOT NULL,
  `FirstName` varchar(350) NOT NULL,
  `MiddleName` varchar(350) NOT NULL,
  `LastName` varchar(350) NOT NULL,
  `SexAssignedAtBirth` tinyint(1) NOT NULL,
  `DateOfBirth` date NOT NULL,
  `CitizenshipStatus` varchar(200) NOT NULL,
  `CitizenshipID` int(10) UNSIGNED ZEROFILL NOT NULL,
  `isTransferee` tinyint(1) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Additional data for studentinfo table
INSERT INTO `studentinfo` (`StudentNo`, `FirstName`, `MiddleName`, `LastName`, `SexAssignedAtBirth`, `DateOfBirth`, `CitizenshipStatus`, `CitizenshipID`, `isTransferee`) VALUES
('STU0001', 'John', 'Smith', 'Doe', 1, '1995-03-15', 'Filipino', 0000000001, 0),
('STU0002', 'Alice', 'Johnson', 'Smith', 0, '1996-07-20', 'American', 0000000002, 0),
('STU0003', 'Robert', 'Brown', 'Johnson', 1, '1994-11-10', 'Filipino', 0000000001, 0),
('STU0004', 'Emily', 'Davis', 'Brown', 0, '1997-05-28', 'American', 0000000002, 0),
('STU0005', 'Michael', 'Wilson', 'Davis', 1, '1998-02-14', 'Filipino', 0000000001, 0),
('STU0006', 'Sophia', 'Martinez', 'Wilson', 0, '1999-09-03', 'American', 0000000002, 0),
('STU0007', 'William', 'Jones', 'Martinez', 1, '1993-12-01', 'Filipino', 0000000001, 0),
('STU0008', 'Olivia', 'Miller', 'Jones', 0, '1992-06-22', 'American', 0000000002, 0),
('STU0009', 'David', 'Garcia', 'Miller', 1, '2000-04-18', 'Filipino', 0000000001, 0),
('STU0010', 'Emma', 'Anderson', 'Garcia', 0, '1991-10-09', 'American', 0000000002, 0);


-- --------------------------------------------------------

--
-- Table structure for table `StudentInfo_Admission`
--

CREATE TABLE `StudentInfo_Admission` (
  `StudentAdmissionID` varchar(100) NOT NULL,
  `FirstName` varchar(350) NOT NULL,
  `MiddleName` varchar(350) NOT NULL,
  `LastName` varchar(350) NOT NULL,
  `isMale` tinyint(1) NOT NULL,
  `DateOfBirth` date NOT NULL,
  `CitizenshipStatus` varchar(200) NOT NULL,
  `CitizenshipID` int(10) UNSIGNED ZEROFILL NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Sample data for StudentInfo_Admission table
INSERT INTO `StudentInfo_Admission` (`StudentAdmissionID`, `FirstName`, `MiddleName`, `LastName`, `isMale`, `DateOfBirth`, `CitizenshipStatus`, `CitizenshipID`) VALUES
('ADMISSION12345', 'John', 'Doe', 'Smith', 1, '2000-01-15', 'Citizen', 0000000001),
('ADMISSION67890', 'Jane', 'Lee', 'Johnson', 0, '1999-03-20', 'Citizen', 0000000002),
('ADMISSION54321', 'Robert', 'James', 'Brown', 1, '2001-05-10', 'Citizen', 0000000003),
('ADMISSION24680', 'Emily', 'Grace', 'Davis', 0, '2002-07-25', 'Citizen', 0000000004),
('ADMISSION97531', 'Michael', 'Allen', 'Wilson', 1, '1998-11-05', 'Citizen', 0000000005);

-- --------------------------------------------------------

--
-- Table structure for table `StudentParentGuardian`
--

CREATE TABLE `StudentParentGuardian` (
  `StudentParentGuardian` bigint(10) UNSIGNED ZEROFILL NOT NULL,
  `StudentAdmissionID` varchar(100) NOT NULL,
  `SPGFirstName` varchar(350) NOT NULL,
  `SPGMiddleName` varchar(350) DEFAULT NULL,
  `SPGLastName` varchar(350) NOT NULL,
  `TypeOfPGid` int(10) UNSIGNED ZEROFILL NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `StudentProgramChoice`
--

CREATE TABLE `StudentProgramChoice` (
  `StudentProgramChoiceID` bigint(10) UNSIGNED ZEROFILL NOT NULL,
  `StudentAdmissionID` varchar(100) NOT NULL,
  `ProgramID` int(10) UNSIGNED ZEROFILL NOT NULL,
  `Priority` tinyint(1) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `studentscholarship`
--

CREATE TABLE `studentscholarship` (
  `StudentScholarshipID` int(10) NOT NULL,
  `ScholarshipID` int(10) DEFAULT NULL,
  `StudentNo` varchar(100) DEFAULT NULL,
  `AcademicYear` varchar(45) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `student_assessment`
--

CREATE TABLE `student_assessment` (
  `SAID` int(10) UNSIGNED ZEROFILL NOT NULL,
  `StudentID` varchar(100) NOT NULL,
  `CollegeID` int(11) UNSIGNED ZEROFILL NOT NULL,
  `ProgramID` int(11) UNSIGNED ZEROFILL NOT NULL,
  `SchoolYear` varchar(100) NOT NULL,
  `Semester` varchar(100) NOT NULL,
  `YearLevel` varchar(100) NOT NULL,
  `CourseSection` varchar(100) NOT NULL,
  `CourseCode` varchar(100) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `regtransaction`
--

CREATE TABLE `regtransaction` (
  `RegTransactionID` int(10) NOT NULL,
  `StudentNo` varchar(45) DEFAULT NULL,
  `TransactionDesc` varchar(45) DEFAULT NULL,
  `Office` varchar(45) DEFAULT NULL,
  `DateTime` datetime DEFAULT NULL,
  `TransactionRequirements` varchar(45) DEFAULT NULL,
  `TransactionPayment` varchar(45) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `typeofparentguardian`
--

CREATE TABLE `typeofparentguardian` (
  `TypeOfPGid` int(10) UNSIGNED ZEROFILL NOT NULL,
  `TypeOfParentGuardian` varchar(250) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `venue`
--

CREATE TABLE `venue` (
  `VenueID` int(10) UNSIGNED ZEROFILL NOT NULL,
  `VenueDesc` varchar(300) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


INSERT INTO `venue` (`VenueID`, `VenueDesc`) VALUES
(0000000001, 'Conference Room A'),
(0000000002, 'Auditorium'),
(0000000003, 'Classroom 101'),
(0000000004, 'Outdoor Amphitheater'),
(0000000005, 'Lecture Hall B'),
(0000000006, 'Gymnasium'),
(0000000007, 'Library Meeting Room'),
(0000000008, 'Art Gallery'),
(0000000009, 'Sports Field'),
(0000000010, 'Cafeteria'),
(0000000011, 'Lab 301'),
(0000000012, 'Music Hall'),
(0000000013, 'Commons Area'),
(0000000014, 'Outdoor Pavilion'),
(0000000015, 'Computer Lab 202'),
(0000000016, 'Theater'),
(0000000017, 'Indoor Pool'),
(0000000018, 'Conference Room B'),
(0000000019, 'Soccer Field'),
(0000000020, 'Engineering Lab 401');



-- --------------------------------------------------------

--
-- Table structure for table `venueavailability`
--

CREATE TABLE `venueavailability` (
  `VenueAvailabilityID` bigint(10) UNSIGNED ZEROFILL NOT NULL,
  `AcademicTermID` bigint(10) UNSIGNED ZEROFILL NOT NULL,
  `VenueID` int(10) UNSIGNED ZEROFILL NOT NULL,
  `DayOfWeek` tinyint(1) NOT NULL,
  `StartTime` time NOT NULL,
  `EndTime` time NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `venueavailability` (`VenueAvailabilityID`, `AcademicTermID`, `VenueID`, `DayOfWeek`, `StartTime`, `EndTime`) VALUES
(0000000001, 0000000001, 0000000001, 1, '08:00:00', '10:00:00'),
(0000000002, 0000000001, 0000000002, 2, '09:30:00', '11:30:00'),
(0000000003, 0000000001, 0000000003, 3, '14:00:00', '16:00:00'),
(0000000004, 0000000002, 0000000004, 4, '10:00:00', '12:00:00'),
(0000000005, 0000000002, 0000000005, 5, '13:30:00', '15:30:00'),
(0000000006, 0000000002, 0000000006, 1, '08:00:00', '10:00:00'),
(0000000007, 0000000003, 0000000007, 2, '09:30:00', '11:30:00'),
(0000000008, 0000000003, 0000000008, 3, '14:00:00', '16:00:00'),
(0000000009, 0000000004, 0000000009, 4, '10:00:00', '12:00:00'),
(0000000010, 0000000004, 0000000010, 5, '13:30:00', '15:30:00'),
(0000000011, 0000000005, 0000000011, 1, '08:00:00', '10:00:00'),
(0000000012, 0000000005, 0000000012, 2, '09:30:00', '11:30:00'),
(0000000013, 0000000006, 0000000013, 3, '14:00:00', '16:00:00'),
(0000000014, 0000000006, 0000000014, 4, '10:00:00', '12:00:00'),
(0000000015, 0000000007, 0000000015, 5, '13:30:00', '15:30:00'),
(0000000016, 0000000007, 0000000016, 1, '08:00:00', '10:00:00'),
(0000000017, 0000000008, 0000000017, 2, '09:30:00', '11:30:00'),
(0000000018, 0000000008, 0000000018, 3, '14:00:00', '16:00:00'),
(0000000019, 0000000009, 0000000019, 4, '10:00:00', '12:00:00'),
(0000000020, 0000000009, 0000000020, 5, '13:30:00', '15:30:00');


-- --------------------------------------------------------

--
-- Table structure for table `version`
--

CREATE TABLE `version` (
  `VersionID` int(10) NOT NULL,
  `DateTime` datetime DEFAULT NULL,
  `VersionDesc` longtext NOT NULL,
  `ResponsiblePerson` varchar(300) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Indexes for dumped tables
--

--
-- Indexes for table `AcademicTerm`
--
ALTER TABLE `AcademicTerm`
  ADD PRIMARY KEY (`AcademicTermID`);

--
-- Indexes for table `accountlogs`
--
ALTER TABLE `accountlogs`
  ADD PRIMARY KEY (`AccountLogsID`),
  ADD KEY `fk_AccountLogs_GoogleAccount1_idx` (`EmailAddress`);

--
-- Indexes for table `activityvenue`
--
ALTER TABLE `activityvenue`
  ADD PRIMARY KEY (`OrgActivityID`,`VenueID`),
  ADD KEY `fk_ActivityVenue_OrgActiviy1_idx` (`OrgActivityID`),
  ADD KEY `fk_ActivityVenue_Venue1_idx` (`VenueID`);

--
-- Indexes for table `admissionaccount`
--
ALTER TABLE `admissionaccount`
  ADD PRIMARY KEY (`EmailAddress`),
  ADD KEY `fk_AdmissionAccount_StudentInfo_Admission1_idx` (`StudentAdmissionID`);

--
-- Indexes for table `assessmentfeessettings`
--
ALTER TABLE `assessmentfeessettings`
  ADD PRIMARY KEY (`AssessmentID`),
  ADD KEY `fk_AssessmentFeesSettings_Program1_idx` (`ProgramID`),
  ADD KEY `fk_AssessmentFeesSettings_College1_idx` (`CollegeID`);

--
-- Indexes for table `campus`
--
ALTER TABLE `campus`
  ADD PRIMARY KEY (`CampusID`);

--
-- Indexes for table `citizenship`
--
ALTER TABLE `citizenship`
  ADD PRIMARY KEY (`CitizenshipID`);

--
-- Indexes for table `classtype`
--
ALTER TABLE `classtype`
  ADD PRIMARY KEY (`ClassTypeID`);

--
-- Indexes for table `clearance`
--
ALTER TABLE `clearance`
  ADD PRIMARY KEY (`ClearanceID`),
  ADD KEY `fk_Clearance_Student_Assessment1_idx` (`AssessmentID`);

--
-- Indexes for table `college`
--
ALTER TABLE `college`
  ADD PRIMARY KEY (`CollegeID`),
  ADD KEY `fk_College_Campus_idx` (`CampusID`);

--
-- Indexes for table `course`
--
ALTER TABLE `course`
  ADD PRIMARY KEY (`CourseCode`),
  ADD KEY `fk_Course_Program1_idx` (`ProgramID`);

--
-- Indexes for table `coursecoreq`
--
ALTER TABLE `coursecoreq`
  ADD PRIMARY KEY (`CourseCoReqID`),
  ADD KEY `fk_CourseCoReq_CurriculumCourse1_idx` (`CurriculumCourseID`);

--
-- Indexes for table `courseplotting`
--
ALTER TABLE `courseplotting`
  ADD PRIMARY KEY (`CoursePlottingID`),
  ADD KEY `fk_CourseRoomAssignment_CourseSchedule1_idx` (`CourseScheduleID`),
  ADD KEY `fk_CourseRoomLabAssignment_RoomLab1_idx` (`VenueID`),
  ADD KEY `fk_CoursePlotting_Faculty1_idx` (`EmployeeNo`),
  ADD KEY `fk_CoursePlotting_ClassType1_idx` (`ClassTypeID`);

--
-- Indexes for table `courseprereq`
--
ALTER TABLE `courseprereq`
  ADD PRIMARY KEY (`CoursePreReqID`),
  ADD KEY `fk_CoursePreReq_CurriculumCourse1_idx` (`CurriculumCourseID`);

--
-- Indexes for table `courseschedule`
--
ALTER TABLE `courseschedule`
  ADD PRIMARY KEY (`CourseScheduleID`),
  ADD KEY `fk_StudentCourse_Course1_idx` (`CourseCode`),
  ADD KEY `fk_CourseSchedule_AcademicTerm1_idx` (`AcademicTermID`);

--
-- Indexes for table `curriculum`
--
ALTER TABLE `curriculum`
  ADD PRIMARY KEY (`CurriculumID`),
  ADD KEY `fk_Curriculum_Program1_idx` (`ProgramID`);

--
-- Indexes for table `curriculumcourse`
--
ALTER TABLE `curriculumcourse`
  ADD PRIMARY KEY (`CurriculumCourseID`),
  ADD KEY `fk_CurriculumCourse_Curriculum1_idx` (`CurriculumID`),
  ADD KEY `fk_CurriculumCourse_Course1_idx` (`CourseCode`);

--
-- Indexes for table `regdocumentlist`
--
ALTER TABLE `regdocumentlist`
  ADD PRIMARY KEY (`RegDocumentListID`);

--
-- Indexes for table `regdocumentrequirement`
--
ALTER TABLE `regdocumentrequirement`
  ADD PRIMARY KEY (`RegDocumentRequirementID`),
  ADD KEY `fk_RegDocumentRequirement_Document1_idx` (`RegDocumentListID`);

--
-- Indexes for table `employee`
--
ALTER TABLE `employee`
  ADD PRIMARY KEY (`EmployeeNo`);

--
-- Indexes for table `fees`
--
ALTER TABLE `fees`
  ADD PRIMARY KEY (`FeeID`),
  ADD KEY `fk_Fees_Program1_idx` (`ProgramID`),
  ADD KEY `fk_Fees_FeeType1_idx` (`FeeTypeID`);

--
-- Indexes for table `feetype`
--
ALTER TABLE `feetype`
  ADD PRIMARY KEY (`FeeTypeID`);

--
-- Indexes for table `googleaccount`
--
ALTER TABLE `googleaccount`
  ADD PRIMARY KEY (`EmailAddress`),
  ADD KEY `fk_GoogleAccount_StudentInfo1_idx` (`StudentNo`),
  ADD KEY `fk_GoogleAccount_Employee1_idx` (`EmployeeNo`);

--
-- Indexes for table `reggrade`
--
ALTER TABLE `reggrade`
  ADD PRIMARY KEY (`RegGradeID`),
  ADD KEY `fk_RegGrade_StudentInfo1_idx` (`StudentNo`),
  ADD KEY `fk_RegGrade_Course1_idx` (`CourseCode`),
  ADD KEY `fk_RegGrade_AcademicTerm1_idx` (`AcademicTermID`);

--
-- Indexes for table `orgactivity`
--
ALTER TABLE `orgactivity`
  ADD PRIMARY KEY (`OrgActivityID`),
  ADD KEY `fk_OrgActiviy_Organization1_idx` (`OrganizationID`);

--
-- Indexes for table `organization`
--
ALTER TABLE `organization`
  ADD PRIMARY KEY (`OrganizationID`),
  ADD KEY `fk_Organization_Campus1_idx` (`CampusID`);

--
-- Indexes for table `orgofficer`
--
ALTER TABLE `orgofficer`
  ADD PRIMARY KEY (`OrgOfficerID`),
  ADD KEY `fk_OrgOfficer_Organization1_idx` (`OrganizationID`);

--
-- Indexes for table `otherfees`
--
ALTER TABLE `otherfees`
  ADD PRIMARY KEY (`OID`),
  ADD KEY `fk_OtherFees_Student_Assessment_fees_info1_idx` (`AssessmentID`);

--
-- Indexes for table `payment`
--
ALTER TABLE `payment`
  ADD PRIMARY KEY (`PaymentID`),
  ADD KEY `fk_Payment_StudentInfo1_idx` (`StudentNo`),
  ADD KEY `fk_Payment_PaymentType1_idx` (`PaymentTypeID`);

--
-- Indexes for table `paymentitem`
--
ALTER TABLE `paymentitem`
  ADD PRIMARY KEY (`PaymentItemID`),
  ADD KEY `fk_PaymentItem_Fees1_idx` (`FeeID`),
  ADD KEY `fk_PaymentItem_Payment1_idx` (`PaymentID`);

--
-- Indexes for table `paymenttype`
--
ALTER TABLE `paymenttype`
  ADD PRIMARY KEY (`PaymentTypeID`);

--
-- Indexes for table `program`
--
ALTER TABLE `program`
  ADD PRIMARY KEY (`ProgramID`),
  ADD KEY `fk_Program_College1_idx` (`CollegeID`),
  ADD KEY `fk_Program_ProgramLevel1_idx` (`ProgramLevelID`);

--
-- Indexes for table `programlevel`
--
ALTER TABLE `programlevel`
  ADD PRIMARY KEY (`ProgramLevelID`);

--
-- Indexes for table `scholarship`
--
ALTER TABLE `scholarship`
  ADD PRIMARY KEY (`ScholarshipID`);

--
-- Indexes for table `scholarshipsubsidy`
--
ALTER TABLE `scholarshipsubsidy`
  ADD PRIMARY KEY (`ScholarshipID`),
  ADD KEY `fk_ScholarshipSubsidy_Student_Assessment_fees_info1_idx` (`AssessmentID`);

--
-- Indexes for table `statement_of_account_fees`
--
ALTER TABLE `statement_of_account_fees`
  ADD PRIMARY KEY (`ID`,`Date_create`);

--
-- Indexes for table `StudentAcademicHistory`
--
ALTER TABLE `StudentAcademicHistory`
  ADD PRIMARY KEY (`StudentAcademicHistoryID`),
  ADD KEY `fk_StudentAcademicHistory_StudentInfo_Admission1_idx` (`StudentAdmissionID`);

--
-- Indexes for table `studentadditionalinfo`
--
ALTER TABLE `studentadditionalinfo`
  ADD PRIMARY KEY (`StudentAdditionalInfo`);

--
-- Indexes for table `studentaddress`
--
ALTER TABLE `studentaddress`
  ADD PRIMARY KEY (`Student_AddressID`),
  ADD KEY `fk_StudentAddress_StudentInfo1_idx` (`StudentNo`);

--
-- Indexes for table `StudentAdmissionSubmission`
--
ALTER TABLE `StudentAdmissionSubmission`
  ADD PRIMARY KEY (`StudentAdmissionSubmissionID`),
  ADD KEY `fk_RegStudentDocumentSubmission_RegDocumentRequirement1_idx` (`RegDocumentRequirementID`),
  ADD KEY `fk_RegStudentDocumentSubmission_Employee1_idx` (`EmployeeNo`),
  ADD KEY `fk_StudentAdmissionSubmission_StudentInfo_Admission1_idx` (`StudentAdmissionID`);

--
-- Indexes for table `studentadmission_account`
--
ALTER TABLE `studentadmission_account`
  ADD PRIMARY KEY (`EmailAddress`),
  ADD KEY `fk_StudentAdmission_Account_StudentInfo_Admission1_idx` (`StudentAdmissionID`);

--
-- Indexes for table `StudentAdmission_Address`
--
ALTER TABLE `StudentAdmission_Address`
  ADD PRIMARY KEY (`StudentAdmission_AddressID`),
  ADD KEY `fk_StudentAdmission_Address_StudentInfo_Admission1_idx` (`StudentAdmissionID`);

--
-- Indexes for table `StudentAdmission_Application`
--
ALTER TABLE `StudentAdmission_Application`
  ADD PRIMARY KEY (`StudentAdmission_ApplicationID`),
  ADD KEY `fk_StudentAdmission_Application_StudentInfo_Admission1_idx` (`StudentAdmissionID`),
  ADD KEY `fk_StudentAdmission_Application_AdmissionTerm1_idx` (`AcademicTermID`);

--
-- Indexes for table `studentassessmentfees`
--
ALTER TABLE `studentassessmentfees`
  ADD PRIMARY KEY (`FeesID`),
  ADD KEY `fk_StudentAssessmentfees_Assessment_fees_Settings1_idx` (`AssessmentFessID`),
  ADD KEY `fk_StudentAssessmentfees_Student_Assessment_fees_info1_idx` (`AssessmentID`);

--
-- Indexes for table `studentcourseschedule`
--
ALTER TABLE `studentcourseschedule`
  ADD PRIMARY KEY (`CourseScheduleID`,`StudentNo`),
  ADD KEY `fk_StudentYearCourse_StudentInfo1_idx` (`StudentNo`),
  ADD KEY `fk_StudentPYS_CourseSchedule1_idx` (`CourseScheduleID`);

--
-- Indexes for table `studentcurriculum`
--
ALTER TABLE `studentcurriculum`
  ADD PRIMARY KEY (`StudentNo`,`CurriculumID`),
  ADD KEY `fk_StudentCurriculum_Curriculum1_idx` (`CurriculumID`);

--
-- Indexes for table `regstudentdocumentsubmission`
--
ALTER TABLE `regstudentdocumentsubmission`
  ADD PRIMARY KEY (`RegStudentDocumentSubmissionID`),
  ADD KEY `fk_StudentRequirement_StudentInfo1_idx` (`StudentNo`),
  ADD KEY `fk_RegStudentDocumentSubmission_RegDocumentRequirement1_idx` (`RegDocumentRequirementID`),
  ADD KEY `fk_RegStudentDocumentSubmission_Employee1_idx` (`EmployeeNo`);

--
-- Indexes for table `studentinfo`
--
ALTER TABLE `studentinfo`
  ADD PRIMARY KEY (`StudentNo`),
  ADD KEY `fk_StudentInfo_Citizenship1_idx` (`CitizenshipID`);

--
-- Indexes for table `StudentInfo_Admission`
--
ALTER TABLE `StudentInfo_Admission`
  ADD PRIMARY KEY (`StudentAdmissionID`),
  ADD KEY `fk_StudentInfo_Admission_Citizenship1_idx` (`CitizenshipID`);

--
-- Indexes for table `StudentParentGuardian`
--
ALTER TABLE `StudentParentGuardian`
  ADD PRIMARY KEY (`StudentParentGuardian`),
  ADD KEY `fk_StudentParentGuardian_TypeOfParentGuardian1_idx` (`TypeOfPGid`),
  ADD KEY `fk_StudentParentGuardian_StudentInfo_Admission1_idx` (`StudentAdmissionID`);

--
-- Indexes for table `StudentProgramChoice`
--
ALTER TABLE `StudentProgramChoice`
  ADD PRIMARY KEY (`StudentProgramChoiceID`),
  ADD KEY `fk_StudentProgramChoice_StudentInfo_Admission1_idx` (`StudentAdmissionID`),
  ADD KEY `fk_StudentProgramChoice_Program1_idx` (`ProgramID`);

--
-- Indexes for table `studentscholarship`
--
ALTER TABLE `studentscholarship`
  ADD PRIMARY KEY (`StudentScholarshipID`),
  ADD KEY `fk_StudentScholarship_Scholarship1_idx` (`ScholarshipID`),
  ADD KEY `fk_StudentScholarship_StudentInfo1_idx` (`StudentNo`);

--
-- Indexes for table `student_assessment`
--
ALTER TABLE `student_assessment`
  ADD PRIMARY KEY (`SAID`),
  ADD KEY `fk_Student_Assessment_fees_StudentInfo1_idx` (`StudentID`),
  ADD KEY `fk_Student_Assessment_fees_info_College1_idx` (`CollegeID`),
  ADD KEY `fk_Student_Assessment_fees_info_Program1_idx` (`ProgramID`);

--
-- Indexes for table `regtransaction`
--
ALTER TABLE `regtransaction`
  ADD PRIMARY KEY (`RegTransactionID`),
  ADD KEY `fk_RegTransaction_StudentInfo1_idx` (`StudentNo`);

--
-- Indexes for table `typeofparentguardian`
--
ALTER TABLE `typeofparentguardian`
  ADD PRIMARY KEY (`TypeOfPGid`);

--
-- Indexes for table `venue`
--
ALTER TABLE `venue`
  ADD PRIMARY KEY (`VenueID`);

--
-- Indexes for table `venueavailability`
--
ALTER TABLE `venueavailability`
  ADD PRIMARY KEY (`VenueAvailabilityID`),
  ADD KEY `fk_RoomLabAvailability_RoomLab1_idx` (`VenueID`),
  ADD KEY `fk_RoomLabAvailability_AcademicTerm1_idx` (`AcademicTermID`);

--
-- Indexes for table `version`
--
ALTER TABLE `version`
  ADD PRIMARY KEY (`VersionID`);

--
-- AUTO_INCREMENT for dumped tables
--

--
-- AUTO_INCREMENT for table `AcademicTerm`
--
ALTER TABLE `AcademicTerm`
  MODIFY `AcademicTermID` bigint(10) UNSIGNED ZEROFILL NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=4;

--
-- AUTO_INCREMENT for table `assessmentfeessettings`
--
ALTER TABLE `assessmentfeessettings`
  MODIFY `AssessmentID` int(11) UNSIGNED ZEROFILL NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=11;

--
-- AUTO_INCREMENT for table `campus`
--
ALTER TABLE `campus`
  MODIFY `CampusID` int(10) UNSIGNED ZEROFILL NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=3;

--
-- AUTO_INCREMENT for table `citizenship`
--
ALTER TABLE `citizenship`
  MODIFY `CitizenshipID` int(10) UNSIGNED ZEROFILL NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `classtype`
--
ALTER TABLE `classtype`
  MODIFY `ClassTypeID` int(10) UNSIGNED ZEROFILL NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `college`
--
ALTER TABLE `college`
  MODIFY `CollegeID` int(10) UNSIGNED ZEROFILL NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=3;

--
-- AUTO_INCREMENT for table `coursecoreq`
--
ALTER TABLE `coursecoreq`
  MODIFY `CourseCoReqID` bigint(10) UNSIGNED ZEROFILL NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `courseplotting`
--
ALTER TABLE `courseplotting`
  MODIFY `CoursePlottingID` bigint(10) UNSIGNED ZEROFILL NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `courseprereq`
--
ALTER TABLE `courseprereq`
  MODIFY `CoursePreReqID` bigint(10) UNSIGNED ZEROFILL NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `courseschedule`
--
ALTER TABLE `courseschedule`
  MODIFY `CourseScheduleID` bigint(10) UNSIGNED ZEROFILL NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `curriculum`
--
ALTER TABLE `curriculum`
  MODIFY `CurriculumID` int(10) UNSIGNED ZEROFILL NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=3;

--
-- AUTO_INCREMENT for table `curriculumcourse`
--
ALTER TABLE `curriculumcourse`
  MODIFY `CurriculumCourseID` int(10) UNSIGNED ZEROFILL NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=4;

--
-- AUTO_INCREMENT for table `fees`
--
ALTER TABLE `fees`
  MODIFY `FeeID` int(10) UNSIGNED ZEROFILL NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `feetype`
--
ALTER TABLE `feetype`
  MODIFY `FeeTypeID` int(10) UNSIGNED ZEROFILL NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `orgactivity`
--
ALTER TABLE `orgactivity`
  MODIFY `OrgActivityID` int(10) UNSIGNED ZEROFILL NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `organization`
--
ALTER TABLE `organization`
  MODIFY `OrganizationID` int(10) UNSIGNED ZEROFILL NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `orgofficer`
--
ALTER TABLE `orgofficer`
  MODIFY `OrgOfficerID` int(10) UNSIGNED ZEROFILL NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `otherfees`
--
ALTER TABLE `otherfees`
  MODIFY `OID` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `payment`
--
ALTER TABLE `payment`
  MODIFY `PaymentID` int(10) UNSIGNED ZEROFILL NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `paymentitem`
--
ALTER TABLE `paymentitem`
  MODIFY `PaymentItemID` bigint(10) UNSIGNED ZEROFILL NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `paymenttype`
--
ALTER TABLE `paymenttype`
  MODIFY `PaymentTypeID` int(10) UNSIGNED ZEROFILL NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `program`
--
ALTER TABLE `program`
  MODIFY `ProgramID` int(10) UNSIGNED ZEROFILL NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=4;

--
-- AUTO_INCREMENT for table `programlevel`
--
ALTER TABLE `programlevel`
  MODIFY `ProgramLevelID` int(10) UNSIGNED ZEROFILL NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=7;

--
-- AUTO_INCREMENT for table `StudentAcademicHistory`
--
ALTER TABLE `StudentAcademicHistory`
  MODIFY `StudentAcademicHistoryID` bigint(10) UNSIGNED ZEROFILL NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `studentaddress`
--
ALTER TABLE `studentaddress`
  MODIFY `Student_AddressID` bigint(10) UNSIGNED ZEROFILL NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `StudentAdmission_Address`
--
ALTER TABLE `StudentAdmission_Address`
  MODIFY `StudentAdmission_AddressID` bigint(10) UNSIGNED ZEROFILL NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `StudentAdmission_Application`
--
ALTER TABLE `StudentAdmission_Application`
  MODIFY `StudentAdmission_ApplicationID` int(10) UNSIGNED ZEROFILL NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `StudentParentGuardian`
--
ALTER TABLE `StudentParentGuardian`
  MODIFY `StudentParentGuardian` bigint(10) UNSIGNED ZEROFILL NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `StudentProgramChoice`
--
ALTER TABLE `StudentProgramChoice`
  MODIFY `StudentProgramChoiceID` bigint(10) UNSIGNED ZEROFILL NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `typeofparentguardian`
--
ALTER TABLE `typeofparentguardian`
  MODIFY `TypeOfPGid` int(10) UNSIGNED ZEROFILL NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `venue`
--
ALTER TABLE `venue`
  MODIFY `VenueID` int(10) UNSIGNED ZEROFILL NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `venueavailability`
--
ALTER TABLE `venueavailability`
  MODIFY `VenueAvailabilityID` bigint(10) UNSIGNED ZEROFILL NOT NULL AUTO_INCREMENT;

--
-- Constraints for dumped tables
--

--
-- Constraints for table `accountlogs`
--
ALTER TABLE `accountlogs`
  ADD CONSTRAINT `fk_AccountLogs_GoogleAccount1` FOREIGN KEY (`EmailAddress`) REFERENCES `googleaccount` (`EmailAddress`) ON DELETE NO ACTION ON UPDATE NO ACTION;

--
-- Constraints for table `activityvenue`
--
ALTER TABLE `activityvenue`
  ADD CONSTRAINT `fk_ActivityVenue_OrgActiviy1` FOREIGN KEY (`OrgActivityID`) REFERENCES `orgactivity` (`OrgActivityID`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  ADD CONSTRAINT `fk_ActivityVenue_Venue1` FOREIGN KEY (`VenueID`) REFERENCES `venue` (`VenueID`) ON DELETE NO ACTION ON UPDATE NO ACTION;

--
-- Constraints for table `admissionaccount`
--
ALTER TABLE `admissionaccount`
  ADD CONSTRAINT `fk_AdmissionAccount_StudentInfo_Admission1` FOREIGN KEY (`StudentAdmissionID`) REFERENCES `StudentInfo_Admission` (`StudentAdmissionID`) ON DELETE NO ACTION ON UPDATE NO ACTION;

--
-- Constraints for table `assessmentfeessettings`
--
ALTER TABLE `assessmentfeessettings`
  ADD CONSTRAINT `fk_AssessmentFeesSettings_College1` FOREIGN KEY (`CollegeID`) REFERENCES `college` (`CollegeID`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  ADD CONSTRAINT `fk_AssessmentFeesSettings_Program1` FOREIGN KEY (`ProgramID`) REFERENCES `program` (`ProgramID`) ON DELETE NO ACTION ON UPDATE NO ACTION;

--
-- Constraints for table `clearance`
--
ALTER TABLE `clearance`
  ADD CONSTRAINT `fk_Clearance_Student_Assessment1` FOREIGN KEY (`AssessmentID`) REFERENCES `student_assessment` (`SAID`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `college`
--
ALTER TABLE `college`
  ADD CONSTRAINT `fk_College_Campus` FOREIGN KEY (`CampusID`) REFERENCES `campus` (`CampusID`) ON DELETE NO ACTION ON UPDATE NO ACTION;

--
-- Constraints for table `course`
--
ALTER TABLE `course`
  ADD CONSTRAINT `fk_Course_Program1` FOREIGN KEY (`ProgramID`) REFERENCES `program` (`ProgramID`) ON DELETE NO ACTION ON UPDATE NO ACTION;

--
-- Constraints for table `coursecoreq`
--
ALTER TABLE `coursecoreq`
  ADD CONSTRAINT `fk_CourseCoReq_CurriculumCourse1` FOREIGN KEY (`CurriculumCourseID`) REFERENCES `curriculumcourse` (`CurriculumCourseID`) ON DELETE NO ACTION ON UPDATE NO ACTION;

--
-- Constraints for table `courseplotting`
--
ALTER TABLE `courseplotting`
  ADD CONSTRAINT `fk_CoursePlotting_ClassType1` FOREIGN KEY (`ClassTypeID`) REFERENCES `classtype` (`ClassTypeID`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  ADD CONSTRAINT `fk_CoursePlotting_Faculty1` FOREIGN KEY (`EmployeeNo`) REFERENCES `employee` (`EmployeeNo`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  ADD CONSTRAINT `fk_CourseRoomAssignment_CourseSchedule1` FOREIGN KEY (`CourseScheduleID`) REFERENCES `courseschedule` (`CourseScheduleID`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  ADD CONSTRAINT `fk_CourseRoomLabAssignment_RoomLab1` FOREIGN KEY (`VenueID`) REFERENCES `venue` (`VenueID`) ON DELETE NO ACTION ON UPDATE NO ACTION;

--
-- Constraints for table `courseprereq`
--
ALTER TABLE `courseprereq`
  ADD CONSTRAINT `fk_CoursePreReq_CurriculumCourse1` FOREIGN KEY (`CurriculumCourseID`) REFERENCES `curriculumcourse` (`CurriculumCourseID`) ON DELETE NO ACTION ON UPDATE NO ACTION;

--
-- Constraints for table `courseschedule`
--
ALTER TABLE `courseschedule`
  ADD CONSTRAINT `fk_CourseSchedule_AcademicTerm1` FOREIGN KEY (`AcademicTermID`) REFERENCES `AcademicTerm` (`AcademicTermID`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  ADD CONSTRAINT `fk_StudentCourse_Course1` FOREIGN KEY (`CourseCode`) REFERENCES `course` (`CourseCode`) ON DELETE NO ACTION ON UPDATE NO ACTION;

--
-- Constraints for table `curriculum`
--
ALTER TABLE `curriculum`
  ADD CONSTRAINT `fk_Curriculum_Program1` FOREIGN KEY (`ProgramID`) REFERENCES `program` (`ProgramID`) ON DELETE NO ACTION ON UPDATE NO ACTION;

--
-- Constraints for table `curriculumcourse`
--
ALTER TABLE `curriculumcourse`
  ADD CONSTRAINT `fk_CurriculumCourse_Course1` FOREIGN KEY (`CourseCode`) REFERENCES `course` (`CourseCode`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  ADD CONSTRAINT `fk_CurriculumCourse_Curriculum1` FOREIGN KEY (`CurriculumID`) REFERENCES `curriculum` (`CurriculumID`) ON DELETE NO ACTION ON UPDATE NO ACTION;

--
-- Constraints for table `regdocumentrequirement`
--
ALTER TABLE `regdocumentrequirement`
  ADD CONSTRAINT `fk_RegDocumentRequirement_Document1` FOREIGN KEY (`RegDocumentListID`) REFERENCES `regdocumentlist` (`RegDocumentListID`) ON DELETE NO ACTION ON UPDATE NO ACTION;

--
-- Constraints for table `fees`
--
ALTER TABLE `fees`
  ADD CONSTRAINT `fk_Fees_FeeType1` FOREIGN KEY (`FeeTypeID`) REFERENCES `feetype` (`FeeTypeID`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  ADD CONSTRAINT `fk_Fees_Program1` FOREIGN KEY (`ProgramID`) REFERENCES `program` (`ProgramID`) ON DELETE NO ACTION ON UPDATE NO ACTION;

--
-- Constraints for table `googleaccount`
--
ALTER TABLE `googleaccount`
  ADD CONSTRAINT `fk_GoogleAccount_Employee1` FOREIGN KEY (`EmployeeNo`) REFERENCES `employee` (`EmployeeNo`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  ADD CONSTRAINT `fk_GoogleAccount_StudentInfo1` FOREIGN KEY (`StudentNo`) REFERENCES `studentinfo` (`StudentNo`) ON DELETE NO ACTION ON UPDATE NO ACTION;

--
-- Constraints for table `reggrade`
--
ALTER TABLE `reggrade`
  ADD CONSTRAINT `fk_RegGrade_AcademicTerm1` FOREIGN KEY (`AcademicTermID`) REFERENCES `AcademicTerm` (`AcademicTermID`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  ADD CONSTRAINT `fk_RegGrade_Course1` FOREIGN KEY (`CourseCode`) REFERENCES `course` (`CourseCode`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  ADD CONSTRAINT `fk_RegGrade_StudentInfo1` FOREIGN KEY (`StudentNo`) REFERENCES `studentinfo` (`StudentNo`) ON DELETE NO ACTION ON UPDATE NO ACTION;

--
-- Constraints for table `orgactivity`
--
ALTER TABLE `orgactivity`
  ADD CONSTRAINT `fk_OrgActiviy_Organization1` FOREIGN KEY (`OrganizationID`) REFERENCES `organization` (`OrganizationID`) ON DELETE NO ACTION ON UPDATE NO ACTION;

--
-- Constraints for table `organization`
--
ALTER TABLE `organization`
  ADD CONSTRAINT `fk_Organization_Campus1` FOREIGN KEY (`CampusID`) REFERENCES `campus` (`CampusID`) ON DELETE NO ACTION ON UPDATE NO ACTION;

--
-- Constraints for table `orgofficer`
--
ALTER TABLE `orgofficer`
  ADD CONSTRAINT `fk_OrgOfficer_Organization1` FOREIGN KEY (`OrganizationID`) REFERENCES `organization` (`OrganizationID`) ON DELETE NO ACTION ON UPDATE NO ACTION;

--
-- Constraints for table `otherfees`
--
ALTER TABLE `otherfees`
  ADD CONSTRAINT `fk_OtherFees_Student_Assessment_fees_info1` FOREIGN KEY (`AssessmentID`) REFERENCES `student_assessment` (`SAID`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `payment`
--
ALTER TABLE `payment`
  ADD CONSTRAINT `fk_Payment_PaymentType1` FOREIGN KEY (`PaymentTypeID`) REFERENCES `paymenttype` (`PaymentTypeID`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  ADD CONSTRAINT `fk_Payment_StudentInfo1` FOREIGN KEY (`StudentNo`) REFERENCES `studentinfo` (`StudentNo`) ON DELETE NO ACTION ON UPDATE NO ACTION;

--
-- Constraints for table `paymentitem`
--
ALTER TABLE `paymentitem`
  ADD CONSTRAINT `fk_PaymentItem_Fees1` FOREIGN KEY (`FeeID`) REFERENCES `fees` (`FeeID`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  ADD CONSTRAINT `fk_PaymentItem_Payment1` FOREIGN KEY (`PaymentID`) REFERENCES `payment` (`PaymentID`) ON DELETE NO ACTION ON UPDATE NO ACTION;

--
-- Constraints for table `program`
--
ALTER TABLE `program`
  ADD CONSTRAINT `fk_Program_College1` FOREIGN KEY (`CollegeID`) REFERENCES `college` (`CollegeID`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  ADD CONSTRAINT `fk_Program_ProgramLevel1` FOREIGN KEY (`ProgramLevelID`) REFERENCES `programlevel` (`ProgramLevelID`) ON DELETE NO ACTION ON UPDATE NO ACTION;

--
-- Constraints for table `scholarshipsubsidy`
--
ALTER TABLE `scholarshipsubsidy`
  ADD CONSTRAINT `fk_ScholarshipSubsidy_Student_Assessment_fees_info1` FOREIGN KEY (`AssessmentID`) REFERENCES `student_assessment` (`SAID`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `StudentAcademicHistory`
--
ALTER TABLE `StudentAcademicHistory`
  ADD CONSTRAINT `fk_StudentAcademicHistory_StudentInfo_Admission1` FOREIGN KEY (`StudentAdmissionID`) REFERENCES `StudentInfo_Admission` (`StudentAdmissionID`) ON DELETE NO ACTION ON UPDATE NO ACTION;

--
-- Constraints for table `studentaddress`
--
ALTER TABLE `studentaddress`
  ADD CONSTRAINT `fk_StudentAddress_StudentInfo1` FOREIGN KEY (`StudentNo`) REFERENCES `studentinfo` (`StudentNo`) ON DELETE NO ACTION ON UPDATE NO ACTION;

--
-- Constraints for table `StudentAdmissionSubmission`
--
ALTER TABLE `StudentAdmissionSubmission`
  ADD CONSTRAINT `fk_StudentAdmissionSubmission_StudentInfo_Admission1` FOREIGN KEY (`StudentAdmissionID`) REFERENCES `StudentInfo_Admission` (`StudentAdmissionID`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  ADD CONSTRAINT `fk_RegStudentDocumentSubmission_RegDocumentRequirement10` FOREIGN KEY (`RegDocumentRequirementID`) REFERENCES `regdocumentrequirement` (`RegDocumentRequirementID`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  ADD CONSTRAINT `fk_RegStudentDocumentSubmission_Employee10` FOREIGN KEY (`EmployeeNo`) REFERENCES `employee` (`EmployeeNo`) ON DELETE NO ACTION ON UPDATE NO ACTION;

--
-- Constraints for table `studentadmission_account`
--
ALTER TABLE `studentadmission_account`
  ADD CONSTRAINT `fk_StudentAdmission_Account_StudentInfo_Admission1` FOREIGN KEY (`StudentAdmissionID`) REFERENCES `StudentInfo_Admission` (`StudentAdmissionID`) ON DELETE NO ACTION ON UPDATE NO ACTION;

--
-- Constraints for table `StudentAdmission_Address`
--
ALTER TABLE `StudentAdmission_Address`
  ADD CONSTRAINT `fk_StudentAdmission_Address_StudentInfo_Admission1` FOREIGN KEY (`StudentAdmissionID`) REFERENCES `StudentInfo_Admission` (`StudentAdmissionID`) ON DELETE NO ACTION ON UPDATE NO ACTION;

--
-- Constraints for table `StudentAdmission_Application`
--
ALTER TABLE `StudentAdmission_Application`
  ADD CONSTRAINT `fk_StudentAdmission_Application_AdmissionTerm1` FOREIGN KEY (`AcademicTermID`) REFERENCES `AcademicTerm` (`AcademicTermID`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  ADD CONSTRAINT `fk_StudentAdmission_Application_StudentInfo_Admission1` FOREIGN KEY (`StudentAdmissionID`) REFERENCES `StudentInfo_Admission` (`StudentAdmissionID`) ON DELETE NO ACTION ON UPDATE NO ACTION;

--
-- Constraints for table `studentassessmentfees`
--
ALTER TABLE `studentassessmentfees`
  ADD CONSTRAINT `fk_StudentAssessmentfees_Assessment_fees_Settings1` FOREIGN KEY (`AssessmentFessID`) REFERENCES `assessmentfeessettings` (`AssessmentID`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `fk_StudentAssessmentfees_Student_Assessment_fees_info1` FOREIGN KEY (`AssessmentID`) REFERENCES `student_assessment` (`SAID`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `studentcourseschedule`
--
ALTER TABLE `studentcourseschedule`
  ADD CONSTRAINT `fk_StudentPYS_CourseSchedule1` FOREIGN KEY (`CourseScheduleID`) REFERENCES `courseschedule` (`CourseScheduleID`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  ADD CONSTRAINT `fk_StudentYearCourse_StudentInfo1` FOREIGN KEY (`StudentNo`) REFERENCES `studentinfo` (`StudentNo`) ON DELETE NO ACTION ON UPDATE NO ACTION;

--
-- Constraints for table `studentcurriculum`
--
ALTER TABLE `studentcurriculum`
  ADD CONSTRAINT `fk_StudentCurriculum_Curriculum1` FOREIGN KEY (`CurriculumID`) REFERENCES `curriculum` (`CurriculumID`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  ADD CONSTRAINT `fk_StudentCurriculum_StudentInfo1` FOREIGN KEY (`StudentNo`) REFERENCES `studentinfo` (`StudentNo`) ON DELETE NO ACTION ON UPDATE NO ACTION;

--
-- Constraints for table `regstudentdocumentsubmission`
--
ALTER TABLE `regstudentdocumentsubmission`
  ADD CONSTRAINT `fk_RegStudentDocumentSubmission_RegDocumentRequirement1` FOREIGN KEY (`RegDocumentRequirementID`) REFERENCES `regdocumentrequirement` (`RegDocumentRequirementID`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  ADD CONSTRAINT `fk_RegStudentDocumentSubmission_Employee1` FOREIGN KEY (`EmployeeNo`) REFERENCES `employee` (`EmployeeNo`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  ADD CONSTRAINT `fk_StudentRequirement_StudentInfo1` FOREIGN KEY (`StudentNo`) REFERENCES `studentinfo` (`StudentNo`) ON DELETE NO ACTION ON UPDATE NO ACTION;

--
-- Constraints for table `studentinfo`
--
ALTER TABLE `studentinfo`
  ADD CONSTRAINT `fk_StudentInfo_Citizenship1` FOREIGN KEY (`CitizenshipID`) REFERENCES `citizenship` (`CitizenshipID`) ON DELETE NO ACTION ON UPDATE NO ACTION;

--
-- Constraints for table `StudentInfo_Admission`
--
ALTER TABLE `StudentInfo_Admission`
  ADD CONSTRAINT `fk_StudentInfo_Admission_Citizenship1` FOREIGN KEY (`CitizenshipID`) REFERENCES `citizenship` (`CitizenshipID`) ON DELETE NO ACTION ON UPDATE NO ACTION;

--
-- Constraints for table `StudentParentGuardian`
--
ALTER TABLE `StudentParentGuardian`
  ADD CONSTRAINT `fk_StudentParentGuardian_StudentInfo_Admission1` FOREIGN KEY (`StudentAdmissionID`) REFERENCES `StudentInfo_Admission` (`StudentAdmissionID`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  ADD CONSTRAINT `fk_StudentParentGuardian_TypeOfParentGuardian1` FOREIGN KEY (`TypeOfPGid`) REFERENCES `typeofparentguardian` (`TypeOfPGid`) ON DELETE NO ACTION ON UPDATE NO ACTION;

--
-- Constraints for table `StudentProgramChoice`
--
ALTER TABLE `StudentProgramChoice`
  ADD CONSTRAINT `fk_StudentProgramChoice_Program1` FOREIGN KEY (`ProgramID`) REFERENCES `program` (`ProgramID`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  ADD CONSTRAINT `fk_StudentProgramChoice_StudentInfo_Admission1` FOREIGN KEY (`StudentAdmissionID`) REFERENCES `StudentInfo_Admission` (`StudentAdmissionID`) ON DELETE NO ACTION ON UPDATE NO ACTION;

--
-- Constraints for table `studentscholarship`
--
ALTER TABLE `studentscholarship`
  ADD CONSTRAINT `fk_StudentScholarship_Scholarship1` FOREIGN KEY (`ScholarshipID`) REFERENCES `scholarship` (`ScholarshipID`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  ADD CONSTRAINT `fk_StudentScholarship_StudentInfo1` FOREIGN KEY (`StudentNo`) REFERENCES `studentinfo` (`StudentNo`) ON DELETE NO ACTION ON UPDATE NO ACTION;

--
-- Constraints for table `student_assessment`
--
ALTER TABLE `student_assessment`
  ADD CONSTRAINT `fk_Student_Assessment_fees_StudentInfo1` FOREIGN KEY (`StudentID`) REFERENCES `studentinfo` (`StudentNo`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `fk_Student_Assessment_fees_info_College1` FOREIGN KEY (`CollegeID`) REFERENCES `college` (`CollegeID`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `fk_Student_Assessment_fees_info_Program1` FOREIGN KEY (`ProgramID`) REFERENCES `program` (`ProgramID`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `fk_Student_Assessment_fees_info_StudentInfo1` FOREIGN KEY (`StudentID`) REFERENCES `studentinfo` (`StudentNo`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `regtransaction`
--
ALTER TABLE `regtransaction`
  ADD CONSTRAINT `fk_RegTransaction_StudentInfo1` FOREIGN KEY (`StudentNo`) REFERENCES `studentinfo` (`StudentNo`) ON DELETE NO ACTION ON UPDATE NO ACTION;

--
-- Constraints for table `venueavailability`
--
ALTER TABLE `venueavailability`
  ADD CONSTRAINT `fk_RoomLabAvailability_AcademicTerm1` FOREIGN KEY (`AcademicTermID`) REFERENCES `AcademicTerm` (`AcademicTermID`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  ADD CONSTRAINT `fk_RoomLabAvailability_RoomLab1` FOREIGN KEY (`VenueID`) REFERENCES `venue` (`VenueID`) ON DELETE NO ACTION ON UPDATE NO ACTION;
COMMIT;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
