$(document).ready(function () {

    var college = document.getElementById('college');
      // Clear existing options
    college.innerHTML = '<option selected>Please Select</option>';
      // Fetch data from CodeIgniter using AJAX
      $.ajax({
        url: BASE_URL + 'AdmissionReportController/getProgramsByCollege',
        type: 'GET',
        dataType: 'json',
        success: function (data) {
            // Populate options from the received data
            console.log(data);
            data.forEach(function (program) {
                var option = document.createElement('option');
                option.value = program.CollegeID;
                option.text = program.CollegeDesc;
                college.appendChild(option);

            });

        },
        error: function (error) {
            console.error('Error fetching data:', error);
        }
    });
    // FOR PROGRAM NAMAN
    $("#college").change(function () {
        // Retrieve the selected program ID
        var collegeId = $("#college").val();

        // Check if a program is selected
        if (collegeId === "Please Select") {
            // Optionally, you can clear or hide any related elements when no program is selected
            // For example: $("#relatedElement").hide();
            return;
        }

        // Fetch and display data related to the selected program
        $.ajax({
            url: BASE_URL + 'AdmissionReportController/getCollegebyProgram/' + collegeId, 
            type: 'GET',
            dataType: 'json',
            success: function (data) {
                // Update or display the data as needed
               console.log(data);
                console.log('go');

                // Clear existing options
                //   $("#courseSelect").empty();
                // Clear existing options and add an empty option
                $("#program").empty().append($('<option>', {
                    value: '', // Set value to empty or adjust as needed
                    text: 'Select a course' // Set text for the empty option
                }));

                // Populate options from the received data
                data.forEach(function (course) {
                    var option = document.createElement('option');
                    option.value = course.ProgramID; // Adjust the value based on your data
                    option.text = course.ProgramDesc; // Adjust the text based on your data
                    $("#program").append(option);

                });
            },
            error: function (error) {
                console.error('Error fetching data:', error);
            }
        });
    });

     // When a college is selected
    
    // Initialize DataTable with export buttons
    var table = $("#datatables").DataTable({
        processing: true,
        serverSide: true,
        ajax: {
            url: BASE_URL + "AdmissionReportController/fetchRows",
            type: "POST",
            data: function(d) {
                // Dynamically add the filters to the AJAX request
                d.applicationType = $("select[name='applicationType']").val();
                d.status = $("select[name='status']").val();
            },
            error: function (xhr, error, thrown) {
                console.error("AJAX Error:", error, thrown);
                alert("Failed to fetch data. Please try again.");
            }
        },
        lengthMenu: [
            [10, 25, 50, -1],
            [10, 25, 50, "All"],
        ],
        order: [],
        columnDefs: [
            { targets: [0], orderable: false },
        ],
        buttons: [
            {
                extend: 'excelHtml5',
                text: 'Export Excel',
                className: 'dropdown-item',
                title: 'Data Export',
            },
            {
                extend: 'csvHtml5',
                text: 'Export CSV',
                className: 'dropdown-item',
                title: 'Data Export',
            },
            {
                extend: 'pdfHtml5',
                text: 'Export PDF',
                className: 'dropdown-item',
                title: 'Data Export',
            }
        ],
        drawCallback: function () {
            console.log("Table loaded.");
        },
    });

    // Handle filter button click
    $(document).on("click", "#btnsearch", function (e) {
        e.preventDefault();

        // Reload the table data with the updated filters
        table.ajax.reload(); // This reloads data with the filters
    });

    // Export to Excel
    $(document).on("click", "#exportExcel", function (e) {
        e.preventDefault();
        table.button('.buttons-excel').trigger(); // Trigger Excel export
    });

    // Export to CSV
    $(document).on("click", "#exportCsv", function (e) {
        e.preventDefault();
        table.button('.buttons-csv').trigger(); // Trigger CSV export
    });

    // Export to PDF
    $(document).on("click", "#exportPdf", function (e) {
        e.preventDefault();
        table.button('.buttons-pdf').trigger(); // Trigger PDF export
    });
});
