<?php

class MYPDF extends TCPDF
{
    // Page header
    public function Header()
    {
        // Set font
        $this->SetFont('helvetica', '', 10);
          // Logo or image 
          $x = 10;
          $y = 0;
          $w = 18;
          $h = 18;
          $image_file2 = FCPATH . 'writable/headerlogo/cspcc.jpg';  
          $this->Image($image_file2, $x, $y, $w, $h, 'JPG', '', '', false, 300, '', false, false, 0, false, false);
        // Title
        $this->Cell(0, 8, '                Republic of the Philippines', 0, true, 'L', 0, '', 0, true, 'M', 'M');
        $this->Cell(0, 8, '                CAMARINES SUR POLYTECHNIC COLLEGES', 0, true, 'L', 0, '', 0, true, 'M', 'M');
        $this->Cell(0, 8, '                Nabua, Camarines Sur', 0, true, 'L', 0, '', 0, true, 'M', 'M');
    }
}

// create new PDF document
$pdf = new MYPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

// set document information
$pdf->SetCreator(PDF_CREATOR);
$pdf->SetAuthor('Nicola Asuni');
$pdf->SetTitle('Admission Slip');
$pdf->SetSubject('TCPDF Tutorial');
$pdf->SetKeywords('TCPDF, PDF, example, test, guide');

// set default header data
$pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . ' 009', PDF_HEADER_STRING);

// set header and footer fonts
$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));

// set default monospaced font
$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

// set margins
$pdf->SetMargins(PDF_MARGIN_LEFT, 10, PDF_MARGIN_RIGHT); // Adjust top margin
$pdf->SetHeaderMargin(5); // Adjust header margin
$pdf->SetFooTermargin(PDF_MARGIN_FOOTER);

// set auto page breaks
$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);

// set image scale factor
$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);

// set some language-dependent strings (optional)
if (@file_exists(dirname(__FILE__) . '/lang/eng.php')) {
    require_once(dirname(__FILE__) . '/lang/eng.php');
    $pdf->setLanguageArray($l);
}

// -------------------------------------------------------------------
// Get the dimensions of the page
// $pageWidth = $pdf->getPageWidth();

$pageWidth = $pdf->getPageWidth();
$customHeight = 210; // Height in millimeters (8.5 inches).
// add a page
$pdf->AddPage('P', array($pageWidth, $customHeight));
$pdf->ln(10);
// FOR LINE IN TCPDF
 
$lineStyle = array('width' => 0.2, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(0, 0, 0));  
 // Draw a line from (x1, y1) to (x2, y2).
$pdf->Line(10, 21, 170, 21, $lineStyle);  //for applicant line
$pdf->Line(140, 100, 195, 100, $lineStyle);  //LINE OF THE PASSPORT
$pdf->Line(10, 135, 200, 135, $lineStyle);  //for applicant line
// FOR PASSPORT SIZE FOR IMAGE
 // Draw a passport-sized box
$pdf->SetLineStyle(array('width' => 0.2, 'color' => array(0, 0, 0)));
 // Passport size: 35mm x 45mm
$pdf->Rect(140, 88, 55, 35, 'D'); 

 // Draw a passport-sized box
 $pdf->SetLineStyle(array('width' => 0.2, 'color' => array(0, 0, 0)));
 // Passport size: 35mm x 45mm
$pdf->Rect(153, 40, 35, 45, 'D'); 
// ==============================
 // 'Exam_date', 'Start_time', 'End_time', 'Venue', 'Details', 'Created_at'
foreach ($info as $row):
    $StudentAdmissionID = $row->StudentAdmissionID; 
    $Exam_date = $row->Exam_date; 
    $Start_time = $row->Start_time; 
    $Venue = $row->Venue; 
    $Details = $row->Details; 
    $Created_at = $row->Created_at; 
    $name = $row->FirstName.' ' . $row->MiddleName.' '. $row->LastName;
    $program = $row->ProgramDesc;
    $lastschool = $row->SchoolName;
    $applicationDate = date('F j, Y', strtotime($row->DateCreated));
    $studentImage = $row->Image;
 // application date date('Y-m-d H:i:s'),
endforeach;
// ====================
$pdf->ln(3);
$pdf->Cell(90, 0, "", 0, 0, 'C'); 

$pdf->SetFont('helvetica', 'B', 10);
$pdf->Cell(50, 0, "Control Number:", 0, 0, 'R'); 
// $StudentAdmissionID = 396931758;
// $applicationDate = "9/10/2024";
// $name="asd";
// $program="ad";
// $lastschool="asd";
// $Exam_date= "asd";
// $Start_time="asda";
// $Venue = "asd";
// $studentImage = "asdsad";
$pdf->SetFont('helvetica', '', 10);
$pdf->Cell(40, 0, $StudentAdmissionID, 1, 1, 'C'); 
$pdf->ln(5);
$pdf->SetFont('helvetica', 'B', 10);
$pdf->Cell(0, 0, "STUDENT TESTING AND ADMISSION OFFICE", 0, 1, 'C'); 
$pdf->Cell(0, 0, "CSPC-COLLEGE ENTRANCE TEST (CSPC-CET)", 0, 1, 'C'); 
$pdf->Cell(0, 0, "EXAMINATION PERMIT", 0, 1, 'C'); 
$pdf->Cell(0, 0, "S/Y 2024-2025", 0, 1, 'C'); 

$pdf->SetFont('helvetica', '', 11);
$pdf->ln(5);
 
$pdf->Cell(40, 0, "Date of Application:", 0, 0, 'L');
$pdf->Cell(140, 0, $applicationDate, 0, 1, 'L'); 
$pdf->ln(5);
$pdf->SetFont('helvetica', 'B', 11);
$pdf->Cell(50, 0, "STUDENT INFORMATION", 0, 1, 'L'); 
$pdf->SetFont('helvetica', '', 11); 
$pdf->ln(5);
$pdf->Cell(12, 0, "Name:", 0, 0, 'L'); 
$pdf->Cell(165, 0, $name, 0, 1, 'L'); 
$pdf->Cell(35, 0, "Program Applied:", 0, 0, 'L'); 
$pdf->Cell(145, 0, $program, 0, 1, 'L'); 
$pdf->Cell(45, 0, "School Last Attended:", 0, 0, 'L'); 
$pdf->Cell(135, 0, $lastschool, 0, 1, 'L'); 
$pdf->ln(5);
$pdf->SetFont('helvetica', 'B', 11);
$pdf->Cell(0, 0, "SCHEDULE", 0, 1, 'L'); 
$pdf->SetFont('helvetica', '', 11);
$pdf->ln(5);
$pdf->Cell(15, 0, "Date:", 0, 0, 'L'); 
$pdf->Cell(165, 0, $Exam_date, 0, 1, 'L'); 
$pdf->Cell(15, 0, "Time:", 0, 0, 'L'); 
$pdf->Cell(165, 0, $Start_time, 0, 1, 'L'); 
$pdf->Cell(15, 0, "Venue", 0, 0, 'L'); 
$pdf->Cell(165, 0, $Venue, 0, 1, 'L'); 
$pdf->ln(5);

$pdf->SetFont('helvetica', '', 10);
$html = ' 
<p style="font-size: 11px;"><i>What to Bring: Pencils (preferably Mongol No. 2), Examination Permit, and packed snacks</i><br>
<i>Note: There will be no re-scheduling. All applicants should come on the designated date and time. Examinees are advised to <br>
bring snacks and drinks because nobody is allowed to go out once the test has started.</i>
 
 </p> 
';

// Output HTML content
$pdf->writeHTML($html, true, false, true, false, '');
 

// Add text inside the box
$pdf->SetFont('helvetica', 'B', 10);
$pdf->Text(159, 95, 'Signature');
$pdf->SetFont('helvetica', 'B', 10);
$pdf->Text(152, 118, 'Right Thumbmark');

$pdf->SetFont('helvetica', '', 10);
$pdf->ln(18);
$pdf->Cell(60, 0, "Effectively Date: December 2023", 0, 0, 'L'); 
// $pdf->Cell(60, 0, FCPATH, 0, 0, 'L'); 
$pdf->Cell(60, 0, "Rev. 0", 0, 0, 'C'); 

// $pdf->Cell(65, 0, $studentImage, 1, 1, 'R'); 
$pdf->Cell(65, 0, "Page 1 of 1", 0, 0, 'R'); 

// FOR IMAGE OF THE STUDENT
 // Image example with resizing
$pdf->Image('images/image_demo.jpg', 15, 140, 75, 113, 'JPG', 'http://www.tcpdf.org', '', true, 150, '', false, false, 1, false, false, false);

// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

// test fitbox with all alignment combinations

$horizontal_alignments = array('L', 'C', 'R');
$vertical_alignments = array('T', 'M', 'B');

$x = 153.5;
$y = 40;
$w = 34;
$h = 45;
$pdf->Rect($x, $y, $w, $h, 'F', array(), array(128,255,128));  // Draw a filled rectangle with green background

// $image_file = FCPATH . 'writable/uploads/logo_example.jpg'; 
$image_file = FCPATH . 'uploadsImage/'.$studentImage; 
$pdf->Image($image_file, $x, $y, $w, $h, 'JPG', '', '', false, 300, '', false, false, 0, false, false);
 
$pdf->Text(170, 18, 'CSPC-F-STA-15');
$pdf->Text(5, 17, 'ISO 9001:2015');
 
$pdf->Output('example_009.pdf', 'I');
exit;
?>