<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Student Data - Window View</title>
    <style>
        /* Styling the window frame */
        .window-frame {
            width: 80%;
            height: 500px;
            margin: 20px auto;
            border: 2px solid #ccc;
            border-radius: 8px;
            background-color: #fff;
            position: relative;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
        }

        /* Title bar styling */
        .window-title-bar {
            background-color: #4CAF50;
            color: white;
            padding: 10px;
            text-align: center;
            font-size: 18px;
            border-top-left-radius: 8px;
            border-top-right-radius: 8px;
        }

        /* Close button */
        .close-button {
            position: absolute;
            top: 10px;
            right: 10px;
            background-color: red;
            color: white;
            border: none;
            padding: 5px;
            cursor: pointer;
            border-radius: 50%;
        }

        /* iframe styling */
        .iframe-content {
            width: 100%;
            height: 90%;
            border: none;
        }

        /* Add responsiveness for smaller screens */
        @media (max-width: 768px) {
            .window-frame {
                width: 95%;
                height: 400px;
            }
        }
    </style>
</head>
<body>

    <!-- Window frame with iframe inside -->
    <div class="window-frame">
        <div class="window-title-bar">
            <span>Student Data</span>
            <button class="close-button" onclick="closeWindow()">X</button>
        </div>
        <iframe class="iframe-content" src="<?= base_url('student/view') ?>" id="studentIframe"></iframe>
    </div>

    <script>
        // Function to close the window
        function closeWindow() {
            document.querySelector('.window-frame').style.display = 'none';
        }
    </script>

</body>
</html>
