<?= $this->extend('layouts/main'); ?>

<?= $this->section('content'); ?>

<!--begin::Content-->
<div class="content d-flex flex-column flex-column-fluid" id="kt_content">
    <!--begin::Container-->
    <div id="kt_content_container" class=" container-xxl ">
        <!--begin::Stepper-->
        <div class="stepper stepper-pills stepper-column d-flex flex-column flex-xl-row flex-row-fluid gap-10"
            id="kt_create_account_stepper">
            <!--begin::Aside-->
            <div
                class="card d-flex justify-content-center justify-content-xl-start flex-row-auto w-100 w-xl-300px w-xxl-400px">
                <!--begin::Wrapper-->
                <div class="card-body px-6 px-lg-10 px-xxl-15 py-20">
                    <!--begin::Nav-->
                    <div class="stepper-nav">
                        <!--begin::Step 1-->
                        <div class="stepper-item current" data-kt-stepper-element="nav">
                            <!--begin::Wrapper-->
                            <div class="stepper-wrapper">
                                <!--begin::Icon-->
                                <div class="stepper-icon w-40px h-40px">
                                    <i class="ki-outline ki-check fs-2 stepper-check"></i>
                                    <span class="stepper-number">1</span>
                                </div>
                                <!--end::Icon-->

                                <!--begin::Label-->
                                <div class="stepper-label">
                                    <h3 class="stepper-title">
                                        Application Type
                                    </h3>

                                    <div class="stepper-desc fw-semibold">
                                        Setup Your Account Details
                                    </div>
                                </div>
                                <!--end::Label-->
                            </div>
                            <!--end::Wrapper-->

                            <!--begin::Line-->
                            <div class="stepper-line h-40px"></div>
                            <!--end::Line-->
                        </div>
                        <!--end::Step 1-->

                        <!--begin::Step 2-->
                        <div class="stepper-item" data-kt-stepper-element="nav">
                            <!--begin::Wrapper-->
                            <div class="stepper-wrapper">
                                <!--begin::Icon-->
                                <div class="stepper-icon w-40px h-40px">
                                    <i class="ki-outline ki-check fs-2 stepper-check"></i>
                                    <span class="stepper-number">2</span>
                                </div>
                                <!--end::Icon-->

                                <!--begin::Label-->
                                <div class="stepper-label">
                                    <h3 class="stepper-title">
                                        Application Setting
                                    </h3>
                                    <div class="stepper-desc fw-semibold">
                                        Setup Your Account Settings
                                    </div>
                                </div>
                                <!--end::Label-->
                            </div>
                            <!--end::Wrapper-->

                            <!--begin::Line-->
                            <div class="stepper-line h-40px"></div>
                            <!--end::Line-->
                        </div>
                        <!--end::Step 2-->

                        <!--begin::Step 3-->
                        <div class="stepper-item" data-kt-stepper-element="nav">
                            <!--begin::Wrapper-->
                            <div class="stepper-wrapper">
                                <!--begin::Icon-->
                                <div class="stepper-icon w-40px h-40px">
                                    <i class="ki-outline ki-check fs-2 stepper-check"></i>
                                    <span class="stepper-number">3</span>
                                </div>
                                <!--end::Icon-->

                                <!--begin::Label-->
                                <div class="stepper-label">
                                    <h3 class="stepper-title">
                                        Personal Info
                                    </h3>
                                    <div class="stepper-desc fw-semibold">
                                        Your Personal Info
                                    </div>
                                </div>
                                <!--end::Label-->
                            </div>
                            <!--end::Wrapper-->

                            <!--begin::Line-->
                            <div class="stepper-line h-40px"></div>
                            <!--end::Line-->
                        </div>
                        <!--end::Step 3-->

                        <!--begin::Step 4-->
                        <div class="stepper-item" data-kt-stepper-element="nav">
                            <!--begin::Wrapper-->
                            <div class="stepper-wrapper">
                                <!--begin::Icon-->
                                <div class="stepper-icon w-40px h-40px">
                                    <i class="ki-outline ki-check fs-2 stepper-check"></i>
                                    <span class="stepper-number">4</span>
                                </div>
                                <!--end::Icon-->

                                <!--begin::Label-->
                                <div class="stepper-label">
                                    <h3 class="stepper-title">
                                        Contact Details
                                    </h3>
                                    <div class="stepper-desc fw-semibold">
                                        Set Your Contact Details
                                    </div>
                                </div>
                                <!--end::Label-->
                            </div>
                            <!--end::Wrapper-->

                            <!--begin::Line-->
                            <div class="stepper-line h-40px"></div>
                            <!--end::Line-->
                        </div>
                        <!--end::Step 4-->
                        <!--begin::Step 5-->
                        <div class="stepper-item" data-kt-stepper-element="nav">
                            <!--begin::Wrapper-->
                            <div class="stepper-wrapper">
                                <!--begin::Icon-->
                                <div class="stepper-icon w-40px h-40px">
                                    <i class="ki-outline ki-check fs-2 stepper-check"></i>
                                    <span class="stepper-number">5</span>
                                </div>
                                <!--end::Icon-->

                                <!--begin::Label-->
                                <div class="stepper-label">
                                    <h3 class="stepper-title">
                                        Parents/Guardian Details
                                    </h3>
                                    <div class="stepper-desc fw-semibold">
                                        Set Your Parents/Guardian Details
                                    </div>
                                </div>
                                <!--end::Label-->
                            </div>
                            <!--end::Wrapper-->

                            <!--begin::Line-->
                            <div class="stepper-line h-40px"></div>
                            <!--end::Line-->
                        </div>
                        <!--end::Step 5-->
                        <!--begin::Step 6-->
                        <div class="stepper-item" data-kt-stepper-element="nav">
                            <!--begin::Wrapper-->
                            <div class="stepper-wrapper">
                                <!--begin::Icon-->
                                <div class="stepper-icon w-40px h-40px">
                                    <i class="ki-outline ki-check fs-2 stepper-check"></i>
                                    <span class="stepper-number">6</span>
                                </div>
                                <!--end::Icon-->

                                <!--begin::Label-->
                                <div class="stepper-label">
                                    <h3 class="stepper-title">
                                        School Details
                                    </h3>
                                    <div class="stepper-desc fw-semibold">
                                        Set Your School Details
                                    </div>
                                </div>
                                <!--end::Label-->
                            </div>
                            <!--end::Wrapper-->

                            <!--begin::Line-->
                            <div class="stepper-line h-40px"></div>
                            <!--end::Line-->
                        </div>
                        <!--end::Step 6-->
                        <!--begin::Step 7-->
                        <div class="stepper-item" data-kt-stepper-element="nav">
                            <!--begin::Wrapper-->
                            <div class="stepper-wrapper">
                                <!--begin::Icon-->
                                <div class="stepper-icon w-40px h-40px">
                                    <i class="ki-outline ki-check fs-2 stepper-check"></i>
                                    <span class="stepper-number">7</span>
                                </div>
                                <!--end::Icon-->

                                <!--begin::Label-->
                                <div class="stepper-label">
                                    <h3 class="stepper-title">
                                        Academic Details
                                    </h3>
                                    <div class="stepper-desc fw-semibold">
                                        Set Your Academic Details
                                    </div>
                                </div>
                                <!--end::Label-->
                            </div>
                            <!--end::Wrapper-->

                            <!--begin::Line-->
                            <div class="stepper-line h-40px"></div>
                            <!--end::Line-->
                        </div>
                        <!--end::Step 7-->

                        <!--begin::Step 8-->
                        <div class="stepper-item" data-kt-stepper-element="nav">
                            <!--begin::Wrapper-->
                            <div class="stepper-wrapper">
                                <!--begin::Icon-->
                                <div class="stepper-icon w-40px h-40px">
                                    <i class="ki-outline ki-check fs-2 stepper-check"></i>
                                    <span class="stepper-number">8</span>
                                </div>
                                <!--end::Icon-->

                                <!--begin::Label-->
                                <div class="stepper-label">
                                    <h3 class="stepper-title">
                                        Survey
                                    </h3>
                                    <div class="stepper-desc fw-semibold">
                                        Pang Survey
                                    </div>
                                </div>
                                <!--end::Label-->
                            </div>
                            <!--end::Wrapper-->

                            <!--begin::Line-->
                            <div class="stepper-line h-40px"></div>
                            <!--end::Line-->
                        </div>
                        <!--end::Step 8-->
                        <!--begin::Step 8-->
                        <div class="stepper-item" data-kt-stepper-element="nav">
                            <!--begin::Wrapper-->
                            <div class="stepper-wrapper">
                                <!--begin::Icon-->
                                <div class="stepper-icon w-40px h-40px">
                                    <i class="ki-outline ki-check fs-2 stepper-check"></i>
                                    <span class="stepper-number">9</span>
                                </div>
                                <!--end::Icon-->

                                <!--begin::Label-->
                                <div class="stepper-label">
                                    <h3 class="stepper-title">
                                        Application Fee
                                    </h3>
                                    <div class="stepper-desc fw-semibold">
                                        Payment Details
                                    </div>
                                </div>
                                <!--end::Label-->
                            </div>
                            <!--end::Wrapper-->

                            <!--begin::Line-->
                            <div class="stepper-line h-40px"></div>
                            <!--end::Line-->
                        </div>
                        <!--end::Step 8-->
                        <!--begin::Step 6-->
                        <div class="stepper-item mark-completed" data-kt-stepper-element="nav">
                            <!--begin::Wrapper-->
                            <div class="stepper-wrapper">
                                <!--begin::Icon-->
                                <div class="stepper-icon w-40px h-40px">
                                    <i class="ki-outline ki-check fs-2 stepper-check"></i>
                                    <span class="stepper-number">10</span>
                                </div>
                                <!--end::Icon-->

                                <!--begin::Label-->
                                <div class="stepper-label">
                                    <h3 class="stepper-title">
                                        Completed
                                    </h3>
                                    <div class="stepper-desc fw-semibold">
                                        Woah, we are here
                                    </div>
                                </div>
                                <!--end::Label-->
                            </div>
                            <!--end::Wrapper-->
                        </div>
                        <!--end::Step 6-->
                    </div>
                    <!--end::Nav-->
                </div>
                <!--end::Wrapper-->
            </div>
            <!--begin::Aside-->

            <!--begin::Content-->
            <div class="card d-flex flex-row-fluid flex-center">
                <!--begin::Form-->
                <form class="card-body py-20 w-100 mw-xl-700px px-9" novalidate="novalidate" id="kt_create_account_form"
                    method="POST" enctype="multipart/form-data">
                    <!--begin::Step 1-->
                    <div class="current" data-kt-stepper-element="content">
                        <div class="w-100">
                            <div class="pb-10 pb-lg-15">
                                <h2 class="fw-bold d-flex align-items-center text-dark">
                                    Choose Application Type
                                    <span class="ms-1" data-bs-toggle="tooltip"
                                        title="Billing is issued based on your selected account type">
                                        <i class="ki-outline ki-information-5 text-gray-500 fs-6"></i>
                                    </span>
                                </h2>
                            </div>

                            <div class="fv-row">
                                <div class="row">
                                    <?php foreach ($applicationTypes as $type): ?>
                                        <div class="col-lg-6">
                                            <input type="radio" class="btn-check account_type" name="account_type"
                                                value="<?= esc($type['AdmissionTypeID']) ?>"
                                                id="kt_create_account_form_<?= esc($type['AdmissionTypeID']) ?>" />
                                            <label
                                                class="btn btn-outline btn-outline-dashed btn-active-light-primary p-7 d-flex align-items-center mb-10"
                                                for="kt_create_account_form_<?= esc($type['AdmissionTypeID']) ?>">

                                                <span class="d-block fw-semibold text-start">
                                                    <span class="text-dark fw-bold d-block fs-4 mb-2">
                                                        <?= esc($type['AdmissionType']) ?>
                                                    </span>
                                                </span>
                                            </label>
                                        </div>
                                    <?php endforeach; ?>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!--end::Step 1-->
 
                   
                    <!--begin::Step 4 show and hide div-->

                    <!--end::Step 4-->
 
                  
                    <!--begin::Step 7-->
                    <!-- for freshmen -->
                    <div data-kt-stepper-element="content">
                        <!--begin::Wrapper-->
                        <div class="w-100">
                            <!--begin::Heading-->
                            <div class="pb-10 pb-lg-15">
                                <!--begin::Title-->
                                <h2 class="fw-bold text-dark">Academic Details</h2>
                                <!--end::Title-->

                                <!--begin::Notice-->
                                <div class="text-muted fw-semibold fs-6">
                                    Academic Credential Upload
                                    <!-- <a href="#" class="text-primary fw-bold">Help Page</a>. -->
                                </div>
                                <!--end::Notice-->
                            </div>
                            <!--end::Heading-->


                            <!--begin::Input group-->
                            <div class="d-flex flex-stack">
                                <!--begin::Label-->
                                <div class="me-5">
                                    <!-- <label class="fs-6 fw-semibold form-label">Transcript of Records</label> -->
                                    <!-- <div class="fs-12 fw-semibold text-muted">Transcript of Records (TOR) with GWA</div> -->
                                    <!-- <div id="result2">  </div> -->
                                    <!-- <?php if (!empty($admissionData)): ?>
                                        <?php foreach ($admissionData as $requirements): ?>
                                            <div class="mb-3">
                                                <label class="fs-6 fw-semibold form-label"><?= esc($requirements->Requirement_name); ?></label>
                                                <input type="file" 
                                                    class="form-control form-control-solid" 
                                                    name="files[<?= esc($requirements->AdmissionTypeID); ?>]" 
                                                    id="file_<?= esc($requirements->AdmissionTypeID); ?>" />
                                            </div>
                                        <?php endforeach; ?>
                                    <?php else: ?>
                                        <p>No requirements found.</p>
                                    <?php endif; ?> -->
                                    <!-- Section to Render AJAX Data -->
                                    <div id="admission-details"></div>
                                    <!--begin::Row-->
                                    <div class="row fv-row">
                                        <!--begin::Col-->
                                        <!-- <div class="col-12">

                                            <label class="fs-6 fw-semibold form-label">Transcript of Record</label>
                                            <input type="file"  class="form-control form-control-solid" placeholder=""
                                                name="userfile" id="userfile" />

                                        </div> -->
                                        <!--end::Col-->
                                    </div>
                                    <!--end::Row-->

                                </div>
                                <!--end::Label-->

                            </div>
                            <!--end::Input group-->



                        </div>
                        <!--end::Wrapper-->
                    </div>
                    <!--end::Step 7-->
                    <!--begin::Step 7-->
 
                    

                    <!--begin::Actions-->
                    <div class="d-flex flex-stack pt-10">
                        <!--begin::Wrapper-->
                        <div class="mr-2">
                            <button type="button" class="btn btn-lg btn-light-primary me-3"
                                data-kt-stepper-action="previous">
                                <i class="ki-outline ki-arrow-left fs-4 me-1"></i> Back
                            </button>
                        </div>
                        <!--end::Wrapper-->

                        <!--begin::Wrapper-->
                        <div>
                            <button type="button" id="submit" class="btn btn-lg btn-primary me-3"
                                data-kt-stepper-action="submit">
                                <span class="indicator-label">
                                    Submit
                                    <i class="ki-outline ki-arrow-right fs-3 ms-2 me-0"></i> </span>
                                <span class="indicator-progress">
                                    Please wait... <span
                                        class="spinner-border spinner-border-sm align-middle ms-2"></span>
                                </span>
                            </button>

                            <button type="button" class="btn btn-lg btn-primary" data-kt-stepper-action="next">
                                Continue
                                <i class="ki-outline ki-arrow-right fs-4 ms-1 me-0"></i> </button>
                        </div>
                        <!--end::Wrapper-->
                    </div>
                    <!--end::Actions-->
                </form>

                <!--end::Form-->
            </div>
            <!--end::Content-->
        </div>
        <!--end::Stepper-->
    </div>
    <!--end::Container-->
</div>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
    $(document).ready(function () {
        $('.account_type').on('change', function () {
            const admissionTypeId = $(this).val();
            alert(admissionTypeId);
            $.ajax({
                url: '<?= base_url('Admissions/getAdmissionDataAjax') ?>',
                type: 'POST',
                dataType: 'json',
                data: { admission_type_id: admissionTypeId },
                success: function (response) {
                    console.log(response);
                    if (response.success) {
                        // Render fetched data dynamically
                        let html = '';
                        response.admissionData.forEach(function (item) {
                            html += `
                            <div class="mb-3">
                                <label class="fs-6 fw-semibold form-label">${item.Requirement_name}</label>
                                <input type="file" class="form-control form-control-solid" 
                                    name="files[${item.AdmissionTypeID}]" 
                                    id="file_${item.AdmissionTypeID}" />
                            </div>`;
                        });
                        $('#admission-details').html(html);
                    } else {
                        // Show error message
                        $('#admission-details').html(`<p class="text-danger">${response.message}</p>`);
                    }
                },
                error: function (xhr, status, error) {
                    console.error('AJAX Error:', error);
                    $('#admission-details').html('<p class="text-danger">An error occurred. Please try again.</p>');
                }
            });
        });
    });
</script>

<script>
    var select1 = document.getElementById('programs');
    var select2 = document.getElementById('programs2');

    // Add an event listener to the first select element
    select1.addEventListener('change', function () {
        var selectedOption = select1.options[select1.selectedIndex].value;

        // Find the corresponding option in select2 and disable it
        for (var i = 0; i < select2.options.length; i++) {
            if (select2.options[i].value === selectedOption) {
                select2.options[i].disabled = true;
                //   selectedOption.classList.add("d-none");
                //   selectedOption.classList.remove("d-inline-block");
                // Remove the class attribute

                // Remove a specific class from the select element's classList
                selectElement.classList.remove("form-select-lg", "form-select-solid");
                //   selectedOption.classList.remove("form-select form-select-lg form-select-solid");
            } else {
                select2.options[i].disabled = false;

            }
        }
    });
</script>


<?= $this->endSection(); ?>


<!--begin::Custom Javascript-->
<?= $this->section('customscripts'); ?>

<!-- <script src="<?= base_url("public"); ?>/<?= base_url("public"); ?>/assets/js/custom/utilities/modals/thescript.js"></script> -->

<?= $this->endSection(); ?>
<!--end::Custom Javascript-->