<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Add Student with Schedule</title>
</head>
<body>
    <h1>Add Student</h1>

    <?php if (session()->getFlashdata('success')): ?>
        <p><?= session()->getFlashdata('success') ?></p>
    <?php endif; ?>

    <?php if (session()->getFlashdata('error')): ?>
        <p><?= session()->getFlashdata('error') ?></p>
    <?php endif; ?>

    <?php if (session()->getFlashdata('errors')): ?>
        <ul>
            <?php foreach (session()->getFlashdata('errors') as $error): ?>
                <li><?= $error ?></li>
            <?php endforeach; ?>
        </ul>
    <?php endif; ?>

    <form action="<?= base_url('students/addStudent') ?>" method="post">
        <label for="name">Name:</label>
        <input type="text" name="name" id="name" required><br>

        <label for="email">Email:</label>
        <input type="email" name="email" id="email" required><br>

        <label for="schedule_id">Exam Schedule:</label>
        <select name="schedule_id" id="schedule_id" required>
            <?php foreach ($schedules as $schedule): ?>
                <option value="<?= $schedule['id'] ?>">
                    <?= $schedule['exam_date'] ?> - Max: <?= $schedule['max_examinees'] ?>, Current: <?= $schedule['current_examinees'] ?>
                </option>
            <?php endforeach; ?>
        </select><br>

        <button type="submit">Add Student</button>
    </form>

    <h2>Existing Students</h2>
    <ul>
        <?php foreach ($students as $student): ?>
            <li><?= $student['name'] ?> - Schedule ID: <?= $student['schedule_id'] ?></li>
        <?php endforeach; ?>
    </ul>
</body>
</html>
