<?= $this->extend('layouts/mainAdmin'); ?>

<?= $this->section('content'); ?>

<!--begin::Content-->
<div class="content d-flex flex-column flex-column-fluid" id="kt_content">
    <!--begin::Container-->
    <div id="kt_content_container" class=" container-xxl ">
        <!--begin::Card-->
        <div class="card">
            <!--begin::Card header-->
            <div class="card-header border-0 pt-6">
                <!--begin::Card title-->
                <div class="card-title">
                    <!--begin::Search-->
                    <div class="d-flex align-items-center position-relative my-1">
                        <i class="ki-outline ki-magnifier fs-3 position-absolute ms-5"></i>
                        <input type="text" data-kt-user-table-filter="search"
                            class="form-control form-control-solid w-250px ps-13" placeholder="Search" />
                    </div>
                    <!--end::Search-->
                </div>
                <!--begin::Card title-->

                <!--begin::Card toolbar-->
                <div class="card-toolbar">
                    <!--begin::Toolbar-->
                    <div class="d-flex justify-content-end" data-kt-user-table-toolbar="base">
                        <!--begin::Filter-->
                        <button type="button" class="btn btn-light-primary me-3" data-kt-menu-trigger="click"
                            data-kt-menu-placement="bottom-end">
                            <i class="ki-outline ki-filter fs-2"></i> Filter
                        </button>
                        <!--begin::Menu 1-->
                        <div class="menu menu-sub menu-sub-dropdown w-300px w-md-325px" data-kt-menu="true">
                            <!--begin::Header-->
                            <div class="px-7 py-5">
                                <div class="fs-5 text-gray-900 fw-bolder">Filter Options</div>
                            </div>
                            <!--end::Header-->

                            <!--begin::Form-->
                            <!-- <form data-kt-user-table-filter="form" class="form"> -->
                                <div class="menu-item px-7">
                                    <div class="mb-10">
                                            <label class="form-label fs-6 fw-bold mb-2">Colleges</label>
                                            <select name="college" id="college" class="form-select form-select-solid fw-bolder">
                                               
                                            </select>
                                    </div>
                                    <div class="mb-10">
                                            <label class="form-label fs-6 fw-bold mb-2">Program</label>
                                            <select name="program" id="program" class="form-select form-select-solid fw-bolder"> 
                                            </select>
                                    </div>
                                    <div class="mb-10">
                                        <label class="form-label fs-6 fw-bold mb-2">Application Type</label>
                                        <select name="applicationType" class="form-select form-select-solid fw-bolder">
                                            <option value="">All</option>
                                            <?php foreach ($appType as $type): ?>
                                                <option value="<?= $type['AdmissionTypeID']; ?>">
                                                    <?= $type['AdmissionTypeID']; ?></option>
                                            <?php endforeach; ?>
                                        </select>
                                    </div>
                                    <div class="mb-10">
                                        <label class="form-label fs-6 fw-bold mb-2">Status</label>
                                        <select name="status" class="form-select form-select-solid fw-bolder">
                                            <option value="">All</option>
                                            <option value="Qualified">Qualified</option>
                                            <option value="Waitlister">Waitlister</option>
                                        </select>
                                    </div>
                                </div>  
                                <div class="px-7 py-5">
                                    <button type="button" id="btnsearch" class="btn btn-primary">Apply</button>
                                </div>
                            <!-- </form> -->
                            <!--end::Form-->
                        </div>
                        <!--end::Menu 1-->

                        <!--begin::Export-->
                        <div class="btn-group">
                            <button type="button" class="btn btn-light-primary me-3 dropdown-toggle"
                                    data-bs-toggle="dropdown" aria-expanded="false">
                                <i class="ki-outline ki-file fs-2"></i> Export
                            </button>
                            <ul class="dropdown-menu">
                                <li><a class="dropdown-item" href="#" id="exportExcel"><i
                                            class="ki-outline ki-file-excel fs-2"></i> Export Excel</a></li>
                                <li><a class="dropdown-item" href="#" id="exportCsv"><i
                                            class="ki-outline ki-file-csv fs-2"></i> Export CSV</a></li>
                                <li><a class="dropdown-item" href="#" id="exportPdf"><i
                                            class="ki-outline ki-file-pdf fs-2"></i> Export PDF</a></li>
                            </ul>
                        </div>
                        <!--end::Export-->
                    </div>
                    <!--end::Toolbar-->
                </div>
                <!--end::Card toolbar-->
            </div>
            <!--end::Card header-->

            <!--begin::Card body-->
            <div class="card-body pt-0">
                 <div id="table-holder">
                    <?php echo $table; ?>
                </div> 
            </div>
            <!--end::Card body-->
        </div>
        <!--end::Card-->
    </div>
    <!--end::Container-->
</div>
<!--end::Content-->




<?= $this->endSection(); ?>


<!--begin::Custom Javascript-->
<?= $this->section('customscripts'); ?>
<!-- C:\wamp64\www\unis-student-module\public\assets\js\custom\admission -->
<!-- <script src="<?= base_url("public"); ?>/<?= base_url("public"); ?>/assets/js/custom/utilities/modals/thescript.js"></script> -->
<script src="<?= base_url(); ?>public/assets/js/custom/admission/admissionReport.js"></script>

<script>
    const BASE_URL = '<?php echo base_url(); ?>'; 
</script>
<?= $this->endSection(); ?>
<!--end::Custom Javascript-->