<?= $this->extend('layouts/mainAdmin'); ?>

<?= $this->section('content'); ?>

<!--begin::Content-->
<div class="content d-flex flex-column flex-column-fluid" id="kt_content">
    <!--begin::Container-->
    <div id="kt_content_container" class=" container-xxl ">
        <!--begin::Card-->
        <div class="card">
            <!--begin::Card header-->
            <div class="card-header border-0 pt-6">
                <!--begin::Card title-->
                <div class="card-title">
                    <!--begin::Search-->
                    <div class="d-flex align-items-center position-relative my-1">
                        <i class="ki-outline ki-magnifier fs-3 position-absolute ms-5"></i> <input type="text"
                            data-kt-user-table-filter="search" class="form-control form-control-solid w-250px ps-13"
                            placeholder="Search" />
                    </div>
                    <!--end::Search-->
                </div>
                <!--begin::Card title-->

                <!--begin::Card toolbar-->
                <div class="card-toolbar">
                    <!--begin::Toolbar-->
                    <div class="d-flex justify-content-end" data-kt-user-table-toolbar="base">
                        <!--begin::Filter-->
                        <button type="button" class="btn btn-light-primary me-3" data-kt-menu-trigger="click"
                            data-kt-menu-placement="bottom-end">
                            <i class="ki-outline ki-filter fs-2"></i> Filter
                        </button>
                        <!--begin::Menu 1-->
                        <div class="menu menu-sub menu-sub-dropdown w-300px w-md-325px" data-kt-menu="true">
                            <!--begin::Header-->
                            <div class="px-7 py-5">
                                <div class="fs-5 text-gray-900 fw-bold">Filter Options</div>
                            </div>
                            <!--end::Header-->

                            <!--begin::Separator-->
                            <div class="separator border-gray-200"></div>
                            <!--end::Separator-->

                            <!--begin::Content-->
                            <div class="px-7 py-5" data-kt-user-table-filter="form">
                                <!--begin::Input group-->
                                <div class="mb-10">
                                    <label class="form-label fs-6 fw-semibold">Application Type:</label>
                                    <select class="form-select form-select-solid fw-bold" data-kt-select2="true"
                                        data-placeholder="Select option" data-allow-clear="true"
                                        data-kt-user-table-filter="applicationType" data-hide-search="true">
                                        <option></option>
                                        <option value="Admission">Admission</option>
                                        <option value="Scholarship">Scholarship</option>
                                        <option value="Transfer">Transfer</option>
                                        <!-- Add more options as needed -->
                                    </select>
                                </div>

                                <div class="mb-10">
                                    <label class="form-label fs-6 fw-semibold">Filter by Date:</label>
                                    <div class="input-group">
                                        <input type="text" class="form-control" id="filterByDate"
                                            data-kt-datepicker="true" readonly placeholder="Select date">
                                        <div class="input-group-append">
                                            <span class="input-group-text">
                                                <i class="ki ki-calendar"></i>
                                            </span>
                                        </div>
                                    </div>
                                </div>

                                <!--end::Input group-->

                                <!--begin::Input group-->
                                <!-- <div class="mb-10">
                                    <label class="form-label fs-6 fw-semibold">Two Step Verification:</label>
                                    <select class="form-select form-select-solid fw-bold" data-kt-select2="true" data-placeholder="Select option" data-allow-clear="true" data-kt-user-table-filter="two-step" data-hide-search="true">
                                        <option></option>
                                        <option value="Enabled">Enabled</option>
                                    </select>
                                </div> -->
                                <!--end::Input group-->

                                <!--begin::Actions-->
                                <div class="d-flex justify-content-end">
                                    <button type="reset"
                                        class="btn btn-light btn-active-light-primary fw-semibold me-2 px-6"
                                        data-kt-menu-dismiss="true" data-kt-user-table-filter="reset">Reset</button>
                                    <button type="submit" class="btn btn-primary fw-semibold px-6"
                                        data-kt-menu-dismiss="true" data-kt-user-table-filter="filter">Apply</button>
                                </div>
                                <!--end::Actions-->
                            </div>
                            <!--end::Content-->
                        </div>
                        <!--end::Menu 1-->
                        <!--end::Filter-->

                        <!--begin::Export-->
                        <button type="button" class="btn btn-light-primary me-3" data-bs-toggle="modal"
                            data-bs-target="#kt_modal_export_users">
                            <i class="ki-outline ki-exit-up fs-2"></i> Export
                        </button>
                        <!--end::Export-->

                        <!--begin::Add user-->
                        <!-- <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#kt_modal_add_user">
        <i class="ki-outline ki-plus fs-2"></i>        Add User
    </button> -->
                        <!--end::Add user-->
                    </div>
                    <!--end::Toolbar-->

                    <!--begin::Group actions-->
                    <div class="d-flex justify-content-end align-items-center d-none"
                        data-kt-user-table-toolbar="selected">
                        <div class="fw-bold me-5">
                            <span class="me-2" data-kt-user-table-select="selected_count"></span> Selected
                        </div>

                        <button type="button" class="btn btn-danger" data-kt-user-table-select="delete_selected">
                            Delete Selected
                        </button>
                    </div>
                    <!--end::Group actions-->

                    <!--begin::Modal - Adjust Balance-->
                    <div class="modal fade" id="kt_modal_export_users" tabindex="-1" aria-hidden="true">
                        <!-- Modal content -->
                        <div class="modal-dialog modal-dialog-centered mw-650px">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h2 class="fw-bold">Export</h2>
                                    <button type="button" class="btn-close" data-bs-dismiss="modal"
                                        aria-label="Close"></button>
                                </div>
                                <div class="modal-body">
                                    <!-- Export form -->
                                    <form id="kt_modal_export_users_form" class="form" action="#">
                                        <div class="mb-10">
                                            <label class="required fs-6 fw-semibold form-label mb-2">Select Export
                                                Format:</label>
                                            <select name="format" class="form-select form-select-solid fw-bold">
                                                <option value="excel">Excel</option>
                                                <option value="pdf">PDF</option>
                                                <option value="cvs">CSV</option>
                                            </select>
                                        </div>
                                        <div class="text-center">
                                            <button type="submit" class="btn btn-primary">
                                                <span class="indicator-label">Submit</span>
                                                <span class="indicator-progress">
                                                    Please wait... <span
                                                        class="spinner-border spinner-border-sm align-middle ms-2"></span>
                                                </span>
                                            </button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                    <style>
                        .table-responsive {
                            overflow-x: auto;
                        }

                        .sticky-column {
                            position: -webkit-sticky;
                            position: sticky;
                            left: 0;
                            background-color: white;
                            z-index: 2;
                        }

                        .table-responsive .sticky-column {
                            position: -webkit-sticky;
                            position: sticky;
                            left: 0;
                            z-index: 1;
                            background-color: white;
                        }
                    </style>
                    <!--end::Modal - New Card-->

                    <!--begin::Modal - Add task-->

                    <!--end::Modal - Add task-->
                </div>
                <!--end::Card toolbar-->
            </div>
            <!--end::Card header-->

            <!--begin::Card body-->
            <div class="card-body py-4">
                <div class="table-responsive">
                    <table class="table align-middle table-row-dashed fs-6 gy-5" id="kt_table_users">
                        <thead>
                            <tr class="text-start text-muted fw-bold fs-7 text-uppercase gs-0">
                                <th class="w-10px pe-2">
                                    <div class="form-check form-check-sm form-check-custom form-check-solid me-3">
                                        <input class="form-check-input" type="checkbox" data-kt-check="true"
                                            data-kt-check-target="#kt_table_users .form-check-input" value="1" />
                                    </div>
                                </th>
                                <th class="min-w-125px sticky-column">Name</th>
                                <th class="min-w-125px ">Application Type</th>
                                <th class="min-w-125px">Date of Exam</th>
                                <th class="min-w-125px">Junior High School (GWA)</th>
                                <th class="min-w-125px">Senior High School (GWA)</th>
                                <th class="min-w-125px">GWA (60%)</th>
                                <th class="min-w-125px">Raw Score</th>
                                <th class="min-w-125px">School Ability Test</th>
                                <th class="min-w-125px">Verbal Description</th>
                                <th class="min-w-125px">40%</th>
                                <th class="min-w-125px">Total</th>
                                <th class="min-w-125px">Remarks</th>
                            </tr>
                        </thead>
                        <tbody class="text-gray-600 fw-semibold">
                            <?php foreach ($app as $row): ?>
                                <tr>
                                    <td>
                                        <div class="form-check form-check-sm form-check-custom form-check-solid">
                                            <input class="form-check-input" type="checkbox" value="1" />
                                        </div>
                                    </td>
                                    <td class="d-flex align-items-center sticky-column">
                                        <!--begin:: Avatar -->
                                        <div class="symbol symbol-circle symbol-50px overflow-hidden me-3">
                                            <a href="#">
                                                <div class="symbol-label">
                                                    <img src="<?= base_url(); ?>public/assets/media/avatars/300-6.jpg"
                                                        alt="image" width="100%" />
                                                </div>
                                            </a>
                                        </div>
                                        <!--end::Avatar-->
                                        <!--begin::User details-->
                                        <div class="d-flex flex-column">
                                            <a href="<?php echo base_url(); ?>admissions/applicantProfile/<?= $row->StudentAdmissionID ?>"
                                                class="text-gray-800 text-hover-primary mb-1"><?= $row->FirstName . ' ' . $row->LastName ?></a>
                                            <span><?= $row->StudentAdmissionID ?></span>
                                        </div>
                                        <!--begin::User details-->
                                    </td>
                                    <td><?= $row->StudentAdmissionID ?></td>
                                    <td><?= $row->DateCreated ?></td>
                                    <td><input type="text" class="form-control form-control-solid jhs-gwa"
                                            data-id="<?= $row->StudentAdmissionID ?>" data-column="JuniorGWA"></td>
                                    <td><input type="text" class="form-control form-control-solid shs-gwa"
                                            data-id="<?= $row->StudentAdmissionID ?>" data-column="SeniorGWA"></td>
                                    <td><input type="text" class="form-control form-control-solid gwa"
                                            data-id="<?= $row->StudentAdmissionID ?>" data-column="GWAresult" readonly></td>
                                    <td><input type="text" class="form-control form-control-solid raw-score"
                                            data-id="<?= $row->StudentAdmissionID ?>" data-column="RawScore"></td>
                                    <td><input type="text" class="form-control form-control-solid sai"
                                            data-id="<?= $row->StudentAdmissionID ?>" data-column="SAT"></td>
                                    <td><input type="text" class="form-control form-control-solid verbal-desc"
                                            data-id="<?= $row->StudentAdmissionID ?>" data-column="VerbalDesc"></td>
                                    <td><input type="text" class="form-control form-control-solid percentage"
                                            data-id="<?= $row->StudentAdmissionID ?>" data-column="Percentage"></td>
                                    <td><input type="text" class="form-control form-control-solid total"
                                            data-id="<?= $row->StudentAdmissionID ?>" data-column="Total"></td>
                                    <td><input type="text" class="form-control form-control-solid remarks"
                                            data-id="<?= $row->StudentAdmissionID ?>" data-column="Remarks"></td>


                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
            <!--end::Card body-->
        </div>
        <!--end::Card-->
    </div>
    <!--end::Container-->
</div>
<!--end::Content-->



<?= $this->endSection(); ?>


<!--begin::Custom Javascript-->
<?= $this->section('customscripts'); ?>

<!-- <script src="<?= base_url("public"); ?>/<?= base_url("public"); ?>/assets/js/custom/utilities/modals/thescript.js"></script> -->

<script>
    // Function to handle export action
    function exportData(format) {
        // Send an AJAX request to the backend endpoint for exporting data
        const xhr = new XMLHttpRequest();
        xhr.open('POST',
            'path_to_your_export_endpoint'); // Replace 'path_to_your_export_endpoint' with the actual backend endpoint URL
        xhr.setRequestHeader('Content-Type', 'application/json');
        xhr.responseType = 'blob'; // Set the response type to blob for file download
        xhr.onload = function () {
            const blob = xhr.response;
            const fileName = `export.${format}`;
            const link = document.createElement('a');
            link.href = window.URL.createObjectURL(blob);
            link.download = fileName;
            document.body.appendChild(link);
            link.click();
            document.body.removeChild(link);
        };
        xhr.send(JSON.stringify({
            format
        }));
    }

    // Listen for the export form submission
    document.getElementById('kt_modal_export_users_form').addEventListener('submit', function (event) {
        event.preventDefault(); // Prevent form submission
        const format = this.elements['format'].value; // Get the selected export format
        exportData(format); // Call the export function with the selected format
    });
</script>
<script>
    $(document).ready(function () {
        // Calculate GWA when JHS or SHS GWA inputs change
        function calculateGWA(jhsGWA, shsGWA) {
            var result = (jhsGWA + shsGWA) / 2 * 0.6;
            return result.toFixed(2);
        }

        // Mapping of raw scores to SAI values
        const rawScoreToSai = {
            80: 146, 79: 144, 78: 141, 77: 139, 76: 136, 75: 134,
            74: 132, 73: 130, 72: 128, 71: 126, 70: 124, 69: 123,
            68: 121, 67: 120, 66: 118, 65: 117, 64: 116, 63: 115,
            62: 114, 61: 113, 60: 112, 59: 112, 58: 111, 57: 110,
            56: 109, 55: 108, 54: 108, 53: 107, 52: 106, 51: 105,
            50: 104, 49: 104, 48: 103, 47: 102, 46: 101, 45: 100,
            44: 99, 43: 98, 42: 97, 41: 96, 40: 95, 39: 94,
            38: 93, 37: 92, 36: 91, 35: 90, 34: 89, 33: 88,
            32: 87, 31: 86, 30: 84, 29: 83, 28: 82, 27: 81,
            26: 80, 25: 78, 24: 77, 23: 76, 22: 75, 21: 74,
            20: 73, 19: 72, 18: 71, 17: 70, 16: 68, 15: 66,
            14: 64, 13: 62, 12: 59, 11: 57, 10: 54, 9: 52,
            8: 50, 7: 50, 6: 50, 5: 50, 4: 50, 3: 50,
            2: 50, 1: 50, 0: 0
        };

        function getSaiValue(rawScore) {
            return rawScoreToSai[rawScore] !== undefined ? rawScoreToSai[rawScore] : "Invalid Raw Score";
        }

        function getVerbalDescription(sai) {
            if (sai < 71) {
                return "Low";
            } else if (sai >= 72 && sai <= 87) {
                return "Below Average";
            } else if (sai >= 88 && sai <= 111) {
                return "Average";
            } else if (sai >= 112 && sai <= 127) {
                return "Above Average";
            } else if (sai >= 128) {
                return "Superior";
            } else {
                return "";
            }
        }

        function calculatePercentage(sai) {
            if (typeof sai === 'number' && !isNaN(sai)) {
                return ((sai / 146) * 100 * 0.4).toFixed(4);
            } else {
                return '';
            }
        }

        function updateTotal(gwa, percentage) {
            const gwaValue = parseFloat(gwa);
            const percentageValue = parseFloat(percentage);
            if (!isNaN(gwaValue) && !isNaN(percentageValue)) {
                return (gwaValue + percentageValue).toFixed(4);
            } else {
                return '';
            }
        }

        function updateRemarks(totalValue, remarksElement) {
            if (totalValue >= 80) {
                remarksElement.value = "Qualified";
            } else {
                remarksElement.value = "Waitlister";
            }
        }

        // Event listener to update SAI value, verbal description, percentage, and total
        function updateFields(row) {
            const jhsGwaInput = row.find(".jhs-gwa");
            const shsGwaInput = row.find(".shs-gwa");
            const gwaInput = row.find(".gwa");
            const rawScoreInput = row.find(".raw-score");
            const saiInput = row.find(".sai");
            const verbalDescInput = row.find(".verbal-desc");
            const percentageInput = row.find(".percentage");
            const totalInput = row.find(".total");
            const remarksInput = row.find(".remarks");

            function update() {
                const jhsGwa = parseFloat(jhsGwaInput.val()) || 0;
                const shsGwa = parseFloat(shsGwaInput.val()) || 0;
                const rawScore = parseInt(rawScoreInput.val(), 10);
                const saiValue = getSaiValue(rawScore);
                const gwa = calculateGWA(jhsGwa, shsGwa);

                saiInput.val(saiValue);
                verbalDescInput.val(getVerbalDescription(saiValue));
                const percentage = calculatePercentage(saiValue);
                percentageInput.val(percentage);
                gwaInput.val(gwa);
                totalInput.val(updateTotal(gwa, percentage));
                updateRemarks(parseFloat(totalInput.val()) || 0, remarksInput[0]);
            }

            jhsGwaInput.on("input", update);
            shsGwaInput.on("input", update);
            rawScoreInput.on("input", update);
        }

        $('#kt_table_users tbody tr').each(function () {
            updateFields($(this));
        });
    });
</script>
<script>
    $(document).ready(function () {
        $('input.form-control').on('change', function () {
            var input = $(this);
            var value = input.val();
            var id = input.data('id');
            var column = input.data('column');

            $.ajax({
                url: "<?= base_url('admissions/saveData') ?>",  // Replace with your controller method
                method: "POST",
                data: {
                    id: id,
                    column: column,
                    value: value
                },
                success: function (response) {
                    if (response.success) {
                        console.log('Data updated successfully');
                    } else {
                        console.log('Failed to update data');
                    }
                },
                error: function (xhr, status, error) {
                    console.error('Error:', error);
                }
            });
        });
    });

</script>

<?= $this->endSection(); ?>
<!--end::Custom Javascript-->