<?= $this->extend('layouts/mainAdmin'); ?>

<?= $this->section('content'); ?>

<!--begin::Content-->
<div class="content d-flex flex-column flex-column-fluid" id="kt_content">
    <!--begin::Container-->
    <div id="kt_content_container" class="container-xxl">
        <!--begin::Card-->
        <div class="card">
            <!--begin::Card header-->
            <div class="card-header border-0 pt-6">
                <!--begin::Card title-->
                <div class="card-title">
                    <!--begin::Search-->
                    <div class="d-flex align-items-center position-relative my-1">
                        <i class="ki-outline ki-magnifier fs-3 position-absolute ms-5"></i>
                        <input type="text" data-kt-user-table-filter="search" class="form-control form-control-solid w-250px ps-13" placeholder="Search Date" />
                    </div>
                    <!--end::Search-->
                </div>
                <!--begin::Card title-->

                <!--begin::Card toolbar-->
                <div class="card-toolbar">
                    <!--begin::Toolbar-->
                    <div class="d-flex justify-content-end" data-kt-user-table-toolbar="base">
                        <!--begin::Export-->
                        <button type="button" class="btn btn-light-primary me-3" data-bs-toggle="modal" data-bs-target="#kt_modal_export_users">
                            <i class="ki-outline ki-plus fs-2"></i> Add Criteria
                        </button>
                    </div>
                    <!--end::Toolbar-->

                    <!--begin::Group actions-->
                    <div class="d-flex justify-content-end align-items-center d-none" data-kt-user-table-toolbar="selected">
                        <div class="fw-bold me-5">
                            <span class="me-2" data-kt-user-table-select="selected_count"></span> Selected
                        </div>
                        <button type="button" class="btn btn-danger" data-kt-user-table-select="delete_selected">Delete Selected</button>
                    </div>
                    <!--end::Group actions-->

                    <!--begin::Modal - New Duration-->
                    <div class="modal fade" id="kt_modal_export_users" tabindex="-1" aria-hidden="true">
                        <div class="modal-dialog modal-dialog-centered mw-650px">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h2 class="fw-bold">Add Criteria</h2>
                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                </div>
                                <div class="modal-body">
                                <form id="kt_modal_export_users_form" class="form"
                                        action="<?= base_url('AdmissionCriteriaController/addCriteria'); ?>" method="post">
                                        <?= csrf_field(); ?>
                                         
                                        <div class="form-floating mb-7">
                                            <input type="number" class="form-control form-control"
                                                placeholder="Pick date rage" id="admissionName" name="admissionName"
                                                required />
                                            <label for="floatingPassword">Name</label>
                                        </div>
                                        <div class="form-floating mb-7">
                                            <!-- <input class="form-control form-control" placeholder="Pick date rage" id="sched_date" name="sched_date" /> -->
                                            <input class="form-control form-control" placeholder="Pick date rage"
                                                id="gwa" name="gwa" required />
                                            <label for="floatingPassword">GWA</label>
                                        </div>
                                        <div class="form-floating mb-7">
                                            <!-- <input class="form-control form-control" placeholder="Pick date rage" id="sched_date" name="sched_date" /> -->
                                            <input class="form-control form-control" placeholder="Pick date rage"
                                                id="percentage" name="percentage" required />
                                            <label for="floatingPassword">Percentage</label>
                                        </div> 
                                        <!--begin::Input group-->
                                        <div class="form-floating mb-7">
                                            <select class="form-select" id="floatingSelect" aria-label="Floating label select example">
                                                <option selected disabled>Please Select</option>
                                                <?php foreach ($acadTerm as $year): ?>
                                                    <option value="<?= $year['TermID']; ?>"><?= $year['Term'].' '.$year['AdmissionYear'] ; ?></option>
                                                <?php endforeach; ?>
                                            </select>
                                            <label for="floatingSelect">Academic Year</label>
                                        </div>
                                            <!--end::Input group-->
                                        <div class="form-floating mb-7">
                                        <label for="floatingPassword">Status</label>
                                            <select name="status" id="status" class="form-control">
                                            <option></option>
                                                <option value="Active">Active</option>
                                                <option value="Inactive">Inactive</option>
                                            </select>
                                        </div>
                                        <div class="text-center">
                                            <button type="submit" class="btn btn-primary">
                                                <span class="indicator-label">Submit</span>
                                                <span class="indicator-progress">
                                                    Please wait... <span
                                                        class="spinner-border spinner-border-sm align-middle ms-2"></span>
                                                </span>
                                            </button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!--end::Modal - New Duration-->

                    <!-- Edit Modal -->
                    <div class="modal fade" id="editDurationModal" tabindex="-1" aria-hidden="true">
                        <div class="modal-dialog modal-dialog-centered mw-650px">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h2 class="fw-bold">Edit Schedule</h2>
                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                </div>
                                <div class="modal-body">
                                    <form id="editScheduleForm" action="<?= base_url('AdmissionDurationController/editDuration'); ?>" method="post">
                                        <?= csrf_field(); ?>
                                        <input type="text" id="edit_DurationID" name="DurationID">
                                        <div class="form-floating mb-7">
                                            <input type="text" class="form-control form-control-solid" id="edit_Admission_cycle_name" name="Admission_cycle_name" required />
                                            <label for="edit_sched_date">Name</label>
                                        </div>
                                        <div class="form-floating mb-7">
                                            <input type="number" class="form-control form-control-solid" id="edit_Start_date" name="Start_date" required />
                                            <label for="edit_max_examinees">Start Date</label>
                                        </div>
                                        <div class="form-floating mb-7">
                                            <input type="number" class="form-control form-control-solid" id="edit_End_date" name="End_date" required />
                                            <label for="edit_max_examinees">End Date</label>
                                        </div>
                                        <div class="form-floating mb-7">
                                            <input type="number" class="form-control form-control-solid" id="edit_Duration" name="Duration" required />
                                            <label for="edit_max_examinees">Duration</label>
                                        </div>
                                        <div class="form-floating mb-7">
                                        <label for="floatingPassword">Status</label>
                                            <select name="Status" id="edit_Status" class="form-control">
                                            <option></option>
                                                <option value="Active">Active</option>
                                                <option value="Inactive">Inactive</option>
                                            </select>
                                        </div>
                                        <div class="text-center">
                                            <button type="submit" class="btn btn-primary">
                                                <span class="indicator-label">Update</span>
                                                <span class="indicator-progress">Please wait... <span class="spinner-border spinner-border-sm align-middle ms-2"></span></span>
                                            </button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!--end::Edit Modal-->
                </div>
                <!--end::Card toolbar-->
            </div>
            <!--end::Card header-->

            <!--begin::Card body-->
            <div class="card-body py-4">
                <!--begin::Table-->
                <table class="table align-middle table-row-dashed fs-6 gy-5" id="kt_table_users">
                    <thead>
                        <tr class="text-start text-muted fw-bold fs-7 text-uppercase gs-0">
                            <th class="w-10px pe-2">
                                <div class="form-check form-check-sm form-check-custom form-check-solid me-3">
                                    <input class="form-check-input" type="checkbox" data-kt-check="true" data-kt-check-target="#kt_table_users .form-check-input" value="1" />
                                </div>
                            </th>
                            <th class="min-w-125px" hidden>Name</th>
                            <th class="min-w-125px">GWA</th>
                            <th class="min-w-125px">Percentage</th>
                            <th class="min-w-125px">Academic Term</th>
                            <th class="min-w-125px">Status</th>
                            <th class="text-end min-w-100px">Actions</th>
                        </tr>
                    </thead>
                    <tbody class="text-gray-600 fw-semibold">
                        <?php foreach ($criteria as $row): ?>
                            <tr>
                                <td>
                                    <div class="form-check form-check-sm form-check-custom form-check-solid">
                                        <input class="form-check-input" type="checkbox" value="<?= $row['StudentAdmission_CriteriaID']; ?>" />
                                    </div>
                                </td>
                                <td class="d-flex align-items-center" hidden>
                                    <?= $row['StudentAdmission_CriteriaID']; ?>
                                </td>
                                <td><?= $row['GWA']; ?></td>
                                <td><?= $row['Percentage']; ?></td>
                                <td><?= $row['TermID']; ?></td> 
                                <td><?= $row['TermID']; ?></td> 
                                <td class="text-end">
                                    <a href="#" class="btn btn-light btn-active-light-primary btn-flex btn-center btn-sm" data-kt-menu-trigger="click" data-kt-menu-placement="bottom-end">
                                        Actions
                                        <i class="ki-outline ki-down fs-5 ms-1"></i>
                                    </a>
                                    <!--begin::Menu-->
                                    <div class="menu menu-sub menu-sub-dropdown menu-column menu-rounded menu-gray-600 menu-state-bg-light-primary fw-semibold fs-7 w-125px py-4" data-kt-menu="true">
                                        <!--begin::Menu item-->
                                        <div class="menu-item px-3">
                                            <a href="javascript:void(0);" class="menu-link px-3 edit-schedule-btn"
                                               data-id="<?= $row['StudentAdmission_CriteriaID']; ?>"
                                               data-gwa="<?= $row['GWA']; ?>" 
                                              >
                                                Edit
                                            </a>
                                        </div>
                                        <!--end::Menu item-->

                                        <!--begin::Menu item-->
                                        <div class="menu-item px-3">
                                            <a href="<?= base_url('admissions/deleteDuration/' . $row['StudentAdmission_CriteriaID']); ?>" class="menu-link px-3 delete-schedule-btn">
                                                Delete
                                            </a>
                                        </div>
                                        <!--end::Menu item-->
                                    </div>
                                    <!--end::Menu-->
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
                <!--end::Table-->
            </div>
            <!--end::Card body-->
        </div>
        <!--end::Card-->
    </div>
    <!--end::Container-->
</div>
<!--end::Content-->

<?= $this->endSection(); ?>

<!--begin::Custom Javascript-->
<?= $this->section('customscripts'); ?> 
<script>
    $("#start_date").daterangepicker({
        singleDatePicker: true,
        showDropdowns: true,
        minYear: 1901,
        maxYear: parseInt(moment().format("YYYY"), 12),
        minDate: moment().add(1, 'days'),
        locale: {
            format: 'MMMM D, YYYY'
        }
    });
</script>
<script>
    <?php if (session()->getFlashdata('success')): ?>
        Swal.fire({
            icon: 'success',
            title: 'Success!',
            text: '<?= session()->getFlashdata('success'); ?>',
            confirmButtonText: 'OK'
        });
    <?php endif; ?>

    <?php if (session()->getFlashdata('error')): ?>
        Swal.fire({
            icon: 'error',
            title: 'Error!',
            text: '<?= session()->getFlashdata('error'); ?>',
            confirmButtonText: 'OK'
        });
    <?php endif; ?>

    <?php if (session()->getFlashdata('errors')): ?>
        Swal.fire({
            icon: 'error',
            title: 'Validation Errors!',
            html: '<ul><?php foreach (session()->getFlashdata('errors') as $error): ?><li><?= $error ?></li><?php endforeach; ?></ul>',
            confirmButtonText: 'OK'
        });
    <?php endif; ?>
</script>
 
<script>
    // Function to open the edit modal with data
    function openEditModal(id, date, maxExaminees) {
        $('#edit_DurationID').val(id);
        $('#edit_Admission_cycle_name').val(admission);
        $('#edit_Start_date').val(admission);
        $('#edit_End_date').val(admission);
        $('#edit_Duration').val(admission);
        $('#editDurationModal').modal('show');
    }

    // Handle click event on the edit button
    $(document).on('click', '.edit-schedule-btn', function () {
        var id = $(this).data('id');
      
        var admission = $(this).data('admission');
        var date = $(this).data('date');
        var maxExaminees = $(this).data('max_examinees');
        openEditModal(id, date, admission, maxExaminees);
    });
</script>
<script>
    // SweetAlert2 Delete Confirmation
    function confirmDelete(url) {
        Swal.fire({
            title: 'Are you sure?',
            text: "Are you sure you want to delete this schedule?",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, delete it!',
            cancelButtonText: 'Cancel'
        }).then((result) => {
            if (result.isConfirmed) {
                window.location.href = url;
            }
        });
    }

    // Handle click event on the delete button
    $(document).on('click', '.delete-schedule-btn', function (e) {
        e.preventDefault();
        var url = $(this).attr('href');
        confirmDelete(url);
    });
</script>

<?= $this->endSection(); ?> 
 