<?= $this->extend('layouts/mainAdmin'); ?>

<?= $this->section('content'); ?>

<!--begin::Content-->
<div class="content d-flex flex-column flex-column-fluid" id="kt_content">
    <!--begin::Container-->
    <div id="kt_content_container" class=" container-xxl ">
        <!--begin::Card-->
        <div class="card">
            <!--begin::Card header-->
            <div class="card-header border-0 pt-6">
                <!--begin::Card title-->
                <div class="card-title">
                    <!--begin::Search-->
                    <div class="d-flex align-items-center position-relative my-1">
                        <i class="ki-outline ki-magnifier fs-3 position-absolute ms-5"></i> <input type="text"
                            data-kt-user-table-filter="search" class="form-control form-control-solid w-250px ps-13"
                            placeholder="Search Application Type" />
                    </div>
                    <!--end::Search-->
                </div>
                <!--begin::Card title-->

                <!--begin::Card toolbar-->
                <div class="card-toolbar">
                    <!--begin::Toolbar-->
                    <div class="d-flex justify-content-end" data-kt-user-table-toolbar="base">


                        <!--begin::Export-->
                        <button type="button" class="btn btn-light-primary me-3" data-bs-toggle="modal"
                            data-bs-target="#kt_modal_export_users">
                            <i class="ki-outline ki-exit-up fs-2"></i> Add Application Type
                        </button>
                    </div>
                    <!--end::Toolbar-->

                    <!--begin::Group actions-->
                    <div class="d-flex justify-content-end align-items-center d-none"
                        data-kt-user-table-toolbar="selected">
                        <div class="fw-bold me-5">
                            <span class="me-2" data-kt-user-table-select="selected_count"></span> Selected
                        </div>

                        <button type="button" class="btn btn-danger" data-kt-user-table-select="delete_selected">
                            Delete Selected
                        </button>
                    </div>
                    <!--end::Group actions-->

                    <!--begin::Modal - Adjust Balance-->
                    <!--begin::Modal - Add Application Type-->
                    <div class="modal fade" id="kt_modal_export_users" tabindex="-1" aria-hidden="true">
                        <div class="modal-dialog modal-dialog-centered mw-650px">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h2 class="fw-bold">Application Type</h2>
                                    <button type="button" class="btn-close" data-bs-dismiss="modal"
                                        aria-label="Close"></button>
                                </div>
                                <div class="modal-body">
                                    <form id="kt_modal_export_users_form" class="form"
                                        action="<?= base_url('AdmissionApplicationTypeController/addAppType'); ?>"
                                        method="post">
                                        <?= csrf_field(); ?>

                                        <!-- Application Type -->
                                        <div class="form-floating mb-7">
                                            <input class="form-control form-control-solid"
                                                placeholder="Application Type" id="applicationtype"
                                                name="applicationtype" required />
                                            <label for="applicationtype">Application Type</label>
                                        </div>

                                        <!-- Dynamic Requirement List -->
                                        <div id="requirement-list" class="mb-7">
                                            <label class="form-label">Requirements</label>
                                            <div class="input-group mb-3">
                                                <input type="text" class="form-control" name="requirements[]"
                                                    placeholder="Requirement">
                                                <button type="button"
                                                    class="btn btn-primary add-requirement-btn">+</button>
                                            </div>
                                        </div>

                                        <div class="text-center">
                                            <button type="submit" class="btn btn-primary">
                                                <span class="indicator-label">Submit</span>
                                                <span class="indicator-progress">
                                                    Please wait... <span
                                                        class="spinner-border spinner-border-sm align-middle ms-2"></span>
                                                </span>
                                            </button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!--end::Modal - Add Application Type-->
                    <!--end::Modal - New Card-->
                    <!-- Edit Modal -->
                    <div class="modal fade" id="editScheduleModal" tabindex="-1" aria-hidden="true">
                        <div class="modal-dialog modal-dialog-centered mw-650px">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h2 class="fw-bold">Edit Application Type</h2>
                                    <button type="button" class="btn-close" data-bs-dismiss="modal"
                                        aria-label="Close"></button>
                                </div>
                                <div class="modal-body">
                                    <form id="editScheduleForm"
                                        action="<?= base_url('AdmissionApplicationTypeController/update'); ?>"
                                        method="post">
                                        <?= csrf_field(); ?>
                                        <input type="text" id="applicationtypeid" name="applicationtypeid" hidden>
                                        <div class="form-floating mb-7">
                                            <input type="text" class="form-control form-control-solid"
                                                placeholder="Application Type" id="edit_application_type"
                                                name="edit_application_type" required />
                                            <label for="edit_application_type">Application Type</label>
                                        </div>

                                        <div class="text-center">
                                            <button type="submit" class="btn btn-primary">
                                                <span class="indicator-label">Update</span>
                                                <span class="indicator-progress">Please wait... <span
                                                        class="spinner-border spinner-border-sm align-middle ms-2"></span></span>
                                            </button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>


                </div>
                <!--end::Card toolbar-->
            </div>
            <!--end::Card header-->

            <!--begin::Card body-->
            <div class="card-body py-4">

                <!--begin::Table-->
                <table class="table align-middle table-row-dashed fs-6 gy-5" id="kt_table_users">
                    <thead>
                        <tr class="text-start text-muted fw-bold fs-7 text-uppercase gs-0">
                            <th class="w-10px pe-2">
                                <div class="form-check form-check-sm form-check-custom form-check-solid me-3">
                                    <input class="form-check-input" type="checkbox" data-kt-check="true"
                                        data-kt-check-target="#kt_table_users .form-check-input" value="1" />
                                </div>
                            </th>
                            <th class="min-w-125px">No</th>
                            <th class="min-w-125px">Admission Type</th>
                            <th class="min-w-125px">Requirements</th>
                            <th class="min-w-125px" hidden></th>
                            <th class="min-w-125px" hidden></th>
                            <th class="text-end min-w-100px">Actions</th>
                        </tr>
                    </thead>
                    <tbody class="text-gray-600 fw-semibold">
                        <?php
                        $number = 1;
                        foreach ($apptype as $row): ?>
                            <tr>
                                <td>
                                    <div class="form-check form-check-sm form-check-custom form-check-solid">
                                        <input class="form-check-input" type="checkbox"
                                            value="<?= $row->AdmissionTypeID; ?>" />
                                    </div>
                                </td>
                                <td class="d-flex align-items-center">
                                    <?= $number++; ?>
                                </td>
                                <td hidden></td>
                                <td><?= $row->AdmissionType; ?></td>
                                <td><?= $row->Requirement_name; ?></td>
                                <td hidden></td>
                                <!-- Assuming you have current_examinees column -->
                                <td class="text-end">
                                    <a href="#" class="btn btn-light btn-active-light-primary btn-flex btn-center btn-sm"
                                        data-kt-menu-trigger="click" data-kt-menu-placement="bottom-end">
                                        Actions
                                        <i class="ki-outline ki-down fs-5 ms-1"></i>
                                    </a>
                                    <!--begin::Menu-->
                                    <div class="menu menu-sub menu-sub-dropdown menu-column menu-rounded menu-gray-600 menu-state-bg-light-primary fw-semibold fs-7 w-125px py-4"
                                        data-kt-menu="true">
                                        <!--begin::Menu item-->
                                        <div class="menu-item px-3">
                                            <a href="javascript:void(0);" class="menu-link px-3 edit-apptype-btn"
                                                data-id="<?= $row->AdmissionTypeID; ?>"
                                                data-AdmissionType="<?= $row->AdmissionType; ?>">
                                                Edit
                                            </a>
                                        </div>

                                        <!--end::Menu item-->

                                        <!--begin::Menu item-->
                                        <div class="menu-item px-3">
                                            <a href="<?= base_url('AdmissionApplicationTypeController/deleteApplicationType/' . $row->AdmissionTypeID); ?>"
                                                class="menu-link px-3 delete-app-btn">
                                                Delete
                                            </a>
                                        </div>
                                        <!--end::Menu item-->
                                    </div>
                                    <!--end::Menu-->
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
                <!--end::Table-->
            </div>
            <!--end::Card body-->
        </div>
        <!--end::Card-->
    </div>
    <!--end::Container-->
</div>
<!--end::Content-->



<?= $this->endSection(); ?>


<!--begin::Custom Javascript-->
<?= $this->section('customscripts'); ?>

<!-- <script src="<?= base_url("public"); ?>/<?= base_url("public"); ?>/assets/js/custom/utilities/modals/thescript.js"></script> -->
<script src="//cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script>
    // Add new requirement input dynamically
    $(document).on('click', '.add-requirement-btn', function () {
        const newRequirement = `
            <div class="input-group mb-3">
                <input type="text" class="form-control" name="requirements[]" placeholder="Requirement">
                <button type="button" class="btn btn-danger remove-requirement-btn">-</button>
            </div>`;
        $('#requirement-list').append(newRequirement);
    });

    // Remove requirement input dynamically
    $(document).on('click', '.remove-requirement-btn', function () {
        $(this).closest('.input-group').remove();
    });
</script>
<script>
    $("#sched_date").daterangepicker({
        singleDatePicker: true,
        showDropdowns: true,
        minYear: 1901,
        maxYear: parseInt(moment().format("YYYY"), 12),
        // minDate: moment().add(1, 'days'),
        locale: {
            format: 'MMMM D, YYYY'
        }
    });
</script>
<script>
    <?php if (session()->getFlashdata('success')): ?>
        Swal.fire({
            icon: 'success',
            title: 'Success!',
            text: '<?= session()->getFlashdata('success'); ?>',
            confirmButtonText: 'OK'
        });
    <?php endif; ?>

    <?php if (session()->getFlashdata('error')): ?>
        Swal.fire({
            icon: 'error',
            title: 'Error!',
            text: '<?= session()->getFlashdata('error'); ?>',
            confirmButtonText: 'OK'
        });
    <?php endif; ?>

    <?php if (session()->getFlashdata('errors')): ?>
        Swal.fire({
            icon: 'error',
            title: 'Validation Errors!',
            html: '<ul><?php foreach (session()->getFlashdata('errors') as $error): ?><li><?= $error ?></li><?php endforeach; ?></ul>',
            confirmButtonText: 'OK'
        });
    <?php endif; ?>
</script>
<script>

    // Function to open the edit modal with data
    function openEditModal(id, AdmissionType) {
        $('#applicationtypeid').val(id);
        $('#edit_application_type').val(AdmissionType);
        $('#editScheduleModal').modal('show');
    }

    // Handle click event on the edit button
    $(document).on('click', '.edit-apptype-btn', function () {
        var id = $(this).data('id');
        var AdmissionType = $(this).data('AdmissionType');
        openEditModal(id, AdmissionType);
    });
</script>
<script>
    // SweetAlert2 Delete Confirmation
    function confirmDelete(url) {
        Swal.fire({
            title: 'Are you sure?',
            text: "Are you sure you want to delete this Application Type?",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, delete it!',
            cancelButtonText: 'Cancel'
        }).then((result) => {
            if (result.isConfirmed) {
                window.location.href = url;
            }
        });
    }

    // Handle click event on the delete buasdsadtton
    $(document).on('click', '.delete-app-btn', function (e) {
        e.preventDefault();
        var url = $(this).attr('href');
        confirmDelete(url);
    });
</script>
 


<?= $this->endSection(); ?>
<!--end::Custom Javascript-->