<?= $this->extend('layouts/mainAdmin'); ?>

<?= $this->section('content'); ?>

<!--begin::Content-->
<div class="content d-flex flex-column flex-column-fluid" id="kt_content">
    <!--begin::Container-->
    <div id="kt_content_container" class=" container-xxl ">
        <!--begin::Card-->
        <div class="card">
            <!--begin::Card header-->
            <div class="card-header border-0 pt-6">
                <!--begin::Card title-->
                <div class="card-title">
                    <!--begin::Search-->
                    <div class="d-flex align-items-center position-relative my-1">
                        <i class="ki-outline ki-magnifier fs-3 position-absolute ms-5"></i> <input type="text"
                            data-kt-user-table-filter="search" class="form-control form-control-solid w-250px ps-13"
                            placeholder="Search user" />
                    </div>
                    <!--end::Search-->
                </div>
                <!--begin::Card title-->

                <!--begin::Card toolbar-->
                <div class="card-toolbar">
                    <!--begin::Toolbar-->
                    <div class="d-flex justify-content-end" data-kt-user-table-toolbar="base">
                        <!--begin::Filter-->
                        <button type="button" class="btn btn-light-primary me-3" data-kt-menu-trigger="click"
                            data-kt-menu-placement="bottom-end">
                            <i class="ki-outline ki-filter fs-2"></i> Filter
                        </button>
                        <!--begin::Menu 1-->
                        <div class="menu menu-sub menu-sub-dropdown w-300px w-md-325px" data-kt-menu="true">
                            <!--begin::Header-->
                            <div class="px-7 py-5">
                                <div class="fs-5 text-gray-900 fw-bold">Filter Options</div>
                            </div>
                            <!--end::Header-->

                            <!--begin::Separator-->
                            <div class="separator border-gray-200"></div>
                            <!--end::Separator-->

                            <!--begin::Content-->
                            <div class="px-7 py-5" data-kt-user-table-filter="form">
                                <!--begin::Input group-->
                                <div class="mb-10">
                                    <label class="form-label fs-6 fw-semibold">College:</label>
                                    <select id="college" class="form-select form-select-solid fw-bold"
                                        data-kt-select2="true" data-placeholder="Select option" data-allow-clear="true"
                                        data-kt-user-table-filter="role" data-hide-search="true">
                                        <option></option>

                                    </select>
                                </div>
                                <!--end::Input group-->

                                <!--begin::Input group-->
                                <div class="mb-10">
                                    <label class="form-label fs-6 fw-semibold">Program</label>
                                    <select id="program" class="form-select form-select-solid fw-bold"
                                        data-kt-select2="true" data-placeholder="Select option" data-allow-clear="true"
                                        data-kt-user-table-filter="two-step" data-hide-search="true">
                                        <option></option>

                                    </select>
                                </div>
                                <!--end::Input group-->

                                <!--begin::Actions-->
                                <div class="d-flex justify-content-end">
                                    <button type="reset"
                                        class="btn btn-light btn-active-light-primary fw-semibold me-2 px-6"
                                        data-kt-menu-dismiss="true" data-kt-user-table-filter="reset">Reset</button>
                                    <button type="submit" class="btn btn-primary fw-semibold px-6"
                                        data-kt-menu-dismiss="true" data-kt-user-table-filter="filter">Apply</button>
                                </div>
                                <!--end::Actions-->
                            </div>
                            <!--end::Content-->
                        </div>
                        <!--end::Menu 1--> <!--end::Filter-->

                        <!--begin::Export-->
                        <button type="button" class="btn btn-light-primary me-3" data-bs-toggle="modal"
                            data-bs-target="#kt_modal_export_users">
                            <i class="ki-outline ki-exit-up fs-2"></i> Export
                        </button>
                        <!--end::Export-->
 
                    </div>
                    <!--end::Toolbar-->

                    <!--begin::Group actions-->
                    <div class="d-flex justify-content-end align-items-center d-none"
                        data-kt-user-table-toolbar="selected">
                        <div class="fw-bold me-5">
                            <span class="me-2" data-kt-user-table-select="selected_count"></span> Selected
                        </div>

                        <button type="button" class="btn btn-danger" data-kt-user-table-select="delete_selected">
                            Delete Selected
                        </button>
                    </div>
                    <!--end::Group actions-->

                    <!--begin::Modal - Adjust Balance-->
                    <div class="modal fade" id="kt_modal_export_users" tabindex="-1" aria-hidden="true">
                        <!--begin::Modal dialog-->
                        <div class="modal-dialog modal-dialog-centered mw-650px">
                            <!--begin::Modal content-->
                            <div class="modal-content">
                                <!--begin::Modal header-->
                                <!-- <div class="modal-header"> 
                                    <h2 class="fw-bold">Export Users</h2>
                                    
                                    <div class="btn btn-icon btn-sm btn-active-icon-primary"
                                        data-kt-users-modal-action="close">
                                        <i class="ki-outline ki-cross fs-1"></i>
                                    </div>
                                     
                                </div> -->
                                <!--end::Modal header-->

                                <!--begin::Modal body-->
                                <div class="modal-body scroll-y mx-5 mx-xl-15 my-7">
                                    <!--begin::Form-->
                                    <form id="kt_modal_export_users_form" class="form" action="#">
                                        

                                        <!--begin::Input group-->
                                        <div class="fv-row mb-10">
                                            <!--begin::Label-->
                                            <label class="required fs-6 fw-semibold form-label mb-2">Select Export
                                                Format:</label>
                                            <!--end::Label-->

                                            <!--begin::Input-->
                                            <select name="format" data-control="select2"
                                                data-placeholder="Select a format" data-hide-search="true"
                                                class="form-select form-select-solid fw-bold">
                                                <option></option>
                                                <option value="excel">Excel</option>
                                                <option value="pdf">PDF</option>
                                                <option value="cvs">CVS</option>
                                                <option value="zip">ZIP</option>
                                            </select>
                                            <!--end::Input-->
                                        </div>
                                        <!--end::Input group-->

                                        <!--begin::Actions-->
                                        <div class="text-center">
                                            <button type="reset" class="btn btn-light me-3"
                                                data-kt-users-modal-action="cancel">
                                                Discard
                                            </button>

                                            <button type="submit" class="btn btn-primary"
                                                data-kt-users-modal-action="submit">
                                                <span class="indicator-label">
                                                    Submit
                                                </span>
                                                <span class="indicator-progress">
                                                    Please wait... <span
                                                        class="spinner-border spinner-border-sm align-middle ms-2"></span>
                                                </span>
                                            </button>
                                        </div>
                                        <!--end::Actions-->
                                    </form>
                                    <!--end::Form-->
                                </div>
                                <!--end::Modal body-->
                            </div>
                            <!--end::Modal content-->
                        </div>
                        <!--end::Modal dialog-->
                    </div>
                    <!--end::Modal - New Card-->

                   
                </div>
                <!--end::Card toolbar-->
            </div>
            <!--end::Card header-->

            <!--begin::Card body-->
            <div class="card-body py-4">

                <!--begin::Table-->
                <table class="table align-middle table-row-dashed fs-6 gy-5" id="kt_table_users">
                    <thead>
                        <tr class="text-start text-muted fw-bold fs-7 text-uppercase gs-0">
                            <th class="w-10px pe-2">
                                <div class="form-check form-check-sm form-check-custom form-check-solid me-3">
                                    <input class="form-check-input" type="checkbox" data-kt-check="true"
                                        data-kt-check-target="#kt_table_users .form-check-input" value="1" />
                                </div>
                            </th>
                            <th class="min-w-125px">Name</th>
                            <th class="min-w-125px">Application Type</th>
                            <th class="min-w-125px">Applying For</th>
                            <th class="min-w-125px">Date Created</th>
                            <th class="min-w-125px">Days Completed</th>
                            <th class="min-w-125px">Status</th>
                            <th class="text-end min-w-100px">Actions</th>
                        </tr>
                    </thead>
                    <tbody class="text-gray-600 fw-semibold">
                        <?php foreach ($app as $row): ?>
                            <tr>
                                <td>
                                    <div class="form-check form-check-sm form-check-custom form-check-solid">
                                        <input class="form-check-input" type="checkbox" value="1" />
                                    </div>
                                </td>
                                <td class="d-flex align-items-center">
                                    <!--begin:: Avatar -->
                                    
                                    <!-- <div class="symbol symbol-circle symbol-50px overflow-hidden me-3">
                                        <a href="#">
                                            <div class="symbol-label">
                                            <?php if (!empty($row->Image)) : ?>
                                                <img src="<?= base_url('uploadsImage/' . $row->Image) ?>" alt="image" />
                                            
                                            <?php else : ?>
                                                <img src="<?= base_url(); ?>public/assets/media/avatars/300-6.jpg" alt="image" />
                                                
                                            <?php endif; ?>
                                            </div>
                                        </a>
                                    </div> -->
                                    <!--end::Avatar-->
                                    <!--begin::User details-->
                                    <div class="d-flex flex-column">
                                        <a href="<?php echo base_url(); ?>admissions/applicantProfile/<?= $row->StudentAdmissionID ?>"
                                            class="text-gray-800 text-hover-primary mb-1"><?= $row->FirstName . ' ' . $row->LastName ?></a>
                                        <span><?= $row->StudentAdmissionID ?></span>
                                    </div>
                                    <!--begin::User details-->
                                </td>
                                <td><?= $row->Remarks ?></td>
                                <td><?= $row->ProgramDesc ?></td>
                                <td>
                                    <div class="badge badge-light fw-bold"><?= $row->DateCreated ?></div>
                                </td>
                                <td class="d-flex align-items-right">3</td>
                                <td>

                                    <?php if ($row->Status == 'Pending'): ?>
                                        <span class="badge badge-warning"><?= $row->Status ?></span>
                                    <?php elseif ($row->Status == 'Approved'): ?>
                                        <span class="badge badge-success"><?= $row->Status ?></span>
                                    <?php elseif ($row->Status == 'Rejected'): ?>
                                        <span class="badge badge-danger"><?= $row->Status ?></span>
                                    <?php else: ?>
                                        <span class="badge badge-secondary"><?= $row->Status ?></span>
                                    <?php endif; ?>
                                </td>
                                <td class="text-end">
                                    <a href="#" class="btn btn-light btn-active-light-primary btn-flex btn-center btn-sm"
                                        data-kt-menu-trigger="click" data-kt-menu-placement="bottom-end">
                                        Actions
                                        <i class="ki-outline ki-down fs-5 ms-1"></i> </a>
                                    <!--begin::Menu-->
                                    <div class="menu menu-sub menu-sub-dropdown menu-column menu-rounded menu-gray-600 menu-state-bg-light-primary fw-semibold fs-7 w-125px py-4"
                                        data-kt-menu="true">
                                        <!--begin::Menu item-->
                                        <div class="menu-item px-3">
                                            <a href="<?php echo base_url(); ?>admissions/applicantProfile/<?= $row->StudentAdmissionID ?>"
                                                class="menu-link px-3">
                                                Edit
                                            </a>
                                        </div>
                                        <!--end::Menu item-->

                                        <!--begin::Menu item-->
                                        <div class="menu-item px-3">
                                            <a href="#" class="menu-link px-3" data-kt-users-table-filter="delete_row">
                                                Delete
                                            </a>
                                        </div>
                                        <!--end::Menu item-->
                                    </div>
                                    <!--end::Menu-->
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
                <!--end::Table-->
            </div>
            <!--end::Card body-->
        </div>
        <!--end::Card-->
    </div>
    <!--end::Container-->
</div>
<!--end::Content-->
<script src="https://code.jquery.com/jquery-3.6.4.min.js" ></script>
<script>
    var baseUrl = "<?= base_url(); ?>"; 
</script>
<script>
    $(document).ready(function () {
        // function populateProgramSelect() {
        var college = document.getElementById('college');
         
        // Clear existing options
        college.innerHTML = '<option selected>Please Select</option>';

        // Fetch data from CodeIgniter using AJAX
        $.ajax({
            url: baseUrl + '/college',
            type: 'GET',
            dataType: 'json',
            success: function (data) {
                // Populate options from the received data
                console.log(data);
                data.forEach(function (program) {
                    var option = document.createElement('option');
                    option.value = program.CollegeID;
                    option.text = program.CollegeDesc;
                    college.appendChild(option);

                });

            },
            error: function (error) {
                console.error('Error fetching data:', error);
            }
        });
        // FOR PROGRAM NAMAN
        $("#college").change(function () {
            // Retrieve the selected program ID
            var collegeId = $("#college").val();
 
            // Check if a program is selected
            if (collegeId === "Please Select") {
                // Optionally, you can clear or hide any related elements when no program is selected
                // For example: $("#relatedElement").hide();
                return;
            }

            // Fetch and display data related to the selected program
            $.ajax({
                url: baseUrl + '/getProgrambyCollege/' + collegeId, 
                type: 'GET',
                dataType: 'json',
                success: function (data) {
                    // Update or display the data as needed
                   console.log(data);
                    console.log('go');

                    // Clear existing options
                    //   $("#courseSelect").empty();
                    // Clear existing options and add an empty option
                    $("#program").empty().append($('<option>', {
                        value: '', // Set value to empty or adjust as needed
                        text: 'Select a course' // Set text for the empty option
                    }));

                    // Populate options from the received data
                    data.forEach(function (course) {
                        var option = document.createElement('option');
                        option.value = course.ProgramID; // Adjust the value based on your data
                        option.text = course.ProgramDesc; // Adjust the text based on your data
                        $("#program").append(option);

                    });
                },
                error: function (error) {
                    console.error('Error fetching data:', error);
                }
            });
        });
    });
</script>


<?= $this->endSection(); ?>


<!--begin::Custom Javascript-->
<?= $this->section('customscripts'); ?>

<!-- <script src="<?= base_url("public"); ?>/<?= base_url("public"); ?>/assets/js/custom/utilities/modals/thescript.js"></script> -->

<?= $this->endSection(); ?>
<!--end::Custom Javascript-->