<?= $this->extend('layouts/main'); ?>

<?= $this->section('content'); ?>

<!--begin::Content-->
<div class="content d-flex flex-column flex-column-fluid" id="kt_content">
    <!--begin::Container-->
    <div id="kt_content_container" class=" container-xxl ">
        <!--begin::Stepper-->
        <div class="stepper stepper-pills stepper-column d-flex flex-column flex-xl-row flex-row-fluid gap-10"
            id="kt_create_account_stepper">
            <!--begin::Aside-->
            <div
                class="card d-flex justify-content-center justify-content-xl-start flex-row-auto w-100 w-xl-300px w-xxl-400px">
                <!--begin::Wrapper-->
                <div class="card-body px-6 px-lg-10 px-xxl-15 py-20">
                    <!--begin::Nav-->
                    <div class="stepper-nav">
                        <!--begin::Step 1-->
                        <div class="stepper-item current" data-kt-stepper-element="nav">
                            <!--begin::Wrapper-->
                            <div class="stepper-wrapper">
                                <!--begin::Icon-->
                                <div class="stepper-icon w-40px h-40px">
                                    <i class="ki-outline ki-check fs-2 stepper-check"></i>
                                    <span class="stepper-number">1</span>
                                </div>
                                <!--end::Icon-->

                                <!--begin::Label-->
                                <div class="stepper-label">
                                    <h3 class="stepper-title">
                                        Application Type
                                    </h3>

                                    <div class="stepper-desc fw-semibold">
                                        Setup Your Account Details
                                    </div>
                                </div>
                                <!--end::Label-->
                            </div>
                            <!--end::Wrapper-->

                            <!--begin::Line-->
                            <div class="stepper-line h-40px"></div>
                            <!--end::Line-->
                        </div>
                        <!--end::Step 1-->

                        <!--begin::Step 2-->
                        <div class="stepper-item" data-kt-stepper-element="nav">
                            <!--begin::Wrapper-->
                            <div class="stepper-wrapper">
                                <!--begin::Icon-->
                                <div class="stepper-icon w-40px h-40px">
                                    <i class="ki-outline ki-check fs-2 stepper-check"></i>
                                    <span class="stepper-number">2</span>
                                </div>
                                <!--end::Icon-->

                                <!--begin::Label-->
                                <div class="stepper-label">
                                    <h3 class="stepper-title">
                                        Application Setting
                                    </h3>
                                    <div class="stepper-desc fw-semibold">
                                        Setup Your Account Settings
                                    </div>
                                </div>
                                <!--end::Label-->
                            </div>
                            <!--end::Wrapper-->

                            <!--begin::Line-->
                            <div class="stepper-line h-40px"></div>
                            <!--end::Line-->
                        </div>
                        <!--end::Step 2-->

                        <!--begin::Step 3-->
                        <div class="stepper-item" data-kt-stepper-element="nav">
                            <!--begin::Wrapper-->
                            <div class="stepper-wrapper">
                                <!--begin::Icon-->
                                <div class="stepper-icon w-40px h-40px">
                                    <i class="ki-outline ki-check fs-2 stepper-check"></i>
                                    <span class="stepper-number">3</span>
                                </div>
                                <!--end::Icon-->

                                <!--begin::Label-->
                                <div class="stepper-label">
                                    <h3 class="stepper-title">
                                        Personal Info
                                    </h3>
                                    <div class="stepper-desc fw-semibold">
                                        Your Personal Info
                                    </div>
                                </div>
                                <!--end::Label-->
                            </div>
                            <!--end::Wrapper-->

                            <!--begin::Line-->
                            <div class="stepper-line h-40px"></div>
                            <!--end::Line-->
                        </div>
                        <!--end::Step 3-->

                        <!--begin::Step 4-->
                        <div class="stepper-item" data-kt-stepper-element="nav">
                            <!--begin::Wrapper-->
                            <div class="stepper-wrapper">
                                <!--begin::Icon-->
                                <div class="stepper-icon w-40px h-40px">
                                    <i class="ki-outline ki-check fs-2 stepper-check"></i>
                                    <span class="stepper-number">4</span>
                                </div>
                                <!--end::Icon-->

                                <!--begin::Label-->
                                <div class="stepper-label">
                                    <h3 class="stepper-title">
                                        Contact Details
                                    </h3>
                                    <div class="stepper-desc fw-semibold">
                                        Set Your Payment Methods
                                    </div>
                                </div>
                                <!--end::Label-->
                            </div>
                            <!--end::Wrapper-->

                            <!--begin::Line-->
                            <div class="stepper-line h-40px"></div>
                            <!--end::Line-->
                        </div>
                        <!--end::Step 4--> 
                           <!--begin::Step 5-->
                           <div class="stepper-item" data-kt-stepper-element="nav">
                            <!--begin::Wrapper-->
                            <div class="stepper-wrapper">
                                <!--begin::Icon-->
                                <div class="stepper-icon w-40px h-40px">
                                    <i class="ki-outline ki-check fs-2 stepper-check"></i>
                                    <span class="stepper-number">5</span>
                                </div>
                                <!--end::Icon-->

                                <!--begin::Label-->
                                <div class="stepper-label">
                                    <h3 class="stepper-title">
                                        Parents/Guardian Details
                                    </h3>
                                    <div class="stepper-desc fw-semibold">
                                        Set Your Payment Methods
                                    </div>
                                </div>
                                <!--end::Label-->
                            </div>
                            <!--end::Wrapper-->

                            <!--begin::Line-->
                            <div class="stepper-line h-40px"></div>
                            <!--end::Line-->
                        </div>
                        <!--end::Step 5--> 
                        <!--begin::Step 6-->
                        <div class="stepper-item" data-kt-stepper-element="nav">
                            <!--begin::Wrapper-->
                            <div class="stepper-wrapper">
                                <!--begin::Icon-->
                                <div class="stepper-icon w-40px h-40px">
                                    <i class="ki-outline ki-check fs-2 stepper-check"></i>
                                    <span class="stepper-number">6</span>
                                </div>
                                <!--end::Icon-->

                                <!--begin::Label-->
                                <div class="stepper-label">
                                    <h3 class="stepper-title">
                                        School Details
                                    </h3>
                                    <div class="stepper-desc fw-semibold">
                                        Set Your Payment Methods
                                    </div>
                                </div>
                                <!--end::Label-->
                            </div>
                            <!--end::Wrapper-->

                            <!--begin::Line-->
                            <div class="stepper-line h-40px"></div>
                            <!--end::Line-->
                        </div>
                        <!--end::Step 6--> 
                        <!--begin::Step 7-->
                        <div class="stepper-item" data-kt-stepper-element="nav">
                            <!--begin::Wrapper-->
                            <div class="stepper-wrapper">
                                <!--begin::Icon-->
                                <div class="stepper-icon w-40px h-40px">
                                    <i class="ki-outline ki-check fs-2 stepper-check"></i>
                                    <span class="stepper-number">7</span>
                                </div>
                                <!--end::Icon-->

                                <!--begin::Label-->
                                <div class="stepper-label">
                                    <h3 class="stepper-title">
                                        Academic Details
                                    </h3>
                                    <div class="stepper-desc fw-semibold">
                                        Set Your Academic Details
                                    </div>
                                </div>
                                <!--end::Label-->
                            </div>
                            <!--end::Wrapper-->

                            <!--begin::Line-->
                            <div class="stepper-line h-40px"></div>
                            <!--end::Line-->
                        </div>
                        <!--end::Step 7--> 
                        
                         <!--begin::Step 8-->
                         <div class="stepper-item" data-kt-stepper-element="nav">
                            <!--begin::Wrapper-->
                            <div class="stepper-wrapper">
                                <!--begin::Icon-->
                                <div class="stepper-icon w-40px h-40px">
                                    <i class="ki-outline ki-check fs-2 stepper-check"></i>
                                    <span class="stepper-number">8</span>
                                </div>
                                <!--end::Icon-->

                                <!--begin::Label-->
                                <div class="stepper-label">
                                    <h3 class="stepper-title">
                                        Survey
                                    </h3>
                                    <div class="stepper-desc fw-semibold">
                                        Pang Survey
                                    </div>
                                </div>
                                <!--end::Label-->
                            </div>
                            <!--end::Wrapper-->

                            <!--begin::Line-->
                            <div class="stepper-line h-40px"></div>
                            <!--end::Line-->
                        </div>
                        <!--end::Step 8--> 
                         <!--begin::Step 8-->
                         <div class="stepper-item" data-kt-stepper-element="nav">
                            <!--begin::Wrapper-->
                            <div class="stepper-wrapper">
                                <!--begin::Icon-->
                                <div class="stepper-icon w-40px h-40px">
                                    <i class="ki-outline ki-check fs-2 stepper-check"></i>
                                    <span class="stepper-number">9</span>
                                </div>
                                <!--end::Icon-->

                                <!--begin::Label-->
                                <div class="stepper-label">
                                    <h3 class="stepper-title">
                                        Application Fee
                                    </h3>
                                    <div class="stepper-desc fw-semibold">
                                        Payment Details
                                    </div>
                                </div>
                                <!--end::Label-->
                            </div>
                            <!--end::Wrapper-->

                            <!--begin::Line-->
                            <div class="stepper-line h-40px"></div>
                            <!--end::Line-->
                        </div>
                        <!--end::Step 8--> 
                        <!--begin::Step 6-->
                        <div class="stepper-item mark-completed" data-kt-stepper-element="nav">
                            <!--begin::Wrapper-->
                            <div class="stepper-wrapper">
                                <!--begin::Icon-->
                                <div class="stepper-icon w-40px h-40px">
                                    <i class="ki-outline ki-check fs-2 stepper-check"></i>
                                    <span class="stepper-number">10</span>
                                </div>
                                <!--end::Icon-->

                                <!--begin::Label-->
                                <div class="stepper-label">
                                    <h3 class="stepper-title">
                                        Completed
                                    </h3>
                                    <div class="stepper-desc fw-semibold">
                                        Woah, we are here
                                    </div>
                                </div>
                                <!--end::Label-->
                            </div>
                            <!--end::Wrapper-->
                        </div>
                        <!--end::Step 6-->
                    </div>
                    <!--end::Nav-->
                </div>
                <!--end::Wrapper-->
            </div>
            <!--begin::Aside-->

            <!--begin::Content-->
            <div class="card d-flex flex-row-fluid flex-center">
                <!--begin::Form-->
                <form class="card-body py-20 w-100 mw-xl-700px px-9" novalidate="novalidate"
                    id="kt_create_account_form">
                    <!--begin::Step 1-->
                    <div class="current" data-kt-stepper-element="content">
                        <!--begin::Wrapper-->
                        <div class="w-100">
                            <!--begin::Heading-->
                            <div class="pb-10 pb-lg-15">
                                <!--begin::Title-->
                                <h2 class="fw-bold d-flex align-items-center text-dark">
                                    Choose Application Type


                                    <span class="ms-1" data-bs-toggle="tooltip"
                                        title="Billing is issued based on your selected account typ">
                                        <i class="ki-outline ki-information-5 text-gray-500 fs-6"></i></span>
                                </h2>
                                <!--end::Title-->

                                <!--begin::Notice-->
                                <div class="text-muted fw-semibold fs-6">
                                    If you need more info, please check out
                                    <a href="#" class="link-primary fw-bold">Help Page</a>.
                                </div>
                                <!--end::Notice-->
                            </div>
                            <!--end::Heading-->

                            <!--begin::Input group-->
                            <div class="fv-row">
                                <!--begin::Row-->
                                <div class="row">
                                    <!--begin::Col-->
                                    <div class="col-lg-6">
                                        <!--begin::Option-->
                                        <input type="radio" class="btn-check" name="account_type" value="personal"
                                            checked id="kt_create_account_form_account_type_personal" />
                                        <label
                                            class="btn btn-outline btn-outline-dashed btn-active-light-primary p-7 d-flex align-items-center mb-10"
                                            for="kt_create_account_form_account_type_personal">
                                            <i class="ki-outline ki-badge fs-3x me-5"></i>
                                            <!--begin::Info-->
                                            <span class="d-block fw-semibold text-start">
                                                <span class="text-dark fw-bold d-block fs-4 mb-2">
                                                    First-year College AY 2024-2025
                                                </span>
                                                <!-- <span class="text-muted fw-semibold fs-6">If you need more info, please check it out</span> -->
                                            </span>
                                            <!--end::Info-->
                                        </label>
                                        <!--end::Option-->
                                    </div>
                                    <!--end::Col-->

                                    <!--begin::Col-->
                                    <div class="col-lg-6">
                                        <!--begin::Option-->
                                        <input type="radio" class="btn-check" name="account_type" value="corporate"
                                            id="kt_create_account_form_account_type_corporate" />
                                        <label
                                            class="btn btn-outline btn-outline-dashed btn-active-light-primary p-7 d-flex align-items-center"
                                            for="kt_create_account_form_account_type_corporate">
                                            <i class="ki-outline ki-briefcase fs-3x me-5"></i>
                                            <!--begin::Info-->
                                            <span class="d-block fw-semibold text-start">
                                                <span class="text-dark fw-bold d-block fs-4 mb-2">Transferee / Second
                                                    Undergraduate</span>
                                                <!-- <span class="text-muted fw-semibold fs-6">Create corporate account to mane users</span> -->
                                            </span>
                                            <!--end::Info-->
                                        </label>
                                        <!--end::Option-->
                                    </div>
                                    <!--end::Col-->

                                </div>
                                <!--end::Row-->
                                <!--begin::Row-->
                                <div class="row">
                                    <!--begin::Col-->
                                    <div class="col-lg-6">
                                        <!--begin::Option-->
                                        <input type="radio" class="btn-check" name="account_type" value="personal"
                                             id="kt_create_account_form_account_type_personal2" />
                                        <label
                                            class="btn btn-outline btn-outline-dashed btn-active-light-primary p-7 d-flex align-items-center mb-10"
                                            for="kt_create_account_form_account_type_personal2">
                                            <i class="ki-outline ki-badge fs-3x me-5"></i>
                                            <!--begin::Info-->
                                            <span class="d-block fw-semibold text-start">
                                                <span class="text-dark fw-bold d-block fs-4 mb-2">
                                                    Graduate Studies (Master's and Doctoral Programs)
                                                </span>
                                                <!-- <span class="text-muted fw-semibold fs-6">If you need more info, please check it out</span> -->
                                            </span>
                                            <!--end::Info-->
                                        </label>
                                        <!--end::Option-->
                                    </div>
                                    <!--end::Col-->



                                </div>
                                <!--end::Row-->
                            </div>
                            <!--end::Input group-->
                        </div>
                        <!--end::Wrapper-->
                    </div>
                    <!--end::Step 1-->

                    <!--begin::Step 2-->
                    <div data-kt-stepper-element="content">
                        <!--begin::Wrapper-->
                        <div class="w-100">
                            <!--begin::Heading-->
                            <div class="pb-10 pb-lg-15">
                                <!--begin::Title-->
                                <h2 class="fw-bold text-dark">Application Details</h2>
                                <!--end::Title-->

                                <!--begin::Notice-->
                                <div class="text-muted fw-semibold fs-6">
                                    APPLICATION AS:
                                    <a href="#" class="link-primary fw-bold">Freshman</a>
                                </div>
                                <!--end::Notice-->
                                <!--begin::Notice-->
                                <div class="text-muted fw-semibold fs-6">
                                    ACADEMIC YEAR:
                                    <a href="#" class="link-primary fw-bold"> SY 2024-2025</a>
                                </div>
                                <!--end::Notice-->
                            </div>
                            <!--end::Heading-->

                            <!--begin::Input group-->
                            <div class="mb-10 fv-row">
                                <!--begin::Label-->
                                <label class="d-flex align-items-center form-label mb-3">
                                    Program Choices


                                    <span class="ms-1" data-bs-toggle="tooltip"
                                        title="Provide your team size to help us setup your billing">
                                        <i class="ki-outline ki-information-5 text-gray-500 fs-6"></i></span> </label>
                                <!--end::Label-->
                                <!--begin::Input group-->
                                <div class="fv-row mb-10">
                                    <!--begin::Label-->
                                    <label class="form-label required">First Choice</label>
                                    <!--end::Label-->

                                    <!--begin::Input-->
                                    <select name="programs" id="programs" class="form-select form-select-lg form-select-solid"
                                        data-control="select2" data-placeholder="Select..." data-allow-clear="true" value="2"
                                        data-hide-search="true">
                                        <?php foreach ($programs as $item): ?>
                                            <option></option>
                                            <option value="<?= $item['ProgramID']; ?>" selected><?= $item['ProgramDesc']; ?></option>
                                        <?php endforeach; ?>
                                        
                                    </select>
                                    <!--end::Input-->
                                </div>
                                <!--end::Input group-->
                                <!--begin::Input group-->
                                <div class="fv-row mb-10">
                                    <!--begin::Label-->
                                    <label class="form-label required">Second Choice</label>
                                    <!--end::Label-->

                                    <!--begin::Input-->
                                    <select name="programs2" id="programs2" class="form-select form-select-lg form-select-solid"
                                        data-control="select2" data-placeholder="Select..." data-allow-clear="true" 
                                        data-hide-search="true">
                                        <?php foreach ($programs as $item): ?>
                                            <option></option>
                                            <option value="<?= $item['ProgramID']; ?>" selected><?= $item['ProgramDesc']; ?></option>
                                        <?php endforeach; ?>
                                    </select>
                                    <!--end::Input-->
                                </div>
                                <!--end::Input group-->
                                <!--begin::Input group-->
                                <div class="fv-row mb-10">
                                    <!--begin::Label-->
                                    <label class="form-label required">Third Choice</label>
                                    <!--end::Label-->

                                    <!--begin::Input-->
                                    <select name="programs3" id="programs3" class="form-select form-select-lg form-select-solid"
                                        data-control="select2" data-placeholder="Select..." data-allow-clear="true" value="2"
                                        data-hide-search="true">
                                        <?php foreach ($programs as $item): ?>
                                            <option></option>
                                            <option value="<?= $item['ProgramID']; ?>" selected><?= $item['ProgramDesc']; ?></option>
                                        <?php endforeach; ?>
                                    </select>
                                    <!--end::Input-->
                                </div>
                                <!--end::Input group-->


                                <!--begin::Hint-->
                                <div class="form-text">
                                    Customers will see this shortened version of your statement descriptor
                                </div>
                                <!--end::Hint-->
                            </div>
                            <!--end::Input group-->


                        </div>
                        <!--end::Wrapper-->
                    </div>
                    <!--end::Step 2-->
                    <!--begin::Step 3-->
                    <div data-kt-stepper-element="content">
                        <!--begin::Wrapper-->
                        <div class="w-100">
                            <!--begin::Heading-->
                            <div class="pb-10 pb-lg-12">
                                <!--begin::Title-->
                                <h2 class="fw-bold text-dark">Personal Details</h2>
                                <!--end::Title-->

                                <!--begin::Notice-->
                                <div class="text-muted fw-semibold fs-6">
                                    If you need more info, please check out
                                    <a href="#" class="link-primary fw-bold">Help Page</a>.
                                </div>
                                <!--end::Notice-->
                            </div>
                            <!--end::Heading-->

                            <!--begin::Input group-->
                            <div class="fv-row mb-10">
                                <!--begin::Label-->
                                <label class="form-label required">Last Name</label>
                                <!--end::Label-->

                                <!--begin::Input-->
                                <input name="last_name" value="2" class="form-control form-control-lg form-control-solid"
                                    />
                                <!--end::Input-->
                            </div>
                            <!--end::Input group-->
                            <!--begin::Input group-->
                            <div class="fv-row mb-10">
                                <!--begin::Label-->
                                <label class="form-label required">First Name</label>
                                <!--end::Label-->

                                <!--begin::Input-->
                                <input name="first_name" value="2" class="form-control form-control-lg form-control-solid"
                                 />
                                <!--end::Input-->
                            </div>
                            <!--end::Input group-->
                            <!--begin::Input group-->
                            <div class="fv-row mb-10">
                                <!--begin::Label-->
                                <label class="form-label required">Middle Name</label>
                                <!--end::Label-->

                                <!--begin::Input-->
                                <input name="middle_name" value="2" class="form-control form-control-lg form-control-solid"
                                value="asd" />
                                <!--end::Input-->
                            </div>
                            <!--end::Input group-->
                            <!--begin::Input group-->
                            <div class="fv-row mb-10">
                                <!--begin::Label-->
                                <label class="form-label required">Sex</label>
                                <!--end::Label-->
                                <!--begin::Input-->
                                <input name="sex" id="sex" value="2" class="form-control form-control-lg form-control-solid"
                                  />
                                <!--end::Input-->
                            </div>
                            <!--end::Input group-->
                            <!--begin::Input group-->
                            <div class="fv-row mb-10">
                                <!--begin::Label-->
                                <label class="form-label required">Religion</label>
                                <!--end::Label-->

                                <!--begin::Input-->
                                <input name="religion" value="2" class="form-control form-control-lg form-control-solid"
                                value="asd" />
                                <!--end::Input-->
                            </div>
                            <!--end::Input group-->
                            <!--begin::Input group-->
                            <div class="fv-row mb-10">
                                <!--begin::Label-->
                                <label class="form-label required">Citizenship</label>
                                <!--end::Label-->

                                <!--begin::Input-->
                                <input name="citizenship" value="2" class="form-control form-control-lg form-control-solid"
                                value="asd"  />
                                <!--end::Input-->
                            </div>
                            <!--end::Input group-->
                            <!--begin::Input group-->
                            <div class="fv-row mb-10">
                                <!--begin::Label-->
                                <label class="form-label required">Date of Birth</label>
                                <!--end::Label-->

                                <!--begin::Input-->
                                <input type="date" value="2" name="dateofbirth" class="form-control form-control-lg form-control-solid"
                                value="asd"  />
                                <!--end::Input-->
                            </div>
                            <!--end::Input group-->
                            <!--begin::Input group-->
                            <div class="fv-row mb-10">
                                <!--begin::Label-->
                                <label class="form-label required">Place of Birth</label>
                                <!--end::Label-->

                                <!--begin::Input-->
                                <input name="placeofbirth" value="2" class="form-control form-control-lg form-control-solid"
                                value="asd"  />
                                <!--end::Input-->
                            </div>
                            <!--end::Input group-->


                        </div>
                        <!--end::Wrapper-->

                    </div>
                    <!--end::Step 3-->

                    <!--begin::Step 4-->
                    <div data-kt-stepper-element="content">
                        <!--begin::Wrapper-->
                        <div class="w-100">
                            <!--begin::Heading-->
                            <div class="pb-10 pb-lg-15">
                                <!--begin::Title-->
                                <h2 class="fw-bold text-dark">Contact Details</h2>
                                <!--end::Title-->

                                <!--begin::Notice-->
                                <div class="text-muted fw-semibold fs-6">
                                    If you need more info, please check out
                                    <a href="#" class="text-primary fw-bold">Help Page</a>.
                                </div>
                                <!--end::Notice-->
                            </div>
                            <!--end::Heading-->

                            <!--begin::Input group-->
                            <div class="d-flex flex-column mb-7 fv-row">
                                <!--begin::Label-->
                                <label class="d-flex align-items-center fs-6 fw-semibold form-label mb-2">
                                    <span class="required">City  / Municipality</span>


                                    <span class="ms-1" data-bs-toggle="tooltip" title="Specify a card holder's name">
                                        <i class="ki-outline ki-information-5 text-gray-500 fs-6"></i></span> </label>
                                <!--end::Label-->

                                <input type="text" value="2" class="form-control form-control-solid" placeholder=""
                                    name="city"/>
                            </div>
                            <!--end::Input group-->

                            <!--begin::Input group-->
                            <div class="row mb-10">
                                <!--begin::Col-->
                                <div class="col-md-8 fv-row">
                                    <!--begin::Label-->
                                    <label class="required fs-6 fw-semibold form-label mb-2">Barangay</label>
                                    <!--end::Label-->

                                    <!--begin::Row-->
                                    <div class="row fv-row">
                                        <!--begin::Col-->
                                        <div class="col-6">
                                            <input type="text" value="2" class="form-control form-control-solid" placeholder=""
                                                name="barangay"  />

                                        </div>
                                        <!--end::Col-->

                                        <!--begin::Col-->
                                        <div class="col-6">
                                            <input type="text" value="2"  class="form-control form-control-solid"
                                                placeholder="House No" name="houseno" />

                                        </div>
                                        <!--end::Col-->
                                    </div>
                                    <!--end::Row-->
                                    <!--begin::Row-->
                                    <div class="row fv-row">
                                        <!--begin::Col-->
                                        <label class="required fs-6 fw-semibold form-label mb-2">Telephone</label>
                                        <div class="col-6">

                                            <input type="text" value="2" class="form-control form-control-solid"
                                                placeholder="Telephone" name="telephone"  />

                                        </div>
                                        <!--end::Col-->

                                        <!--begin::Col-->
                                        <!-- <div class="col-6">
         
                <input type="text" class="form-control form-control-solid" placeholder="District Address" name="card_name" value="Max Doe"/>

            </div> -->
                                        <!--end::Col-->
                                    </div>
                                    <!--end::Row-->
                                </div>
                                <!--end::Col-->

                                <!--begin::Col-->
                                <div class="col-md-4 fv-row">
                                    <!--begin::Label-->
                                    <label class="d-flex align-items-center fs-6 fw-semibold form-label mb-2">
                                        <span class="required">Street</span>


                                        <span class="ms-1" data-bs-toggle="tooltip" title="Enter a card CVV code">
                                            <i class="ki-outline ki-information-5 text-gray-500 fs-6"></i></span>
                                    </label>
                                    <!--end::Label-->

                                    <!--begin::Input wrapper-->
                                    <div class="position-relative">
                                        <!--begin::Input-->
                                        <input type="text" value="2" class="form-control form-control-solid"  placeholder="Street" name="street" />
                                        <!--end::Input-->

                                        <!--begin::CVV icon-->
                                        <div class="position-absolute translate-middle-y top-50 end-0 me-3">
                                            <i class="ki-outline ki-credit-cart fs-2hx"></i>
                                        </div>
                                        <!--end::CVV icon-->
                                    </div>
                                    <!--end::Input wrapper-->
                                </div>
                                <!--end::Col-->
                            </div>
                            <!--end::Input group-->

                            <!--begin::Input group-->
                            <div class="d-flex flex-stack">
                                <!--begin::Label-->
                                <div class="me-5">
                                    <label class="fs-6 fw-semibold form-label">Current Address</label>
                                    <div class="fs-7 fw-semibold text-muted">Same as Permanent Address indicated for the
                                        applicant?</div>
                                    <div class="form-check form-check-custom form-check-solid">
                                        <input class="form-check-input" type="radio" value="" name="address"
                                            id="flexRadioDefault" value="2" />
                                        <label class="form-check-label" for="flexRadioDefault">
                                            Yes
                                        </label>
                                    </div>
                                    <div class="form-check form-check-custom form-check-solid">
                                        <input class="form-check-input" value="2" type="radio" value="" name="address"
                                            id="flexRadioDefault2" />
                                        <label class="form-check-label" for="flexRadioDefault">
                                            No
                                        </label>
                                    </div>
                                    <!--begin::Row-->
                                    <div class="row fv-row">
                                        <!--begin::Col-->
                                        <div class="col-12">

                                            <label class="fs-6 fw-semibold form-label">Mobile Phone</label>
                                            <input type="text" value="2" class="form-control form-control-solid" placeholder=""
                                                name="mobile"  />

                                        </div>
                                        <!--end::Col-->


                                    </div>
                                    <!--end::Row-->
                                    <!--begin::Row-->
                                    <div class="row fv-row">
                                        <!--begin::Col-->
                                        <div class="col-12">

                                            <label class="fs-6 fw-semibold form-label">E-Mail Address</label>
                                            <input type="text" value="vincent@gmail.com" class="form-control form-control-solid" placeholder=""
                                                name="e_mail"  />

                                        </div>
                                        <!--end::Col-->


                                    </div>
                                    <!--end::Row-->
                                </div>
                                <!--end::Label-->

                                <!--begin::Switch-->
                                <!-- <label class="form-check form-switch form-check-custom form-check-solid">
        <input class="form-check-input" type="checkbox" value="1" checked="checked"/>
        <span class="form-check-label fw-semibold text-muted">
            Save Card
        </span>
    </label> -->
                                <!--end::Switch-->
                            </div>
                            <!--end::Input group-->

                        </div>
                        <!--end::Wrapper-->
                    </div>
                    <!--end::Step 4-->

                    <!--begin::Step 5-->
                    <div data-kt-stepper-element="content">
                        <!--begin::Wrapper-->
                        <div class="w-100">
                            <!--begin::Heading-->
                            <div class="pb-10 pb-lg-15">
                                <!--begin::Title-->
                                <h2 class="fw-bold text-dark">Parents/Guardian Details</h2>
                                <!--end::Title-->

                                <!--begin::Notice-->
                                <div class="text-muted fw-semibold fs-6">
                                    If you need more info, please check out
                                    <a href="#" class="text-primary fw-bold">Help Page</a>.
                                </div>
                                <!--end::Notice-->
                            </div>
                            <!--end::Heading-->


                            <!--begin::Input group-->
                            <div class="row mb-10">
                                <!--begin::Col-->
                                <div class="col-md-8 fv-row">
                                    <!--begin::Label-->
                                    <label class="required fs-6 fw-semibold form-label mb-2">Name of Mother</label>
                                    <!--end::Label-->

                                    <!--begin::Row-->
                                    <div class="row fv-row">
                                        <!--begin::Col-->
                                        <div class="col-6">
                                           
                                            <input type="text" value="2" class="form-control form-control-solid" placeholder="First Name"
                                                name="mother_firstname"  />

                                        </div>
                                        <!--end::Col-->

                                        <!--begin::Col-->
                                        <div class="col-6">
                                            <input type="text" value="2" class="form-control form-control-solid"
                                                placeholder="Middle Name" name="mother_middlename" />

                                        </div>
                                        <!--end::Col-->
                                    </div>
                                    <!--end::Row-->
                                    <!--begin::Row-->
                                    <div class="row fv-row">
                                        <!--begin::Col-->
                                        <label class="required fs-6 fw-semibold form-label mb-2">Telephone</label>
                                        <div class="col-6">

                                            <input type="text" value="2" class="form-control form-control-solid"
                                                placeholder="Telephone" name="c_telephone"  />

                                        </div>
                                        <!--end::Col-->
                                    </div>
                                    <!--end::Row-->
                                </div>
                                <!--end::Col-->

                                <!--begin::Col-->
                                <div class="col-md-4 fv-row">
                                    <!--begin::Label-->
                                    <label class="d-flex align-items-center fs-6 fw-semibold form-label mb-2">
                                        <!-- <span class="required">Lastname</span> -->


                                        <!-- <span class="ms-1" data-bs-toggle="tooltip" title="Enter a card CVV code">
                                            <i class="ki-outline ki-information-5 text-gray-500 fs-6"></i></span> -->
                                    </label>
                                    <!--end::Label-->

                                    <!--begin::Input wrapper-->
                                    <div class="position-relative">
                                        <!--begin::Input-->
                                        <input type="text" value="2" class="form-control form-control-solid"  placeholder="Last Name"  name="mother_lastname" />
                                        <!--end::Input-->

                                        <!--begin::CVV icon-->
                                        <div class="position-absolute translate-middle-y top-50 end-0 me-3">
                                            <i class="ki-outline ki-credit-cart fs-2hx"></i>
                                        </div>
                                        <!--end::CVV icon-->
                                    </div>
                                    <!--end::Input wrapper-->
                                </div>
                                <!--end::Col-->
                            </div>
                            <!--end::Input group-->

                             <!--begin::Input group-->
                             <div class="row mb-10">
                                <!--begin::Col-->
                                <div class="col-md-8 fv-row">
                                    <!--begin::Label-->
                                    <label class="required fs-6 fw-semibold form-label mb-2">Name of Father</label>
                                    <!--end::Label-->

                                    <!--begin::Row-->
                                    <div class="row fv-row">
                                        <!--begin::Col-->
                                        <div class="col-6">
                                           
                                            <input type="text" value="2" class="form-control form-control-solid" placeholder="First Name"
                                                name="father_fistname"  />

                                        </div>
                                        <!--end::Col-->

                                        <!--begin::Col-->
                                        <div class="col-6">
                                            <input type="text" value="2" class="form-control form-control-solid"
                                                placeholder="Middle Name" name="father_middlename"  />

                                        </div>
                                        <!--end::Col-->
                                    </div>
                                    <!--end::Row-->
                                    <!--begin::Row-->
                                    <div class="row fv-row">
                                        <!--begin::Col-->
                                        <label class="required fs-6 fw-semibold form-label mb-2">Telephone</label>
                                        <div class="col-6">

                                            <input type="text" value="2" class="form-control form-control-solid"
                                                placeholder="Telephone" name="father_telephone" />

                                        </div>
                                        <!--end::Col-->
                                    </div>
                                    <!--end::Row-->
                                </div>
                                <!--end::Col-->

                                <!--begin::Col-->
                                <div class="col-md-4 fv-row">
                                    <!--begin::Label-->
                                    <label class="d-flex align-items-center fs-6 fw-semibold form-label mb-2">
                                        <!-- <span class="required">Lastname</span> -->


                                        <span class="ms-1" data-bs-toggle="tooltip" title="Enter a card CVV code">
                                            <i class="ki-outline ki-information-5 text-gray-500 fs-6"></i></span>
                                    </label>
                                    <!--end::Label-->

                                    <!--begin::Input wrapper-->
                                    <div class="position-relative">
                                        <!--begin::Input-->
                                        <input type="text" value="2" class="form-control form-control-solid" placeholder="Last Name"  name="father_lastname" />
                                        <!--end::Input-->

                                        <!--begin::CVV icon-->
                                        <div class="position-absolute translate-middle-y top-50 end-0 me-3">
                                            <i class="ki-outline ki-credit-cart fs-2hx"></i>
                                        </div>
                                        <!--end::CVV icon-->
                                    </div>
                                    <!--end::Input wrapper-->
                                </div>
                                <!--end::Col-->
                            </div>
                            <!--end::Input group-->

                            <!--begin::Input group-->
                            <div class="d-flex flex-stack">
                                <!--begin::Label-->
                                <div class="me-5">
                                    <label class="fs-6 fw-semibold form-label">Current Address</label>
                                    <div class="fs-7 fw-semibold text-muted">Same as Permanent Address indicated for the
                                        applicant?</div>
                                    <div class="form-check form-check-custom form-check-solid">
                                        <input class="form-check-input" type="radio" value="" name="address"
                                            id="flexRadioDefault" />
                                        <label class="form-check-label" for="flexRadioDefault">
                                            Yes
                                        </label>
                                    </div>
                                    <div class="form-check form-check-custom form-check-solid">
                                        <input class="form-check-input" type="radio" value="" name="address"
                                            id="flexRadioDefault2" />
                                        <label class="form-check-label" for="flexRadioDefault">
                                            No
                                        </label>
                                    </div>
                                    <!--begin::Row-->
                                    <div class="row fv-row">
                                        <!--begin::Col-->
                                        <div class="col-12">

                                            <label class="fs-6 fw-semibold form-label">Monthly Family Income</label>
                                            <input type="text" value="2" class="form-control form-control-solid" placeholder=""
                                                name="monthly_income"/>

                                        </div>
                                        <!--end::Col-->


                                    </div>
                                    <!--end::Row-->
                              
                                </div>
                                <!--end::Label-->

                                <!--begin::Switch-->
                                <!-- <label class="form-check form-switch form-check-custom form-check-solid">
                                <input class="form-check-input" type="checkbox" value="1" checked="checked"/>
                                <span class="form-check-label fw-semibold text-muted">
                                    Save Card
                                </span>
                            </label> -->
                                <!--end::Switch-->
                            </div>
                            <!--end::Input group-->

                        </div>
                        <!--end::Wrapper-->
                    </div>
                    <!--end::Step 5-->
                     <!--begin::Step 6-->
                     <div data-kt-stepper-element="content">
                        <!--begin::Wrapper-->
                        <div class="w-100">
                            <!--begin::Heading-->
                            <div class="pb-10 pb-lg-15">
                                <!--begin::Title-->
                                <h2 class="fw-bold text-dark">School Details</h2>
                                <!--end::Title-->

                                <!--begin::Notice-->
                                <div class="text-muted fw-semibold fs-6">
                                    If you need more info, please check out
                                    <a href="#" class="text-primary fw-bold">Help Page</a>.
                                </div>
                                <!--end::Notice-->
                            </div>
                            <!--end::Heading-->

                            <!--begin::Input group-->
                            <div class="fv-row mb-10">
                                <!--begin::Label-->
                                <label class="form-label required">Last School Attended</label>
                                <!--end::Label-->

                                <!--begin::Input-->
                                <input name="last_school_attended" value="2" class="form-control form-control-lg form-control-solid"
                                     />
                                <!--end::Input-->
                                
                            </div>
                            <!--end::Input group-->
 
 
                             <div class="fv-row mb-10">
                                <!--begin::Label-->
                                <label class="form-label required">Address</label>
                                <!--end::Label-->

                                <!--begin::Input-->
                                <input name="school_address" value="2" class="form-control form-control-lg form-control-solid"
                                     />
                                <!--end::Input-->
                            </div>
                                <!--end::Col-->
                                
                             <div class="fv-row mb-10">
                                <!--begin::Label-->
                                <label class="form-label required">Honor/Awards Received</label>
                                <!--end::Label-->

                                <!--begin::Input-->
                                <input name="honor_award" value="2" class="form-control form-control-lg form-control-solid"
                                     />
                                <!--end::Input-->
                            </div>
                                <!--end::Col-->
  
                            <!--end::Input group-->

                            

                        </div>
                        <!--end::Wrapper-->
                    </div>
                    <!--end::Step 6-->
                      <!--begin::Step 7-->
                      <div data-kt-stepper-element="content">
                        <!--begin::Wrapper-->
                        <div class="w-100">
                            <!--begin::Heading-->
                            <div class="pb-10 pb-lg-15">
                                <!--begin::Title-->
                                <h2 class="fw-bold text-dark">Academic Details</h2>
                                <!--end::Title-->

                                <!--begin::Notice-->
                                <div class="text-muted fw-semibold fs-6">
                                    If you need more info, please check out
                                    <a href="#" class="text-primary fw-bold">Help Page</a>.
                                </div>
                                <!--end::Notice-->
                            </div>
                            <!--end::Heading-->


                           <!--begin::Input group-->
                           <div class="d-flex flex-stack">
                                <!--begin::Label-->
                                <div class="me-5">
                                    <label class="fs-6 fw-semibold form-label">Transcript of Records</label>
                                    <div class="fs-12 fw-semibold text-muted">Transcript of Records (TOR) with GWA</div>
                                    
                                    <!--begin::Row-->
                                    <div class="row fv-row">
                                        <!--begin::Col-->
                                        <div class="col-12">

                                            <!-- <label class="fs-6 fw-semibold form-label">Transcript of Record</label> -->
                                            <input type="text" value="2" class="form-control form-control-solid" placeholder=""
                                                name="transcript_of_records" />

                                        </div>
                                        <!--end::Col-->
                                    </div>
                                    <!--end::Row-->
                              
                                </div>
                                <!--end::Label-->

                            </div>
                            <!--end::Input group-->

                             

                        </div>
                        <!--end::Wrapper-->
                    </div>
                    <!--end::Step 7-->
                     <!--begin::Step 8 survey-->
                     <div data-kt-stepper-element="content">
                        <!--begin::Wrapper-->
                        <div class="w-100">
                            <!--begin::Heading-->
                            <div class="pb-10 pb-lg-15">
                                <!--begin::Title-->
                                <h2 class="fw-bold text-dark">Survey</h2>
                                <!--end::Title-->

                                <!--begin::Notice-->
                                <div class="text-muted fw-semibold fs-6">
                                    If you need more info, please check out
                                    <a href="#" class="text-primary fw-bold">Help Page</a>.
                                </div>
                                <!--end::Notice-->
                            </div>
                            <!--end::Heading-->


                            <!--begin::Input group-->
                            <div class="row mb-10">
                                <!--begin::Col-->
                                <div class="col-md-8 fv-row">
                                    <!--begin::Label-->
                                    <label class="required fs-6 fw-semibold form-label mb-2">What College or University is your first choice?</label>
                                    <!--end::Label-->

                                    <!--begin::Row-->
                                    <div class="row fv-row">
                                        <!--begin::Col-->
                                        <div class="col-6">
                                           
                                            <input type="text" class="form-control form-control-solid" placeholder="First Choice"
                                                name="first_choice" />

                                        </div>
                                        <!--end::Col-->

                                        <!--begin::Col-->
                                        <div class="col-6">
                                            <input type="text" class="form-control form-control-solid"
                                                placeholder="Second Choice" name="second_choice" />

                                        </div>
                                        <!--end::Col-->
                                    </div>
                                    <!--end::Row-->
                                </div>
                                <!--end::Col-->

                                <!--begin::Col-->
                                <div class="col-md-4 fv-row">
                                    <!--begin::Label-->
                                    <label class="d-flex align-items-center fs-6 fw-semibold form-label mb-2">
                                        <!-- <span class="required">Lastname</span> -->


                                        <span class="ms-1" data-bs-toggle="tooltip" title="Enter a card CVV code">
                                            <i class="ki-outline ki-information-5 text-gray-500 fs-6"></i></span>
                                    </label>
                                    <!--end::Label-->

                                    <!--begin::Input wrapper-->
                                    <div class="position-relative">
                                        <!--begin::Input-->
                                        <input type="text" class="form-control form-control-solid" placeholder="Third Choice"  name="third_choice" />
                                        <!--end::Input-->

                                        <!--begin::CVV icon-->
                                        <div class="position-absolute translate-middle-y top-50 end-0 me-3">
                                            <i class="ki-outline ki-credit-cart fs-2hx"></i>
                                        </div>
                                        <!--end::CVV icon-->
                                    </div>
                                    <!--end::Input wrapper-->
                                </div>
                                <!--end::Col-->
                            </div>
                            <!--end::Input group-->
                            <div class="fv-row mb-10">
                                <!--begin::Label-->
                                <label class="form-label required">In case you do not qualified for admission, where do you plan to pursue college?</label>
                                <!--end::Label-->

                                <!--begin::Input-->
                                <input name="question2" class="form-control form-control-lg form-control-solid"
                                     />
                                <!--end::Input-->
                            </div>
                             <!--begin::Input group-->
                             <div class="row mb-10">
                                <!--begin::Col-->
                                <div class="col-md-8 fv-row">
                                    <!--begin::Label-->
                                    <label class="required fs-6 fw-semibold form-label mb-2">Course applied in CSPC:</label>
                                    <!--end::Label-->

                                    <!--begin::Row-->
                                    <div class="row fv-row">
                                        <!--begin::Col-->
                                        <div class="col-6">
                                           
                                            <input type="text" class="form-control form-control-solid" placeholder="1st Priority"
                                                name="first_priority" />

                                        </div>
                                        <!--end::Col-->

                                        <!--begin::Col-->
                                        <div class="col-6">
                                            <input type="text" class="form-control form-control-solid"
                                                placeholder="2nd Priority" name="second_priority" />

                                        </div>
                                        <!--end::Col-->
                                    </div>
                                    <!--end::Row-->
                                </div>
                                <!--end::Col-->

                                <!--begin::Col-->
                                <div class="col-md-4 fv-row">
                                    <!--begin::Label-->
                                    <label class="d-flex align-items-center fs-6 fw-semibold form-label mb-2">
                                        <!-- <span class="required">Lastname</span> -->


                                        <span class="ms-1" data-bs-toggle="tooltip" title="Enter a card CVV code">
                                            <i class="ki-outline ki-information-5 text-gray-500 fs-6"></i></span>
                                    </label>
                                    <!--end::Label-->

                                    <!--begin::Input wrapper-->
                                    <div class="position-relative">
                                        <!--begin::Input-->
                                        <input type="text" class="form-control form-control-solid" placeholder="3rd Priority"  name="third_priority" />
                                        <!--end::Input-->

                                        <!--begin::CVV icon-->
                                        <div class="position-absolute translate-middle-y top-50 end-0 me-3">
                                            <i class="ki-outline ki-credit-cart fs-2hx"></i>
                                        </div>
                                        <!--end::CVV icon-->
                                    </div>
                                    <!--end::Input wrapper-->
                                </div>
                                <!--end::Col-->
                            </div>
                            <!--end::Input group-->
                            <div class="fv-row mb-10">
                                <!--begin::Label-->
                                <label class="form-label required">Reasons why you want to study in CSPC?</label>
                                <!--end::Label-->

                                <!--begin::Input-->
                                <input name="reasons" class="form-control form-control-lg form-control-solid"
                                     />
                                <!--end::Input-->
                            </div>
                            <div class="fv-row mb-10">
                                <!--begin::Label-->
                                <label class="form-label required">Do you have any other financial assistance?</label>
                                <!--end::Label-->

                                <!--begin::Input-->
                                <input name="financial_assistance" class="form-control form-control-lg form-control-solid"
                                     />
                                <!--end::Input-->
                            </div>
                            <div class="fv-row mb-10">
                                <!--begin::Label-->
                                <label class="form-label required">Do you belong to a household that is or was beneficiary of 4Ps?</label>
                                <!--end::Label-->

                                <!--begin::Input-->
                                <input name="question2" class="form-control form-control-lg form-control-solid"
                                     />
                                <!--end::Input-->
                            </div>
                             

                        </div>
                        <!--end::Wrapper-->
                    </div>
                    <!--end::Step 8-->
                      <!--begin::Step 9 application fee-->
                      <div data-kt-stepper-element="content">
                        <!--begin::Wrapper-->
                        <div class="w-100">
                            <!--begin::Heading-->
                            <div class="pb-10 pb-lg-15">
                                <!--begin::Title-->
                                <h2 class="fw-bold text-dark">Application Fee</h2>
                                <!--end::Title-->

                                <!--begin::Notice-->
                                <div class="text-muted fw-semibold fs-6">
                                    If you need more info, please check out
                                    <a href="#" class="text-primary fw-bold">Help Page</a>.
                                </div>
                                <!--end::Notice-->
                            </div>
                            <!--end::Heading-->


                            <!--begin::Input group-->
                            <div class="row mb-10">
                                 <!--begin::Invoice 2 content-->
                                <div class="mt-n1">                                    
                                    <!--begin::Top-->
                                    <div class="d-flex flex-stack pb-10">
                                        <!--begin::Logo-->
                                        <a href="#">
                                            <img alt="Logo"  src="/metronic8/demo6/assets/media/svg/brand-logos/code-lab.svg"/>
                                        </a>
                                        <!--end::Logo-->
                                                            
                                        <!--begin::Action-->            
                                        <a href="#" class="btn btn-sm btn-success">Pay Now</a>                 
                                        <!--end::Action--> 
                                    </div>                
                                    <!--end::Top-->                

                                    <!--begin::Wrapper-->
                                    <div class="m-0"> 
                                        <!--begin::Label-->
                                        <div class="fw-bold fs-3 text-gray-800 mb-8">Invoice #34782</div>                
                                        <!--end::Label-->  

                                        <!--begin::Row-->
                                        <div class="row g-5 mb-11">
                                            <!--end::Col-->
                                            <div class="col-sm-6">
                                                <!--end::Label-->
                                                <div class="fw-semibold fs-7 text-gray-600 mb-1">Issue Date:</div>                
                                                <!--end::Label-->  

                                                <!--end::Col-->
                                                <div class="fw-bold fs-6 text-gray-800">12 Apr 2021</div>                
                                                <!--end::Col-->  
                                            </div>                
                                            <!--end::Col-->  

                                            <!--end::Col-->
                                            <div class="col-sm-6">
                                                <!--end::Label-->
                                                <div class="fw-semibold fs-7 text-gray-600 mb-1">Due Date:</div>                
                                                <!--end::Label-->  

                                                <!--end::Info-->
                                                <div class="fw-bold fs-6 text-gray-800 d-flex align-items-center flex-wrap">
                                                    <span class="pe-2">02 May 2021</span> 
                                                    
                                                    <span class="fs-7 text-danger d-flex align-items-center">
                                                        <span class="bullet bullet-dot bg-danger me-2"></span> 
                                                        
                                                        Due in 7 days
                                                    </span>
                                                </div>                
                                                <!--end::Info-->  
                                            </div>                
                                            <!--end::Col-->  
                                        </div>                
                                        <!--end::Row-->   

                                        <!--begin::Row-->
                                        <div class="row g-5 mb-12">
                                            <!--end::Col-->
                                            <div class="col-sm-6">
                                                <!--end::Label-->
                                                <div class="fw-semibold fs-7 text-gray-600 mb-1">Issue For:</div>                
                                                <!--end::Label-->  

                                                <!--end::Text-->
                                                <div class="fw-bold fs-6 text-gray-800">KeenThemes Inc.</div>                
                                                <!--end::Text-->  

                                                <!--end::Description-->
                                                <div class="fw-semibold fs-7 text-gray-600">
                                                    8692 Wild Rose Drive <br/>
                                                    Livonia, MI 48150
                                                </div>                
                                                <!--end::Description-->  
                                            </div>                
                                            <!--end::Col-->  

                                            <!--end::Col-->
                                            <div class="col-sm-6">
                                                <!--end::Label-->
                                                <div class="fw-semibold fs-7 text-gray-600 mb-1">Issued By:</div>                
                                                <!--end::Label-->  

                                                <!--end::Text-->
                                                <div class="fw-bold fs-6 text-gray-800">CodeLab Inc.</div>                
                                                <!--end::Text-->  

                                                <!--end::Description-->
                                                <div class="fw-semibold fs-7 text-gray-600">                      
                                                    9858 South 53rd Ave.<br/>
                                                    Matthews, NC 28104                         
                                                </div>                
                                                <!--end::Description-->   
                                            </div>                
                                            <!--end::Col-->  
                                        </div>                
                                        <!--end::Row-->   


                                        <!--begin::Content-->
                                        <div class="flex-grow-1">
                                            <!--begin::Table-->
                                            <div class="table-responsive border-bottom mb-9">
                                                <table class="table mb-3">
                                                    <thead>
                                                        <tr class="border-bottom fs-6 fw-bold text-muted">
                                                            <th class="min-w-175px pb-2">Description</th>
                                                            <th class="min-w-70px text-end pb-2">Hours</th>
                                                            <th class="min-w-80px text-end pb-2"></th>
                                                            <th class="min-w-100px text-end pb-2"></th>
                                                        </tr>
                                                    </thead>

                                                    <tbody>
                                                        <tr class="fw-bold text-gray-700 fs-5 text-end">
                                                            <td class="d-flex align-items-center pt-6">                                            
                                                                <i class="fa fa-genderless text-danger fs-2 me-2"></i>                                           

                                                                Applicant Type
                                                            </td>

                                                            <td class="pt-6">Transferee</td>
                                                            <!-- <td class="pt-6">$40.00</td> -->
                                                            <!-- <td class="pt-6 text-dark fw-bolder">$3200.00</td> -->
                                                        </tr>

                                                        <tr class="fw-bold text-gray-700 fs-5 text-end">
                                                            <td class="d-flex align-items-center">                                           
                                                                <i class="fa fa-genderless text-success fs-2 me-2"></i>                                        

                                                               Application Fee Amount
                                                            </td>
                                                                
                                                            <td>500</td>
                                                            <td></td>
                                                            <!-- <td class="fs-5 text-dark fw-bolder">$4800.00</td> -->
                                                        </tr>
                                                            
                                                        <tr class="fw-bold text-gray-700 fs-5 text-end">
                                                            <td class="d-flex align-items-center">                                           
                                                                <!-- <i class="fa fa-genderless text-primary fs-2 me-2"></i>                                           -->

                                                                Total
                                                            </td>

                                                            <td>P 500.00</td>
                                                            <td></td>
                                                            <!-- <td class="fs-5 text-dark fw-bolder">$12600.00</td> -->
                                                        </tr>
                                                        <tr class="fw-bold text-gray-700 fs-5 text-end">
                                                            <td class="d-flex align-items-center">                                           
                                                                <!-- <i class="fa fa-genderless text-primary fs-2 me-2"></i>                                           -->

                                                                Payment Method
                                                            </td>

                                                            <td></td>
                                                            <td></td>
                                                            <!-- <td class="fs-5 text-dark fw-bolder">$12600.00</td> -->
                                                        </tr>
                                                    </tbody>
                                                </table>
                                            </div>  
                                            <!--end::Table-->                     

                                            <!--begin::Container-->
                                            <div class="d-flex justify-content-end">
                                                <!--begin::Section-->
                                                <div class="mw-300px">
                                                    <!--begin::Item-->
                                                    <div class="d-flex flex-stack mb-3">
                                                        <!--begin::Accountname-->
                                                        <div class="fw-semibold pe-10 text-gray-600 fs-7">Payment Date:</div>
                                                        <!--end::Accountname-->

                                                        <!--begin::Label-->
                                                        <div class="text-end fw-bold fs-6 text-gray-800">$ 20,600.00</div> 
                                                        <!--end::Label-->
                                                    </div>
                                                    <!--end::Item-->

                                                    <!--begin::Item-->
                                                    <div class="d-flex flex-stack mb-3">
                                                        <!--begin::Accountname-->
                                                        <div class="fw-semibold pe-10 text-gray-600 fs-7">Payment Ref No.</div>
                                                        <!--end::Accountname-->

                                                        <!--begin::Label-->
                                                        <div class="text-end fw-bold fs-6 text-gray-800">N/A</div> 
                                                        <!--end::Label-->
                                                    </div>
                                                    <!--end::Item-->

                                                    <!--begin::Item-->
                                                    <div class="d-flex flex-stack mb-3">
                                                        <!--begin::Accountnumber-->
                                                        <div class="fw-semibold pe-10 text-gray-600 fs-7">Total Amount Paid</div>
                                                        <!--end::Accountnumber-->

                                                        <!--begin::Number-->
                                                        <div class="text-end fw-bold fs-6 text-gray-800">00</div> 
                                                        <!--end::Number-->
                                                    </div>
                                                    <!--end::Item-->

                                                    <!--begin::Item-->
                                                    <div class="d-flex flex-stack">
                                                        <!--begin::Code-->
                                                        <div class="fw-semibold pe-10 text-gray-600 fs-7">Payment Status</div>
                                                        <!--end::Code-->

                                                        <!--begin::Label-->
                                                        <div class="text-end fw-bold fs-6 text-gray-800">No Payment Received</div> 
                                                        <!--end::Label-->
                                                    </div>
                                                    <!--end::Item-->
                                                      <!--end::Col-->
                                                    <div class="col-sm-12">
                                                       <br>
                                                    <a href="#" class="btn btn-sm btn-success">Pay Now</a> 
                                                    </div>                
                                                    <!--end::Col-->  
                                                </div>   
                                                <!--end::Section-->                        
                                            </div>   
                                            <!--end::Container-->                 
                                        </div>
                                        <!--end::Content-->          
                                    </div>
                                    <!--end::Wrapper-->           
                                </div>     
                                <!--end::Invoice 2 content--> 
                            </div>
                            <!--end::Input group-->
 

                        </div>
                        <!--end::Wrapper-->
                    </div>
                    <!--end::Step 9-->
                     <!--begin::Step  Finish-->

                    <div data-kt-stepper-element="content">


                        <!--begin::Wrapper-->
                        <div class="w-100">
                            <!--begin::Heading-->
                            <div class="pb-8 pb-lg-10">
                                <!--begin::Title-->
                                <h2 class="fw-bold text-dark">Your Are Done!</h2>
                                <!--end::Title-->

                                <!--begin::Notice-->
                                <div class="text-muted fw-semibold fs-6">
                                    If you need more info, please
                                    <a href="#" class="link-primary fw-bold">
                                        Sign In
                                    </a>
                                    .
                                </div>
                                <!--end::Notice-->
                            </div>
                            <!--end::Heading-->

                            <!--begin::Body-->
                            <div class="mb-0">
                                <!--begin::Text-->
                                <div class="fs-6 text-gray-600 mb-5">
                                    Writing headlines for blog posts is as much an art as it is a science
                                    and probably warrants its own post, but for all advise is with what
                                    works for your great & amazing audience.
                                </div>
                                <!--end::Text-->

                                <!--begin::Alert-->

                                <!--begin::Notice-->
                                <div
                                    class="notice d-flex bg-light-warning rounded border-warning border border-dashed  p-6">
                                    <!--begin::Icon-->
                                    <i class="ki-outline ki-information fs-2tx text-warning me-4"></i>
                                    <!--end::Icon-->

                                    <!--begin::Wrapper-->
                                    <div class="d-flex flex-stack flex-grow-1 ">
                                        <!--begin::Content-->
                                        <div class=" fw-semibold">
                                            <h4 class="text-gray-900 fw-bold">We need your attention!</h4>

                                            <div class="fs-6 text-gray-700 ">To start using great tools, please, <a
                                                    href="/metronic8/demo6/../demo6/utilities/wizards/vertical.html"
                                                    class="fw-bold">Create Team Platform</a></div>
                                        </div>
                                        <!--end::Content-->

                                    </div>
                                    <!--end::Wrapper-->
                                </div>
                                <!--end::Notice-->
                                <!--end::Alert-->
                            </div>
                            <!--end::Body-->
                        </div>
                        <!--end::Wrapper-->

                    </div>
                    <!--end::Step 5-->

                    <!--begin::Actions-->
                    <div class="d-flex flex-stack pt-10">
                        <!--begin::Wrapper-->
                        <div class="mr-2">
                            <button type="button" class="btn btn-lg btn-light-primary me-3"
                                data-kt-stepper-action="previous">
                                <i class="ki-outline ki-arrow-left fs-4 me-1"></i> Back
                            </button>
                        </div>
                        <!--end::Wrapper-->

                        <!--begin::Wrapper-->
                        <div>
                            <button type="button" id="submit" class="btn btn-lg btn-primary me-3" data-kt-stepper-action="submit">
                                <span class="indicator-label">
                                    Submit
                                    <i class="ki-outline ki-arrow-right fs-3 ms-2 me-0"></i> </span>
                                <span class="indicator-progress">
                                    Please wait... <span
                                        class="spinner-border spinner-border-sm align-middle ms-2"></span>
                                </span>
                            </button>

                            <button type="button" class="btn btn-lg btn-primary" data-kt-stepper-action="next">
                                Continue
                                <i class="ki-outline ki-arrow-right fs-4 ms-1 me-0"></i> </button>
                        </div>
                        <!--end::Wrapper-->
                    </div>
                    <!--end::Actions-->
                </form>
                <!--end::Form-->
            </div>
            <!--end::Content-->
        </div>
        <!--end::Stepper-->
    </div>
    <!--end::Container-->
</div>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>


<script>
        $(document).ready(function() {
            $('#kt_create_account_form').submit(function(e) {
                e.preventDefault(); // Prevent the form from submitting
                console.log('test');
                // Get input values
                var name = $('#name').val();
                var email = $('#email').val();
                var message = $('#message').val();

                // Send Ajax request to the CodeIgniter controller
                // $.ajax({
                //     type: 'POST',
                //     url: 'MyController/processInput', // Replace with your controller and function name
                //     data: {
                //         name: name,
                //         email: email,
                //         message: message
                //     },
                //     dataType: 'json',
                //     success: function(response) {
                //         // Handle the response from the controller
                //         $('#output').html(response.message);
                //     }
                // });
            });
        });
    </script>



<?= $this->endSection(); ?>


<!--begin::Custom Javascript-->
<?= $this->section('customscripts'); ?>

<!-- <script src="<?= base_url("public"); ?>/<?= base_url("public"); ?>/assets/js/custom/utilities/modals/thescript.js"></script> -->

<?= $this->endSection(); ?>
<!--end::Custom Javascript-->