<?= $this->extend('layouts/main'); ?>

<?= $this->section('content'); ?>

<!--begin::Content-->
<div class="content d-flex flex-column flex-column-fluid" id="kt_content">
    <!--begin::Container-->
    <div id="kt_content_container" class=" container-xxl ">
        <!--begin::Stepper-->
        <div class="stepper stepper-pills stepper-column d-flex flex-column flex-xl-row flex-row-fluid gap-10"
            id="kt_create_account_stepper">
            <!--begin::Aside-->
            <div
                class="card d-flex justify-content-center justify-content-xl-start flex-row-auto w-100 w-xl-300px w-xxl-400px">
                <!--begin::Wrapper-->
                <div class="card-body px-6 px-lg-10 px-xxl-15 py-20">
                    <!--begin::Nav-->
                    <div class="stepper-nav">
                        <!--begin::Step 1-->
                        <div class="stepper-item current" data-kt-stepper-element="nav">
                            <!--begin::Wrapper-->
                            <div class="stepper-wrapper">
                                <!--begin::Icon-->
                                <div class="stepper-icon w-40px h-40px">
                                    <i class="ki-outline ki-check fs-2 stepper-check"></i>
                                    <span class="stepper-number">1</span>
                                </div>
                                <!--end::Icon-->

                                <!--begin::Label-->
                                <div class="stepper-label">
                                    <h3 class="stepper-title">
                                        Application Type
                                    </h3>

                                    <div class="stepper-desc fw-semibold">
                                        Setup Your Account Details
                                    </div>
                                </div>
                                <!--end::Label-->
                            </div>
                            <!--end::Wrapper-->

                            <!--begin::Line-->
                            <div class="stepper-line h-40px"></div>
                            <!--end::Line-->
                        </div>
                        <!--end::Step 1-->

                        <!--begin::Step 2-->
                        <div class="stepper-item" data-kt-stepper-element="nav">
                            <!--begin::Wrapper-->
                            <div class="stepper-wrapper">
                                <!--begin::Icon-->
                                <div class="stepper-icon w-40px h-40px">
                                    <i class="ki-outline ki-check fs-2 stepper-check"></i>
                                    <span class="stepper-number">2</span>
                                </div>
                                <!--end::Icon-->

                                <!--begin::Label-->
                                <div class="stepper-label">
                                    <h3 class="stepper-title">
                                        Application Setting
                                    </h3>
                                    <div class="stepper-desc fw-semibold">
                                        Setup Your Account Settings
                                    </div>
                                </div>
                                <!--end::Label-->
                            </div>
                            <!--end::Wrapper-->

                            <!--begin::Line-->
                            <div class="stepper-line h-40px"></div>
                            <!--end::Line-->
                        </div>
                        <!--end::Step 2-->

                        <!--begin::Step 3-->
                        <div class="stepper-item" data-kt-stepper-element="nav">
                            <!--begin::Wrapper-->
                            <div class="stepper-wrapper">
                                <!--begin::Icon-->
                                <div class="stepper-icon w-40px h-40px">
                                    <i class="ki-outline ki-check fs-2 stepper-check"></i>
                                    <span class="stepper-number">3</span>
                                </div>
                                <!--end::Icon-->

                                <!--begin::Label-->
                                <div class="stepper-label">
                                    <h3 class="stepper-title">
                                        Personal Info
                                    </h3>
                                    <div class="stepper-desc fw-semibold">
                                        Your Personal Info
                                    </div>
                                </div>
                                <!--end::Label-->
                            </div>
                            <!--end::Wrapper-->

                            <!--begin::Line-->
                            <div class="stepper-line h-40px"></div>
                            <!--end::Line-->
                        </div>
                        <!--end::Step 3-->

                        <!--begin::Step 4-->
                        <div class="stepper-item" data-kt-stepper-element="nav">
                            <!--begin::Wrapper-->
                            <div class="stepper-wrapper">
                                <!--begin::Icon-->
                                <div class="stepper-icon w-40px h-40px">
                                    <i class="ki-outline ki-check fs-2 stepper-check"></i>
                                    <span class="stepper-number">4</span>
                                </div>
                                <!--end::Icon-->

                                <!--begin::Label-->
                                <div class="stepper-label">
                                    <h3 class="stepper-title">
                                        Contact Details
                                    </h3>
                                    <div class="stepper-desc fw-semibold">
                                        Set Your Contact Details
                                    </div>
                                </div>
                                <!--end::Label-->
                            </div>
                            <!--end::Wrapper-->

                            <!--begin::Line-->
                            <div class="stepper-line h-40px"></div>
                            <!--end::Line-->
                        </div>
                        <!--end::Step 4-->
                        <!--begin::Step 5-->
                        <div class="stepper-item" data-kt-stepper-element="nav">
                            <!--begin::Wrapper-->
                            <div class="stepper-wrapper">
                                <!--begin::Icon-->
                                <div class="stepper-icon w-40px h-40px">
                                    <i class="ki-outline ki-check fs-2 stepper-check"></i>
                                    <span class="stepper-number">5</span>
                                </div>
                                <!--end::Icon-->

                                <!--begin::Label-->
                                <div class="stepper-label">
                                    <h3 class="stepper-title">
                                        Parents/Guardian Details
                                    </h3>
                                    <div class="stepper-desc fw-semibold">
                                        Set Your Parents/Guardian Details
                                    </div>
                                </div>
                                <!--end::Label-->
                            </div>
                            <!--end::Wrapper-->

                            <!--begin::Line-->
                            <div class="stepper-line h-40px"></div>
                            <!--end::Line-->
                        </div>
                        <!--end::Step 5-->
                        <!--begin::Step 6-->
                        <div class="stepper-item" data-kt-stepper-element="nav">
                            <!--begin::Wrapper-->
                            <div class="stepper-wrapper">
                                <!--begin::Icon-->
                                <div class="stepper-icon w-40px h-40px">
                                    <i class="ki-outline ki-check fs-2 stepper-check"></i>
                                    <span class="stepper-number">6</span>
                                </div>
                                <!--end::Icon-->

                                <!--begin::Label-->
                                <div class="stepper-label">
                                    <h3 class="stepper-title">
                                        School Details
                                    </h3>
                                    <div class="stepper-desc fw-semibold">
                                        Set Your School Details
                                    </div>
                                </div>
                                <!--end::Label-->
                            </div>
                            <!--end::Wrapper-->

                            <!--begin::Line-->
                            <div class="stepper-line h-40px"></div>
                            <!--end::Line-->
                        </div>
                        <!--end::Step 6-->
                        <!--begin::Step 7-->
                        <div class="stepper-item" data-kt-stepper-element="nav">
                            <!--begin::Wrapper-->
                            <div class="stepper-wrapper">
                                <!--begin::Icon-->
                                <div class="stepper-icon w-40px h-40px">
                                    <i class="ki-outline ki-check fs-2 stepper-check"></i>
                                    <span class="stepper-number">7</span>
                                </div>
                                <!--end::Icon-->

                                <!--begin::Label-->
                                <div class="stepper-label">
                                    <h3 class="stepper-title">
                                        Academic Details
                                    </h3>
                                    <div class="stepper-desc fw-semibold">
                                        Set Your Academic Details
                                    </div>
                                </div>
                                <!--end::Label-->
                            </div>
                            <!--end::Wrapper-->

                            <!--begin::Line-->
                            <div class="stepper-line h-40px"></div>
                            <!--end::Line-->
                        </div>
                        <!--end::Step 7-->

                        <!--begin::Step 8-->
                        <div class="stepper-item" data-kt-stepper-element="nav">
                            <!--begin::Wrapper-->
                            <div class="stepper-wrapper">
                                <!--begin::Icon-->
                                <div class="stepper-icon w-40px h-40px">
                                    <i class="ki-outline ki-check fs-2 stepper-check"></i>
                                    <span class="stepper-number">8</span>
                                </div>
                                <!--end::Icon-->

                                <!--begin::Label-->
                                <div class="stepper-label">
                                    <h3 class="stepper-title">
                                        Survey
                                    </h3>
                                    <div class="stepper-desc fw-semibold">
                                        Pang Survey
                                    </div>
                                </div>
                                <!--end::Label-->
                            </div>
                            <!--end::Wrapper-->

                            <!--begin::Line-->
                            <div class="stepper-line h-40px"></div>
                            <!--end::Line-->
                        </div>
                        <!--end::Step 8-->
                        <!--begin::Step 8-->
                        <div class="stepper-item" data-kt-stepper-element="nav">
                            <!--begin::Wrapper-->
                            <div class="stepper-wrapper">
                                <!--begin::Icon-->
                                <div class="stepper-icon w-40px h-40px">
                                    <i class="ki-outline ki-check fs-2 stepper-check"></i>
                                    <span class="stepper-number">9</span>
                                </div>
                                <!--end::Icon-->

                                <!--begin::Label-->
                                <div class="stepper-label">
                                    <h3 class="stepper-title">
                                        Application Fee
                                    </h3>
                                    <div class="stepper-desc fw-semibold">
                                        Payment Details
                                    </div>
                                </div>
                                <!--end::Label-->
                            </div>
                            <!--end::Wrapper-->

                            <!--begin::Line-->
                            <div class="stepper-line h-40px"></div>
                            <!--end::Line-->
                        </div>
                        <!--end::Step 8-->
                        <!--begin::Step 6-->
                        <div class="stepper-item mark-completed" data-kt-stepper-element="nav">
                            <!--begin::Wrapper-->
                            <div class="stepper-wrapper">
                                <!--begin::Icon-->
                                <div class="stepper-icon w-40px h-40px">
                                    <i class="ki-outline ki-check fs-2 stepper-check"></i>
                                    <span class="stepper-number">10</span>
                                </div>
                                <!--end::Icon-->

                                <!--begin::Label-->
                                <div class="stepper-label">
                                    <h3 class="stepper-title">
                                        Completed
                                    </h3>
                                    <div class="stepper-desc fw-semibold">
                                        Woah, we are here
                                    </div>
                                </div>
                                <!--end::Label-->
                            </div>
                            <!--end::Wrapper-->
                        </div>
                        <!--end::Step 6-->
                    </div>
                    <!--end::Nav-->
                </div>
                <!--end::Wrapper-->
            </div>
            <!--begin::Aside-->

            <!--begin::Content-->
            <div class="card d-flex flex-row-fluid flex-center">
                <!--begin::Form-->
                <form class="card-body py-20 w-100 mw-xl-700px px-9" novalidate="novalidate" id="kt_create_account_form"
                    method="POST" enctype="multipart/form-data">
                    <!--begin::Step 1-->
                    <div class="current" data-kt-stepper-element="content">
                        <div class="w-100">
                            <div class="pb-10 pb-lg-15">
                                <h2 class="fw-bold d-flex align-items-center text-dark">
                                    Choose Application Type
                                    <span class="ms-1" data-bs-toggle="tooltip"
                                        title="Billing is issued based on your selected account type">
                                        <i class="ki-outline ki-information-5 text-gray-500 fs-6"></i>
                                    </span>
                                </h2>
                            </div>

                            <div class="fv-row">
                                <div class="row">
                                    <?php foreach ($applicationTypes as $type): ?>
                                        <div class="col-lg-6">
                                            <input type="radio" class="btn-check account_type" name="account_type"
                                                value="<?= esc($type['AdmissionTypeID']) ?>"
                                                id="kt_create_account_form_<?= esc($type['AdmissionTypeID']) ?>" />
                                            <label
                                                class="btn btn-outline btn-outline-dashed btn-active-light-primary p-7 d-flex align-items-center mb-10"
                                                for="kt_create_account_form_<?= esc($type['AdmissionTypeID']) ?>">

                                                <span class="d-block fw-semibold text-start">
                                                    <span class="text-dark fw-bold d-block fs-4 mb-2">
                                                        <?= esc($type['AdmissionType']) ?>
                                                    </span>
                                                </span>
                                            </label>
                                        </div>
                                    <?php endforeach; ?>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!--end::Step 1-->

                    <!--begin::Step 2-->
                    <div data-kt-stepper-element="content">
                        <!--begin::Wrapper-->
                        <div class="w-100">
                            <!--begin::Heading-->
                            <div class="pb-10 pb-lg-15">
                                <!--begin::Title-->
                                <h2 class="fw-bold text-dark">Application Details</h2>
                                <!--end::Title-->

                                <!--begin::Notice-->
                                <div class="text-muted fw-semibold fs-6" style="display: inline;">
                                    Application as:
                                    <a href="#" class="link-primary fw-bold" style="display: inline;">
                                        <span id="result" style="display: inline;"></span>
                                    </a>
                                </div>
                                <div class="text-muted fw-semibold fs-6">
                                    Application Number:
                                    <a href="#" class="link-primary fw-bold">
                                        <?php echo $ApplicationNo; ?>
                                    </a>
                                </div>
                                <!--end::Notice-->
                                <!--begin::Notice-->
                                <div class="text-muted fw-semibold fs-6">
                                    Academic Year:
                                    <a href="#" class="link-primary fw-bold">
                                        <?php echo $AcademicTerm->Term . ' ' . $AcademicTerm->AdmissionYear; ?></a>
                                </div>
                                <!--end::Notice-->
                            </div>
                            <!--end::Heading-->

                            <!--begin::Input group-->
                            <div class="mb-10 fv-row">
                                <!--begin::Label-->
                                <label class="d-flex align-items-center form-label mb-3">
                                    Program Choices


                                    <span class="ms-1" data-bs-toggle="tooltip"
                                        title="Provide your team size to help us setup your billing">
                                        <i class="ki-outline ki-information-5 text-gray-500 fs-6"></i></span> </label>
                                <!--end::Label-->
                                <!--begin::Input group-->
                                <div class="fv-row mb-10">
                                    <!--begin::Label-->
                                    <label class="form-label required">First Choice</label>
                                    <!--end::Label-->

                                    <!--begin::Input-->
                                    <select name="programs" id="programs"
                                        class="form-select form-select-lg form-select-solid" data-control="select2"
                                        data-placeholder="Select an option" data-control="select2"
                                        data-placeholder="Select..." data-allow-clear="true" data-hide-search="false">
                                        <?php foreach ($programs as $item): ?>
                                            <option></option>
                                            <option value="<?= $item['ProgramID']; ?>"><?= $item['ProgramDesc']; ?></option>
                                        <?php endforeach; ?>

                                    </select>
                                    <!--end::Input-->
                                </div>
                                <!--end::Input group-->
                                <!--begin::Input group-->
                                <div class="fv-row mb-10">
                                    <!--begin::Label-->
                                    <label class="form-label required">Second Choice</label>
                                    <!--end::Label-->

                                    <!--begin::Input-->
                                    <select name="programs2" id="programs2"
                                        class="form-select form-select-lg form-select-solid" data-control="select2"
                                        data-placeholder="Select..." data-allow-clear="true" data-hide-search="false">
                                        <?php foreach ($programs as $item): ?>
                                            <option></option>
                                            <option value="<?= $item['ProgramID']; ?>"><?= $item['ProgramDesc']; ?></option>
                                        <?php endforeach; ?>
                                    </select>
                                    <!--end::Input-->
                                </div>
                                <!--end::Input group-->
                                <!--begin::Input group-->
                                <div class="fv-row mb-10">
                                    <!--begin::Label-->
                                    <label class="form-label required">Third Choice</label>
                                    <!--end::Label-->

                                    <!--begin::Input-->
                                    <select name="programs3" id="programs3"
                                        class="form-select form-select-lg form-select-solid" data-control="select2"
                                        data-placeholder="Select..." data-allow-clear="true" value="2"
                                        data-hide-search="false">
                                        <?php foreach ($programs as $item): ?>
                                            <option></option>
                                            <option value="<?= $item['ProgramID']; ?>"><?= $item['ProgramDesc']; ?></option>
                                        <?php endforeach; ?>
                                    </select>
                                    <!--end::Input-->
                                </div>
                                <!--end::Input group-->


                                <!--begin::Hint-->
                                <!-- <div class="form-text">
                                    Customers will see this shortened version of your statement descriptor
                                </div> -->
                                <!--end::Hint-->
                            </div>
                            <!--end::Input group-->


                        </div>
                        <!--end::Wrapper-->
                    </div>
                    <!--end::Step 2-->
                    <!--begin::Step 3-->
                    <div data-kt-stepper-element="content">
                        <!--begin::Wrapper-->
                        <div class="w-100">
                            <!--begin::Heading-->
                            <div class="pb-10 pb-lg-12">
                                <!--begin::Title-->
                                <h2 class="fw-bold text-dark">Personal Details</h2>
                                <!--end::Title-->

                                <!--begin::Notice-->
                                <!-- <div class="text-muted fw-semibold fs-6">
                                    If you need more info, please check out
                                    <a href="#" class="link-primary fw-bold">Help Page</a>.
                                </div> -->
                                <!--end::Notice-->
                            </div>
                            <!--end::Heading-->
                            <!--begin::Input group-->
                            <div class="mb-7">
                                <!--begin::Label-->
                                <label class="fs-6 fw-semibold mb-3">
                                    <span>Upload Image</span>

                                    <span class="ms-1" data-bs-toggle="tooltip"
                                        title="Allowed file types: png, jpg, jpeg.">
                                        <i class="ki-outline ki-information fs-7"></i> </span>
                                </label>
                                <!--end::Label-->

                                <!--begin::Image input wrapper-->
                                <div class="mt-1">

                                    <!--begin::Image placeholder-->
                                    <style>
                                        .image-input-placeholder {
                                            background-image: url('/metronic8/demo6/assets/media/svg/files/blank-image.svg');
                                        }

                                        [data-bs-theme="dark"] .image-input-placeholder {
                                            background-image: url('/metronic8/demo6/assets/media/svg/files/blank-image-dark.svg');
                                        }
                                    </style>
                                    <!--end::Image placeholder-->
                                    <!--begin::Image input-->
                                    <div class="image-input image-input-outline image-input-placeholder image-input-empty image-input-empty "
                                        data-kt-image-input="true">
                                        <!--begin::Preview existing avatar-->
                                        <div class="image-input-wrapper w-100px h-100px"
                                            style="background-image: url('')"></div>
                                        <!--end::Preview existing avatar-->

                                        <!--begin::Edit-->
                                        <label
                                            class="btn btn-icon btn-circle btn-active-color-primary w-25px h-25px bg-body shadow"
                                            data-kt-image-input-action="change" data-bs-toggle="tooltip"
                                            title="Change avatar">
                                            <i class="ki-outline ki-pencil fs-7"></i>
                                            <!--begin::Inputs-->
                                            <input type="file" name="avatar" id="avatar" accept=".png, .jpg, .jpeg" />
                                            <!-- <input type="hidden" name="avatar_remove" /> -->
                                            <!--end::Inputs-->
                                        </label>
                                        <!--end::Edit-->

                                        <!--begin::Cancel-->
                                        <span
                                            class="btn btn-icon btn-circle btn-active-color-primary w-25px h-25px bg-body shadow"
                                            data-kt-image-input-action="cancel" data-bs-toggle="tooltip"
                                            title="Cancel avatar">
                                            <i class="ki-outline ki-cross fs-2"></i> </span>
                                        <!--end::Cancel-->

                                        <!--begin::Remove-->
                                        <span
                                            class="btn btn-icon btn-circle btn-active-color-primary w-25px h-25px bg-body shadow"
                                            data-kt-image-input-action="remove" data-bs-toggle="tooltip"
                                            title="Remove avatar">
                                            <i class="ki-outline ki-cross fs-2"></i> </span>
                                        <!--end::Remove-->
                                    </div>
                                    <!--end::Image input-->
                                </div>
                                <!--end::Image input wrapper-->
                            </div>
                            <!--end::Input group-->
                            <!--begin::Input group-->
                            <div class="fv-row mb-10">
                                <!--begin::Label-->
                                <label class="form-label required">Last Name</label>
                                <!--end::Label-->

                                <!--begin::Input-->
                                <input name="last_name" class="form-control form-control-lg form-control-solid" />
                                <!--end::Input-->
                            </div>
                            <!--end::Input group-->
                            <!--begin::Input group-->
                            <div class="fv-row mb-10">
                                <!--begin::Label-->
                                <label class="form-label required">First Name</label>
                                <!--end::Label-->

                                <!--begin::Input-->
                                <input name="first_name" class="form-control form-control-lg form-control-solid" />
                                <!--end::Input-->
                            </div>
                            <!--end::Input group-->
                            <!--begin::Input group-->
                            <div class="fv-row mb-10">
                                <!--begin::Label-->
                                <label class="form-label required">Middle Name</label>
                                <!--end::Label-->

                                <!--begin::Input-->
                                <input name="middle_name" class="form-control form-control-lg form-control-solid" />
                                <!--end::Input-->
                            </div>
                            <!--end::Input group-->
                            <!--begin::Input group-->
                            <div class="fv-row mb-10">
                                <!--begin::Label-->
                                <label class="form-label required">Sex</label>
                                <!--end::Label-->
                                <!--begin::Input-->
                                <!-- <input name="sex" id="sex" value="2" class="form-control form-control-lg form-control-solid"
                                  /> -->
                                <!--begin::Input-->
                                <select name="sex" id="sex" class="form-select form-select-lg form-select-solid"
                                    data-control="select2" data-placeholder="Select..." data-allow-clear="true"
                                    data-hide-search="true">
                                    <option></option>
                                    <option value="1">Male</option>
                                    <option value="0">Female</option>


                                </select>
                                <!--end::Input-->
                                <!--end::Input-->
                            </div>
                            <!--end::Input group-->
                            <!--begin::Input group-->
                            <div class="fv-row mb-10">
                                <!--begin::Label-->
                                <label class="form-label required">Religion</label>
                                <!--end::Label-->

                                <!--begin::Input-->
                                <input name="religion" class="form-control form-control-lg form-control-solid" />
                                <!--end::Input-->
                            </div>
                            <!--end::Input group-->
                            <!--begin::Input group-->
                            <div class="fv-row mb-10">
                                <!--begin::Label-->
                                <label class="form-label required">Citizenship</label>
                                <!--end::Label-->

                                <!--begin::Input-->
                                <!-- <input name="citizenship" value="2" class="form-control form-control-lg form-control-solid"
                                value="asd"  /> -->
                                <!--begin::Input-->
                                <select name="citizenship" id="citizenship"
                                    class="form-select form-select-lg form-select-solid" data-control="select2"
                                    data-placeholder="Select..." data-allow-clear="true" data-hide-search="true">
                                    <?php foreach ($citizenship as $key): ?>
                                        <option></option>
                                        <option value="<?= $key['CitizenshipID']; ?>" selected><?= $key['Citizenship']; ?>
                                        </option>
                                    <?php endforeach; ?>

                                </select>
                                <!--end::Input-->

                                <!--end::Input-->
                            </div>
                            <!--end::Input group-->
                            <!--begin::Input group-->
                            <div class="fv-row mb-10">
                                <!--begin::Label-->
                                <label class="form-label required">Date of Birth</label>
                                <!--end::Label-->

                                <!--begin::Input-->
                                <!-- <input type="date" value="2" name="dateofbirth" class="form-control form-control-lg form-control-solid"
                                value="asd"  /> -->
                                <div class="input-group" id="kt_td_picker_simple" data-td-target-input="nearest"
                                    data-td-target-toggle="nearest">
                                    <input id="kt_td_picker_basic_input" name="dateofbirth" type="text"
                                        class="form-control" data-td-target="#kt_td_picker_basic" />
                                    <span class="input-group-text" data-td-target="#kt_td_picker_basic"
                                        data-td-toggle="datetimepicker">
                                        <i class="ki-duotone ki-calendar fs-2"><span class="path1"></span><span
                                                class="path2"></span></i>
                                    </span>
                                </div>
                                <!--end::Input-->
                            </div>
                            <!--end::Input group-->
                            <!--begin::Input group-->
                            <div class="fv-row mb-10">
                                <!--begin::Label-->
                                <label class="form-label required">Place of Birth</label>
                                <!--end::Label-->

                                <!--begin::Input-->
                                <input name="placeofbirth" class="form-control form-control-lg form-control-solid" />

                                <!--end::Input-->
                            </div>
                            <!--end::Input group-->


                        </div>
                        <!--end::Wrapper-->

                    </div>
                    <!--end::Step 3-->

                    <!--begin::Step 4-->
                    <div data-kt-stepper-element="content">
                        <!--begin::Wrapper-->
                        <div class="w-100">
                            <!--begin::Heading-->
                            <div class="pb-10 pb-lg-15">
                                <!--begin::Title-->
                                <h2 class="fw-bold text-dark">Contact Details</h2>
                                <!--end::Title-->

                                <!--begin::Notice-->
                                <div class="text-muted fw-semibold fs-6">
                                    If you need more info, please check out
                                    <a href="#" class="text-primary fw-bold">Help Page</a>.
                                </div>
                                <!--end::Notice-->
                            </div>
                            <!--end::Heading-->

                            <!--begin::Input group-->
                            <div class="d-flex flex-column mb-7 fv-row">
                                <!--begin::Label-->
                                <label class="d-flex align-items-center fs-6 fw-semibold form-label mb-2">
                                    <span class="required">Country</span>


                                    <span class="ms-1" data-bs-toggle="tooltip" title="Specify a card holder's name">
                                        <i class="ki-outline ki-information-5 text-gray-500 fs-6"></i></span> </label>
                                <!--end::Label-->

                                <input type="text" value="2" class="form-control form-control-solid" placeholder=""
                                    name="country" />
                            </div>
                            <!--end::Input group-->
                            <!--begin::Input group-->
                            <div class="d-flex flex-column mb-7 fv-row">
                                <!--begin::Label-->
                                <label class="d-flex align-items-center fs-6 fw-semibold form-label mb-2">
                                    <span class="required">Region</span>


                                    <span class="ms-1" data-bs-toggle="tooltip" title="Specify a card holder's name">
                                        <i class="ki-outline ki-information-5 text-gray-500 fs-6"></i></span> </label>
                                <!--end::Label-->

                                <input type="text" value="2" class="form-control form-control-solid" placeholder=""
                                    name="region" />
                            </div>
                            <!--end::Input group-->
                            <!--begin::Input group-->
                            <div class="d-flex flex-column mb-7 fv-row">
                                <!--begin::Label-->
                                <label class="d-flex align-items-center fs-6 fw-semibold form-label mb-2">
                                    <span class="required">Province</span>


                                    <span class="ms-1" data-bs-toggle="tooltip" title="Specify a card holder's name">
                                        <i class="ki-outline ki-information-5 text-gray-500 fs-6"></i></span> </label>
                                <!--end::Label-->

                                <input type="text" value="2" class="form-control form-control-solid" placeholder=""
                                    name="province" />
                            </div>
                            <!--end::Input group-->
                            <!--begin::Input group-->
                            <div class="d-flex flex-column mb-7 fv-row">
                                <!--begin::Label-->
                                <label class="d-flex align-items-center fs-6 fw-semibold form-label mb-2">
                                    <span class="required">City / Municipality</span>


                                    <span class="ms-1" data-bs-toggle="tooltip" title="Specify a card holder's name">
                                        <i class="ki-outline ki-information-5 text-gray-500 fs-6"></i></span> </label>
                                <!--end::Label-->

                                <input type="text" value="Iriga City" class="form-control form-control-solid"
                                    placeholder="" name="city" />
                            </div>
                            <!--end::Input group-->

                            <!--begin::Input group-->
                            <div class="row mb-10">
                                <!--begin::Col-->
                                <div class="col-md-8 fv-row">
                                    <!--begin::Label-->
                                    <label class="required fs-6 fw-semibold form-label mb-2">Barangay</label>
                                    <!--end::Label-->

                                    <!--begin::Row-->
                                    <div class="row fv-row">
                                        <!--begin::Col-->
                                        <div class="col-6">
                                            <input type="text" value="2" class="form-control form-control-solid"
                                                placeholder="" name="barangay" />

                                        </div>
                                        <!--end::Col-->

                                        <!--begin::Col-->
                                        <div class="col-6">

                                            <input type="text" value="2" class="form-control form-control-solid"
                                                placeholder="House No" name="houseno" />

                                        </div>
                                        <!--end::Col-->
                                    </div>
                                    <!--end::Row-->
                                    <!--begin::Row-->
                                    <!-- <div class="row fv-row"> -->
                                    <!--begin::Col-->
                                    <!-- <label class="required fs-6 fw-semibold form-label mb-2">Telephone</label>
                                        <div class="col-6">

                                            <input type="text" value="2" class="form-control form-control-solid"
                                                placeholder="Telephone" name="telephone"  />

                                        </div> -->
                                    <!--end::Col-->

                                    <!--begin::Col-->
                                    <!-- <div class="col-6">
         
                                            <input type="text" class="form-control form-control-solid" placeholder="District Address" name="card_name" value="Max Doe"/>

                                        </div> -->
                                    <!--end::Col-->
                                    <!-- </div> -->
                                    <!--end::Row-->
                                </div>
                                <!--end::Col-->

                                <!--begin::Col-->
                                <div class="col-md-4 fv-row">
                                    <!--begin::Label-->
                                    <label class="d-flex align-items-center fs-6 fw-semibold form-label mb-2">
                                        <span class="required">Street</span>


                                        <span class="ms-1" data-bs-toggle="tooltip" title="Enter a card CVV code">
                                            <i class="ki-outline ki-information-5 text-gray-500 fs-6"></i></span>
                                    </label>
                                    <!--end::Label-->

                                    <!--begin::Input wrapper-->
                                    <div class="position-relative">
                                        <!--begin::Input-->
                                        <input type="text" value="2" class="form-control form-control-solid"
                                            placeholder="Street" name="street" />
                                        <!--end::Input-->

                                        <!--begin::CVV icon-->
                                        <div class="position-absolute translate-middle-y top-50 end-0 me-3">
                                            <i class="ki-outline ki-credit-cart fs-2hx"></i>
                                        </div>
                                        <!--end::CVV icon-->
                                    </div>
                                    <!--end::Input wrapper-->
                                </div>
                                <!--end::Col-->
                            </div>
                            <!--end::Input group-->

                            <!--begin::Input group old code here-->
                            <div class="fv-row mb-5">
                                <!--begin::Label-->
                                <label class="form-label required">Current Address </label>
                                <!--end::Label-->
                                <div class="fs-7 fw-semibold text-muted">Same as Permanent Address indicated for the
                                    applicant?</div>
                                <!--begin::Input-->
                                <select name="options" id="options"
                                    class="form-select form-select-lg form-select-solid options" data-control="select2"
                                    data-placeholder="Select..." data-allow-clear="true"
                                    onchange="cbCurrAddSameChanged()" data-hide-search="true">
                                    <option></option>
                                    <option value="Yes" selected>Yes</option>
                                    <option value="No">Nooo</option>


                                </select>

                            </div>
                            <!--end::Input group-->

                            <div id="divCurrAdd" style="display: none;">
                                <!-- This is the div to show/hide. -->

                                <!--begin::Wrapper-->
                                <div class="w-100">
                                    <!--begin::Heading-->
                                    <div class="pb-10 pb-lg-15">
                                        <!--begin::Title-->
                                        <!-- <h2 class="fw-bold text-dark">ok</h2> -->
                                        <!--end::Title-->

                                        <!--begin::Notice-->
                                        <!-- <div class="text-muted fw-semibold fs-6">
                                    If you need more info, please check out
                                    <a href="#" class="text-primary fw-bold">Help Page</a>.
                                </div> -->
                                        <!--end::Notice-->
                                    </div>
                                    <!--end::Heading-->

                                    <!--begin::Input group-->
                                    <div class="d-flex flex-column mb-7 fv-row">
                                        <!--begin::Label-->
                                        <label class="d-flex align-items-center fs-6 fw-semibold form-label mb-2">
                                            <span class="required">Country</span>


                                            <span class="ms-1" data-bs-toggle="tooltip"
                                                title="Specify a card holder's name">
                                                <i class="ki-outline ki-information-5 text-gray-500 fs-6"></i></span>
                                        </label>
                                        <!--end::Label-->

                                        <input type="text" value="2" class="form-control form-control-solid"
                                            placeholder="" name="country2" />
                                    </div>
                                    <!--end::Input group-->
                                    <!--begin::Input group-->
                                    <div class="d-flex flex-column mb-7 fv-row">
                                        <!--begin::Label-->
                                        <label class="d-flex align-items-center fs-6 fw-semibold form-label mb-2">
                                            <span class="required">Region</span>


                                            <span class="ms-1" data-bs-toggle="tooltip"
                                                title="Specify a card holder's name">
                                                <i class="ki-outline ki-information-5 text-gray-500 fs-6"></i></span>
                                        </label>
                                        <!--end::Label-->

                                        <input type="text" value="2" class="form-control form-control-solid"
                                            placeholder="" name="region2" />
                                    </div>
                                    <!--end::Input group-->
                                    <!--begin::Input group-->
                                    <div class="d-flex flex-column mb-7 fv-row">
                                        <!--begin::Label-->
                                        <label class="d-flex align-items-center fs-6 fw-semibold form-label mb-2">
                                            <span class="required">Province</span>


                                            <span class="ms-1" data-bs-toggle="tooltip"
                                                title="Specify a card holder's name">
                                                <i class="ki-outline ki-information-5 text-gray-500 fs-6"></i></span>
                                        </label>
                                        <!--end::Label-->

                                        <input type="text" value="2" class="form-control form-control-solid"
                                            placeholder="" name="province2" />
                                    </div>
                                    <!--end::Input group-->
                                    <!--begin::Input group-->
                                    <div class="d-flex flex-column mb-7 fv-row">
                                        <!--begin::Label-->
                                        <label class="d-flex align-items-center fs-6 fw-semibold form-label mb-2">
                                            <span class="required">City / Municipality</span>


                                            <span class="ms-1" data-bs-toggle="tooltip"
                                                title="Specify a card holder's name">
                                                <i class="ki-outline ki-information-5 text-gray-500 fs-6"></i></span>
                                        </label>
                                        <!--end::Label-->

                                        <input type="text" value="2" class="form-control form-control-solid"
                                            placeholder="" name="city2" />
                                    </div>
                                    <!--end::Input group-->

                                    <!--begin::Input group-->
                                    <div class="row mb-10">
                                        <!--begin::Col-->
                                        <div class="col-md-8 fv-row">
                                            <!--begin::Label-->
                                            <label class="required fs-6 fw-semibold form-label mb-2">Barangay</label>
                                            <!--end::Label-->

                                            <!--begin::Row-->
                                            <div class="row fv-row">
                                                <!--begin::Col-->
                                                <div class="col-6">
                                                    <input type="text" value="2" class="form-control form-control-solid"
                                                        placeholder="" name="barangay2" />

                                                </div>
                                                <!--end::Col-->

                                                <!--begin::Col-->
                                                <div class="col-6">
                                                    <input type="text" value="2" class="form-control form-control-solid"
                                                        placeholder="House No" name="houseno2" />

                                                </div>
                                                <!--end::Col-->
                                            </div>
                                            <!--end::Row-->

                                        </div>
                                        <!--end::Col-->

                                        <!--begin::Col-->
                                        <div class="col-md-4 fv-row">
                                            <!--begin::Label-->
                                            <label class="d-flex align-items-center fs-6 fw-semibold form-label mb-2">
                                                <span class="required">Street</span>


                                                <span class="ms-1" data-bs-toggle="tooltip"
                                                    title="Enter a card CVV code">
                                                    <i
                                                        class="ki-outline ki-information-5 text-gray-500 fs-6"></i></span>
                                            </label>
                                            <!--end::Label-->

                                            <!--begin::Input wrapper-->
                                            <div class="position-relative">
                                                <!--begin::Input-->
                                                <input type="text" value="2" class="form-control form-control-solid"
                                                    placeholder="Street" name="street2" />
                                                <!--end::Input-->

                                                <!--begin::CVV icon-->
                                                <div class="position-absolute translate-middle-y top-50 end-0 me-3">
                                                    <i class="ki-outline ki-credit-cart fs-2hx"></i>
                                                </div>
                                                <!--end::CVV icon-->
                                            </div>
                                            <!--end::Input wrapper-->
                                        </div>
                                        <!--end::Col-->
                                    </div>
                                    <!--end::Input group-->

                                </div>
                                <!--end::Wrapper-->

                            </div>
                            <!--begin::Input group old code here-->
                            <div class="fv-row mb-5">
                                <!--begin::Label-->
                                <label class="form-label required">Telephone</label>
                                <!--end::Label-->
                                <input type="text" value="2" class="form-control form-control-solid"
                                    placeholder="telephone" name="telephone" />

                                <!--begin::Input-->

                                <!--end::Input-->
                            </div>
                            <!--end::Input group-->
                            <!--begin::Input group old code here-->
                            <div class="fv-row mb-5">
                                <!--begin::Label-->
                                <label class="form-label required">Email</label>
                                <!--end::Label-->
                                <input type="text" value="sample@gmail.com" class="form-control form-control-solid"
                                    placeholder="Email" name="street" />

                                <!--begin::Input-->

                                <!--end::Input-->
                            </div>
                            <!--end::Input group-->
                        </div>
                        <!--end::Wrapper-->
                    </div>
                    <!--end::Step 4-->
                    <!--begin::Step 4 show and hide div-->

                    <!--end::Step 4-->

                    <!--begin::Step 5-->
                    <div data-kt-stepper-element="content">
                        <!--begin::Wrapper-->
                        <div class="w-100">
                            <!--begin::Heading-->
                            <div class="pb-10 pb-lg-15">
                                <!--begin::Title-->
                                <h2 class="fw-bold text-dark">Parents/Guardian Details</h2>
                                <!--end::Title-->

                                <!--begin::Notice-->
                                <div class="text-muted fw-semibold fs-6">
                                    If you need more info, please check out
                                    <a href="#" class="text-primary fw-bold">Help Page</a>.
                                </div>
                                <!--end::Notice-->
                            </div>
                            <!--end::Heading-->


                            <!--begin::Input group-->
                            <div class="row mb-10">
                                <!--begin::Col-->
                                <div class="col-md-8 fv-row">
                                    <!--begin::Label-->
                                    <label class="required fs-6 fw-semibold form-label mb-2">Name of Mother</label>
                                    <!--end::Label-->

                                    <!--begin::Row-->
                                    <div class="row fv-row">
                                        <!--begin::Col-->
                                        <div class="col-6">

                                            <input type="text" class="form-control form-control-solid"
                                                placeholder="First Name" name="mother_firstname" />

                                        </div>
                                        <!--end::Col-->

                                        <!--begin::Col-->
                                        <div class="col-6">
                                            <input type="text" class="form-control form-control-solid"
                                                placeholder="Middle Name" name="mother_middlename" />

                                        </div>
                                        <!--end::Col-->
                                    </div>
                                    <!--end::Row-->
                                    <!--begin::Row-->
                                    <div class="row fv-row">
                                        <!--begin::Col-->
                                        <label class="required fs-6 fw-semibold form-label mb-2">Telephone</label>
                                        <div class="col-6">

                                            <input type="text" class="form-control form-control-solid"
                                                placeholder="Telephone" name="c_telephone" />

                                        </div>
                                        <!--end::Col-->
                                    </div>
                                    <!--end::Row-->
                                </div>
                                <!--end::Col-->

                                <!--begin::Col-->
                                <div class="col-md-4 fv-row">
                                    <!--begin::Label-->
                                    <label class="d-flex align-items-center fs-6 fw-semibold form-label mb-2">
                                        <!-- <span class="required">Lastname</span> -->


                                        <!-- <span class="ms-1" data-bs-toggle="tooltip" title="Enter a card CVV code">
                                            <i class="ki-outline ki-information-5 text-gray-500 fs-6"></i></span> -->
                                    </label>
                                    <!--end::Label-->

                                    <!--begin::Input wrapper-->
                                    <div class="position-relative">
                                        <!--begin::Input-->
                                        <input type="text" class="form-control form-control-solid"
                                            placeholder="Last Name" name="mother_lastname" />
                                        <!--end::Input-->

                                        <!--begin::CVV icon-->
                                        <div class="position-absolute translate-middle-y top-50 end-0 me-3">
                                            <i class="ki-outline ki-credit-cart fs-2hx"></i>
                                        </div>
                                        <!--end::CVV icon-->
                                    </div>
                                    <!--end::Input wrapper-->
                                </div>
                                <!--end::Col-->
                            </div>
                            <!--end::Input group-->

                            <!--begin::Input group-->
                            <div class="row mb-10">
                                <!--begin::Col-->
                                <div class="col-md-8 fv-row">
                                    <!--begin::Label-->
                                    <label class="required fs-6 fw-semibold form-label mb-2">Name of Father</label>
                                    <!--end::Label-->

                                    <!--begin::Row-->
                                    <div class="row fv-row">
                                        <!--begin::Col-->
                                        <div class="col-6">

                                            <input type="text" class="form-control form-control-solid"
                                                placeholder="First Name" name="father_fistname" />

                                        </div>
                                        <!--end::Col-->

                                        <!--begin::Col-->
                                        <div class="col-6">
                                            <input type="text" class="form-control form-control-solid"
                                                placeholder="Middle Name" name="father_middlename" />

                                        </div>
                                        <!--end::Col-->
                                    </div>
                                    <!--end::Row-->
                                    <!--begin::Row-->
                                    <div class="row fv-row">
                                        <!--begin::Col-->
                                        <label class="required fs-6 fw-semibold form-label mb-2">Telephone</label>
                                        <div class="col-6">

                                            <input type="text" class="form-control form-control-solid"
                                                placeholder="Telephone" name="father_telephone" />

                                        </div>
                                        <!--end::Col-->
                                    </div>
                                    <!--end::Row-->
                                </div>
                                <!--end::Col-->

                                <!--begin::Col-->
                                <div class="col-md-4 fv-row">
                                    <!--begin::Label-->
                                    <label class="d-flex align-items-center fs-6 fw-semibold form-label mb-2">
                                        <!-- <span class="required">Lastname</span> -->


                                        <span class="ms-1" data-bs-toggle="tooltip" title="Enter a card CVV code">
                                            <i class="ki-outline ki-information-5 text-gray-500 fs-6"></i></span>
                                    </label>
                                    <!--end::Label-->

                                    <!--begin::Input wrapper-->
                                    <div class="position-relative">
                                        <!--begin::Input-->
                                        <input type="text" class="form-control form-control-solid"
                                            placeholder="Last Name" name="father_lastname" />
                                        <!--end::Input-->

                                        <!--begin::CVV icon-->
                                        <div class="position-absolute translate-middle-y top-50 end-0 me-3">
                                            <i class="ki-outline ki-credit-cart fs-2hx"></i>
                                        </div>
                                        <!--end::CVV icon-->
                                    </div>
                                    <!--end::Input wrapper-->
                                </div>
                                <!--end::Col-->
                            </div>
                            <!--end::Input group-->

                            <!--begin::Input group old code here-->
                            <div class="fv-row mb-5">
                                <!--begin::Label-->
                                <label class="form-label required">Current Address </label>
                                <!--end::Label-->
                                <div class="fs-7 fw-semibold text-muted">Same as Permanent Address indicated for the
                                    applicant?</div>
                                <!--begin::Input-->
                                <select name="options2" id="options2"
                                    class="form-select form-select-lg form-select-solid options" data-control="select2"
                                    data-placeholder="Select..." data-allow-clear="true"
                                    onchange="cbCurrAddSameChanged2()" data-hide-search="true">
                                    <option></option>
                                    <option value="Yes" selected>Yes</option>
                                    <option value="No">Nooo</option>


                                </select>

                            </div>
                            <div id="divCurrAdd2" style="display: none;">
                                <!-- This is the div to show/hide. -->

                                <!--begin::Wrapper-->
                                <div class="w-100">
                                    <!--begin::Heading-->
                                    <div class="pb-10 pb-lg-15">
                                        <!--begin::Title-->
                                        <!-- <h2 class="fw-bold text-dark">ok</h2> -->
                                        <!--end::Title-->

                                        <!--begin::Notice-->
                                        <!-- <div class="text-muted fw-semibold fs-6">
                                    If you need more info, please check out
                                    <a href="#" class="text-primary fw-bold">Help Page</a>.
                                </div> -->
                                        <!--end::Notice-->
                                    </div>
                                    <!--end::Heading-->

                                    <!--begin::Input group-->
                                    <div class="d-flex flex-column mb-7 fv-row">
                                        <!--begin::Label-->
                                        <label class="d-flex align-items-center fs-6 fw-semibold form-label mb-2">
                                            <span class="required">Country</span>


                                            <span class="ms-1" data-bs-toggle="tooltip"
                                                title="Specify a card holder's name">
                                                <i class="ki-outline ki-information-5 text-gray-500 fs-6"></i></span>
                                        </label>
                                        <!--end::Label-->

                                        <input type="text" value="2" class="form-control form-control-solid"
                                            placeholder="" name="country" />
                                    </div>
                                    <!--end::Input group-->
                                    <!--begin::Input group-->
                                    <div class="d-flex flex-column mb-7 fv-row">
                                        <!--begin::Label-->
                                        <label class="d-flex align-items-center fs-6 fw-semibold form-label mb-2">
                                            <span class="required">Region</span>


                                            <span class="ms-1" data-bs-toggle="tooltip"
                                                title="Specify a card holder's name">
                                                <i class="ki-outline ki-information-5 text-gray-500 fs-6"></i></span>
                                        </label>
                                        <!--end::Label-->

                                        <input type="text" value="2" class="form-control form-control-solid"
                                            placeholder="" name="region" />
                                    </div>
                                    <!--end::Input group-->
                                    <!--begin::Input group-->
                                    <div class="d-flex flex-column mb-7 fv-row">
                                        <!--begin::Label-->
                                        <label class="d-flex align-items-center fs-6 fw-semibold form-label mb-2">
                                            <span class="required">Province</span>


                                            <span class="ms-1" data-bs-toggle="tooltip"
                                                title="Specify a card holder's name">
                                                <i class="ki-outline ki-information-5 text-gray-500 fs-6"></i></span>
                                        </label>
                                        <!--end::Label-->

                                        <input type="text" value="2" class="form-control form-control-solid"
                                            placeholder="" name="province" />
                                    </div>
                                    <!--end::Input group-->
                                    <!--begin::Input group-->
                                    <div class="d-flex flex-column mb-7 fv-row">
                                        <!--begin::Label-->
                                        <label class="d-flex align-items-center fs-6 fw-semibold form-label mb-2">
                                            <span class="required">City / Municipality</span>


                                            <span class="ms-1" data-bs-toggle="tooltip"
                                                title="Specify a card holder's name">
                                                <i class="ki-outline ki-information-5 text-gray-500 fs-6"></i></span>
                                        </label>
                                        <!--end::Label-->

                                        <input type="text" value="2" class="form-control form-control-solid"
                                            placeholder="" name="city" />
                                    </div>
                                    <!--end::Input group-->

                                    <!--begin::Input group-->
                                    <div class="row mb-10">
                                        <!--begin::Col-->
                                        <div class="col-md-8 fv-row">
                                            <!--begin::Label-->
                                            <label class="required fs-6 fw-semibold form-label mb-2">Barangay</label>
                                            <!--end::Label-->

                                            <!--begin::Row-->
                                            <div class="row fv-row">
                                                <!--begin::Col-->
                                                <div class="col-6">
                                                    <input type="text" value="2" class="form-control form-control-solid"
                                                        placeholder="" name="barangay" />

                                                </div>
                                                <!--end::Col-->

                                                <!--begin::Col-->
                                                <div class="col-6">
                                                    <span class="required">Street</span>
                                                    <input type="text" value="2" class="form-control form-control-solid"
                                                        placeholder="House No" name="house" />

                                                </div>
                                                <!--end::Col-->
                                            </div>
                                            <!--end::Row-->

                                        </div>
                                        <!--end::Col-->

                                        <!--begin::Col-->
                                        <div class="col-md-4 fv-row">
                                            <!--begin::Label-->
                                            <label class="d-flex align-items-center fs-6 fw-semibold form-label mb-2">
                                                <span class="required">Street</span>


                                                <span class="ms-1" data-bs-toggle="tooltip"
                                                    title="Enter a card CVV code">
                                                    <i
                                                        class="ki-outline ki-information-5 text-gray-500 fs-6"></i></span>
                                            </label>
                                            <!--end::Label-->

                                            <!--begin::Input wrapper-->
                                            <div class="position-relative">
                                                <!--begin::Input-->
                                                <input type="text" value="2" class="form-control form-control-solid"
                                                    placeholder="Street" name="street" />
                                                <!--end::Input-->

                                                <!--begin::CVV icon-->
                                                <div class="position-absolute translate-middle-y top-50 end-0 me-3">
                                                    <i class="ki-outline ki-credit-cart fs-2hx"></i>
                                                </div>
                                                <!--end::CVV icon-->
                                            </div>
                                            <!--end::Input wrapper-->
                                        </div>
                                        <!--end::Col-->
                                    </div>
                                    <!--end::Input group-->

                                </div>
                                <!--end::Wrapper-->

                            </div>
                            <!--end::Input group-->

                        </div>
                        <!--end::Wrapper-->
                    </div>
                    <!--end::Step 5-->
                    <!--begin::Step 6-->
                    <div data-kt-stepper-element="content">
                        <!--begin::Wrapper-->
                        <div class="w-100">
                            <!--begin::Heading-->
                            <div class="pb-10 pb-lg-15">
                                <!--begin::Title-->
                                <h2 class="fw-bold text-dark">School Details</h2>
                                <!--end::Title-->

                                <!--begin::Notice-->
                                <div class="text-muted fw-semibold fs-6">
                                    If you need more info, please check out
                                    <a href="#" class="text-primary fw-bold">Help Page</a>.
                                </div>
                                <!--end::Notice-->
                            </div>
                            <!--end::Heading-->

                            <!--begin::Input group-->
                            <div class="fv-row mb-10">
                                <!--begin::Label-->
                                <label class="form-label required">Last School Attended</label>
                                <!--end::Label-->

                                <!--begin::Input-->
                                <input name="last_school_attended"
                                    class="form-control form-control-lg form-control-solid" />
                                <!--end::Input-->

                            </div>
                            <!--end::Input group-->


                            <div class="fv-row mb-10">
                                <!--begin::Label-->
                                <label class="form-label required">Address</label>
                                <!--end::Label-->

                                <!--begin::Input-->
                                <input name="school_address" class="form-control form-control-lg form-control-solid" />
                                <!--end::Input-->
                            </div>
                            <!--end::Col-->

                            <div class="fv-row mb-10">
                                <!--begin::Label-->
                                <label class="form-label required">Honor/Awards Received</label>
                                <!--end::Label-->

                                <!--begin::Input-->
                                <input name="honor_award" class="form-control form-control-lg form-control-solid" />
                                <!--end::Input-->
                            </div>
                            <!--end::Col-->

                            <!--end::Input group-->



                        </div>
                        <!--end::Wrapper-->
                    </div>
                    <!--end::Step 6-->
                    <!--begin::Step 7-->
                    <!-- for freshmen -->
                    <div data-kt-stepper-element="content">
                        <!--begin::Wrapper-->
                        <div class="w-100">
                            <!--begin::Heading-->
                            <div class="pb-10 pb-lg-15">
                                <!--begin::Title-->
                                <h2 class="fw-bold text-dark">Academic Details</h2>
                                <!--end::Title-->

                                <!--begin::Notice-->
                                <div class="text-muted fw-semibold fs-6">
                                    Academic Credential Upload
                                    <!-- <a href="#" class="text-primary fw-bold">Help Page</a>. -->
                                </div>
                                <!--end::Notice-->
                            </div>
                            <!--end::Heading-->


                            <!--begin::Input group-->
                            <div class="d-flex flex-stack">
                                <!--begin::Label-->
                                <div class="me-5">
                                    <!-- <label class="fs-6 fw-semibold form-label">Transcript of Records</label> -->
                                    <!-- <div class="fs-12 fw-semibold text-muted">Transcript of Records (TOR) with GWA</div> -->
                                    <!-- <div id="result2">  </div> -->
                                    <!-- <?php if (!empty($admissionData)): ?>
                                        <?php foreach ($admissionData as $requirements): ?>
                                            <div class="mb-3">
                                                <label class="fs-6 fw-semibold form-label"><?= esc($requirements->Requirement_name); ?></label>
                                                <input type="file" 
                                                    class="form-control form-control-solid" 
                                                    name="files[<?= esc($requirements->AdmissionTypeID); ?>]" 
                                                    id="file_<?= esc($requirements->AdmissionTypeID); ?>" />
                                            </div>
                                        <?php endforeach; ?>
                                    <?php else: ?>
                                        <p>No requirements found.</p>
                                    <?php endif; ?> -->
                                    <!-- Section to Render AJAX Data -->
                                    <div id="admission-details"></div>
                                    <!--begin::Row-->
                                    <div class="row fv-row">
                                        <!--begin::Col-->
                                        <!-- <div class="col-12">

                                            <label class="fs-6 fw-semibold form-label">Transcript of Record</label>
                                            <input type="file"  class="form-control form-control-solid" placeholder=""
                                                name="userfile" id="userfile" />

                                        </div> -->
                                        <!--end::Col-->
                                    </div>
                                    <!--end::Row-->

                                </div>
                                <!--end::Label-->

                            </div>
                            <!--end::Input group-->



                        </div>
                        <!--end::Wrapper-->
                    </div>
                    <!--end::Step 7-->
                    <!--begin::Step 7-->


                    <!--begin::Step 8 survey-->
                    <div data-kt-stepper-element="content">
                        <!--begin::Wrapper-->
                        <div class="w-100">
                            <!--begin::Heading-->
                            <div class="pb-10 pb-lg-15">
                                <!--begin::Title-->
                                <h2 class="fw-bold text-dark">Survey</h2>
                                <!--end::Title-->

                                <!--begin::Notice-->
                                <div class="text-muted fw-semibold fs-6">
                                    If you need more info, please check out
                                    <a href="#" class="text-primary fw-bold">Help Page</a>.
                                </div>
                                <!--end::Notice-->
                            </div>
                            <!--end::Heading-->


                            <!--begin::Input group-->
                            <div class="row mb-10">
                                <!--begin::Col-->
                                <div class="col-md-8 fv-row">
                                    <!--begin::Label-->
                                    <label class="required fs-6 fw-semibold form-label mb-2">What College or University
                                        is your first choice?</label>
                                    <!--end::Label-->

                                    <!--begin::Row-->
                                    <div class="row fv-row">
                                        <!--begin::Col-->
                                        <div class="col-6">

                                            <input type="text" class="form-control form-control-solid"
                                                placeholder="First Choice" name="first_choice" />

                                        </div>
                                        <!--end::Col-->

                                        <!--begin::Col-->
                                        <div class="col-6">
                                            <input type="text" class="form-control form-control-solid"
                                                placeholder="Second Choice" name="second_choice" />

                                        </div>
                                        <!--end::Col-->
                                    </div>
                                    <!--end::Row-->
                                </div>
                                <!--end::Col-->

                                <!--begin::Col-->
                                <div class="col-md-4 fv-row">
                                    <!--begin::Label-->
                                    <label class="d-flex align-items-center fs-6 fw-semibold form-label mb-2">
                                        <!-- <span class="required">Lastname</span> -->


                                        <span class="ms-1" data-bs-toggle="tooltip" title="Enter a card CVV code">
                                            <i class="ki-outline ki-information-5 text-gray-500 fs-6"></i></span>
                                    </label>
                                    <!--end::Label-->

                                    <!--begin::Input wrapper-->
                                    <div class="position-relative">
                                        <!--begin::Input-->
                                        <input type="text" class="form-control form-control-solid"
                                            placeholder="Third Choice" name="third_choice" />
                                        <!--end::Input-->

                                        <!--begin::CVV icon-->
                                        <div class="position-absolute translate-middle-y top-50 end-0 me-3">
                                            <i class="ki-outline ki-credit-cart fs-2hx"></i>
                                        </div>
                                        <!--end::CVV icon-->
                                    </div>
                                    <!--end::Input wrapper-->
                                </div>
                                <!--end::Col-->
                            </div>
                            <!--end::Input group-->
                            <div class="fv-row mb-10">
                                <!--begin::Label-->
                                <label class="form-label required">In case you do not qualified for admission, where do
                                    you plan to pursue college?</label>
                                <!--end::Label-->

                                <!--begin::Input-->
                                <input name="question2" class="form-control form-control-lg form-control-solid" />
                                <!--end::Input-->
                            </div>
                            <!--begin::Input group-->
                            <div class="row mb-10">
                                <!--begin::Col-->
                                <div class="col-md-8 fv-row">
                                    <!--begin::Label-->
                                    <label class="required fs-6 fw-semibold form-label mb-2">Course applied in
                                        CSPC:</label>
                                    <!--end::Label-->

                                    <!--begin::Row-->
                                    <div class="row fv-row">
                                        <!--begin::Col-->
                                        <div class="col-6">

                                            <input type="text" class="form-control form-control-solid"
                                                placeholder="1st Priority" name="first_priority" />

                                        </div>
                                        <!--end::Col-->

                                        <!--begin::Col-->
                                        <div class="col-6">
                                            <input type="text" class="form-control form-control-solid"
                                                placeholder="2nd Priority" name="second_priority" />

                                        </div>
                                        <!--end::Col-->
                                    </div>
                                    <!--end::Row-->
                                </div>
                                <!--end::Col-->

                                <!--begin::Col-->
                                <div class="col-md-4 fv-row">
                                    <!--begin::Label-->
                                    <label class="d-flex align-items-center fs-6 fw-semibold form-label mb-2">
                                        <!-- <span class="required">Lastname</span> -->


                                        <span class="ms-1" data-bs-toggle="tooltip" title="Enter a card CVV code">
                                            <i class="ki-outline ki-information-5 text-gray-500 fs-6"></i></span>
                                    </label>
                                    <!--end::Label-->

                                    <!--begin::Input wrapper-->
                                    <div class="position-relative">
                                        <!--begin::Input-->
                                        <input type="text" class="form-control form-control-solid"
                                            placeholder="3rd Priority" name="third_priority" />
                                        <!--end::Input-->

                                        <!--begin::CVV icon-->
                                        <div class="position-absolute translate-middle-y top-50 end-0 me-3">
                                            <i class="ki-outline ki-credit-cart fs-2hx"></i>
                                        </div>
                                        <!--end::CVV icon-->
                                    </div>
                                    <!--end::Input wrapper-->
                                </div>
                                <!--end::Col-->
                            </div>
                            <!--end::Input group-->
                            <div class="fv-row mb-10">
                                <!--begin::Label-->
                                <label class="form-label required">Reasons why you want to study in CSPC?</label>
                                <!--end::Label-->

                                <!--begin::Input-->
                                <input name="reasons" class="form-control form-control-lg form-control-solid" />
                                <!--end::Input-->
                            </div>
                            <div class="fv-row mb-10">
                                <!--begin::Label-->
                                <label class="form-label required">Do you have any other financial assistance?</label>
                                <!--end::Label-->

                                <!--begin::Input-->
                                <input name="financial_assistance"
                                    class="form-control form-control-lg form-control-solid" />
                                <!--end::Input-->
                            </div>
                            <div class="fv-row mb-10">
                                <!--begin::Label-->
                                <label class="form-label required">Do you belong to a household that is or was
                                    beneficiary of 4Ps?</label>
                                <!--end::Label-->

                                <!--begin::Input-->
                                <input name="question2" class="form-control form-control-lg form-control-solid" />
                                <!--end::Input-->
                            </div>


                        </div>
                        <!--end::Wrapper-->
                    </div>
                    <!--end::Step 8-->
                    <!--begin::Step 9 application fee-->
                    <div data-kt-stepper-element="content">
                        <!--begin::Wrapper-->
                        <div class="w-100">
                            <!--begin::Heading-->
                            <div class="pb-10 pb-lg-15">
                                <!--begin::Title-->
                                <h2 class="fw-bold text-dark">Application Fee</h2>
                                <!--end::Title-->

                                <!--begin::Notice-->
                                <div class="text-muted fw-semibold fs-6">
                                    If you need more info, please check out
                                    <a href="#" class="text-primary fw-bold">Help Page</a>.
                                </div>
                                <!--end::Notice-->
                            </div>
                            <!--end::Heading-->


                            <!--begin::Input group-->
                            <div class="row mb-10">
                                <!--begin::Invoice 2 content-->
                                <div class="mt-n1">
                                    <!--begin::Top-->
                                    <div class="d-flex flex-stack pb-10">
                                        <!--begin::Logo-->
                                        <a href="#">
                                            <img alt="Logo"
                                                src="/metronic8/demo6/assets/media/svg/brand-logos/code-lab.svg" />
                                        </a>
                                        <!--end::Logo-->

                                        <!--begin::Action-->
                                        <a href="#" class="btn btn-sm btn-success">Pay Now</a>
                                        <!--end::Action-->
                                    </div>
                                    <!--end::Top-->

                                    <!--begin::Wrapper-->
                                    <div class="m-0">
                                        <!--begin::Label-->
                                        <div class="fw-bold fs-3 text-gray-800 mb-8">Invoice #34782</div>
                                        <!--end::Label-->

                                        <!--begin::Row-->
                                        <div class="row g-5 mb-11">
                                            <!--end::Col-->
                                            <div class="col-sm-6">
                                                <!--end::Label-->
                                                <div class="fw-semibold fs-7 text-gray-600 mb-1">Issue Date:</div>
                                                <!--end::Label-->

                                                <!--end::Col-->
                                                <div class="fw-bold fs-6 text-gray-800">12 Apr 2021</div>
                                                <!--end::Col-->
                                            </div>
                                            <!--end::Col-->

                                            <!--end::Col-->
                                            <div class="col-sm-6">
                                                <!--end::Label-->
                                                <div class="fw-semibold fs-7 text-gray-600 mb-1">Due Date:</div>
                                                <!--end::Label-->

                                                <!--end::Info-->
                                                <div
                                                    class="fw-bold fs-6 text-gray-800 d-flex align-items-center flex-wrap">
                                                    <span class="pe-2">02 May 2021</span>

                                                    <span class="fs-7 text-danger d-flex align-items-center">
                                                        <span class="bullet bullet-dot bg-danger me-2"></span>

                                                        Due in 7 days
                                                    </span>
                                                </div>
                                                <!--end::Info-->
                                            </div>
                                            <!--end::Col-->
                                        </div>
                                        <!--end::Row-->

                                        <!--begin::Row-->
                                        <div class="row g-5 mb-12">
                                            <!--end::Col-->
                                            <div class="col-sm-6">
                                                <!--end::Label-->
                                                <div class="fw-semibold fs-7 text-gray-600 mb-1">Issue For:</div>
                                                <!--end::Label-->

                                                <!--end::Text-->
                                                <div class="fw-bold fs-6 text-gray-800">KeenThemes Inc.</div>
                                                <!--end::Text-->

                                                <!--end::Description-->
                                                <div class="fw-semibold fs-7 text-gray-600">
                                                    8692 Wild Rose Drive <br />
                                                    Livonia, MI 48150
                                                </div>
                                                <!--end::Description-->
                                            </div>
                                            <!--end::Col-->

                                            <!--end::Col-->
                                            <div class="col-sm-6">
                                                <!--end::Label-->
                                                <div class="fw-semibold fs-7 text-gray-600 mb-1">Issued By:</div>
                                                <!--end::Label-->

                                                <!--end::Text-->
                                                <div class="fw-bold fs-6 text-gray-800">CodeLab Inc.</div>
                                                <!--end::Text-->

                                                <!--end::Description-->
                                                <div class="fw-semibold fs-7 text-gray-600">
                                                    9858 South 53rd Ave.<br />
                                                    Matthews, NC 28104
                                                </div>
                                                <!--end::Description-->
                                            </div>
                                            <!--end::Col-->
                                        </div>
                                        <!--end::Row-->


                                        <!--begin::Content-->
                                        <div class="flex-grow-1">
                                            <!--begin::Table-->
                                            <div class="table-responsive border-bottom mb-9">
                                                <table class="table mb-3">
                                                    <thead>
                                                        <tr class="border-bottom fs-6 fw-bold text-muted">
                                                            <th class="min-w-175px pb-2">Description</th>
                                                            <th class="min-w-70px text-end pb-2">Hours</th>
                                                            <th class="min-w-80px text-end pb-2"></th>
                                                            <th class="min-w-100px text-end pb-2"></th>
                                                        </tr>
                                                    </thead>

                                                    <tbody>
                                                        <tr class="fw-bold text-gray-700 fs-5 text-end">
                                                            <td class="d-flex align-items-center pt-6">
                                                                <i class="fa fa-genderless text-danger fs-2 me-2"></i>

                                                                Applicant Type
                                                            </td>

                                                            <td class="pt-6">Transferee</td>
                                                            <!-- <td class="pt-6">$40.00</td> -->
                                                            <!-- <td class="pt-6 text-dark fw-bolder">$3200.00</td> -->
                                                        </tr>

                                                        <tr class="fw-bold text-gray-700 fs-5 text-end">
                                                            <td class="d-flex align-items-center">
                                                                <i class="fa fa-genderless text-success fs-2 me-2"></i>

                                                                Application Fee Amount
                                                            </td>

                                                            <td>500</td>
                                                            <td></td>
                                                            <!-- <td class="fs-5 text-dark fw-bolder">$4800.00</td> -->
                                                        </tr>

                                                        <tr class="fw-bold text-gray-700 fs-5 text-end">
                                                            <td class="d-flex align-items-center">
                                                                <!-- <i class="fa fa-genderless text-primary fs-2 me-2"></i>                                           -->

                                                                Total
                                                            </td>

                                                            <td>P 500.00</td>
                                                            <td></td>
                                                            <!-- <td class="fs-5 text-dark fw-bolder">$12600.00</td> -->
                                                        </tr>
                                                        <tr class="fw-bold text-gray-700 fs-5 text-end">
                                                            <td class="d-flex align-items-center">
                                                                <!-- <i class="fa fa-genderless text-primary fs-2 me-2"></i>                                           -->

                                                                Payment Method
                                                            </td>

                                                            <td></td>
                                                            <td></td>
                                                            <!-- <td class="fs-5 text-dark fw-bolder">$12600.00</td> -->
                                                        </tr>
                                                    </tbody>
                                                </table>
                                            </div>
                                            <!--end::Table-->

                                            <!--begin::Container-->
                                            <div class="d-flex justify-content-end">
                                                <!--begin::Section-->
                                                <div class="mw-300px">
                                                    <!--begin::Item-->
                                                    <div class="d-flex flex-stack mb-3">
                                                        <!--begin::Accountname-->
                                                        <div class="fw-semibold pe-10 text-gray-600 fs-7">Payment Date:
                                                        </div>
                                                        <!--end::Accountname-->

                                                        <!--begin::Label-->
                                                        <div class="text-end fw-bold fs-6 text-gray-800">$ 20,600.00
                                                        </div>
                                                        <!--end::Label-->
                                                    </div>
                                                    <!--end::Item-->

                                                    <!--begin::Item-->
                                                    <div class="d-flex flex-stack mb-3">
                                                        <!--begin::Accountname-->
                                                        <div class="fw-semibold pe-10 text-gray-600 fs-7">Payment Ref
                                                            No.</div>
                                                        <!--end::Accountname-->

                                                        <!--begin::Label-->
                                                        <div class="text-end fw-bold fs-6 text-gray-800">N/A</div>
                                                        <!--end::Label-->
                                                    </div>
                                                    <!--end::Item-->

                                                    <!--begin::Item-->
                                                    <div class="d-flex flex-stack mb-3">
                                                        <!--begin::Accountnumber-->
                                                        <div class="fw-semibold pe-10 text-gray-600 fs-7">Total Amount
                                                            Paid</div>
                                                        <!--end::Accountnumber-->

                                                        <!--begin::Number-->
                                                        <div class="text-end fw-bold fs-6 text-gray-800">00</div>
                                                        <!--end::Number-->
                                                    </div>
                                                    <!--end::Item-->

                                                    <!--begin::Item-->
                                                    <div class="d-flex flex-stack">
                                                        <!--begin::Code-->
                                                        <div class="fw-semibold pe-10 text-gray-600 fs-7">Payment Status
                                                        </div>
                                                        <!--end::Code-->

                                                        <!--begin::Label-->
                                                        <div class="text-end fw-bold fs-6 text-gray-800">No Payment
                                                            Received</div>
                                                        <!--end::Label-->
                                                    </div>
                                                    <!--end::Item-->
                                                    <!--end::Col-->
                                                    <div class="col-sm-12">
                                                        <br>
                                                        <a href="#" class="btn btn-sm btn-success">Pay Now</a>
                                                    </div>
                                                    <!--end::Col-->
                                                </div>
                                                <!--end::Section-->
                                            </div>
                                            <!--end::Container-->
                                        </div>
                                        <!--end::Content-->
                                    </div>
                                    <!--end::Wrapper-->
                                </div>
                                <!--end::Invoice 2 content-->
                            </div>
                            <!--end::Input group-->


                        </div>
                        <!--end::Wrapper-->
                    </div>
                    <!--end::Step 9-->
                    <!--begin::Step  Finish-->

                    <div data-kt-stepper-element="content">


                        <!--begin::Wrapper-->
                        <div class="w-100">
                            <!--begin::Heading-->
                            <div class="pb-8 pb-lg-10">
                                <!--begin::Title-->
                                <h2 class="fw-bold text-dark">Your Are Done!</h2>
                                <!--end::Title-->

                                <!--begin::Notice-->
                                <!-- <div class="text-muted fw-semibold fs-6">
                                    If you need more info, please
                                    <a href="#" class="link-primary fw-bold">
                                        Sign In
                                    </a>
                                    .
                                </div> -->
                                <!--end::Notice-->
                            </div>
                            <!--end::Heading-->

                            <!--begin::Body-->
                            <div class="mb-0">
                                <!--begin::Text-->
                                <!-- <div class="fs-6 text-gray-600 mb-5">
                                    Writing headlines for blog posts is as much an art as it is a science
                                    and probably warrants its own post, but for all advise is with what
                                    works for your great & amazing audience.
                                </div> -->
                                <!--end::Text-->

                                <!--begin::Alert-->

                                <!--begin::Notice-->
                                <div
                                    class="notice d-flex bg-light-warning rounded border-warning border border-dashed  p-6">
                                    <!--begin::Icon-->
                                    <i class="ki-outline ki-information fs-2tx text-warning me-4"></i>
                                    <!--end::Icon-->

                                    <!--begin::Wrapper-->
                                    <div class="d-flex flex-stack flex-grow-1 ">
                                        <!--begin::Content-->
                                        <div class=" fw-semibold">
                                            <h4 class="text-gray-900 fw-bold">Thank you!</h4>

                                            <div class="fs-6 text-gray-700 ">We appreciate your application and will
                                                inform you of its status either
                                                via email or through the <a
                                                    href="<?php echo base_url(); ?>Admissions/status"
                                                    class="fw-bold">status</a> tab where you can check for updates.
                                            </div>
                                        </div>
                                        <!--end::Content-->

                                    </div>
                                    <!--end::Wrapper-->
                                </div>
                                <!--end::Notice-->
                                <!--end::Alert-->
                            </div>
                            <!--end::Body-->
                        </div>
                        <!--end::Wrapper-->

                    </div>
                    <!--end::Step 5-->

                    <!--begin::Actions-->
                    <div class="d-flex flex-stack pt-10">
                        <!--begin::Wrapper-->
                        <div class="mr-2">
                            <button type="button" class="btn btn-lg btn-light-primary me-3"
                                data-kt-stepper-action="previous">
                                <i class="ki-outline ki-arrow-left fs-4 me-1"></i> Back
                            </button>
                        </div>
                        <!--end::Wrapper-->

                        <!--begin::Wrapper-->
                        <div>
                            <button type="button" id="submit" class="btn btn-lg btn-primary me-3"
                                data-kt-stepper-action="submit">
                                <span class="indicator-label">
                                    Submit
                                    <i class="ki-outline ki-arrow-right fs-3 ms-2 me-0"></i> </span>
                                <span class="indicator-progress">
                                    Please wait... <span
                                        class="spinner-border spinner-border-sm align-middle ms-2"></span>
                                </span>
                            </button>

                            <button type="button" class="btn btn-lg btn-primary" data-kt-stepper-action="next">
                                Continue
                                <i class="ki-outline ki-arrow-right fs-4 ms-1 me-0"></i> </button>
                        </div>
                        <!--end::Wrapper-->
                    </div>
                    <!--end::Actions-->
                </form>

                <!--end::Form-->
            </div>
            <!--end::Content-->
        </div>
        <!--end::Stepper-->
    </div>
    <!--end::Container-->
</div>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
    $(document).ready(function () {
        $('.account_type').on('change', function () {
            const admissionTypeId = $(this).val();
            // alert(admissionTypeId);
            $.ajax({
                url: '<?= base_url('Admissions/getAdmissionDataAjax') ?>',
                type: 'POST',
                dataType: 'json',
                data: { admission_type_id: admissionTypeId },
                success: function (response) {
                    console.log(response);
                    if (response.success) {
                        // Render fetched data dynamically
                        let html = '';
                        response.admissionData.forEach(function (item) {
                            html += `
                            <div class="mb-3">
                                <label class="fs-6 fw-semibold form-label">${item.Requirement_name}</label>
                                <input type="file" class="form-control form-control-solid" 
                                    name="files[${item.AdmissionTypeID}]" 
                                    id="file_${item.AdmissionTypeID}" />
                            </div>`;
                        });
                        $('#admission-details').html(html);
                    } else {
                        // Show error message
                        $('#admission-details').html(`<p class="text-danger">${response.message}</p>`);
                    }
                },
                error: function (xhr, status, error) {
                    console.error('AJAX Error:', error);
                    $('#admission-details').html('<p class="text-danger">An error occurred. Please try again.</p>');
                }
            });
        });
    });
</script>

<script>
    var select1 = document.getElementById('programs');
    var select2 = document.getElementById('programs2');

    // Add an event listener to the first select element
    select1.addEventListener('change', function () {
        var selectedOption = select1.options[select1.selectedIndex].value;

        // Find the corresponding option in select2 and disable it
        for (var i = 0; i < select2.options.length; i++) {
            if (select2.options[i].value === selectedOption) {
                select2.options[i].disabled = true;
                //   selectedOption.classList.add("d-none");
                //   selectedOption.classList.remove("d-inline-block");
                // Remove the class attribute

                // Remove a specific class from the select element's classList
                selectElement.classList.remove("form-select-lg", "form-select-solid");
                //   selectedOption.classList.remove("form-select form-select-lg form-select-solid");
            } else {
                select2.options[i].disabled = false;

            }
        }
    });
</script>


<?= $this->endSection(); ?>


<!--begin::Custom Javascript-->
<?= $this->section('customscripts'); ?>

<!-- <script src="<?= base_url("public"); ?>/<?= base_url("public"); ?>/assets/js/custom/utilities/modals/thescript.js"></script> -->

<?= $this->endSection(); ?>
<!--end::Custom Javascript-->