<?php

namespace App\Models;

use CodeIgniter\Model;

class StudentModel extends Model
{
    protected $table = 'student';
    protected $primaryKey = 'id';
    protected $allowedFields = ['name', 'email', 'schedule_id'];

    protected $validationRules = [
        'name' => 'required',
        'email' => 'required|valid_email|is_unique[student.email]',
        'schedule_id' => 'required|integer',
    ];
}
