<?php

namespace App\Models;

use CodeIgniter\Model;

class ExamScheduleModel extends Model
{ 
    
    protected $table = 'StudentAdmission_ExamDate'; // Replace with your actual table name
    protected $primaryKey = 'Schedule_id'; // Replace with your primary key field name
    protected $allowedFields = ['StudentAdmissionID', 'Exam_date', 'Start_time', 'End_time', 'Venue', 'Details', 'Created_at'];
    public function insertSched($data)
    {
        $builder = $this->db->table('StudentAdmission_ExamDate');
        // return $builder->replace($data);
       return $builder->insert($data);
    }
    public function getInforbyApplicant()
    {
        $builder = $this->db->table('StudentAdmission_ExamDate');
        $builder->select('*'); 
        $builder->join('StudentInfo_Admission', 'StudentAdmission_ExamDate.StudentAdmissionID = StudentInfo_Admission.StudentAdmissionID','left'); 
        $builder->join('StudentProgramChoice', 'StudentAdmission_ExamDate.StudentAdmissionID = StudentProgramChoice.StudentAdmissionID','left'); 
        $builder->join('StudentAcademicHistory', 'StudentInfo_Admission.StudentAdmissionID = StudentAcademicHistory.StudentAdmissionID','left'); 
        $builder->join('StudentAdmission_Application', 'StudentInfo_Admission.StudentAdmissionID = StudentAdmission_Application.StudentAdmissionID','left'); 
        $builder->join('Program', 'StudentProgramChoice.ProgramID = Program.ProgramID','left');  
        $builder->where('StudentAdmission_ExamDate.StudentAdmissionID', '396931758');
        $query = $builder->get();
        return $query->getResult();
    }
    //get the academic year
    public function geAcademicYear()
    {
        $builder = $this->db->table('AcademicTerm');
        $builder->select('*');   
        $builder->where('isActive', 1);
        $query = $builder->get();
        return $query->getResult();
    }
}

// <link href="assets/plugins/custom/datatables/datatables.bundle.css" rel="stylesheet" type="text/css"/>
// <script src="assets/plugins/custom/datatables/datatables.bundle.js"></script>