<?php

namespace App\Models;

use CodeIgniter\Model;

class AdmissionSchedModel extends Model
{
    protected $table = 'StudentAdmission_Schedule';
    protected $primaryKey = 'StudentAdmission_ScheduleID';
    protected $allowedFields = ['Exam_Date', 'Max_Examinees', 'Current_Examinees'];

    public function incrementExamineeCount($id)
    {
        $this->set('Current_Examinees', 'Current_Examinees + 1', false)
            ->where('StudentAdmission_ScheduleID', $id)
            ->update();
    }

    public function isFull($id)
    {
        $schedule = $this->find($id);
        return $schedule['Current_Examinees'] >= $schedule['Max_Examinees'];
    }

    public function getAvailableSchedule()
    {
        return $this->where('Current_Examinees < Max_Examinees')
            ->orderBy('Exam_Date', 'ASC') // Optional: Order by date
            ->first();
    } 
//     public function getAvailableSchedule()
// {
//     return $this->select('*')
//         ->where('Current_Examinees < Max_Examinees')
//         ->orderBy('Exam_Date', 'ASC')
//         ->first();
// }
    public function update_schedule($id, $data) {
         
       // Ensure $id and $data are provided
    //    if (!$id || !is_array($data)) {
    //     return false;
    // }

    // Update the record where the ID matches
    return $this->where('StudentAdmission_ScheduleID', $id)->set($data)->update();
    }
}
