<?php

namespace App\Models;

use CodeIgniter\Model;


class AdmissionReportModel extends Model
{
    protected $table = 'StudentInfo_Admission';

    protected $db;

    public function __construct()
    {
        $this->db = \Config\Database::connect(); // Initialize the database connection
    }

    // public function getAllAdmission()
    // { 
    //     $builder = $this->db->table('StudentAdmission_Application');
    //     $builder->join('StudentInfo_Admission', 'StudentInfo_Admission.StudentAdmissionID = StudentAdmission_Application.StudentAdmissionID'); 
    //     // $builder->join('StudentProgramChoice', 'StudentProgramChoice.StudentAdmissionID = StudentAdmission_Application.StudentAdmissionID');
    //     // $builder->join('program', 'program.ProgramID = StudentProgramChoice.ProgramID'); 
    //     // $builder->join('AdmissionType', 'AdmissionType.AdmissionTypeID = StudentAdmission_Application.AdmissionTypeID'); 
    //     $builder->where('RemarksAdmission', null);
    //     $query = $builder->get(); 
    //     return $query->getResult();
    // }
    // function make_query(){ 

    //     // var_dump($month);
    //     // $this->db->select("a.*,b.*");  //   GROUP_CONCAT(DISTINCT d.file_name SEPARATOR ',') as images,  
    //     $builder = $this->db->table("StudentInfo_Admission"); // Query Builder
    //     $builder->select("*");
    //     return $builder;  
    // }  


    // function make_datatables(){  
    //     $builder = $this->make_query(); // Get the query builder instance
    //     $query = $builder->get(); // Execute the query
    //     return $query->getResult(); // Return the result as an array of objects  
    // }  
    public function make_query($applicationType = null, $status = null)
    {
        $builder = $this->db->table("StudentAdmission_Application");

        $builder->select("StudentAdmission_Application.*, AdmissionType.*, StudentInfo_Admission.*");


        $builder->join("AdmissionType", "AdmissionType.AdmissionTypeID = StudentAdmission_Application.AdmissionTypeID");

        $builder->join("StudentInfo_Admission", "StudentInfo_Admission.StudentAdmissionID = StudentAdmission_Application.StudentAdmissionID");

        if ($applicationType != null) {
            $builder->where('StudentAdmission_Application.AdmissionTypeID', $applicationType);
        }

        if ($status != null) {
            $builder->where('StudentAdmission_Application.RemarksAdmission', $status);
        }

        return $builder;
    }

    public function make_datatables($applicationType = null, $status = null)
    {
        $builder = $this->make_query($applicationType, $status);  // Pass the filter to the query builder
        $query = $builder->get();  // Execute the query
        return $query->getResult();  // Return the result as an array of objects
    }

    public function get_all_data()
    {
        $builder = $this->db->table("StudentAdmission_Application");
        return $builder->countAllResults();  // Get the total number of rows in the table
    }

    public function get_filtered_data($filters)
    {
        $builder = $this->db->table("StudentAdmission_Application");

        // Apply the filters
        if (!empty($filters['applicationType'])) {
            $builder->where('AdmissionTypeID', $filters['applicationType']);
        }
        if (!empty($filters['status']) || $filters['status'] === null) {
            if ($filters['status'] !== null) {
                $builder->where('RemarksAdmission', $filters['status']);
            }
        }

        return $builder->countAllResults();  // Get the number of rows matching the filters
    }

    public function getAllAdmission()
    {
        $builder = $this->db->table('StudentAdmission_Application');

        // Join the StudentInfo_Admission table
        $builder->join('StudentInfo_Admission', 'StudentInfo_Admission.StudentAdmissionID = StudentAdmission_Application.StudentAdmissionID');
        $builder->join('AdmissionType', 'AdmissionType.AdmissionTypeID = StudentAdmission_Application.AdmissionTypeID');

        // Filter where RemarksAdmission is NULL
        $builder->where('RemarksAdmission IS NOT NULL', null, false); // Explicit use of IS NULL

        // Get the results
        $query = $builder->get();

        // Return the results as an array of objects
        return $query->getResult();
    }

    public function getAcademicTerm()
    {
        $builder = $this->db->table('AcademicTerm');
        $builder->join('Term', 'Term.TermID = AcademicTerm.TermID', 'left');
        return $builder->orderBy('AcademicTermID', 'ASC')
            ->get()
            ->getResultArray();
    }
    public function getAdmissionType()
    {
        $builder = $this->db->table('AdmissionType');
        // $builder->join('Term', 'Term.TermID = AcademicTerm.TermID','left'); 
        return $builder->orderBy('AdmissionTypeID', 'ASC')
            ->get()
            ->getResultArray();
    }
    public function getAllProgram()
    {
        $builder = $this->db->table('Program');
        // $builder->join('Term', 'Term.TermID = AcademicTerm.TermID','left'); 
        return $builder->get()
            ->getResultArray();
    }
    public function getFilteredApplications($applicationType = null, $status = null, $course = null)
    {
        $builder = $this->db->table($this->table);
        $builder->select('StudentAdmissionID, FirstName, MiddleName, LastName, AdmissionType, ProgramDesc');
        $builder->join('program', 'program.ProgramID = StudentAdmission_Application.ProgramID');
        $builder->join('StudentInfo_Admission', 'StudentInfo_Admission.StudentID = StudentAdmission_Application.StudentID');
        $builder->join('StudentProgramChoice', 'StudentProgramChoice.StudentAdmissionID = StudentAdmission_Application.StudentAdmissionID');

        if ($applicationType) {
            $builder->where('AdmissionTypeID', $applicationType);
        }
        if ($status) {
            $builder->where('Status', $status);
        }
        if ($course) {
            $builder->where('ProgramID', $course);
        }

        return $builder->get()->getResult();
    }
    public function getFilteredData($applicationType = null, $status = null)
    {
        // Initialize the query builder for the table
        $builder = $this->db->table('StudentAdmission_Application');

        // Select required fields
        $builder->select('StudentAdmission_Application.*, AdmissionType.*, StudentInfo_Admission.*');

        // Join with other tables
        $builder->join('StudentInfo_Admission', 'StudentInfo_Admission.StudentAdmissionID = StudentAdmission_Application.StudentAdmissionID', 'inner');
        $builder->join('AdmissionType', 'AdmissionType.AdmissionTypeID = StudentAdmission_Application.AdmissionTypeID', 'inner');

        // Apply filters if they are provided
        if ($applicationType) {
            $builder->where('AdmissionType.AdmissionTypeID', $applicationType); // Ensure to use the correct column name
        }

        if ($status) {
            $builder->where('StudentAdmission_Application.RemarksAdmission', $status); // Ensure to use the correct column name
        }

        // Execute the query and return results
        return $builder->get()->getResult(); // Use getResult() to fetch results
    }
    public function getAllColleges()
    { 
       
        $builder = $this->db->table('College');
        $builder->select('*');
         $query = $builder->get();
       return $query->getResult();
    }
    public function getProgramsByCollege($collegeID)
    {
        $builder = $this->db->table('Program');
        $builder->select('ProgramID, ProgramDesc'); // Fetch only necessary fields
        $builder->where('CollegeID', $collegeID);
        $query = $builder->get();
    
        return $query->getResultArray(); // Return as an array of results
    }
    public function getProgramDatabyCollege($collegeId)
    {
        $builder = $this->db->table('Program');
        $builder->where('CollegeID', $collegeId); // Select the mapped column names 
        $query = $builder->get();
        return $query->getResultArray();
    }




}