<?php
namespace App\Models;

use CodeIgniter\Model;

class AdmissionModel extends Model
{
    // protected $table = 'program';
    protected $table = 'payment'; // Replace with your actual table name
    protected $primaryKey = 'PaymentID'; // Replace with your primary key field name
    protected $allowedFields = ['Amount']; // Replace with your table fields


    public function getProgram()
    {
        // Fetch data from your database
        $builder = $this->db->table('Program');
        // return $this->findAll();
        $query = $builder->get();

        // Return the result as an array of objects
        return $query->getResultArray();
    }
    public function getCitizenship()
    {
        // Fetch data from your database e
        $builder = $this->db->table('Citizenship');
        // return $this->findAll();
        $query = $builder->get();

        // Return the result as an array of objects
        return $query->getResultArray();
    }
    public function insertApplicantInfo($data)
    {
        $builder = $this->db->table('StudentInfo_Admission');
        // return $builder->replace($data);
        $builder->insert($data);
    }
    public function insertApplicantAddress($address)
    {
        $builder = $this->db->table('StudentAdmission_Address');
        $builder->insert($address);
    }
    public function insertApplicantsubmission($submission)
    {
        // $this->db->transStart(); // Begin the transaction

        // try {
            $builder = $this->db->table('StudentAdmissionSubmission');
            $builder->insertBatch($submission); // Insert the batch
            
            // Commit if no errors occurred
        //     $this->db->transCommit();
        // } catch (\Exception $e) {
        //     $this->db->transRollback(); // Rollback on error
        //     log_message('error', 'Error inserting batch: ' . $e->getMessage());
        // }
    }
    public function insertApplicantApplication($application)
    {
        $builder = $this->db->table('StudentAdmission_Application');
        $builder->insert($application);
    }
    public function InsertProgramChoice($programchoice)
    {
        $builder = $this->db->table('StudentProgramChoice');
        $builder->insert($programchoice);
    }
    public function InsertStudentApplication($studentApplication)
    {
        $builder = $this->db->table('StudentAdmission_Application');
        $builder->insert($studentApplication);
    }
    public function getAcademicTerm()
    {
        // Get the last record from the table
        $builder = $this->db->table('AcademicTerm');
        $builder->join('Term', 'Term.TermID = AcademicTerm.TermID'); 
        return $builder->orderBy('AcademicTermID', 'desc')
            ->get()
            ->getRow();
        // $builder = $this->db->table('AcademicTerm');
        // $builder->select('AcademicTerm.*, Term.*');  
        // $builder->join('Term', 'Term.TermID = AcademicTerm.TermID'); 
        // return $builder->orderBy('AcademicTerm.AcademicTermID', 'desc')
        //                ->get()
        //                ->getRow();
        
    }
    public function isApplicationNumberUnique($applicationNumber)
    {
        // // Check if the application number already exists in the database
        // $existingApplication = $this->where('StudentAdmissionID', $applicationNumber)->first();

        // return empty($existingApplication);
        $builder = $this->db->table('StudentInfo_Admission');
        $existingApplication = $builder->where('StudentAdmissionID', $applicationNumber)->get()->getRow();

        return empty($existingApplication);
    }
    public function insertFile($doupload)
    {
        $builder = $this->db->table('StudentAdmissionSubmission');
        $builder->insert($doupload);
    }
    // GET ALL APPLICANTS
    // public function getAllApplicants()
    // {
    //     $builder = $this->db->table('StudentInfo_Admission');
    //     $builder->select('*');
    //     $builder->join('StudentAdmission_Application', 'StudentInfo_Admission.StudentAdmissionID = StudentAdmission_Application.StudentAdmissionID');
    //     $builder->join('StudentProgramChoice', 'StudentInfo_Admission.StudentAdmissionID = StudentProgramChoice.StudentAdmissionID');
    //     $builder->join('StudentProgramChoice', 'StudentInfo_Admission.StudentAdmissionID = StudentProgramChoice.StudentAdmissionID');
    //     $builder->join('program', 'StudentProgramChoice.ProgramID = program.ProgramID');
    //     $builder->where('StudentProgramChoice.Priority', 1);
    //     $query = $builder->get();
    //     return $query->getResult();
    // }
    public function getAllApplicants()
{
    $builder = $this->db->table('StudentInfo_Admission');
    $builder->select('*');
    $builder->join('StudentAdmission_Application', 'StudentInfo_Admission.StudentAdmissionID = StudentAdmission_Application.StudentAdmissionID');
    $builder->join('StudentProgramChoice', 'StudentInfo_Admission.StudentAdmissionID = StudentProgramChoice.StudentAdmissionID');
    $builder->join('Program', 'StudentProgramChoice.ProgramID = Program.ProgramID');
    $builder->where('StudentProgramChoice.Priority', 1);
    $query = $builder->get();
    return $query->getResult();
}

    
    public function getAllApplicantsForExaminee()
    {
        $builder = $this->db->table('StudentInfo_Admission');
        $builder->select('*');
        $builder->join('StudentAdmission_Application', 'StudentInfo_Admission.StudentAdmissionID = StudentAdmission_Application.StudentAdmissionID','left');
        $builder->join('StudentProgramChoice', 'StudentInfo_Admission.StudentAdmissionID = StudentProgramChoice.StudentAdmissionID','left');
        $builder->join('StudentAdmission_ExamDate', 'StudentInfo_Admission.StudentAdmissionID = StudentAdmission_ExamDate.StudentAdmissionID','right');
        $builder->join('Program', 'StudentProgramChoice.ProgramID = Program.ProgramID','left');
        $builder->where('StudentProgramChoice.Priority', 1);
        $query = $builder->get();
        return $query->getResult();
    }
    // testing purpose
    public function getAllApplicantsByIDT()
    {
        $studentAdmissionID = '1554968541';
        $builder = $this->db->table('StudentInfo_Admission');
        $builder->select('*');
        $builder->where('StudentAdmissionID', $studentAdmissionID);
        $query = $builder->get();

        // Check if the query returned any rows
        if ($query->getNumRows() > 0) {
            // Get the result as an array of objects
            $result = $query->getResult();

            // Check if the 'Status' property exists in the first row of the result
            if (isset($result[0]->Status)) {
                return $result;
            } else {
                // Handle case where 'Status' property is missing
                return null;
            }
        } else {
            // Handle case where query returned no rows
            return null;
        }
    }

    // ======================
    public function getAllApplicantsByID($StudentAdmissionID)
    {
        
        $builder = $this->db->table('StudentInfo_Admission,StudentProgramChoice');
        $builder->select('*');
        $builder->join('StudentAdmission_Application', 'StudentAdmission_Application.StudentAdmissionID = StudentInfo_Admission.StudentAdmissionID','left');
        $builder->join('StudentAdmission_Address', 'StudentAdmission_Address.StudentAdmissionID = StudentInfo_Admission.StudentAdmissionID','left');
        $builder->join('StudentAdmissionSubmission', 'StudentAdmissionSubmission.StudentAdmissionID = StudentInfo_Admission.StudentAdmissionID','left');
        $builder->join('StudentParentGuardian', 'StudentParentGuardian.StudentAdmissionID = StudentInfo_Admission.StudentAdmissionID','left');
        $builder->join('StudentAcademicHistory', 'StudentAcademicHistory.StudentAdmissionID = StudentInfo_Admission.StudentAdmissionID','left');
        $builder->join('Program', 'StudentProgramChoice.ProgramID = Program.ProgramID');  
        // $builder->where('StudentInfo_Admission.StudentAdmissionID', $StudentAdmissionID);
        $builder->where('StudentInfo_Admission.StudentAdmissionID', $StudentAdmissionID);
        // $builder->where('StudentProgramChoice.ProgramID', '1'); 
        $query = $builder->get();
        return $query->getRow();
    }
    //UPDATE STATUS OF APPLICATION
    public function updateDataBasedOnStatus($id, $status)
    {
        $data = [
            'Status' => $status,
            // Add other columns and values as needed
        ];
        $builder = $this->db->table('StudentInfo_Admission');
        $builder->where('StudentAdmissionID', $id)->update($data);
        // return $builder->affectedRows() > 0;
    }
    //UPDATE PERSONAL INFORMATION 
    public function updatePersonalInfo($StudentAdmissionID, $data)
    {
        $builder = $this->db->table('StudentInfo_Admission');
        $builder->where('StudentAdmissionID', $StudentAdmissionID)->update($data);
        // return $builder->affectedRows() > 0;
    }
    //UPDATE CONTACT INFORMATION 
    public function updateContactInfo($StudentAdmissionID, $data)
    {
        $builder = $this->db->table('StudentAdmission_Address');
        $builder->where('StudentAdmissionID', $StudentAdmissionID)->update($data);
        // return $builder->affectedRows() > 0;
    }
    //UPDATE PARENT /GUARDIAN INFORMATION 
    public function updateGuardianInfo($StudentAdmissionID, $data)
    {
        $builder = $this->db->table('StudentParentGuardian');
        $builder->where('StudentAdmissionID', $StudentAdmissionID)->update($data);
        // return $builder->affectedRows() > 0;
    }
    //UPDATE ACADEMIC HISTORY INFORMATION 
    public function updateAcadInfo($StudentAdmissionID, $data)
    {
        $builder = $this->db->table('StudentAcademicHistory');
        $builder->where('StudentAdmissionID', $StudentAdmissionID)->update($data);
        // return $builder->affectedRows() > 0;
    }
    // get all the academic Term
    public function getAcadTerm()
    {
        $builder = $this->db->table('AcademicTerm');
        $builder->select('*'); 
        $builder->join('Term', 'AcademicTerm.TermID = Term.TermID', 'left');
    
        $query = $builder->get();
        return $query->getResult();
    }

    public function updateAcadTerm($TermId)
    {
        // Get the Query Builder instance
        $builder = $this->db->table('AcademicTerm');
    
        // Set isActive to 0 for all records
        $builder->set('isActive', 0);
        $builder->update();
    
        // Set isActive to 1 for the specified AcademicTermID
        $builder->set('isActive', 1);
        $builder->where('AcademicTermID', $TermId);
        $builder->update();
    
        // Return true assuming no errors occurred
        return true;
    }
    public function getSchoolYear()
    {
        // $builder = $this->db->table('AcademicTerm');
        // $builder->select('*');
        // $builder->where('isActive', 1);
        // $query = $builder->get();
        // return $query->getResult();
        $builder = $this->db->table('AcademicTerm');
        $builder->select('*');
        $builder->where('isActive', 1);
        $query = $builder->get();

        // Check if there is a result before returning
        // return $query->getResult() ?? [];
        return $query->getResult();
    }
    public function getAllTerm()
    {
        $builder = $this->db->table('AcademicTerm');
        $builder->select('*');
        $query = $builder->get();
        return $query->getResult();
    }
    public function getRecordById($studentid)
    {
        $builder = $this->db->table('StudentInfo_Admission'); // Replace 'your_table_name' with the actual table name
        $builder->select('*');
        $builder->where('StudentAdmissionID', $studentid); // Replace 'id' with the actual column name for your ID

        $query = $builder->get();

        return $query->getRow(); // Assuming you expect only one result, use getRow() instead of getResult()
    }
    public function getAllCollege()
    {
        $builder = $this->db->table('College');
        $builder->select('*');
        // $builder->join('program', 'college.CollegeID = program.CollegeID'); 

        // $builder->where('StudentAdmission_Application.StudentAdmissionID', $StudentAdmissionID);
        $query = $builder->get();
       return $query->getResult();
    }
    public function getProgramDatabyCollege($collegeId)
    {
        $builder = $this->db->table('Program');
        $builder->where('CollegeID', $collegeId); // Select the mapped column names 
        $query = $builder->get();
        return $query->getResultArray();
    }
}