<?php

namespace App\Models;

use CodeIgniter\Model;

class AdmissionCriteriaModel extends Model
{ 
    protected $table = 'StudentAdmission_Criteria'; 
    protected $primaryKey = 'StudentAdmission_CriteriaID';   

     public function getCurrentCriteria()
     {
        $builder = $this->db->table('StudentAdmission_Criteria');
        // $builder->join('Term', 'Term.TermID = StudentAdmission_Criteria.TermID'); 
        return $builder->orderBy('StudentAdmission_CriteriaID', 'ASC')
            ->get()
            ->getResultArray();
     }

     public function insertCriteria($criteria)
    {
        $builder = $this->db->table('StudentAdmission_Criteria');
        $builder->insert($criteria);
    }
    public function getAcademicTerm()
    {
        $builder = $this->db->table('AcademicTerm');
        $builder->join('Term', 'Term.TermID = AcademicTerm.TermID','left'); 
        return $builder->orderBy('AcademicTermID', 'ASC')
            ->get()
            ->getResultArray();
    }
    public function getAllTerm()
    {
        $builder = $this->db->table('Term');
        // $builder->join('Term', 'Term.TermID = AcademicTerm.TermID','left'); 
        return $builder->orderBy('TermID', 'ASC')
            ->get()
            ->getResultArray();
    }
    

    
}
