<?php

namespace App\Models;

use CodeIgniter\Model;

class AdmissionApplicationTypeModel extends Model
{
    
    protected $table = 'AdmissionType';
    protected $primaryKey = 'AdmissionTypeID';
    protected $allowedFields = ['AdmissionType'];

    public function getAllAdmission()
    { 
        $builder = $this->db->table('StudentAdmission_Application');
        
        // Join the StudentInfo_Admission table
        $builder->join('StudentInfo_Admission', 'StudentInfo_Admission.StudentAdmissionID = StudentAdmission_Application.StudentAdmissionID'); 
        $builder->join('AdmissionType', 'AdmissionType.AdmissionTypeID = StudentAdmission_Application.AdmissionTypeID'); 
        
        // Filter where RemarksAdmission is NULL
        $builder->where('RemarksAdmission IS NOT NULL', null, false); // Explicit use of IS NULL
        
        // Get the results
        $query = $builder->get(); 
        
        // Return the results as an array of objects
        return $query->getResult();
    }
    public function update_apptype($id, $data) {
         
        // Ensure $id and $data are provided
     //    if (!$id || !is_array($data)) {
     //     return false;
     // }
 
     // Update the record where the ID matches
     return $this->where('AdmissionTypeID', $id)->set($data)->update();
     }
     public function insertBatchRequirements(array $data)
     {
           // Use the builder to interact with the 'admissionrequirements' table
        $builder = $this->db->table('AdmissionRequirements');

        // Call insertBatch on the builder instance
        return $builder->insertBatch($data);
     }
     public function getRequirements()
     {
        $builder = $this->db->table('AdmissionType');
        $builder->select('AdmissionType.*, AdmissionRequirements.*'); 
        $builder->join('AdmissionRequirements', 'AdmissionRequirements.AdmissionTypeID = AdmissionType.AdmissionTypeID');

        
        $query = $builder->get();
        
        return $query->getResult();
     }
     public function getAdmissionTypeData($admissionTypeId)
     { 
        //  $builder = $this->db->table("AdmissionType");
        // //  $builder->select('*');  
        // $builder->select('AdmissionType.*, AdmissionRequirements.*'); 
        // $builder->join('AdmissionRequirements', 'AdmissionRequirements.AdmissionTypeID = AdmissionType.AdmissionTypeID');
        //  $builder->where('AdmissionTypeID', $admissionTypeId);
 
        //  $query = $builder->get();
 
        //  // Return the result as an associative array
        //  return $query->getRowArray();
        $builder = $this->db->table("AdmissionType");
        $builder->select('AdmissionType.*, AdmissionRequirements.*');
        $builder->join('AdmissionRequirements', 'AdmissionRequirements.AdmissionTypeID = AdmissionType.AdmissionTypeID');
        $builder->where('AdmissionType.AdmissionTypeID', $admissionTypeId);
    
        $query = $builder->get();
    
        // Use getResultArray() if expecting multiple rows
        return $query->getResultArray();
     }
}
