<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;
use CodeIgniter\Database\RawSql;

class AcademicTerm extends Migration
{
    public function up()
    {
        $this->forge->addField([
            'AcademicTermID' => [
                'type'              => 'BIGINT(10) ZEROFILL',
                'unsigned'          => true,
                'auto_increment'    => true,
            ],
            'Term' => [
                'type' => 'VARCHAR(50)',
            ],
            'AdmissionYear' => [
                'type' => 'YEAR(4)',
            ],
            'CreatedAt'=> [
                'type'      => 'TIMESTAMP',
                'default'   => new RawSql('CURRENT_TIMESTAMP'),
            ],
            'DeletedAt'=> [
                'type'  => 'TIMESTAMP',
                'null'  => true,
            ],
            'LastUpdateAt'=> [
                'type'  => 'TIMESTAMP',
                'null'  => true,
            ],
        ]);

        $this->forge->addPrimaryKey('AcademicTermID');
        $this->forge->createTable('AcademicTerm');
    }

    public function down(){
        $this->forge->dropTable('AcademicTerm');
    }
}