<?php

namespace App\Controllers;

use App\Models\AdmissionModel;
use App\Models\ExamScheduleModel;
use App\Models\AdmissionSchedModel;
use App\Models\ApplicationTypeModel;
use App\Models\AdmissionApplicationTypeModel;
use CodeIgniter\Files\File; 
use TCPDF\TCPDF;

class Admissions extends BaseController
{
    public $email;
    public function __construct()
    {
        helper('form');
        $this->AdmissionModel = new AdmissionModel();
        $this->ExamScheduleModel = new ExamScheduleModel();
        $this->AdmissionSchedModel = new AdmissionSchedModel();
        $this->ApplicationTypeModel = new ApplicationTypeModel();
        $this->AdmissionApplicationTypeModel = new AdmissionApplicationTypeModel();
        $this->email = \Config\Services::email();
        $uri = new \CodeIgniter\HTTP\URI();
    }
    public function index()
    {
        // return view('welcome_message');
        $data['page_title'] = "Student form";
        $data['programs'] = $this->AdmissionModel->getProgram();
        $data['AcademicTerm'] = $this->AdmissionModel->getAcademicTerm();
        $data['citizenship'] = $this->AdmissionModel->getCitizenship();
        $data['schoolyear'] = $this->AdmissionModel->getSchoolYear();
        $data['ApplicationNo'] = $this->generateApplicationNumber();
        $data['requirements'] = $this->AdmissionApplicationTypeModel->getRequirements();
        $data['applicationTypes'] = $this->ApplicationTypeModel->findAll(); // Fetch all application types
        return view('pages/admission/Admission', $data);
        // print_r($data['requirements']);


    }
    public function getAdmissionDataAjax()
    {
        if ($this->request->isAJAX()) {
            // Get the AdmissionTypeID sent via AJAX
            $admissionTypeId = $this->request->getPost('admission_type_id');

            if (!$admissionTypeId) {
                return $this->response->setJSON([
                    'success' => false,
                    'message' => 'No Admission Type ID provided.',
                ]);
            }

            $admissionData = $this->AdmissionApplicationTypeModel->getAdmissionTypeData($admissionTypeId);

            if ($admissionData) {
                return $this->response->setJSON([
                    'success' => true,
                    'admissionData' => $admissionData,
                ]);
            } else {
                return $this->response->setJSON([
                    'success' => false,
                    'message' => 'Admission Type not found.',
                ]);
            }
        }

        return $this->response->setStatusCode(405)->setJSON([
            'success' => false,
            'message' => 'Method not allowed.',
        ]);
    }
    public function generateApplicationNumber()
    {
        // Load the helper
        helper('text');

        // Initialize the application number
        $applicationNumber = '';

        // $admissionmodel = new AdmissionModel();

        do {
            // Generate a random application number (e.g., 10 characters)
            $applicationNumber = random_string('num', 10);
            $isUnique = $this->AdmissionModel->isApplicationNumberUnique($applicationNumber);

            // Check if the generated number already exists in the database
            // $existingApplication = $this->AdmissionModel->where('StudentAdmissionID', $applicationNumber)->first();
        } while (!$isUnique);

        // You can save this unique application number to your database or use it as needed
        // echo 'Random Application Number: ' . $applicationNumber;
        return $applicationNumber;
    }
    public function fileupload()
    {
        $data['page_title'] = "Student form";
        $data['programs'] = $this->AdmissionModel->getProgram();
        $data['AcademicTerm'] = $this->AdmissionModel->getAcademicTerm();
        $data['citizenship'] = $this->AdmissionModel->getCitizenship();
        $data['schoolyear'] = $this->AdmissionModel->getSchoolYear();
        $data['ApplicationNo'] = $this->generateApplicationNumber();
        $data['requirements'] = $this->AdmissionApplicationTypeModel->getRequirements();
        $data['applicationTypes'] = $this->ApplicationTypeModel->findAll(); // Fetch all application types
        return view('pages/admission/fileupload',$data);
    }
    public function uploadfilemol()
    {
           // FOR FILE UPLOAD REQUIREMENTS
           $files = $this->request->getFiles();
           $uploadPath = FCPATH . 'uploads/uploads';
           if (!is_dir($uploadPath)) {
               mkdir($uploadPath, 0777, true);
           }
           print_r($files)
;            $savedFiles = [];
           if (isset($files['files']) && is_array($files['files'])) {
               foreach ($files['files'] as $key => $file) {
                   try {
                       if ($file->isValid() && !$file->hasMoved()) {
                           $fileName = $file->getRandomName();
                           $file->move($uploadPath, $fileName);
                           $savedFiles[] = [
                               'StudentAdmissionID' => 123,
                               'DateSubmitted' => date('Y-m-d H:i:s'),
                               'DocumentRequirementID' => $key,
                               'StudentRequirementFilename' => $fileName,
                               'isValid' => 0,
                               'EmployeeNo' => 'EMP001',
                           ];
                       }
                       print_r($savedFiles);
                   } catch (\Exception $e) {
                       log_message('error', 'File upload error: ' . $e->getMessage());
                   }
               }
           }
           if (!empty($savedFiles)) {
               $this->AdmissionModel->insertApplicantsubmission($savedFiles);
           }

    }
    public function getApplicantData()
    {
        try {
            $this->AdmissionModel->transStart();

            $studentid = $this->generateApplicationNumber();

            $avatar = $this->request->getFile('avatar');
            if ($avatar->isValid() && !$avatar->hasMoved()) {
                $avatarname = $avatar->getName();
                $avatar->move(FCPATH . 'uploadsImage', $avatarname);
                $data = [
                    'StudentAdmissionID' => $studentid,
                    'FirstName' => $this->request->getVar('first_name'),
                    'MiddleName' => $this->request->getVar('middle_name'),
                    'LastName' => $this->request->getVar('last_name'),
                    'isMale' => $this->request->getVar('sex'),
                    'DateofBirth' => $this->request->getVar('dateofbirth'),
                    'CitizenshipStatus' => 'Citizen',
                    'CitizenshipID' => $this->request->getVar('citizenship'),
                    'Picture' => $avatarname,

                ];

                $inserted = $this->AdmissionModel->insertApplicantInfo($data);
            }
            $address = [
                'StudentAdmissionID' => $studentid,
                // 'StudentAdmission_AddressID' => 1,
                'Country' => $this->request->getVar('country'),
                'HouseNo' => $this->request->getVar('houseno'),
                'Street' => $this->request->getVar('street'),
                'Brgy' => $this->request->getVar('barangay'),
                'Town' => $this->request->getVar('city'),
                'Province' => $this->request->getVar('province'),
                'Region' => $this->request->getVar('region'),
                'AddressLine1' => $this->request->getVar('address1'),
                // 'AddressLine2' => 1,

            ];
            $this->AdmissionModel->insertApplicantAddress($address);

            // FOR FILE UPLOAD REQUIREMENTS
              // Handle file uploads for the "files" array
         // Handle file uploads for the "files" array
        //  $files = $this->request->getFiles();
        //  log_message('info', 'Received files: ' . print_r($files, true)); // Debugging files array
 
        //  $uploadPath = WRITEPATH . 'uploads/requirements';
 
        //  // Ensure the upload directory exists
        //  if (!is_dir($uploadPath)) {
        //      mkdir($uploadPath, 0777, true);
        //      log_message('info', 'Created upload directory: ' . $uploadPath);
        //  }
 
        //  $savedFiles = [];
        //  if (isset($files['files']) && is_array($files['files'])) {
        //      foreach ($files['files'] as $file) {
        //          log_message('info', 'Processing file: ' . print_r($file, true)); // Debugging each file
        //          // Check if file is valid
        //          if ($file instanceof \CodeIgniter\Files\File && $file->isValid() && !$file->hasMoved()) {
        //              try {
        //                  // Generate a random file name and move the file
        //                  $fileName = $file->getRandomName();
        //                  $file->move($uploadPath, $fileName);
        //                  log_message('info', 'File uploaded: ' . $fileName);
 
        //                  // Save file info to array
        //                  $savedFiles[] = [
        //                      'StudentAdmissionID' => $studentid,
        //                      'DateSubmitted' => date('Y-m-d H:i:s'),
        //                      'DocumentRequirementID' => 1, // Replace with actual value if needed
        //                      'StudentRequirementFilename' => $fileName,
        //                      'isValid' => 0,
        //                      'EmployeeNo' => 'EMP001',
        //                  ];
        //              } catch (\Exception $e) {
        //                  log_message('error', 'File upload error: ' . $e->getMessage());
        //              }
        //          } else {
        //              log_message('info', 'Invalid file or already moved.');
        //          }
        //      }
        //  }  

        // Insert the saved files into the database
        // if (!empty($savedFiles)) {
        //     $this->AdmissionModel->insertApplicantsubmission($savedFiles);
        //     log_message('info', 'Files saved to database.');
        //     $response = ['message' => 'Data received successfully'];
        // } else {
        //     $response = ['message' => 'No files uploaded or invalid files'];
        // }
            // if ($inserted) {

            //     // Send a response back to the client
            //     $this->emailtosend();
            //     $response = ['message' => 'Data received successfully'];
            // } else {
            //     $this->emailtosend();
            //     // Send a response back to the client
            //     $response = ['message' => 'testign'];
            // }

            
            $application = [
                // 'StudentAdmission_ApplicationID' => 12,
                'StudentAdmissionID' => $studentid,
                'AdmissionTypeID' => 1,
                'AcademicTermID' => 1,
                'Remarks' => 1,
                'AdmissionStatusID' => 1,
                'DateCreated' => date('Y-m-d H:i:s'),
            ];
            $this->AdmissionModel->insertApplicantApplication($application);
            // FOR INSERTION OF PROGRAM CHOICE
            $programs = [
                ['ProgramID' => $this->request->getVar('programs'), 'Priority' => 1],
                ['ProgramID' => $this->request->getVar('programs2'), 'Priority' => 2],
                ['ProgramID' => $this->request->getVar('programs3'), 'Priority' => 3],
            ];
            foreach ($programs as $program) {
                $programchoice = [
                    'StudentAdmissionID' => $studentid,
                    'ProgramID' => $program['ProgramID'],
                    'Priority' => $program['Priority'],
                ];

                $this->AdmissionModel->InsertProgramChoice($programchoice);
            }
            // Commit the transaction if all inserts are successful
            $this->AdmissionModel->transCommit();
            $this->emailtosendpending(); // added for the verification transaction

        } catch (\Exception $e) {
            // Something went wrong, rollback the transaction
            $this->AdmissionModel->transRollback();

            // Handle the error, log it, or return an error message
            echo 'Error: ' . $e->getMessage();
        }
        if ($inserted) {

            // Send a response back to the client
            $this->emailtosend();
            $response = ['message' => 'Data received successfully'];
        } else {
            $this->emailtosend();
            // Send a response back to the client
            $response = ['message' => 'testign'];
        }
        // Process the data as needed
        // Perform any necessary database operations or other logic here

        return $this->response->setJSON($response);
    }

    public function status()
    {
        $data['page_title'] = "Admission";
        $data['app'] = $this->AdmissionModel->getAllApplicantsByIDT();
        return view('pages/admission/Status', $data);
        // print_r($data);
    }
    public function AdmissionSlip()
    {

        $data['page_title'] = "Admission";
        $data['app'] = $this->AdmissionModel->getAllApplicantsByIDT();
        $data['info'] = $this->ExamScheduleModel->getInforbyApplicant();
        $data['academicyear'] = $this->ExamScheduleModel->geAcademicYear();
        // return view('pages/admission/AdmissionSlip', $data);
        // print_r($data['info']);
        return view('pages/admission/printAdmissionSlip', $data);
        //  print_r($data['info']);
    }

    public function college()
    {
        $college = $this->AdmissionModel->getAllCollege();
        return $this->response->setJSON($college);
    }
    public function getCollegebyProgram($collegeId)
    {
        // Validate the program ID or handle it as needed 

        // Fetch data based on the selected program ID
        $data = $this->AdmissionModel->getProgramDatabyCollege($collegeId);

        // Return the data as JSON (assuming it's JSON data)
        return $this->response->setJSON($data);
    }
    //for admin admission
    public function applicants()
    {
        $data['page_title'] = "Admission List";
        // return $data['app'] = $this->AdmissionModel->getAllApplicants(); 
        $data['app'] = $this->AdmissionModel->getAllApplicants();
        $data['appTerm'] = $this->AdmissionModel->getAllTerm();
        $data['college'] = $this->AdmissionModel->getAllCollege();
        $applications = $data['app'];

        // Calculate days since status update
        foreach ($applications as &$application) {
            if ($application->Status === 'Approved' || $application->Status === 'Rejected') {
                $application->days_since_status = $this->calculateDaysSinceStatus($application->Status_Updated_at);
            } else {
                $application->days_since_status = null;
            }
        }
        return view('pages/admission/Applicants', $data);
        //  var_dump($data);
        //   print_r( $data['app'] );
        // return $data['programs'];

    }
    private function calculateDaysSinceStatus($statusUpdatedAt)
    {
        $statusDate = new \DateTime($statusUpdatedAt);
        $currentDate = new \DateTime();
        $interval = $currentDate->diff($statusDate);
        return $interval->days;
    }
    // applicant list of examniee
    public function Examinee()
    {
        $data['page_title'] = "List of Examinee";
        // return $data['app'] = $this->AdmissionModel->getAllApplicants(); 
        $data['app'] = $this->AdmissionModel->getAllApplicantsForExaminee();
        $data['appTerm'] = $this->AdmissionModel->getAllTerm();
        return view('pages/admission/ApplicantExaminee', $data);
        //  var_dump($data);
        // print_r($data['app']);
        // return $data['programs'];

    }
    //grade entry assesmnt
    public function Assessment()
    {
        $data['page_title'] = "Grade Entry Assessment";
        // return $data['app'] = $this->AdmissionModel->getAllApplicants(); 
        $data['app'] = $this->AdmissionModel->getAllApplicants();
        $data['appTerm'] = $this->AdmissionModel->getAllTerm();
        return view('pages/admission/GradeAssessment', $data);
        //  var_dump($data);
        // print_r($data);
        // return $data['programs'];

    }

    public function Transferee()
    {
        return 'ready';
    }

    public function applicantProfile($StudentAdmissionID)
    {
        $StudentAdmissionID = "ADMISSION12345";
        $data['page_title'] = "Student Profile";
        $data['StudentAdmissionID'] = $StudentAdmissionID;
        $data['appdata'] = $this->AdmissionModel->getAllApplicantsByID($StudentAdmissionID);
        $data['programs'] = $this->AdmissionModel->getProgram();
        $data['AcademicTerm'] = $this->AdmissionModel->getAcademicTerm();
        $data['citizenship'] = $this->AdmissionModel->getCitizenship();

        // $data['examDate'] = $this->AdmissionModel->getExamDate();

        // print_r($data['appdata']);
        return view('pages/admission/profile', $data);

    }
    public function update_data($StudentAdmissionID)
    {
        return $StudentAdmissionID;
    }
    public function updatedata()
    {
        // return $StudentAdmissionID;
        // return $this->response->setJSON(['message' => 'Data updated successfully']);
        // Check if the request is a POST request (form submission)
        if ($this->request->isAJAX()) {
            // Get JSON data from the POST request
            $json = $this->request->getJSON();

            // Extract 'id' and 'status' from the JSON data
            $id = $json->id;
            $status = $json->status;
            // $this->saveExamSchedule($id);
            // Perform your update logic here
            // Example: Update a record in the database
            $this->AdmissionModel->updateDataBasedOnStatus($id, $status);

            // Check if status is 'approved'
            if ($status === 'Approved') {
                //save schedule 

                $this->saveExamSchedule($id);
                // Send email
                $this->emailtosend();
            } else if ($status === 'Rejected') {
                $this->emailtosendReject();
            } else {
                $this->emailtosendPending();
            }
            // Send a JSON response
            return $this->response->setJSON(['message' => $status, 'alert' => 'success']);
        } else {
            // Display the form (GET request)

            // You can load any necessary views or perform other actions here
            // For example, load a view that contains your form
            return view('update_data_form');
        }
    }
    public function saveExamSchedule($id)
    {
        $this->AdmissionSchedModel = new AdmissionSchedModel();
        // Find an available schedule
        $availableSchedule = $this->AdmissionSchedModel->getAvailableSchedule();

        if ($availableSchedule) {
            // Get the schedule ID and date
            $scheduleId = $availableSchedule['StudentAdmission_ScheduleID'];
            $examDate = $availableSchedule['Exam_Date'];
            // $examDate = date('F j, Y', strtotime($availableSchedule['Exam_Date'])); // Outputs: September 6, 2024
            // Prepare the data for the student's exam schedule
            $data = [
                'StudentAdmissionID' => $id, // Replace with actual data
                'Exam_date' => $examDate,
                'Start_time' => '02:00:00',
                'End_time' => '12:00:00',
                'Venue' => 'Examination Hall',
                'Details' => 'Please bring your ID and examination permit.'
            ];

            // Insert the student's exam schedule
            $this->ExamScheduleModel->insertSched($data);

            // Increment the current_examinees count
            $this->AdmissionSchedModel->incrementExamineeCount($scheduleId);

            // Redirect or load a view
            // return redirect()->to('/your-next-route'); // Adjust the redirection as needed
        } else {
            //     // Handle the case where no schedule is available
            return redirect()->back()->with('error', 'No available schedule.');
        }

        // $data = [
        //     'StudentAdmissionID' => $id,
        //     'Exam_date' => $date,
        //     'Start_time' => '09:00:00',  // Example start time
        //     'End_time' => '12:00:00',    // Example end time
        //     'Venue' => 'Examination Hall', // Example venue
        //     'Details' => 'Please bring your ID and examination permit.' // Example details
        // ];

        // $this->ExamScheduleModel->insertSched($data);
    }
    public function updatePersonalInfo()
    {
        // Get the form data
        $StudentAdmissionID = $this->request->getPost('StudentAdmissionID');
        $data = [
            'LastName' => $this->request->getPost('last_name'),
            'FirstName' => $this->request->getPost('first_name'),
            'MiddleName' => $this->request->getPost('middle_name'),
            'isMale' => $this->request->getPost('sex'),
            'Religion' => $this->request->getPost('religion'),
            'CitizenshipID' => $this->request->getPost('citizenship'),
            'DateOfBirth' => $this->request->getPost('dateofbirth'),
            'PlaceOfBirth' => $this->request->getPost('placeofbirth'),
        ];
        $this->AdmissionModel->updatePersonalInfo($StudentAdmissionID, $data);
        // $token = $this->request->uri->getSegment(3);

        return $this->response->setJSON(['message' => 'inserted']);
    }
    public function updateContactInfo()
    {
        // Get the form data
        $StudentAdmissionID = $this->request->getPost('StudentAdmissionID');
        $data = [
            'Country' => $this->request->getPost('country'),

        ];
        $this->AdmissionModel->updateContactInfo($StudentAdmissionID, $data);
        // $token = $this->request->uri->getSegment(3);

        return $this->response->setJSON(['message' => 'inserted']);
    }
    //UPDATE PARENT CONTACT INFORMATION
    public function updateParentInfo()
    {
        // Get the form data
        $StudentAdmissionID = $this->request->getPost('StudentAdmissionID');
        $data = [
            'SPGFirstName' => $this->request->getPost('father_fistname'),

        ];
        $this->AdmissionModel->updateGuardianInfo($StudentAdmissionID, $data);
        // $token = $this->request->uri->getSegment(3);

        return $this->response->setJSON(['message' => 'inserted']);
    }
    //UPDATE ACADEMIC INFORMATION
    public function updateAcadInfo()
    {
        // Get the form data
        $StudentAdmissionID = $this->request->getPost('StudentAdmissionID');
        $data = [
            'SchoolName' => $this->request->getPost('last_school_attended'),

        ];
        $this->AdmissionModel->updateAcadInfo($StudentAdmissionID, $data);
        // $token = $this->request->uri->getSegment(3);

        return $this->response->setJSON(['message' => 'inserted']);
    }



    public function update_status($TermId)
    {
        // Load the AdmissionModel if not loaded in constructor
        // $this->load->model('AdmissionModel'); // Ensure the model is loaded

        // Call the model method to update the status
        $success = $this->AdmissionModel->updateAcadTerm($TermId);

        // Prepare JSON response
        $response = array();
        if ($success) {
            $response['status'] = 'success';
            $response['message'] = 'Status updated successfully.';
        } else {
            $response['status'] = 'error';
            $response['message'] = 'Failed to update status.';
        }

        // Send JSON response back to the view
        $this->output
            ->set_content_type('application/json')
            ->set_output(json_encode($response));
    }
    // public function payment()
    // { 
    //     $data['page_title'] = "Payments";
    //     return view('pages/admission/payment', $data);
    // }

    // public function emailtosend()
    // {
    //     $to = 'vincentcortez@cspc.edu.ph';
    //     $subject = 'Camarines Sur Polytechnic Colleges - Admission';
    //     // $token = $userdata['uniid'];
    //     $message = 'Your application is currently FOR VERIFICATION <br><br>'
    //             .'Your application and the documents you uploaded is undergoing a verification process to deTermine if they are compliant with our standard and requirement. After seven (7) working days, you will be notified of the result of the verification process through email to be sent to your registered email address. <br>'
    //             .'Should you have further inquiries please admission.requirements@cspc.edu.ph with subject heading Frosh Application AY 2024-2025.<br>'
    //             .'You may also check our website at http://www.cspc.edu.ph/ for important updates and advisories. You may also follow CSPC on Facebook and Instagram.'
    //             .'Thank you';

    //         $this->email->setTo($to);
    //         $this->email->setFrom("cortezvincent@gmail.com");
    //         $this->email->setSubject($subject);
    //         $this->email->setMessage($message);
    //         // $filepath = 'public/static/img/avatar/avatar.jpg';
    //         // $this->email->attach($filepath);
    //         if($this->email->send())
    //         {

    //             //  $this->session->setTempdata('success','Reset password link sent', 3);
    //             return redirect()->back(); 
    //         // return 'Good';
    //         }
    //         else
    //         {
    //           // $data = $email->printDebugger(['header']);
    //           // print_r($data);
    //             //  $this->session->setTempdata('error','Error po', 3);
    //         return redirect()->to(current_url());
    //         }
    // }
    public function emailtosend()
    {
        $to = 'vincentcortez@cspc.edu.ph';
        $subject = 'Camarines Sur Polytechnic Colleges - Admission';

        // Load the email template view
        $message = view('pages/admission/email');

        $email = \Config\Services::email();

        $email->setTo($to);
        $email->setFrom("cortezvincent@gmail.com", "CSPC Admissions");
        $email->setSubject($subject);
        $email->setMessage($message);  // Set the HTML message
        $email->setMailType('html');   // Ensure the email is sent as HTML

        if ($email->send()) {
            // Email sent successfully
            return redirect()->back()->with('success', 'Email sent successfully');
        } else {
            // Failed to send email
            return redirect()->back()->with('error', $email->printDebugger(['headers']));
        }
    }
    public function emailtosendpending()
    {
        $to = 'vincentcortez@cspc.edu.ph';
        $subject = 'Camarines Sur Polytechnic Colleges - Admission';

        // Load the email template view
        $message = view('pages/admission/emailtopending');

        $email = \Config\Services::email();

        $email->setTo($to);
        $email->setFrom("cortezvincent@gmail.com", "CSPC Admissions");
        $email->setSubject($subject);
        $email->setMessage($message);  // Set the HTML message
        $email->setMailType('html');   // Ensure the email is sent as HTML

        if ($email->send()) {
            // Email sent successfully
            return redirect()->back()->with('success', 'Email sent successfully');
        } else {
            // Failed to send email
            return redirect()->back()->with('error', $email->printDebugger(['headers']));
        }
    }
    public function emailtosendReject()
    {
        $to = 'vincentcortez@cspc.edu.ph';
        $subject = 'Camarines Sur Polytechnic Colleges - Admission';

        // Load the email template view
        $message = view('pages/admission/emailreject');

        $email = \Config\Services::email();

        $email->setTo($to);
        $email->setFrom("cortezvincent@gmail.com", "CSPC Admissions");
        $email->setSubject($subject);
        $email->setMessage($message);  // Set the HTML message
        $email->setMailType('html');   // Ensure the email is sent as HTML

        if ($email->send()) {
            // Email sent successfully
            return redirect()->back()->with('success', 'Email sent successfully');
        } else {
            // Failed to send email
            return redirect()->back()->with('error', $email->printDebugger(['headers']));
        }
    }
    public function emailtemplate()
    {
        return view('pages/admission/email');
    }


}
