<?php

namespace App\Controllers;

use App\Controllers\BaseController;

use App\Models\AdmissionSchedModel;
use App\Models\StudentModel;
use App\Models\ExamScheduleModel;

class AdmissionSchedController extends BaseController
{
    public function __construct()
    {
        helper('form');
        $this->AdmissionSchedModel = new AdmissionSchedModel();
        $this->StudentModel = new StudentModel();
        $this->ExamScheduleModel = new ExamScheduleModel();

    }
    public function index()
    {
        $scheduleModel = new AdmissionSchedModel;
        $studentModel = new StudentModel();
        $data['page_title'] = "Set Schedule";
        $data['schedules'] = $scheduleModel->findAll();
        // $data['students'] = $studentModel->findAll();

        // return view('pages/admission/exam_view', $data);
        return view('pages/admission/scheduleSetting', $data);
        // print_r($data['schedules']);
    }

    public function addStudent()
    {
        $scheduleModel = new AdmissionSchedModel();

        $examDate = $this->request->getPost('sched_date');
        $maxExaminees = $this->request->getPost('max_examinees');

        // Check if the date already exists in the database
        $existingSchedule = $scheduleModel->where('Exam_Date', $examDate)->first();

        if ($existingSchedule) {
            // If a schedule with the same date exists, return an error with a flash message
            return redirect()->back()->withInput()->with('error', 'A schedule with this date already exists. Please choose another date.');
        }

        // If the date does not exist, save the new schedule
        $data = [
            'Exam_Date' => $examDate,
            'Max_Examinees' => $maxExaminees,
        ];

        if ($scheduleModel->save($data)) {
            return redirect()->to('/schedule')->with('success', 'Schedule added successfully');
        } else {
            return redirect()->back()->withInput()->with('errors', $scheduleModel->errors());
        }
    }
    public function edit($id)
    {
        $scheduleModel = new AdmissionSchedModel();
        $schedule = $scheduleModel->find($id);

        if (!$schedule) {
            return redirect()->to('/schedule')->with('error', 'Schedule not found.');
        }

        return view('edit_schedule', ['schedule' => $schedule]);
    }

    public function update() {
        $scheduleModel = new AdmissionSchedModel();
        $id = $this->request->getPost('schedule_id');
        $data = [
            'Exam_Date' => $this->request->getPost('sched_date'),
            'Max_Examinees' => $this->request->getPost('max_examinees'),
        ];
    
        // Check if ID is valid
        if (!$id) {
            return redirect()->to('/schedule')->with('error', 'Invalid schedule ID.');
        }
    
        // Update schedule
        if ($scheduleModel->update_schedule($id, $data)) {
            return redirect()->to('/schedule')->with('success', 'Schedule updated successfully.');
        } else {
            return redirect()->to('/schedule')->with('error', 'Failed to update schedule.');
        }
    }
    public function delete($id)
    {
        $scheduleModel = new AdmissionSchedModel();

        if ($scheduleModel->delete($id)) {
            return redirect()->to('/schedule')->with('success', 'Schedule deleted successfully.');
        } else {
            return redirect()->back()->with('error', 'Failed to delete schedule.');
        }
    }

}



// StudentInfo_Admission = studentAdmissionID
//student_assessment = StudentID
//StudentAdmission_Address = StudentAdmissionID
// StudentParentGuardian = StudentAdmissionID
// student_assessment.college = college.CollegeID
// student_assessment.ProgramID = program.ProgramID



