<?php

namespace App\Controllers;

use App\Controllers\BaseController;
use App\Models\AdmissionReportModel;
use CodeIgniter\I18n\Time;
class AdmissionReportController extends BaseController
{
    protected $db;
    protected $builder;
    public function __construct()
    {
        helper('form');
        $this->AdmissionReport = new AdmissionReportModel();
        $this->email = \Config\Services::email();
        $uri = new \CodeIgniter\HTTP\URI();
        $this->db = \Config\Database::connect();
        $this->request = \Config\Services::request();
        $this->builder = $this->db->table('StudentAdmission_Application'); // Replace 'your_table_name' with your actual table
    }
    public function index()
    {
        $data['page_title'] = "Admission Report";
        $data['applicantInfo'] = $this->AdmissionReport->getAllAdmission();
        $data['appType'] = $this->AdmissionReport->getAdmissionType();
        $data['colleges'] = $this->AdmissionReport->getAllColleges();
        // $data['program'] = $this->AdmissionReport->getAllProgram();
        // $data['programs'] = $this->AdmissionReport->getAllProgram();

        $data['table'] = view("pages/admission/helpers/admissionReport");
        return view('pages/admission/Reports', $data);
        // print_r($data['program']);
    }

    public function fetchRows()
    {
        // Get filters (including applicationType)
        $filters = $this->request->getPost();
        $applicationType = isset($filters['applicationType']) ? $filters['applicationType'] : null;
        $status = isset($filters['status']) ? $filters['status'] : null;
        // Fetch the results based on filters
        $results = $this->AdmissionReport->make_datatables($applicationType,  $status); // Pass the applicationType filter to the model function
    
        // Prepare the data to be returned to DataTable
        $data = array();
        $number = 1;
        foreach ($results as $row) {
            $data_array = array(); 
           
            // $data_array[] = '<th>
            //         <div class="form-check form-check-sm form-check-custom form-check-solid">
            //             <input class="form-check-input" type="checkbox" />
            //         </div>
            // </th>';
            $data_array[] = $row->StudentAdmissionID;
            $data_array[] = $row->FirstName.' '.$row->MiddleName.' '.$row->LastName;
            $data_array[] = $row->AdmissionType;
            $data_array[] = $row->RemarksAdmission;
            $data[] = $data_array;
            
        }
    
        // Prepare output to return to DataTable
        $output = array(
            "draw"             => intval($this->request->getVar('draw')),  // Must match DataTables draw parameter
            "recordsTotal"     => $this->AdmissionReport->get_all_data(),
            "recordsFiltered"  => $this->AdmissionReport->get_filtered_data($filters),
            "data"             => $data
        );
        
        echo json_encode($output);
    }


    public function loadReport()
    {
        $applicationType = $this->request->getPost('applicationType');
        // $status = $this->request->getPost('status');
        // $course = $this->request->getPost('course');

        // Fetch filtered data from the model
        $applicantInfo = $this->studentAdmissionModel->getFilteredApplications($applicationType, $status, $course);

        // Prepare the response
        $response = 'REady';
        // foreach ($applicantInfo as $row) {
        //     $response .= '<tr>';
        //     $response .= '<td>' . $row->StudentAdmissionID . '</td>';
        //     $response .= '<td>' . $row->FirstName . ' ' . $row->MiddleName . ' ' . $row->LastName . '</td>';
        //     $response .= '<td>' . $row->AdmissionType . '</td>';
        //     $response .= '<td>' . $row->ProgramDesc . '</td>';
        //     $response .= '</tr>';
        // }

        // Return the response as JSON
        return $this->response->setJSON($response);
    }
    public function filter()
    {
        $applicationType = $this->request->getGet('applicationType');
        $status = $this->request->getGet('status');

        $builder = $this->db->table('StudentAdmission_Application');
        $builder->select('StudentAdmission_Application.*, AdmissionType.*, StudentInfo_Admission.*');
        $builder->join('StudentInfo_Admission', 'StudentInfo_Admission.StudentAdmissionID = StudentAdmission_Application.StudentAdmissionID', 'inner');
        $builder->join('AdmissionType', 'AdmissionType.AdmissionTypeID = StudentAdmission_Application.AdmissionTypeID', 'inner');

        if ($applicationType) {
            $builder->where('AdmissionTypeID', $applicationType);
        }
        if ($status) {
            $builder->where('RemarksAdmission', $status);
        }

        $query = $builder->get();
        $data = $query->getResultArray();

        // Add row numbers to data
        $data = array_map(function ($row, $index) {
            $row['no'] = $index + 1;
            return $row;
        }, $data, array_keys($data));

        return $this->response->setJSON($data);
    }
    public function filter2()
    {
        $applicationType = $this->request->getGet('applicationType');
        $status = $this->request->getGet('status');

        $builder = $this->AdmissionReport->builder();

        if (!empty($applicationType)) {
            $builder->where('AdmissionTypeID', $applicationType);
        }

        if (!empty($status)) {
            $builder->where('RemarksAdmission', $status);
        }

        $data = $builder->get()->getResult();

        return $this->response->setJSON($data);
    }

    public function export()
    {
        $format = $this->request->getGet('format');

        $builder = $this->db->table('StudentAdmission_Application');
        $query = $builder->get();
        $data = $query->getResultArray();

        switch ($format) {
            case 'excel':
                $this->exportToExcel($data);
                break;
            case 'csv':
                $this->exportToCSV($data);
                break;
            case 'pdf':
                $this->exportToPDF($data);
                break;
            default:
                throw new \Exception('Unsupported format');
        }
    }

    private function exportToExcel($data)
    {
        $spreadsheet = new \PhpOffice\PhpSpreadsheet\Spreadsheet();
        $sheet = $spreadsheet->getActiveSheet();

        // Set header
        $sheet->setCellValue('A1', 'No');
        $sheet->setCellValue('B1', 'Admission ID');
        $sheet->setCellValue('C1', 'Name');
        $sheet->setCellValue('D1', 'Application Type');
        $sheet->setCellValue('E1', 'Remarks');

        // Fill data
        $rowNumber = 2;
        foreach ($data as $row) {
            $sheet->setCellValue('A' . $rowNumber, $row['StudentAdmissionID']);
            $sheet->setCellValue('B' . $rowNumber, $row['StudentAdmissionID']);
            $sheet->setCellValue('C' . $rowNumber, $row['StudentAdmissionID'] . ' ' . $row['StudentAdmissionID'] . ' ' . $row['StudentAdmissionID']);
            $sheet->setCellValue('D' . $rowNumber, $row['StudentAdmissionID']);
            $sheet->setCellValue('E' . $rowNumber, $row['StudentAdmissionID']);
            $rowNumber++;
        }

        $writer = new \PhpOffice\PhpSpreadsheet\Writer\Xlsx($spreadsheet);
        $filename = 'admission_data.xlsx';

        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment;filename="' . $filename . '"');
        header('Cache-Control: max-age=0');
        $writer->save('php://output');
        exit;
    }

    private function exportToCSV($data)
    {
        $filename = 'admission_data.csv';

        header('Content-Type: text/csv');
        header('Content-Disposition: attachment;filename="' . $filename . '"');

        $output = fopen('php://output', 'w');
        fputcsv($output, ['No', 'Admission ID', 'Name', 'Application Type', 'Remarks']);

        $rowNumber = 1;
        foreach ($data as $row) {
            fputcsv($output, [
                $rowNumber++,
                $row['StudentAdmissionID'],
                $row['StudentAdmissionID'] . ' ' . $row['StudentAdmissionID'] . ' ' . $row['StudentAdmissionID'],
                $row['AdmissionTypeID'],
                $row['RemarksAdmission']
            ]);
        }
        fclose($output);
        exit;
    }

    private function exportToPDF($data)
    {
        $pdf = new \TCPDF();
        $pdf->AddPage();
        $pdf->SetFont('helvetica', '', 12);

        $html = '<h1>Admission Data</h1>';
        $html .= '<table border="1" cellpadding="4"><thead><tr><th>No</th><th>Admission ID</th><th>Name</th><th>Application Type</th><th>Remarks</th></tr></thead><tbody>';

        $rowNumber = 1;
        foreach ($data as $row) {
            $html .= '<tr>';
            $html .= '<td>' . $rowNumber++ . '</td>';
            $html .= '<td>' . $row['StudentAdmissionID'] . '</td>';
            $html .= '<td>' . $row['StudentAdmissionID'] . ' ' . $row['StudentAdmissionID'] . ' ' . $row['StudentAdmissionID'] . '</td>';
            $html .= '<td>' . $row['StudentAdmissionID'] . '</td>';
            $html .= '<td>' . $row['StudentAdmissionID'] . '</td>';
            $html .= '</tr>';
        }
        $html .= '</tbody></table>';

        $pdf->writeHTML($html);
        $pdf->Output('admission_data.pdf', 'D');
        exit;
    }

    public function getProgramsByCollege()
    { 
        $college = $this->AdmissionReport->getAllColleges();
        return $this->response->setJSON($college);
    }
    public function getCollegebyProgram($collegeId)
    {
        // Validate the program ID or handle it as needed 

        // Fetch data based on the selected program ID
        $data = $this->AdmissionReport->getProgramDatabyCollege($collegeId);

        // Return the data as JSON (assuming it's JSON data)
        return $this->response->setJSON($data);
    }


}
