<?php

namespace App\Controllers;

use App\Controllers\BaseController;
use App\Models\AdmissionDurationModel;

class AdmissionDurationController extends BaseController
{
    public function index()
    {
        $model = new AdmissionDurationModel();
        $data['page_title'] = "Duration Setting";
        $data['durations'] = $model->findAll();
        return view('pages/admission/durationSetting',$data);
    }
    public function addDuration()
    {
        $model = new AdmissionDurationModel();
        $data = [
            'AdmissionName' => $this->request->getPost('admission_cycle_name'),
            'Start_date' => $this->request->getPost('start_date'),
            'End_date' => $this->request->getPost('end_date'),
            'Duration' => $this->request->getPost('duration'),
            'Status' => $this->request->getPost('status')
        ];

        if ($model->save($data)) {
            return redirect()->to('/AdmissionDurationController')->with('success', 'Admission duration created successfully.');
        } else {
            return redirect()->back()->with('error', 'Failed to create admission duration.');
        }
    }
}
