<?php

namespace App\Controllers;

use App\Controllers\BaseController; 
use App\Models\AdmissionCriteriaModel;

class AdmissionCriteriaController extends BaseController
{
    public function __construct()
    {
        helper('form');
        $this->AdmissionCriteria = new AdmissionCriteriaModel(); 
        $this->email = \Config\Services::email();
        $uri = new \CodeIgniter\HTTP\URI();
    }
    public function index()
    {
        $data['page_title'] = "Criteria"; 
        $data['acadTerm'] = $this->AdmissionCriteria->getAcademicTerm();
        // $data['Terms'] = $this->AdmissionCriteria->getAllTerm();
        $data['criteria'] = $this->AdmissionCriteria->getCurrentCriteria();
        // print_r($data['acadTerm']);
        return view('pages/admission/Criteria', $data);
    }
    // to be fix depende on the criteria given by admission office.
    public function addCriteria()
    {  
        $criteria = [
            // 'StudentAdmission_ApplicationID' => 12,
            // 'StudentAdmissionID' => $studentid,
            'GWA' => $this->request->getVar('gwa'),
            'Percentage' => $this->request->getVar('percentage'),
            'TermID' => 1, 
            // 'DateCreated' => date('Y-m-d H:i:s'),
        ];
        $this->AdmissionCriteria->insertCriteria($criteria);
        
    }
}
