<?php

namespace App\Controllers;

use App\Controllers\BaseController;
use App\Models\AdmissionSchedModel;
use App\Models\StudentModel;
use App\Models\ExamScheduleModel;
use App\Models\AdmissionApplicationTypeModel;

class AdmissionApplicationTypeController extends BaseController
{
    public function __construct()
    {
        helper('form');
        $this->AdmissionSchedModel = new AdmissionSchedModel();
        $this->StudentModel = new StudentModel();
        $this->ExamScheduleModel = new ExamScheduleModel();
        $this->ApplicationType = new AdmissionApplicationTypeModel();

    }
    public function index()
    {   
        $data['page_title'] = "Appplication Type";
        $data['apptype'] = $this->ApplicationType->getRequirements(); 
        return view('pages/admission/ApplicationType', $data);
        // print_r($data['apptype']);
    }
    public function addAppType()
    {
         // Validate the input
        // if (!$this->validate([
        //     'applicationtype' => 'required|min_length[3]|max_length[255]',
        //     'requirements.*' => 'permit_empty|min_length[3]|max_length[255]', // Allow empty but validate if provided
        // ])) {
        //     return redirect()->back()->withInput()->with('errors', $this->validator->getErrors());
        // }

        // Get input values
        $applicationtype = $this->request->getPost('applicationtype');
        $requirements = $this->request->getPost('requirements'); // This will be an array

        // Check if the application type already exists
        $existingapplicationtype = $this->ApplicationType->where('AdmissionType', $applicationtype)->first();
        if ($existingapplicationtype) {
            return redirect()->back()->withInput()->with('error', 'An application type already exists. Please choose another.');
        }

        // Save the application type
        $data = [
            'AdmissionType' => $applicationtype,
        ];

        if ($this->ApplicationType->save($data)) {
            // Get the ID of the newly created application type
            $AdmissionTypeID = $this->ApplicationType->getInsertID();

            // If there are requirements, save them in the `requirements` table
            if (!empty($requirements)) {
                $requirementData = [];
                foreach ($requirements as $requirement) {
                    if (!empty($requirement)) { // Skip empty inputs
                        $requirementData[] = [
                            'AdmissionTypeID' => $AdmissionTypeID,
                            'Requirement_name' => $requirement,
                        ];
                    }
                }

                if (!empty($requirementData)) {
                    $this->ApplicationType->insertBatchRequirements($requirementData); // Insert multiple rows at once
                }
            }

            return redirect()->to('/AdmissionApplicationTypeController')->with('success', 'Application Type and Requirements added successfully');
        } else {
            return redirect()->back()->withInput()->with('errors', $this->ApplicationType->errors());
        }

        // $applicationtype = $this->request->getPost('applicationtype'); 

        // // Check if the date already exists in the database
        // $existingapplicationtype =  $this->ApplicationType->where('AdmissionType', $applicationtype)->first();

        // if ($existingapplicationtype) {
        //     // If a schedule with the same date exists, return an error with a flash message
        //     return redirect()->back()->withInput()->with('error', 'A application type is already exists. Please choose another date.');
        // }

        // // If the date does not exist, save the new schedule
        // $data = [
        //     'AdmissionType' => $applicationtype, 
        // ];

        // if ($this->ApplicationType->save($data)) {
        //     return redirect()->to('/AdmissionApplicationTypeController')->with('success', 'Application Type added successfully');
        // } else {
        //     return redirect()->back()->withInput()->with('errors', $this->ApplicationType->errors());
        // }
    }
    public function deleteApplicationType($id)
    { 

            if ($this->ApplicationType->delete($id)) {
                return redirect()->to('/AdmissionApplicationTypeController')->with('success', 'Application Type deleted successfully.');
            } else {
                return redirect()->back()->with('error', 'Failed to delete schedule.');
            }
    }

    public function edit($id)
    { 
        $schedule = $this->ApplicationType->find($id);

        if (!$schedule) {
            return redirect()->to('/schAdmissionApplicationTypeControlleredule')->with('error', 'Schedule not found.');
        }

        return view('edit_schedule', ['schedule' => $schedule]);
    }

    public function update() { 
        $id = $this->request->getPost('applicationtypeid');
        $data = [ 
            'AdmissionType' => $this->request->getPost('edit_application_type'),
        ];
    
        // Check if ID is valid
        if (!$id) {
            return redirect()->to('/AdmissionApplicationTypeController')->with('error', 'Invalid Application type.');
        }
    
        // Update schedule
        if ($this->ApplicationType->update_apptype($id, $data)) {
            return redirect()->to('/AdmissionApplicationTypeController')->with('success', 'Application type updated successfully.');
        } else {
            return redirect()->to('/AdmissionApplicationTypeController')->with('error', 'Failed to update Application type.');
        }
    }
    // public function delete($id)
    // {
    //     $scheduleModel = new AdmissionSchedModel();

    //     if ($scheduleModel->delete($id)) {
    //         return redirect()->to('/schedule')->with('success', 'Schedule deleted successfully.');
    //     } else {
    //         return redirect()->back()->with('error', 'Failed to delete schedule.');
    //     }
    // }
}
