<?php

namespace Config;

// Create a new instance of our RouteCollection class.
$routes = Services::routes();

/*
 * --------------------------------------------------------------------
 * Router Setup
 * --------------------------------------------------------------------
 */
$routes->setDefaultNamespace('App\Controllers');
$routes->setDefaultController('Main');
$routes->setDefaultMethod('index');
$routes->setTranslateURIDashes(false);
$routes->set404Override();
$routes->setAutoRoute(true);

$routes->get('/', 'Home::index');
$routes->get('assessment-form', 'Home::assessmentform');


// ===================================================================== accounting routes ====================
$routes->get('Assessment', 'Accounting::assessmentList');
$routes->get('statement-of-account', 'Accounting::statementofaccount');






// ===================================================================== registrar routes ====================



// ===================================================================== SASO routes =========================
$routes->get('student-organization', 'Saso::student_org');
$routes->get('student-activity', 'Saso::student_activity');

//ADMISSION ROUTES
// app/Config/Routes.php

$routes->get('admissions/applicantProfile/(:segment)', 'Admissions::applicantProfile/$1');
$routes->match(['get','post'],'admissions/applicantProfile/approved', 'Admissions::updatedata');
$routes->match(['get','post'],'admissions/applicantProfile/updatePersonalInfo', 'Admissions::updatePersonalInfo');
$routes->match(['get','post'],'admissions/applicantProfile/updateContactInfo', 'Admissions::updateContactInfo');
$routes->match(['get','post'],'admissions/applicantProfile/updateParentInfo', 'Admissions::updateParentInfo');
$routes->match(['get','post'],'admissions/applicantProfile/updateAcadInfo', 'Admissions::updateAcadInfo');
// $routes->match(['get','post'],'getApplicantData', 'Admissions::getApplicantData');
$routes->get('/college', 'Admissions::college');

$routes->get('/getProgrambyCollege/(:any)', 'Admissions::getCollegebyProgram/$1');

$routes->get('/schedule', 'AdmissionSchedController::index');
$routes->post('/students/addStudent', 'AdmissionSchedController::addStudent');

$routes->post('/admissions/saveData', 'AdmissionAssessmentController::updateField');
$routes->get('schedule/edit/(:num)', 'AdmissionSchedController::edit/$1');
// $routes->post('schedule/update/(:num)', 'AdmissionSchedController::update/$1');
// $routes->post('schedule/updateSchedule/(:num)', 'AdmissionSchedController::update/$1');
$routes->get('schedule/delete/(:num)', 'AdmissionSchedController::delete/$1');


// $routes->post('/update_status/(:any)', 'Admissions::update_status/$1');

// $routes->match(['get','post'],'admissions/update_status/(:any)', 'Admissions::update_status/$1');
/*
 * --------------------------------------------------------------------
 * Additional Routing
 * --------------------------------------------------------------------
 *
 * There will often be times that you need additional routing and you
 * need it to be able to override any defaults in this file. Environment
 * based routes is one such time. require() additional route files here
 * to make that happen.
 *
 * You will have access to the $routes object within that file without
 * needing to reload it.
 */
if (is_file(APPPATH . 'Config/' . ENVIRONMENT . '/Routes.php')) {
    require APPPATH . 'Config/' . ENVIRONMENT . '/Routes.php';
}
